/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.upgrade;

import com.android.annotations.concurrency.Slow;
import com.android.flags.Flag;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.ForcedPluginPreviewVersionUpgradeDialog;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.ProjectUpgradeNotification;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.RecommendedPluginVersionUpgradeDialog;
import com.android.tools.idea.gradle.project.sync.setup.post.upgrade.RecommendedUpgradeReminder;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.SystemProperties;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eH\u0007\u001a0\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u000e2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007\u001a\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0007\u001a$\u0010\u0016\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u000e\u001a&\u0010\u0019\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0018\u001a\u00020\u000eH\u0007\u001a\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000eH\u0007\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\nH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"AGP_UPGRADE_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "getAGP_UPGRADE_NOTIFICATION_GROUP", "()Lcom/intellij/notification/NotificationGroup;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "displayForceUpdatesDisabledMessage", "", "project", "Lcom/intellij/openapi/project/Project;", "performForcedPluginUpgrade", "", "currentPluginVersion", "Lcom/android/ide/common/repository/GradleVersion;", "newPluginVersion", "performRecommendedPluginUpgrade", "currentVersion", "recommendedVersion", "dialogFactory", "Lcom/android/tools/idea/gradle/project/sync/setup/post/upgrade/RecommendedPluginVersionUpgradeDialog$Factory;", "recommendPluginUpgrade", "shouldForcePluginUpgrade", "current", "recommended", "shouldRecommendPluginUpgrade", "shouldRecommendUpgrade", "findPluginInfo", "Lcom/android/tools/idea/gradle/plugin/AndroidPluginInfo;", "intellij.android.core"})
@JvmName(name="GradlePluginUpgrade")
public final class GradlePluginUpgrade {
    private static final Logger LOG;
    @NotNull
    private static final NotificationGroup AGP_UPGRADE_NOTIFICATION_GROUP;

    @NotNull
    public static final NotificationGroup getAGP_UPGRADE_NOTIFICATION_GROUP() {
        return AGP_UPGRADE_NOTIFICATION_GROUP;
    }

    @Slow
    @JvmOverloads
    public static final boolean shouldRecommendPluginUpgrade(@NotNull Project project, @Nullable GradleVersion current, @NotNull GradleVersion recommended) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)recommended, (String)"recommended");
        if (SystemProperties.getBooleanProperty((String)"studio.skip.agp.upgrade", (boolean)false)) {
            return false;
        }
        if (!TimeBasedReminder.shouldAsk$default(new RecommendedUpgradeReminder(project), 0L, 1, null)) {
            return false;
        }
        if (current == null) {
            return false;
        }
        return GradlePluginUpgrade.shouldRecommendUpgrade(current, recommended);
    }

    public static /* synthetic */ boolean shouldRecommendPluginUpgrade$default(Project project, GradleVersion gradleVersion2, GradleVersion gradleVersion3, int n, Object object) {
        if ((n & 2) != 0) {
            AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
            Object object2 = gradleVersion2 = androidPluginInfo != null ? androidPluginInfo.getPluginVersion() : null;
        }
        if ((n & 4) != 0) {
            GradleVersion gradleVersion4 = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion4, (String)"GradleVersion.parse(Late\u2026nProvider.INSTANCE.get())");
            gradleVersion3 = gradleVersion4;
        }
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade(project, gradleVersion2, gradleVersion3);
    }

    @Slow
    @JvmOverloads
    public static final boolean shouldRecommendPluginUpgrade(@NotNull Project project, @Nullable GradleVersion current) {
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade$default(project, current, null, 4, null);
    }

    @Slow
    @JvmOverloads
    public static final boolean shouldRecommendPluginUpgrade(@NotNull Project project) {
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade$default(project, null, null, 6, null);
    }

    public static final void recommendPluginUpgrade(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectUpgradeNotification[] existing2 = (ProjectUpgradeNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(ProjectUpgradeNotification.class, project);
        Intrinsics.checkNotNullExpressionValue((Object)existing2, (String)"existing");
        ProjectUpgradeNotification[] projectUpgradeNotificationArray = existing2;
        boolean bl = false;
        if (projectUpgradeNotificationArray.length == 0) {
            NotificationListener listener2 = new NotificationListener(project){
                final /* synthetic */ Project $project;

                public final void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                    Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                    notification.expire();
                    if (GradlePluginUpgrade.performRecommendedPluginUpgrade$default(this.$project, null, null, null, 14, null)) {
                        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_AGP_VERSION_UPDATED);
                        GradleSyncInvoker.getInstance().requestProjectSync(this.$project, request);
                    }
                }
                {
                    this.$project = project;
                }
            };
            ProjectUpgradeNotification notification = new ProjectUpgradeNotification(listener2);
            notification.notify(project);
        }
    }

    @Slow
    @VisibleForTesting
    @JvmOverloads
    public static final boolean performRecommendedPluginUpgrade(@NotNull Project project, @Nullable GradleVersion currentVersion, @NotNull GradleVersion recommendedVersion, @NotNull RecommendedPluginVersionUpgradeDialog.Factory dialogFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)recommendedVersion, (String)"recommendedVersion");
        Intrinsics.checkNotNullParameter((Object)dialogFactory, (String)"dialogFactory");
        if (currentVersion == null) {
            return false;
        }
        LOG.info("Gradle model version: " + currentVersion + ", recommended version for IDE: " + recommendedVersion + ", current, recommended");
        boolean userAccepted2 = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.NON_MODAL, (Function0)((Function0)new Function0<Boolean>(dialogFactory, project, currentVersion, recommendedVersion){
            final /* synthetic */ RecommendedPluginVersionUpgradeDialog.Factory $dialogFactory;
            final /* synthetic */ Project $project;
            final /* synthetic */ GradleVersion $currentVersion;
            final /* synthetic */ GradleVersion $recommendedVersion;

            public final boolean invoke() {
                RecommendedPluginVersionUpgradeDialog recommendedPluginVersionUpgradeDialog = this.$dialogFactory.create(this.$project, this.$currentVersion, this.$recommendedVersion);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)recommendedPluginVersionUpgradeDialog), (String)"dialogFactory.create(pro\u2026sion, recommendedVersion)");
                RecommendedPluginVersionUpgradeDialog updateDialog = recommendedPluginVersionUpgradeDialog;
                return updateDialog.showAndGet();
            }
            {
                this.$dialogFactory = factory;
                this.$project = project;
                this.$currentVersion = gradleVersion2;
                this.$recommendedVersion = gradleVersion3;
                super(0);
            }
        }));
        if (userAccepted2) {
            AndroidPluginVersionUpdater androidPluginVersionUpdater = AndroidPluginVersionUpdater.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)androidPluginVersionUpdater, (String)"AndroidPluginVersionUpdater.getInstance(project)");
            AndroidPluginVersionUpdater updater = androidPluginVersionUpdater;
            GradleVersion latestGradleVersion = GradleVersion.parse((String)"6.1.1");
            AndroidPluginVersionUpdater.UpdateResult updateResult = updater.updatePluginVersion(recommendedVersion, latestGradleVersion, currentVersion);
            if (updateResult.versionUpdateSuccess()) {
                return true;
            }
        }
        return false;
    }

    public static /* synthetic */ boolean performRecommendedPluginUpgrade$default(Project project, GradleVersion gradleVersion2, GradleVersion gradleVersion3, RecommendedPluginVersionUpgradeDialog.Factory factory, int n, Object object) {
        if ((n & 2) != 0) {
            AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
            Object object2 = gradleVersion2 = androidPluginInfo != null ? androidPluginInfo.getPluginVersion() : null;
        }
        if ((n & 4) != 0) {
            GradleVersion gradleVersion4 = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion4, (String)"GradleVersion.parse(Late\u2026nProvider.INSTANCE.get())");
            gradleVersion3 = gradleVersion4;
        }
        if ((n & 8) != 0) {
            factory = new RecommendedPluginVersionUpgradeDialog.Factory();
        }
        return GradlePluginUpgrade.performRecommendedPluginUpgrade(project, gradleVersion2, gradleVersion3, factory);
    }

    @Slow
    @VisibleForTesting
    @JvmOverloads
    public static final boolean performRecommendedPluginUpgrade(@NotNull Project project, @Nullable GradleVersion currentVersion, @NotNull GradleVersion recommendedVersion) {
        return GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, currentVersion, recommendedVersion, null, 8, null);
    }

    @Slow
    @VisibleForTesting
    @JvmOverloads
    public static final boolean performRecommendedPluginUpgrade(@NotNull Project project, @Nullable GradleVersion currentVersion) {
        return GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, currentVersion, null, null, 12, null);
    }

    @Slow
    @VisibleForTesting
    @JvmOverloads
    public static final boolean performRecommendedPluginUpgrade(@NotNull Project project) {
        return GradlePluginUpgrade.performRecommendedPluginUpgrade$default(project, null, null, null, 14, null);
    }

    @VisibleForTesting
    public static final boolean shouldRecommendUpgrade(@NotNull GradleVersion current, @NotNull GradleVersion recommended) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter((Object)recommended, (String)"recommended");
        if (recommended.isSnapshot() && current.compareIgnoringQualifiers(recommended) == 0) {
            return false;
        }
        if (current.isPreview() && recommended.isPreview() && !recommended.isSnapshot()) {
            return false;
        }
        if (!current.isPreview() && recommended.isPreview() && current.compareIgnoringQualifiers(recommended) < 0) {
            return true;
        }
        return current.compareTo(recommended) < 0;
    }

    public static final boolean shouldForcePluginUpgrade(@Nullable Project project, @Nullable GradleVersion current, @NotNull GradleVersion recommended) {
        Intrinsics.checkNotNullParameter((Object)recommended, (String)"recommended");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return false;
        }
        if (SystemProperties.getBooleanProperty((String)"studio.skip.agp.upgrade", (boolean)false)) {
            return false;
        }
        Object object = StudioFlags.DISABLE_FORCED_UPGRADES.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.DISABLE_FORCED_UPGRADES.get()");
        if (((Boolean)object).booleanValue()) {
            if (project != null) {
                GradlePluginUpgrade.displayForceUpdatesDisabledMessage(project);
            }
            return false;
        }
        return GradlePluginUpgrade.shouldForcePluginUpgrade(current, recommended);
    }

    public static /* synthetic */ boolean shouldForcePluginUpgrade$default(Project project, GradleVersion gradleVersion2, GradleVersion gradleVersion3, int n, Object object) {
        if ((n & 4) != 0) {
            GradleVersion gradleVersion4 = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion4, (String)"GradleVersion.parse(Late\u2026nProvider.INSTANCE.get())");
            gradleVersion3 = gradleVersion4;
        }
        return GradlePluginUpgrade.shouldForcePluginUpgrade(project, gradleVersion2, gradleVersion3);
    }

    @VisibleForTesting
    public static final boolean shouldForcePluginUpgrade(@Nullable GradleVersion current, @NotNull GradleVersion recommended) {
        Intrinsics.checkNotNullParameter((Object)recommended, (String)"recommended");
        GradleVersion gradleVersion2 = current;
        if ((gradleVersion2 != null ? gradleVersion2.getPreviewType() : null) == null) {
            return false;
        }
        if (recommended.isSnapshot() && current.compareIgnoringQualifiers(recommended) == 0) {
            return false;
        }
        if (recommended.isAtLeast(2, 4, 0, "alpha", 8, false)) {
            if (current.compareTo(recommended) >= 0) {
                return false;
            }
            if (Intrinsics.areEqual((Object)current.getPreviewType(), (Object)"rc") && recommended.getPreviewType() != null && current.getMajor() == recommended.getMajor() && current.getMinor() == recommended.getMinor() - 1) {
                return false;
            }
            boolean isOlderPluginAllowed = current.isPreview() && current.getMajor() == 2 && current.getMinor() == 4 && current.compareTo(recommended) < 0;
            return !isOlderPluginAllowed;
        }
        return current.compareTo(recommended) < 0;
    }

    @Slow
    public static final boolean performForcedPluginUpgrade(@NotNull Project project, @Nullable GradleVersion currentPluginVersion, @NotNull GradleVersion newPluginVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)newPluginVersion, (String)"newPluginVersion");
        boolean upgradeAccepted2 = (Boolean)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.NON_MODAL, (Function0)((Function0)new Function0<Boolean>(project, currentPluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ GradleVersion $currentPluginVersion;

            public final boolean invoke() {
                return new ForcedPluginPreviewVersionUpgradeDialog(this.$project, this.$currentPluginVersion).showAndGet();
            }
            {
                this.$project = project;
                this.$currentPluginVersion = gradleVersion2;
                super(0);
            }
        }));
        if (!upgradeAccepted2) {
            SyncMessage syncMessage = new SyncMessage("Gradle Sync Issues", com.android.tools.idea.project.messages.MessageType.ERROR, "The project is using an incompatible version of the Android Gradle plugin.", "Please update your project to use version " + newPluginVersion + '.');
            String pluginName = "com.android.tools.build:gradle";
            syncMessage.add(new SearchInBuildFilesHyperlink(pluginName));
            GradleSyncMessages.getInstance(project).report(syncMessage);
            return false;
        }
        AndroidPluginVersionUpdater androidPluginVersionUpdater = AndroidPluginVersionUpdater.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)androidPluginVersionUpdater, (String)"AndroidPluginVersionUpdater.getInstance(project)");
        AndroidPluginVersionUpdater versionUpdater = androidPluginVersionUpdater;
        versionUpdater.updatePluginVersion(newPluginVersion, GradleVersion.parse((String)"6.1.1"), currentPluginVersion);
        return true;
    }

    public static /* synthetic */ boolean performForcedPluginUpgrade$default(Project project, GradleVersion gradleVersion2, GradleVersion gradleVersion3, int n, Object object) {
        if ((n & 4) != 0) {
            GradleVersion gradleVersion4 = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion4, (String)"GradleVersion.parse(Late\u2026nProvider.INSTANCE.get())");
            gradleVersion3 = gradleVersion4;
        }
        return GradlePluginUpgrade.performForcedPluginUpgrade(project, gradleVersion2, gradleVersion3);
    }

    public static final void displayForceUpdatesDisabledMessage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        StringBuilder stringBuilder = new StringBuilder().append("Forced upgrades are disabled, errors seen may be due to incompatibilities between the Android Gradle Plugin and the version of Android Studio.\nTo re-enable forced updates please go to 'Tools > Internal Actions > Edit Studio Flags' and set ").append('\'');
        Flag flag = StudioFlags.DISABLE_FORCED_UPGRADES;
        Intrinsics.checkNotNullExpressionValue((Object)flag, (String)"DISABLE_FORCED_UPGRADES");
        String msg = stringBuilder.append(flag.getDisplayName()).append("' to 'Off'.").toString();
        MessageType messageType = MessageType.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.WARNING");
        Notification notification = AGP_UPGRADE_NOTIFICATION_GROUP.createNotification(msg, messageType);
        notification.notify(project);
    }

    private static final AndroidPluginInfo findPluginInfo(Project $this$findPluginInfo) {
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find($this$findPluginInfo);
        if (pluginInfo == null) {
            LOG.warn("Unable to obtain application's Android Project");
            return null;
        }
        return pluginInfo;
    }

    static {
        Logger logger2 = Logger.getInstance((String)"AndroidGradlePluginUpdates");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(\"AndroidGradlePluginUpdates\")");
        LOG = logger2;
        AGP_UPGRADE_NOTIFICATION_GROUP = new NotificationGroup("Android Gradle Upgrade Notification", NotificationDisplayType.STICKY_BALLOON, true, null, null, 24, null);
    }

    public static final /* synthetic */ AndroidPluginInfo access$findPluginInfo(Project $this$access_u24findPluginInfo) {
        return GradlePluginUpgrade.findPluginInfo($this$access_u24findPluginInfo);
    }
}

