/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.JarDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.ModuleDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.details.MultipleLibraryDependenciesDetails;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.GoToModuleAction;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.ModuleDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.graph.DependenciesTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.graph.DependenciesTreeRootNode;
import com.android.tools.idea.gradle.structure.configurables.dependencies.treeview.graph.DependenciesTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.issues.DependencyViewIssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseCollapseAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseExpandAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.NodeHyperlinkSupport;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDeclaredDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DependencyGraphPanel
extends AbstractDependenciesPanel {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final Tree myTree;
    @NotNull
    private final DependenciesTreeBuilder myTreeBuilder;
    @NotNull
    private final NodeHyperlinkSupport<ModuleDependencyNode> myHyperlinkSupport;
    @NotNull
    private final SelectionChangeEventDispatcher<List<AbstractDependencyNode<?, ? extends PsBaseDependency>>> myEventDispatcher;
    private final MergingUpdateQueue myUpdateIssuesQueue;
    private boolean myIgnoreTreeSelectionEvents;

    DependencyGraphPanel(@NotNull PsModule fakeModule, @NotNull PsContext context) {
        if (fakeModule == null) {
            DependencyGraphPanel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DependencyGraphPanel.$$$reportNull$$$0(1);
        }
        super("All Dependencies", context, null);
        this.myEventDispatcher = new SelectionChangeEventDispatcher();
        this.myUpdateIssuesQueue = new MergingUpdateQueue("myUpdateIssuesQueue", 300, true, (JComponent)this, (Disposable)this);
        this.myContext = context;
        this.myUpdateIssuesQueue.setRestartTimerOnAdd(true);
        this.initializeDependencyDetails();
        this.setIssuesViewer(new IssuesViewer(this.myContext, new DependencyViewIssuesRenderer(this.myContext)));
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree(treeModel){
            {
                this.setRowHeight(JBUI.scale((int)24));
            }

            protected void processMouseEvent(MouseEvent e) {
                ModuleDependencyNode node;
                int id = e.getID();
                if (id == 501 && (node = DependencyGraphPanel.this.myHyperlinkSupport.getIfHyperlink(e)) != null) {
                    PsModuleDependency moduleDependency = (PsModuleDependency)node.getFirstModel();
                    String name = moduleDependency.getName();
                    DependencyGraphPanel.this.myContext.setSelectedModule(name, DependencyGraphPanel.this);
                    return;
                }
                super.processMouseEvent(e);
            }
        };
        this.getContentsPanel().add((Component)this.createActionsPanel(), "North");
        DependenciesTreeStructure treeStructure = new DependenciesTreeStructure(this.createRootNode());
        this.myTreeBuilder = new DependenciesTreeBuilder((JTree)this.myTree, treeModel, treeStructure);
        JScrollPane scrollPane = UiUtil.setUp(this.myTreeBuilder, "dependenciesTree");
        this.getContentsPanel().add((Component)scrollPane, "Center");
        TreeSelectionListener treeSelectionListener = e -> {
            if (!this.myIgnoreTreeSelectionEvents) {
                PsBaseDependency selected;
                List<AbstractDependencyNode<?, PsBaseDependency>> selection = this.getSelection();
                PsBaseDependency psBaseDependency = selected = !selection.isEmpty() ? (PsBaseDependency)selection.get(0).getFirstModel() : null;
                if (selected == null) {
                    this.notifySelectionChanged(Collections.emptyList());
                } else {
                    this.notifySelectionChanged(selection);
                }
                this.updateDetails(selected);
                this.updateIssues(selection);
            }
            this.myIgnoreTreeSelectionEvents = false;
        };
        this.myTree.addTreeSelectionListener(treeSelectionListener);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DependencyGraphPanel.this.popupInvoked(x, y);
            }
        });
        this.myTreeBuilder.getInitialized().doWhenDone(this::doEnsureSelection);
        this.myHyperlinkSupport = new NodeHyperlinkSupport<ModuleDependencyNode>(this.myTree, ModuleDependencyNode.class, this.myContext, true);
        PsModule.DependenciesChangeListener dependenciesChangeListener = event -> {
            if (event instanceof PsModule.DependencyAddedEvent) {
                PsDeclaredDependency dependency = (PsDeclaredDependency)((PsModule.DependencyAddedEvent)event).getDependency().getValue();
                this.myTreeBuilder.reset(() -> {
                    AbstractDependencyNode found = this.myTreeBuilder.findDeclaredDependency(dependency);
                    if (found != null) {
                        this.myTreeBuilder.select(found);
                    }
                });
            } else {
                this.myTreeBuilder.reset(() -> {});
            }
        };
        this.myContext.getProject().forEachModule(module -> module.add(dependenciesChangeListener, this));
    }

    @NotNull
    private DependenciesTreeRootNode createRootNode() {
        return new DependenciesTreeRootNode(this.myContext.getProject(), this.myContext.getUiSettings());
    }

    @NotNull
    private List<AbstractDependencyNode<?, ? extends PsBaseDependency>> getSelection() {
        ArrayList selection = new ArrayList();
        Set matchingSelection = this.myTreeBuilder.getSelectedElements(AbstractDependencyNode.class);
        for (AbstractDependencyNode node : matchingSelection) {
            selection.add(node);
        }
        ArrayList arrayList = selection;
        if (arrayList == null) {
            DependencyGraphPanel.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private void updateIssues(final @NotNull List<AbstractDependencyNode<?, ? extends PsBaseDependency>> selection) {
        if (selection == null) {
            DependencyGraphPanel.$$$reportNull$$$0(3);
        }
        this.myUpdateIssuesQueue.queue(new Update(this){

            public void run() {
                HashSet<PsIssue> issues = new HashSet<PsIssue>();
                for (AbstractDependencyNode node : selection) {
                    for (PsBaseDependency dependency : node.getModels()) {
                        issues.addAll(DependencyGraphPanel.this.myContext.getAnalyzerDaemon().getIssues().findIssues(dependency.getPath(), null));
                    }
                }
                DependencyGraphPanel.this.displayIssues(issues, null);
            }
        });
    }

    private void notifySelectionChanged(@NotNull List<AbstractDependencyNode<?, ? extends PsBaseDependency>> selected) {
        if (selected == null) {
            DependencyGraphPanel.$$$reportNull$$$0(4);
        }
        this.myEventDispatcher.selectionChanged(selected);
    }

    private void popupInvoked(int x, int y) {
        ModuleDependencyNode node = this.myHyperlinkSupport.getNodeForLocation(x, y);
        if (node != null) {
            PsModuleDependency moduleDependency = (PsModuleDependency)node.getFirstModel();
            String name = moduleDependency.getName();
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.add((AnAction)new GoToModuleAction(name, this.getContext(), (JComponent)this.myTree));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group2);
            popupMenu.getComponent().show((Component)this.myTree, x, y);
        }
    }

    private void initializeDependencyDetails() {
        this.addDetails(new MultipleLibraryDependenciesDetails());
        this.addDetails(new JarDependencyDetails(this.getContext(), false));
        this.addDetails(new ModuleDependencyDetails(this.getContext(), false));
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            DependencyGraphPanel.$$$reportNull$$$0(5);
        }
        return tree;
    }

    void add(@NotNull SelectionChangeListener<List<AbstractDependencyNode<?, ? extends PsBaseDependency>>> listener2) {
        if (listener2 == null) {
            DependencyGraphPanel.$$$reportNull$$$0(6);
        }
        this.myEventDispatcher.addListener(listener2, this);
    }

    @Override
    @NotNull
    protected List<AnAction> getExtraToolbarActions(@NotNull JComponent focusComponent) {
        if (focusComponent == null) {
            DependencyGraphPanel.$$$reportNull$$$0(7);
        }
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        actions2.add((AnAction)new AbstractBaseExpandAllAction(this.myTree, AllIcons.Actions.Expandall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                DependencyGraphPanel.this.myTree.requestFocusInWindow();
                DependencyGraphPanel.this.myTreeBuilder.expandAllNodes();
                DependencyGraphPanel.this.doEnsureSelection();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel$4", "actionPerformed"));
            }
        });
        actions2.add((AnAction)new AbstractBaseCollapseAllAction(this.myTree, AllIcons.Actions.Collapseall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                DependencyGraphPanel.this.myTreeBuilder.clearSelection();
                DependencyGraphPanel.this.notifySelectionChanged(Collections.emptyList());
                DependencyGraphPanel.this.myTree.requestFocusInWindow();
                DependencyGraphPanel.this.myTreeBuilder.collapseAllNodes();
                DependencyGraphPanel.this.doEnsureSelection();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel$5", "actionPerformed"));
            }
        });
        ArrayList<AnAction> arrayList = actions2;
        if (arrayList == null) {
            DependencyGraphPanel.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private void doEnsureSelection() {
        TreeUtil.ensureSelection((JTree)this.myTree);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myTreeBuilder);
        Disposer.dispose(this.myHyperlinkSupport);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return ActionCallback.DONE;
    }

    @Override
    @NotNull
    protected String getPlaceName() {
        return "dependencies.graph.project";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateIssues";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "notifySelectionChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExtraToolbarActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

