/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.services;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.structure.services.DeveloperServiceBuildSystemOperations;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleOperations
implements DeveloperServiceBuildSystemOperations {
    @Override
    public boolean canHandle(@NotNull Project project) {
        if (project == null) {
            GradleOperations.$$$reportNull$$$0(0);
        }
        return GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }

    @Override
    public boolean containsAllDependencies(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        DependenciesModel dependenciesModel;
        if (module == null) {
            GradleOperations.$$$reportNull$$$0(1);
        }
        if (metadata == null) {
            GradleOperations.$$$reportNull$$$0(2);
        }
        ArrayList<String> moduleDependencyNames = new ArrayList<String>();
        GradleBuildModel buildModel = GradleBuildModel.get((Module)module);
        if (buildModel != null && (dependenciesModel = buildModel.dependencies()) != null) {
            for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
                String name = dependency.name().forceString();
                moduleDependencyNames.add(name);
            }
        }
        boolean allDependenciesFound = true;
        for (String serviceDependency : metadata.getDependencies()) {
            boolean thisDependencyFound = false;
            for (String moduleDependencyName : moduleDependencyNames) {
                if (!serviceDependency.contains(moduleDependencyName)) continue;
                thisDependencyFound = true;
                break;
            }
            if (thisDependencyFound) continue;
            allDependenciesFound = false;
            break;
        }
        return allDependenciesFound;
    }

    @Override
    public boolean isServiceInstalled(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        DependenciesModel dependenciesModel;
        GradleBuildModel buildModel;
        if (module == null) {
            GradleOperations.$$$reportNull$$$0(3);
        }
        if (metadata == null) {
            GradleOperations.$$$reportNull$$$0(4);
        }
        if ((buildModel = GradleBuildModel.get((Module)module)) != null && (dependenciesModel = buildModel.dependencies()) != null) {
            for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
                ArtifactDependencySpec spec = ArtifactDependencySpec.create((ArtifactDependencyModel)dependency);
                for (String dependencyValue : metadata.getDependencies()) {
                    ArtifactDependencySpec value2 = ArtifactDependencySpec.create((String)dependencyValue);
                    assert (value2 != null);
                    if (!value2.equalsIgnoreVersion((Object)spec) || VersionComparatorUtil.compare((String)spec.getVersion(), (String)value2.getVersion()) < 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void removeDependencies(@NotNull Module module, @NotNull DeveloperServiceMetadata metadata) {
        GradleBuildModel buildModel;
        if (module == null) {
            GradleOperations.$$$reportNull$$$0(5);
        }
        if (metadata == null) {
            GradleOperations.$$$reportNull$$$0(6);
        }
        if ((buildModel = GradleBuildModel.get((Module)module)) != null) {
            boolean dependenciesChanged = false;
            DependenciesModel dependenciesModel = buildModel.dependencies();
            if (dependenciesModel != null) {
                block0: for (ArtifactDependencyModel dependency : dependenciesModel.artifacts()) {
                    ArtifactDependencySpec spec = ArtifactDependencySpec.create((ArtifactDependencyModel)dependency);
                    for (String dependencyValue : metadata.getDependencies()) {
                        if (!spec.equals((Object)ArtifactDependencySpec.create((String)dependencyValue))) continue;
                        dependenciesModel.remove((DependencyModel)dependency);
                        dependenciesChanged = true;
                        continue block0;
                    }
                }
            }
            Project project = module.getProject();
            if (dependenciesChanged) {
                new WriteCommandAction.Simple(project, "Uninstall " + metadata.getName(), new PsiFile[0]){

                    public void run() {
                        buildModel.applyChanges();
                    }
                }.execute();
            }
            GradleSyncInvoker.getInstance().requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_PSD_DEPENDENCY_REMOVED);
        }
    }

    @Override
    public void initializeServices(@NotNull Module module, final @NotNull Runnable initializationTask) {
        if (module == null) {
            GradleOperations.$$$reportNull$$$0(7);
        }
        if (initializationTask == null) {
            GradleOperations.$$$reportNull$$$0(8);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        assert (facet2 != null);
        GradleSyncState.subscribe(module.getProject(), new GradleSyncListener(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                initializationTask.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/structure/services/GradleOperations$2", "syncSucceeded"));
            }
        }, (Disposable)module);
    }

    @Override
    @NotNull
    public String getBuildSystemId() {
        return "Gradle";
    }

    @Override
    @Nullable
    public String getHighestVersion(@NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            GradleOperations.$$$reportNull$$$0(9);
        }
        if (artifactId == null) {
            GradleOperations.$$$reportNull$$$0(10);
        }
        GradleCoordinate gradleCoordinate = new GradleCoordinate(groupId, artifactId, new GradleCoordinate.RevisionComponent[]{GradleCoordinate.PLUS_REV});
        return RepositoryUrlManager.get().resolveDynamicCoordinateVersion(gradleCoordinate, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadata";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializationTask";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/services/GradleOperations";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandle";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "containsAllDependencies";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isServiceInstalled";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDependencies";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeServices";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getHighestVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

