/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.builder.model.AppBundleProjectBuildOutput;
import com.android.builder.model.AppBundleVariantBuildOutput;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.AndroidPluginVersionUpdater;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.run.AndroidAppRunConfigurationBase;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicAppUtils {
    private static final int UPDATE_BUTTON_INDEX = 1;

    @NotNull
    public static List<Module> getDependentFeatureModulesForBase(@NotNull Module module) {
        AndroidModuleModel androidModule;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(0);
        }
        if ((androidModule = AndroidModuleModel.get(module)) == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                DynamicAppUtils.$$$reportNull$$$0(1);
            }
            return immutableList;
        }
        return DynamicAppUtils.getDependentFeatureModulesForBase(module.getProject(), androidModule.getAndroidProject());
    }

    @Nullable
    public static Module getBaseFeature(@NotNull Module module) {
        String gradlePath;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(2);
        }
        if ((gradlePath = DynamicAppUtils.getGradlePath(module)) == null) {
            return null;
        }
        return Arrays.stream(ModuleManager.getInstance((Project)module.getProject()).getModules()).filter(baseModule -> {
            AndroidModuleModel baseModel = AndroidModuleModel.get(baseModule);
            return baseModel != null && baseModel.getAndroidProject().getDynamicFeatures().contains(gradlePath);
        }).findFirst().orElse(null);
    }

    @NotNull
    public static List<Module> getDependentFeatureModulesForBase(@NotNull Project project, @NotNull IdeAndroidProject androidProject) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(3);
        }
        if (androidProject == null) {
            DynamicAppUtils.$$$reportNull$$$0(4);
        }
        Map<String, Module> featureMap = DynamicAppUtils.getDynamicFeaturesMap(project);
        List<Module> list = androidProject.getDynamicFeatures().stream().map(featurePath -> (Module)featureMap.get(featurePath)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            DynamicAppUtils.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<Module> getModulesToBuild(@NotNull Module module) {
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(6);
        }
        List<Module> list = Stream.concat(Stream.of(module), DynamicAppUtils.getDependentFeatureModulesForBase(module).stream()).collect(Collectors.toList());
        if (list == null) {
            DynamicAppUtils.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static List<Module> getFeatureModulesDependingOnFeature(@NotNull Module featureModule) {
        if (featureModule == null) {
            DynamicAppUtils.$$$reportNull$$$0(8);
        }
        if (!((Boolean)StudioFlags.SUPPORT_FEATURE_ON_FEATURE_DEPS.get()).booleanValue()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                DynamicAppUtils.$$$reportNull$$$0(9);
            }
            return immutableList;
        }
        return DynamicAppUtils.selectFeatureModules(ModuleManager.getInstance((Project)featureModule.getProject()).getModuleDependentModules(featureModule).stream());
    }

    @NotNull
    public static List<Module> getFeatureModuleDependenciesForFeature(@NotNull Module featureModule) {
        if (featureModule == null) {
            DynamicAppUtils.$$$reportNull$$$0(10);
        }
        if (!((Boolean)StudioFlags.SUPPORT_FEATURE_ON_FEATURE_DEPS.get()).booleanValue()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                DynamicAppUtils.$$$reportNull$$$0(11);
            }
            return immutableList;
        }
        return DynamicAppUtils.selectFeatureModules(Stream.of(ModuleRootManager.getInstance((Module)featureModule).getDependencies()));
    }

    @NotNull
    public static boolean baseIsInstantEnabled(@NotNull Project project) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(12);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel model2 = AndroidModuleModel.get(module);
            if (model2 == null || !model2.getAndroidProject().isBaseSplit() || !model2.getSelectedVariant().isInstantAppCompatible()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Module> getModulesSupportingBundleTask(@NotNull Project project) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(13);
        }
        List<Module> list = ProjectStructure.getInstance(project).getAppModules().stream().filter(module -> DynamicAppUtils.supportsBundleTask(module)).collect(Collectors.toList());
        if (list == null) {
            DynamicAppUtils.$$$reportNull$$$0(14);
        }
        return list;
    }

    public static boolean supportsBundleTask(@NotNull Module module) {
        AndroidModuleModel androidModule;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(15);
        }
        if ((androidModule = AndroidModuleModel.get(module)) == null) {
            return false;
        }
        return !StringUtil.isEmpty((String)androidModule.getSelectedVariant().getMainArtifact().getBundleTaskName());
    }

    public static boolean promptUserForGradleUpdate(@NotNull Project project) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(16);
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.openHtmlBody();
        builder2.add("Building Android App Bundles requires you to update to the latest version of the Android Gradle Plugin.");
        builder2.newline();
        builder2.addLink("Learn More", "https://d.android.com/r/studio-ui/dynamic-delivery/overview.html");
        builder2.newline();
        builder2.newline();
        builder2.add("App bundles allow you to support multiple device configurations from a single build artifact.");
        builder2.newline();
        builder2.add("App stores that support the bundle format use it to build and sign your APKs for you, and");
        builder2.newline();
        builder2.add("serve those APKs to users as needed.");
        builder2.newline();
        builder2.newline();
        builder2.closeHtmlBody();
        int result2 = Messages.showDialog((Project)project, (String)builder2.getHtml(), (String)"Update the Android Gradle Plugin", (String[])new String[]{Messages.getCancelButton(), "Update"}, (int)1, (Icon)AllIcons.General.WarningDialog);
        if (result2 == 1) {
            ApplicationManager.getApplication().invokeLater(() -> {
                GradleVersion gradleVersion2 = GradleVersion.parse((String)"6.1.1");
                GradleVersion pluginVersion = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
                AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(project);
                Runnable updatePluginVersion = () -> {
                    AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(project);
                    updater.updatePluginVersion(pluginVersion, gradleVersion2, pluginInfo == null ? null : pluginInfo.getPluginVersion());
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    updatePluginVersion.run();
                } else {
                    ApplicationManager.getApplication().executeOnPooledThread(updatePluginVersion);
                }
            });
        }
        return result2 == 1;
    }

    @NotNull
    public static String getFeatureNameFromPathHack(@NotNull Path path2) {
        String fileName;
        int separatorIndex;
        if (path2 == null) {
            DynamicAppUtils.$$$reportNull$$$0(17);
        }
        if ((separatorIndex = (fileName = path2.getFileName().toString()).lastIndexOf(45)) < 0) {
            return "";
        }
        String string = fileName.substring(0, separatorIndex);
        if (string == null) {
            DynamicAppUtils.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public static ApkInfo collectAppBundleOutput(@NotNull Module module, @NotNull PostBuildModelProvider outputModelProvider, @NotNull String pkgName) {
        AndroidModuleModel androidModel;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(19);
        }
        if (outputModelProvider == null) {
            DynamicAppUtils.$$$reportNull$$$0(20);
        }
        if (pkgName == null) {
            DynamicAppUtils.$$$reportNull$$$0(21);
        }
        if ((androidModel = AndroidModuleModel.get(module)) == null) {
            DynamicAppUtils.getLogger().warn("Android model is null. Sync might have failed");
            return null;
        }
        PostBuildModel model2 = outputModelProvider.getPostBuildModel();
        if (model2 == null) {
            DynamicAppUtils.getLogger().warn("Post build model is null. Build might have failed.");
            return null;
        }
        AppBundleProjectBuildOutput output = model2.findAppBundleProjectBuildOutput(module);
        if (output == null) {
            DynamicAppUtils.getLogger().warn("Project output is null. Build may have failed.");
            return null;
        }
        for (AppBundleVariantBuildOutput variantBuildOutput : output.getAppBundleVariantsBuildOutput()) {
            ApkInfo apkInfo;
            block15: {
                if (!variantBuildOutput.getName().equals(androidModel.getSelectedVariant().getName())) continue;
                File apkFolder = variantBuildOutput.getApkFolder();
                Stream<Path> stream = Files.list(apkFolder.toPath());
                try {
                    List<ApkFileUnit> apks = stream.map(path2 -> new ApkFileUnit(DynamicAppUtils.getFeatureNameFromPathHack(path2), path2.toFile())).collect(Collectors.toList());
                    apkInfo = new ApkInfo(apks, pkgName);
                    if (stream == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        DynamicAppUtils.getLogger().warn(String.format("Error reading list of APK files from bundle build output directory \"%s\".", apkFolder), (Throwable)e);
                        return null;
                    }
                }
                stream.close();
            }
            return apkInfo;
        }
        DynamicAppUtils.getLogger().warn("Bundle variant build output model has no entries. Build may have failed.");
        return null;
    }

    public static boolean useSelectApksFromBundleBuilder(@NotNull Module module, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        AndroidModuleModel androidModuleModel;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(22);
        }
        if (configuration == null) {
            DynamicAppUtils.$$$reportNull$$$0(23);
        }
        if (targetDevices == null) {
            DynamicAppUtils.$$$reportNull$$$0(24);
        }
        if (configuration instanceof AndroidAppRunConfigurationBase) {
            AndroidAppRunConfigurationBase androidConfiguration = (AndroidAppRunConfigurationBase)configuration;
            if (androidConfiguration.DEPLOY_APK_FROM_BUNDLE) {
                Preconditions.checkArgument((boolean)androidConfiguration.DEPLOY);
                return true;
            }
        }
        if (targetDevices.stream().anyMatch(device -> device.getVersion().getFeatureLevel() < 21) && !DynamicAppUtils.getDependentFeatureModulesForBase(module).isEmpty()) {
            return true;
        }
        return configuration instanceof AndroidTestRunConfiguration && (androidModuleModel = AndroidModuleModel.get(module)) != null && androidModuleModel.getAndroidProject().getProjectType() == 6;
    }

    public static boolean shouldCollectListOfLanguages(@NotNull Module module, @NotNull RunConfiguration configuration, @NotNull List<AndroidDevice> targetDevices) {
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(25);
        }
        if (configuration == null) {
            DynamicAppUtils.$$$reportNull$$$0(26);
        }
        if (targetDevices == null) {
            DynamicAppUtils.$$$reportNull$$$0(27);
        }
        if (!DynamicAppUtils.useSelectApksFromBundleBuilder(module, configuration, targetDevices)) {
            return false;
        }
        return targetDevices.stream().allMatch(device -> device.getVersion().getFeatureLevel() >= 21);
    }

    @NotNull
    public static List<Module> getDependentInstantFeatureModules(@NotNull Module module) {
        AndroidModuleModel androidModule;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(28);
        }
        if ((androidModule = AndroidModuleModel.get(module)) == null) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                DynamicAppUtils.$$$reportNull$$$0(29);
            }
            return immutableList;
        }
        return DynamicAppUtils.getDependentInstantFeatureModules(module.getProject(), androidModule.getAndroidProject());
    }

    @NotNull
    public static List<Module> getDependentInstantFeatureModules(@NotNull Project project, @NotNull IdeAndroidProject androidProject) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(30);
        }
        if (androidProject == null) {
            DynamicAppUtils.$$$reportNull$$$0(31);
        }
        Map<String, Module> featureMap = DynamicAppUtils.getDynamicFeaturesMap(project);
        List<Module> list = androidProject.getDynamicFeatures().stream().map(featurePath -> (Module)featureMap.get(featurePath)).filter(Objects::nonNull).filter(f -> AndroidModuleModel.get(f).getSelectedVariant().isInstantAppCompatible()).collect(Collectors.toList());
        if (list == null) {
            DynamicAppUtils.$$$reportNull$$$0(32);
        }
        return list;
    }

    public static boolean isFeatureEnabled(@NotNull List<String> myDisabledFeatures, @NotNull ApkFileUnit apkFileUnit) {
        if (myDisabledFeatures == null) {
            DynamicAppUtils.$$$reportNull$$$0(33);
        }
        if (apkFileUnit == null) {
            DynamicAppUtils.$$$reportNull$$$0(34);
        }
        return myDisabledFeatures.stream().noneMatch(m -> DynamicAppUtils.featureNameEquals(apkFileUnit, m));
    }

    public static boolean featureNameEquals(@NotNull ApkFileUnit apkFileUnit, @NotNull String featureName) {
        if (apkFileUnit == null) {
            DynamicAppUtils.$$$reportNull$$$0(35);
        }
        if (featureName == null) {
            DynamicAppUtils.$$$reportNull$$$0(36);
        }
        return StringUtil.equals((CharSequence)featureName.replace('-', '_'), (CharSequence)apkFileUnit.getModuleName());
    }

    @NotNull
    private static Map<String, Module> getDynamicFeaturesMap(@NotNull Project project) {
        if (project == null) {
            DynamicAppUtils.$$$reportNull$$$0(37);
        }
        Map<String, Module> map2 = Arrays.stream(ModuleManager.getInstance((Project)project).getModules()).map(module -> {
            AndroidModuleModel model2 = AndroidModuleModel.get(module);
            if (model2 == null) {
                return null;
            }
            if (model2.getAndroidProject().getProjectType() != 6) {
                return null;
            }
            String gradlePath = DynamicAppUtils.getGradlePath(module);
            if (gradlePath == null) {
                return null;
            }
            return Pair.create((Object)gradlePath, (Object)module);
        }).filter(Objects::nonNull).collect(Collectors.toMap(p -> (String)p.first, p -> (Module)p.second, DynamicAppUtils::handleModuleAmbiguity));
        if (map2 == null) {
            DynamicAppUtils.$$$reportNull$$$0(38);
        }
        return map2;
    }

    @NotNull
    private static List<Module> selectFeatureModules(Stream<Module> moduleStream) {
        List<Module> list = moduleStream.filter(module -> {
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null) {
                return false;
            }
            int type = androidModuleModel.getAndroidProject().getProjectType();
            return type == 5 || type == 6;
        }).collect(Collectors.toList());
        if (list == null) {
            DynamicAppUtils.$$$reportNull$$$0(39);
        }
        return list;
    }

    @Nullable
    private static String getGradlePath(@NotNull Module module) {
        GradleFacet facet2;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(40);
        }
        if ((facet2 = GradleFacet.getInstance(module)) == null) {
            return null;
        }
        GradleModuleModel gradleModel = facet2.getGradleModuleModel();
        if (gradleModel == null) {
            return null;
        }
        return gradleModel.getGradlePath();
    }

    @NotNull
    private static Module handleModuleAmbiguity(@NotNull Module m1, @NotNull Module m2) {
        if (m1 == null) {
            DynamicAppUtils.$$$reportNull$$$0(41);
        }
        if (m2 == null) {
            DynamicAppUtils.$$$reportNull$$$0(42);
        }
        DynamicAppUtils.getLogger().warn(String.format("Unexpected ambiguity processing modules: %s - %s", m1.getName(), m2.getName()));
        Module module = m1;
        if (module == null) {
            DynamicAppUtils.$$$reportNull$$$0(43);
        }
        return module;
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(DynamicAppUtils.class);
        if (logger2 == null) {
            DynamicAppUtils.$$$reportNull$$$0(44);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 29: 
            case 32: 
            case 38: 
            case 39: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 29: 
            case 32: 
            case 38: 
            case 39: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 29: 
            case 32: 
            case 38: 
            case 39: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/DynamicAppUtils";
                break;
            }
            case 3: 
            case 12: 
            case 13: 
            case 16: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureModule";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputModelProvider";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkgName";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDevices";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDisabledFeatures";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFileUnit";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m1";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/DynamicAppUtils";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentFeatureModulesForBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesToBuild";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureModulesDependingOnFeature";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureModuleDependenciesForFeature";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesSupportingBundleTask";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureNameFromPathHack";
                break;
            }
            case 29: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentInstantFeatureModules";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicFeaturesMap";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFeatureModules";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "handleModuleAmbiguity";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDependentFeatureModulesForBase";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 29: 
            case 32: 
            case 38: 
            case 39: 
            case 43: 
            case 44: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBaseFeature";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModulesToBuild";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureModulesDependingOnFeature";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureModuleDependenciesForFeature";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "baseIsInstantEnabled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModulesSupportingBundleTask";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "supportsBundleTask";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "promptUserForGradleUpdate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureNameFromPathHack";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectAppBundleOutput";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "useSelectApksFromBundleBuilder";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldCollectListOfLanguages";
                break;
            }
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDependentInstantFeatureModules";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isFeatureEnabled";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "featureNameEquals";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getDynamicFeaturesMap";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getGradlePath";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "handleModuleAmbiguity";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 29: 
            case 32: 
            case 38: 
            case 39: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

