/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.androidSql.psi;

import com.android.tools.idea.lang.androidSql.psi.AndroidSqlBindParameter;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlColumnAliasName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlColumnDefinitionName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlColumnName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlColumnRefExpression;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlDefinedTableName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlFromTable;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlPsiTypes;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlResultColumns;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectStatement;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectSubquery;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSelectedTableName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlSingleTableStatementTable;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlTableAliasName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlTableDefinitionName;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlWithClauseTable;
import com.android.tools.idea.lang.androidSql.psi.AndroidSqlWithClauseTableDef;
import com.android.tools.idea.lang.androidSql.refactoring.AndroidSqlNameElementManipulator;
import com.android.tools.idea.lang.androidSql.resolution.AliasColumnsTable;
import com.android.tools.idea.lang.androidSql.resolution.AliasedTable;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlColumnPsiReference;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlDefinedTablePsiReference;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlParameterReference;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlSelectedTablePsiReference;
import com.android.tools.idea.lang.androidSql.resolution.AndroidSqlTable;
import com.android.tools.idea.lang.androidSql.resolution.QualifiedColumnPsiReference;
import com.android.tools.idea.lang.androidSql.resolution.SubqueryTable;
import com.android.tools.idea.lang.androidSql.resolution.UnqualifiedColumnPsiReference;
import com.android.tools.idea.lang.androidSql.resolution.WithClauseTable;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000x\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\r\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\r\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0016\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001d\u001a\u00020\u001e\u001a\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001f\u001a\u00020 \u001a\u0010\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020#\u001a\u000e\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010&\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0001\u001a\u0016\u0010&\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0001\u001a\u0016\u0010&\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0001\u001a\u0016\u0010&\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0001\u00a8\u0006("}, d2={"getName", "", "columnAliasName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlColumnAliasName;", "columnDefinitionName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlColumnDefinitionName;", "tableAliasName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlTableAliasName;", "tableDefinitionName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlTableDefinitionName;", "getParameterNameAsString", "bindParameter", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlBindParameter;", "getReference", "Lcom/intellij/psi/PsiReference;", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlColumnPsiReference;", "columnName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlColumnName;", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlDefinedTablePsiReference;", "tableName", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlDefinedTableName;", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlSelectedTablePsiReference;", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlSelectedTableName;", "getSqlTable", "Lcom/android/tools/idea/lang/androidSql/resolution/AndroidSqlTable;", "fromTable", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlFromTable;", "resultColumns", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlResultColumns;", "subquery", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlSelectSubquery;", "table", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlSingleTableStatementTable;", "getTableDefinition", "withClauseTable", "Lcom/android/tools/idea/lang/androidSql/psi/AndroidSqlWithClauseTable;", "isColonNamedParameter", "", "setName", "newName", "intellij.android.lang"})
@JvmName(name="PsiImplUtil")
public final class PsiImplUtil {
    @NotNull
    public static final AndroidSqlSelectedTablePsiReference getReference(@NotNull AndroidSqlSelectedTableName tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return new AndroidSqlSelectedTablePsiReference(tableName);
    }

    @NotNull
    public static final AndroidSqlDefinedTablePsiReference getReference(@NotNull AndroidSqlDefinedTableName tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        return new AndroidSqlDefinedTablePsiReference(tableName, !(tableName.getParent() instanceof AndroidSqlSingleTableStatementTable));
    }

    @NotNull
    public static final AndroidSqlColumnPsiReference getReference(@NotNull AndroidSqlColumnName columnName) {
        AndroidSqlSelectedTableName tableName;
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        PsiElement parent = columnName.getParent();
        if (parent instanceof AndroidSqlColumnRefExpression && (tableName = ((AndroidSqlColumnRefExpression)parent).getSelectedTableName()) != null) {
            return new QualifiedColumnPsiReference(columnName, tableName);
        }
        return new UnqualifiedColumnPsiReference(columnName);
    }

    @Nullable
    public static final PsiReference getReference(@NotNull AndroidSqlBindParameter bindParameter) {
        Intrinsics.checkNotNullParameter((Object)bindParameter, (String)"bindParameter");
        return bindParameter.isColonNamedParameter() ? (PsiReference)new AndroidSqlParameterReference(bindParameter) : null;
    }

    @Nullable
    public static final String getParameterNameAsString(@NotNull AndroidSqlBindParameter bindParameter) {
        String string;
        Intrinsics.checkNotNullParameter((Object)bindParameter, (String)"bindParameter");
        if (PsiImplUtil.isColonNamedParameter(bindParameter)) {
            String string2 = bindParameter.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bindParameter.text");
            String string3 = string2;
            int n = 1;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isColonNamedParameter(@NotNull AndroidSqlBindParameter bindParameter) {
        Intrinsics.checkNotNullParameter((Object)bindParameter, (String)"bindParameter");
        ASTNode aSTNode = bindParameter.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"bindParameter.node");
        ASTNode aSTNode2 = aSTNode.getFirstChildNode();
        if (aSTNode2 == null) return false;
        ASTNode node = aSTNode2;
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)AndroidSqlPsiTypes.NAMED_PARAMETER)) return false;
        CharSequence charSequence = node.getChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"node.chars");
        if (!StringsKt.startsWith$default((CharSequence)charSequence, (char)':', (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Nullable
    public static final AndroidSqlTable getSqlTable(@NotNull AndroidSqlFromTable fromTable) {
        Intrinsics.checkNotNullParameter((Object)fromTable, (String)"fromTable");
        AndroidSqlDefinedTableName androidSqlDefinedTableName = fromTable.getDefinedTableName();
        Intrinsics.checkNotNullExpressionValue((Object)androidSqlDefinedTableName, (String)"fromTable.definedTableName");
        AndroidSqlTable androidSqlTable = androidSqlDefinedTableName.getReference().resolveSqlTable();
        if (androidSqlTable == null) {
            return null;
        }
        AndroidSqlTable realTable = androidSqlTable;
        AndroidSqlTableAliasName alias = fromTable.getTableAliasName();
        return alias != null ? (AndroidSqlTable)new AliasedTable(realTable, alias.getNameAsString(), alias) : realTable;
    }

    @Nullable
    public static final AndroidSqlTable getSqlTable(@NotNull AndroidSqlSelectSubquery subquery) {
        Intrinsics.checkNotNullParameter((Object)subquery, (String)"subquery");
        AndroidSqlSelectStatement androidSqlSelectStatement = subquery.getSelectStatement();
        if (androidSqlSelectStatement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidSqlSelectStatement, (String)"subquery.selectStatement ?: return null");
        SubqueryTable subqueryTable = new SubqueryTable(androidSqlSelectStatement);
        AndroidSqlTableAliasName alias = subquery.getTableAliasName();
        return alias == null ? (AndroidSqlTable)subqueryTable : (AndroidSqlTable)new AliasedTable(subqueryTable, alias.getNameAsString(), alias);
    }

    @Nullable
    public static final AndroidSqlTable getSqlTable(@NotNull AndroidSqlResultColumns resultColumns) {
        Intrinsics.checkNotNullParameter((Object)resultColumns, (String)"resultColumns");
        return new AliasColumnsTable(resultColumns);
    }

    @Nullable
    public static final AndroidSqlTable getTableDefinition(@NotNull AndroidSqlWithClauseTable withClauseTable) {
        AndroidSqlTable androidSqlTable;
        Intrinsics.checkNotNullParameter((Object)withClauseTable, (String)"withClauseTable");
        AndroidSqlWithClauseTableDef androidSqlWithClauseTableDef = withClauseTable.getWithClauseTableDef();
        Intrinsics.checkNotNullExpressionValue((Object)androidSqlWithClauseTableDef, (String)"withClauseTable.withClauseTableDef");
        List<AndroidSqlColumnDefinitionName> list = androidSqlWithClauseTableDef.getColumnDefinitionNameList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"withClauseTable.withClau\u2026.columnDefinitionNameList");
        Collection collection2 = list;
        boolean bl = false;
        if (!collection2.isEmpty()) {
            androidSqlTable = new WithClauseTable(withClauseTable);
        } else {
            AndroidSqlWithClauseTableDef androidSqlWithClauseTableDef2 = withClauseTable.getWithClauseTableDef();
            Intrinsics.checkNotNullExpressionValue((Object)androidSqlWithClauseTableDef2, (String)"withClauseTable.withClauseTableDef");
            AndroidSqlTableDefinitionName androidSqlTableDefinitionName = androidSqlWithClauseTableDef2.getTableDefinitionName();
            Intrinsics.checkNotNullExpressionValue((Object)androidSqlTableDefinitionName, (String)"withClauseTable.withClau\u2026leDef.tableDefinitionName");
            AndroidSqlTableDefinitionName tableName = androidSqlTableDefinitionName;
            String string = tableName.getNameAsString();
            PsiElement psiElement = tableName;
            AndroidSqlSelectStatement androidSqlSelectStatement = withClauseTable.getSelectStatement();
            if (androidSqlSelectStatement == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)androidSqlSelectStatement, (String)"withClauseTable.selectStatement ?: return null");
            AndroidSqlTable androidSqlTable2 = new SubqueryTable(androidSqlSelectStatement);
            PsiElement psiElement2 = psiElement;
            String string2 = string;
            androidSqlTable = new AliasedTable(androidSqlTable2, string2, psiElement2);
        }
        return androidSqlTable;
    }

    @Nullable
    public static final AndroidSqlTable getSqlTable(@NotNull AndroidSqlSingleTableStatementTable table2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        AndroidSqlDefinedTableName androidSqlDefinedTableName = table2.getDefinedTableName();
        Intrinsics.checkNotNullExpressionValue((Object)androidSqlDefinedTableName, (String)"table.definedTableName");
        return androidSqlDefinedTableName.getReference().resolveSqlTable();
    }

    @NotNull
    public static final String getName(@NotNull AndroidSqlTableAliasName tableAliasName) {
        Intrinsics.checkNotNullParameter((Object)tableAliasName, (String)"tableAliasName");
        return tableAliasName.getNameAsString();
    }

    @NotNull
    public static final AndroidSqlTableAliasName setName(@NotNull AndroidSqlTableAliasName tableAliasName, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)tableAliasName, (String)"tableAliasName");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        new AndroidSqlNameElementManipulator().handleContentChange(tableAliasName, newName2);
        return tableAliasName;
    }

    @NotNull
    public static final String getName(@NotNull AndroidSqlTableDefinitionName tableDefinitionName) {
        Intrinsics.checkNotNullParameter((Object)tableDefinitionName, (String)"tableDefinitionName");
        return tableDefinitionName.getNameAsString();
    }

    @NotNull
    public static final AndroidSqlTableDefinitionName setName(@NotNull AndroidSqlTableDefinitionName tableDefinitionName, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)tableDefinitionName, (String)"tableDefinitionName");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        new AndroidSqlNameElementManipulator().handleContentChange(tableDefinitionName, newName2);
        return tableDefinitionName;
    }

    @NotNull
    public static final String getName(@NotNull AndroidSqlColumnAliasName columnAliasName) {
        Intrinsics.checkNotNullParameter((Object)columnAliasName, (String)"columnAliasName");
        return columnAliasName.getNameAsString();
    }

    @NotNull
    public static final AndroidSqlColumnAliasName setName(@NotNull AndroidSqlColumnAliasName columnAliasName, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)columnAliasName, (String)"columnAliasName");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        new AndroidSqlNameElementManipulator().handleContentChange(columnAliasName, newName2);
        return columnAliasName;
    }

    @NotNull
    public static final String getName(@NotNull AndroidSqlColumnDefinitionName columnDefinitionName) {
        Intrinsics.checkNotNullParameter((Object)columnDefinitionName, (String)"columnDefinitionName");
        return columnDefinitionName.getNameAsString();
    }

    @NotNull
    public static final AndroidSqlColumnDefinitionName setName(@NotNull AndroidSqlColumnDefinitionName columnDefinitionName, @NotNull String newName2) {
        Intrinsics.checkNotNullParameter((Object)columnDefinitionName, (String)"columnDefinitionName");
        Intrinsics.checkNotNullParameter((Object)newName2, (String)"newName");
        new AndroidSqlNameElementManipulator().handleContentChange(columnDefinitionName, newName2);
        return columnDefinitionName;
    }
}

