/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.layoutinspector.proto.SkiaParser;
import com.android.tools.idea.layoutinspector.proto.SkiaParserServiceGrpc;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.net.NetUtils;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.NettyChannelBuilder;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\n\u0010'\u001a\u0004\u0018\u00010\u001fH\u0002J\u0010\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+J\u0012\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010)2\u0006\u0010.\u001a\u00020/H\u0002J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000201J\u0006\u00103\u001a\u000201J\b\u00104\u001a\u000205H\u0002R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b \u0010!R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u00066"}, d2={"Lcom/android/tools/idea/layoutinspector/ServerInfo;", "", "serverVersion", "", "skpStart", "skpEnd", "(Ljava/lang/Integer;ILjava/lang/Integer;)V", "channel", "Lio/grpc/ManagedChannel;", "getChannel", "()Lio/grpc/ManagedChannel;", "setChannel", "(Lio/grpc/ManagedChannel;)V", "client", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParserServiceGrpc$SkiaParserServiceBlockingStub;", "getClient", "()Lcom/android/tools/idea/layoutinspector/proto/SkiaParserServiceGrpc$SkiaParserServiceBlockingStub;", "setClient", "(Lcom/android/tools/idea/layoutinspector/proto/SkiaParserServiceGrpc$SkiaParserServiceBlockingStub;)V", "handler", "Lcom/intellij/execution/process/OSProcessHandler;", "getHandler", "()Lcom/intellij/execution/process/OSProcessHandler;", "setHandler", "(Lcom/intellij/execution/process/OSProcessHandler;)V", "packagePath", "", "progressIndicator", "Lcom/android/tools/idea/sdk/progress/StudioLoggerProgressIndicator;", "serverName", "serverPath", "Ljava/io/File;", "getServerVersion", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "skpVersionRange", "Lkotlin/ranges/IntRange;", "getSkpVersionRange", "()Lkotlin/ranges/IntRange;", "findPath", "getViewTree", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$GetViewTreeResponse;", "data", "", "getViewTreeImpl", "getViewTreeWithRetry", "request", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$GetViewTreeRequest;", "ping", "", "runServer", "shutdown", "tryDownload", "", "intellij.android.layout-inspector"})
final class ServerInfo {
    private final String serverName;
    @NotNull
    private final IntRange skpVersionRange;
    @Nullable
    private SkiaParserServiceGrpc.SkiaParserServiceBlockingStub client;
    @Nullable
    private ManagedChannel channel;
    @Nullable
    private OSProcessHandler handler;
    private final StudioLoggerProgressIndicator progressIndicator;
    private final String packagePath;
    private final File serverPath;
    @Nullable
    private final Integer serverVersion;

    @NotNull
    public final IntRange getSkpVersionRange() {
        return this.skpVersionRange;
    }

    @Nullable
    public final SkiaParserServiceGrpc.SkiaParserServiceBlockingStub getClient() {
        return this.client;
    }

    public final void setClient(@Nullable SkiaParserServiceGrpc.SkiaParserServiceBlockingStub skiaParserServiceBlockingStub) {
        this.client = skiaParserServiceBlockingStub;
    }

    @Nullable
    public final ManagedChannel getChannel() {
        return this.channel;
    }

    public final void setChannel(@Nullable ManagedChannel managedChannel) {
        this.channel = managedChannel;
    }

    @Nullable
    public final OSProcessHandler getHandler() {
        return this.handler;
    }

    public final void setHandler(@Nullable OSProcessHandler oSProcessHandler) {
        this.handler = oSProcessHandler;
    }

    private final File findPath() {
        File file;
        if (this.serverVersion == null) {
            file = new File(PathManager.getHomePath(), "../../bazel-bin/tools/base/dynamic-layout-inspector/" + this.serverName);
        } else {
            AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
            Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"AndroidSdks.getInstance().tryToChooseSdkHandler()");
            AndroidSdkHandler sdkHandler = androidSdkHandler;
            LocalPackage localPackage = sdkHandler.getLocalPackage(this.packagePath, (ProgressIndicator)this.progressIndicator);
            if (localPackage == null) {
                return null;
            }
            LocalPackage serverPackage = localPackage;
            file = new File(serverPackage.getLocation(), this.serverName);
        }
        return file;
    }

    public final void runServer() {
        block9: {
            if (this.client != null) {
                ManagedChannel managedChannel = this.channel;
                if (managedChannel == null || !managedChannel.isShutdown()) {
                    ManagedChannel managedChannel2 = this.channel;
                    if (managedChannel2 == null || !managedChannel2.isTerminated()) {
                        Object object = this.handler;
                        if (object != null && (object = object.getProcess()) != null) {
                            if (((Process)object).isAlive()) {
                                return;
                            }
                        }
                    }
                }
            }
            File file = this.serverPath;
            if (file == null || !file.exists()) {
                if (!this.tryDownload()) {
                    throw (Throwable)new Exception("Unable to find server version " + this.serverVersion);
                }
            }
            File file2 = this.serverPath;
            if (file2 == null) {
                throw (Throwable)new Exception("Unable to find server version " + this.serverVersion);
            }
            File realPath = file2;
            int localPort = NetUtils.findAvailableSocketPort();
            if (localPort < 0) {
                throw (Throwable)new Exception("Unable to find available socket port");
            }
            this.channel = (ManagedChannel)NettyChannelBuilder.forAddress((String)"localhost", (int)localPort).usePlaintext(true).maxMessageSize(0x1FFFFFFF).build();
            this.client = SkiaParserServiceGrpc.newBlockingStub((Channel)((Channel)this.channel));
            OSProcessHandler oSProcessHandler = this.handler = new OSProcessHandler(new GeneralCommandLine(new String[]{realPath.getAbsolutePath(), String.valueOf(localPort)}));
            Intrinsics.checkNotNull((Object)oSProcessHandler);
            oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (event.getExitCode() != 0 && event.getExitCode() != 137) {
                        Logger.getInstance(SkiaParser.class).error("SkiaServer terminated exitCode: " + event.getExitCode() + "  text: " + event.getText());
                    } else {
                        Logger.getInstance(SkiaParser.class).info("SkiaServer terminated successfully");
                    }
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Logger.getInstance(SkiaParser.class).debug("SkiaServer willTerminate");
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    Logger.getInstance(SkiaParser.class).info("SkiaServer Message: " + event.getText());
                }
            });
            OSProcessHandler oSProcessHandler2 = this.handler;
            if (oSProcessHandler2 == null) break block9;
            oSProcessHandler2.startNotify();
        }
    }

    public final void shutdown() {
        ManagedChannel managedChannel = this.channel;
        if (managedChannel != null) {
            managedChannel.shutdownNow();
        }
        ManagedChannel managedChannel2 = this.channel;
        if (managedChannel2 != null) {
            managedChannel2.awaitTermination(1L, TimeUnit.SECONDS);
        }
        this.channel = null;
        this.client = null;
        OSProcessHandler oSProcessHandler = this.handler;
        if (oSProcessHandler != null) {
            oSProcessHandler.destroyProcess();
        }
        this.handler = null;
    }

    private final boolean tryDownload() {
        if (this.serverVersion == null) {
            return false;
        }
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"AndroidSdks.getInstance().tryToChooseSdkHandler()");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)this.progressIndicator);
        sdkManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)this.progressIndicator, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance());
        RepoManager repoManager = sdkManager;
        Intrinsics.checkNotNullExpressionValue((Object)repoManager, (String)"sdkManager");
        RepositoryPackages repositoryPackages = repoManager.getPackages();
        Intrinsics.checkNotNullExpressionValue((Object)repositoryPackages, (String)"sdkManager.packages");
        UpdatablePackage updatablePackage = (UpdatablePackage)repositoryPackages.getConsolidatedPkgs().get(this.packagePath);
        if (updatablePackage == null) {
            return false;
        }
        UpdatablePackage updatablePackage2 = updatablePackage;
        if (updatablePackage2.hasLocal() && !updatablePackage2.isUpdate()) {
            return false;
        }
        boolean bl = false;
        ModelWizardDialog modelWizardDialog = SdkQuickfixUtils.createDialogForPackages(null, CollectionsKt.listOf((Object)updatablePackage2), CollectionsKt.emptyList(), false);
        if (modelWizardDialog == null) {
            return false;
        }
        modelWizardDialog.show();
        sdkManager.reloadLocalIfNeeded((ProgressIndicator)this.progressIndicator);
        RepositoryPackages repositoryPackages2 = sdkManager.getPackages();
        Intrinsics.checkNotNullExpressionValue((Object)repositoryPackages2, (String)"sdkManager.packages");
        UpdatablePackage updatablePackage3 = (UpdatablePackage)repositoryPackages2.getConsolidatedPkgs().get(this.packagePath);
        if (updatablePackage3 == null) {
            return false;
        }
        UpdatablePackage newPackage = updatablePackage3;
        return newPackage.hasLocal() && !newPackage.isUpdate();
    }

    @Nullable
    public final SkiaParser.GetViewTreeResponse getViewTree(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.ping();
        return this.getViewTreeImpl(data);
    }

    public final void ping() {
        this.getViewTreeImpl(new byte[1]);
    }

    private final SkiaParser.GetViewTreeResponse getViewTreeImpl(byte[] data) {
        SkiaParser.GetViewTreeRequest request;
        SkiaParser.GetViewTreeRequest getViewTreeRequest = request = SkiaParser.GetViewTreeRequest.newBuilder().setSkp(ByteString.copyFrom((byte[])data)).build();
        Intrinsics.checkNotNullExpressionValue((Object)getViewTreeRequest, (String)"request");
        return this.getViewTreeWithRetry(getViewTreeRequest);
    }

    private final SkiaParser.GetViewTreeResponse getViewTreeWithRetry(SkiaParser.GetViewTreeRequest request) {
        long delay = 10L;
        StatusRuntimeException lastException = null;
        for (int tries = 0; tries < 10; ++tries) {
            try {
                SkiaParserServiceGrpc.SkiaParserServiceBlockingStub skiaParserServiceBlockingStub = this.client;
                return skiaParserServiceBlockingStub != null ? skiaParserServiceBlockingStub.getViewTree(request) : null;
            }
            catch (StatusRuntimeException ex) {
                Status status = ex.getStatus();
                Intrinsics.checkNotNullExpressionValue((Object)status, (String)"ex.status");
                if (status.getCode() != Status.Code.UNAVAILABLE) {
                    throw (Throwable)ex;
                }
                Thread.sleep(delay);
                long l = (long)2 * delay;
                long l2 = 1000L;
                boolean bl = false;
                delay = Math.max(l, l2);
                lastException = ex;
                continue;
            }
        }
        StatusRuntimeException statusRuntimeException = lastException;
        Intrinsics.checkNotNull((Object)((Object)statusRuntimeException));
        throw (Throwable)statusRuntimeException;
    }

    @Nullable
    public final Integer getServerVersion() {
        return this.serverVersion;
    }

    public ServerInfo(@Nullable Integer serverVersion, int skpStart, @Nullable Integer skpEnd) {
        this.serverVersion = serverVersion;
        this.serverName = "skia-grpc-server" + (SystemInfo.isWindows ? ".exe" : "");
        Integer n = skpEnd;
        this.skpVersionRange = new IntRange(skpStart, n != null ? n : Integer.MAX_VALUE);
        this.progressIndicator = new StudioLoggerProgressIndicator(ServerInfo.class);
        this.packagePath = "skiaparser;" + this.serverVersion;
        this.serverPath = this.findPath();
    }
}

