/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.transport.InspectorClient;
import com.android.tools.idea.layoutinspector.ui.SelectProcessAction;
import com.android.tools.idea.layoutinspector.ui.SelectProcessAction$updateActions$1;
import com.android.tools.idea.layoutinspector.ui.SelectProcessActionKt;
import com.android.tools.profiler.proto.Common;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/SelectProcessAction;", "Lcom/android/tools/adtui/actions/DropDownAction;", "layoutInspector", "Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "(Lcom/android/tools/idea/layoutinspector/LayoutInspector;)V", "currentProcess", "Lcom/android/tools/profiler/proto/Common$Process;", "kotlin.jvm.PlatformType", "getLayoutInspector", "()Lcom/android/tools/idea/layoutinspector/LayoutInspector;", "project", "Lcom/intellij/openapi/project/Project;", "displayTextInToolbar", "", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateActions", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "ConnectAction", "DeviceAction", "StopAction", "intellij.android.layout-inspector"})
public final class SelectProcessAction
extends DropDownAction {
    private Common.Process currentProcess;
    private Project project;
    @NotNull
    private final LayoutInspector layoutInspector;

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.project = event.getProject();
        if (Intrinsics.areEqual((Object)this.currentProcess, (Object)this.layoutInspector.getCurrentClient().getSelectedProcess()) ^ true) {
            String string = this.layoutInspector.getCurrentClient().getSelectedProcess().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"layoutInspector.currentClient.selectedProcess.name");
            String processName = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null);
            String actionName = Intrinsics.areEqual((Object)this.layoutInspector.getCurrentClient().getSelectedProcess(), (Object)Common.Process.getDefaultInstance()) ? "Select Process" : processName;
            this.currentProcess = this.layoutInspector.getCurrentClient().getSelectedProcess();
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
            presentation.setText(actionName);
        }
    }

    protected boolean updateActions(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.removeAll();
        boolean bl = false;
        Set serials = new LinkedHashSet();
        for (InspectorClient client : this.layoutInspector.getAllClients()) {
            for (Common.Stream stream : client.getStreams()) {
                String serial;
                Common.Device device = stream.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)device, (String)"stream.device");
                String string = serial = device.getSerial();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serial");
                if (!serials.add(string)) continue;
                Common.Device device2 = stream.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)device2, (String)"stream.device");
                String string2 = device2.getModel();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stream.device.model");
                Common.Device device3 = stream.getDevice();
                Intrinsics.checkNotNullExpressionValue((Object)device3, (String)"stream.device");
                String deviceName = SelectProcessActionKt.buildDeviceName(serial, string2, device3.getManufacturer());
                this.add((AnAction)new DeviceAction(deviceName, stream, client));
            }
        }
        if (this.getChildrenCount() == 0) {
            AnAction noDeviceAction2 = new AnAction("No devices detected"){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                }
            };
            Presentation presentation = noDeviceAction2.getTemplatePresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"noDeviceAction.templatePresentation");
            presentation.setEnabled(false);
            this.add(noDeviceAction2);
        } else {
            this.add(new StopAction((Function0<? extends InspectorClient>)((Function0)new SelectProcessAction$updateActions$1(this.layoutInspector))));
        }
        return true;
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    @NotNull
    public final LayoutInspector getLayoutInspector() {
        return this.layoutInspector;
    }

    public SelectProcessAction(@NotNull LayoutInspector layoutInspector) {
        Intrinsics.checkNotNullParameter((Object)layoutInspector, (String)"layoutInspector");
        super("Select Process", "Select a process to connect to.", AllIcons.General.Add);
        this.layoutInspector = layoutInspector;
        this.currentProcess = Common.Process.getDefaultInstance();
    }

    @VisibleForTesting
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0012H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/SelectProcessAction$ConnectAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "process", "Lcom/android/tools/profiler/proto/Common$Process;", "stream", "Lcom/android/tools/profiler/proto/Common$Stream;", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "(Lcom/android/tools/profiler/proto/Common$Process;Lcom/android/tools/profiler/proto/Common$Stream;Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;)V", "getClient", "()Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "getProcess", "()Lcom/android/tools/profiler/proto/Common$Process;", "getStream", "()Lcom/android/tools/profiler/proto/Common$Stream;", "connect", "Ljava/util/concurrent/Future;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.android.layout-inspector"})
    public static final class ConnectAction
    extends ToggleAction {
        @NotNull
        private final Common.Process process;
        @NotNull
        private final Common.Stream stream;
        @NotNull
        private final InspectorClient client;

        public boolean isSelected(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return Intrinsics.areEqual((Object)this.process, (Object)this.client.getSelectedProcess()) && Intrinsics.areEqual((Object)this.stream, (Object)this.client.getSelectedStream());
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (state) {
                this.connect();
            }
        }

        @VisibleForTesting
        @NotNull
        public final Future<?> connect() {
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this){
                final /* synthetic */ ConnectAction this$0;

                public final void run() {
                    this.this$0.getClient().attach(this.this$0.getStream(), this.this$0.getProcess());
                }
                {
                    this.this$0 = connectAction;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"ApplicationManager.getAp\u2026attach(stream, process) }");
            return future2;
        }

        @NotNull
        public final Common.Process getProcess() {
            return this.process;
        }

        @NotNull
        public final Common.Stream getStream() {
            return this.stream;
        }

        @NotNull
        public final InspectorClient getClient() {
            return this.client;
        }

        public ConnectAction(@NotNull Common.Process process2, @NotNull Common.Stream stream, @NotNull InspectorClient client) {
            Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            super(process2.getName() + " (" + process2.getPid() + ')');
            this.process = process2;
            this.stream = stream;
            this.client = client;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/SelectProcessAction$StopAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "client", "Lkotlin/Function0;", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "(Lkotlin/jvm/functions/Function0;)V", "getClient", "()Lkotlin/jvm/functions/Function0;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.layout-inspector"})
    private static final class StopAction
    extends AnAction {
        @NotNull
        private final Function0<InspectorClient> client;

        public void update(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Presentation presentation = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
            presentation.setEnabled(((InspectorClient)this.client.invoke()).isConnected());
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ((InspectorClient)this.client.invoke()).disconnect();
        }

        @NotNull
        public final Function0<InspectorClient> getClient() {
            return this.client;
        }

        public StopAction(@NotNull Function0<? extends InspectorClient> client) {
            Intrinsics.checkNotNullParameter(client, (String)"client");
            super("Stop inspector");
            this.client = client;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/SelectProcessAction$DeviceAction;", "Lcom/android/tools/adtui/actions/DropDownAction;", "deviceName", "", "stream", "Lcom/android/tools/profiler/proto/Common$Stream;", "client", "Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;", "(Ljava/lang/String;Lcom/android/tools/profiler/proto/Common$Stream;Lcom/android/tools/idea/layoutinspector/transport/InspectorClient;)V", "displayTextInToolbar", "", "intellij.android.layout-inspector"})
    private static final class DeviceAction
    extends DropDownAction {
        public boolean displayTextInToolbar() {
            return true;
        }

        public DeviceAction(@NotNull String deviceName, @NotNull Common.Stream stream, @NotNull InspectorClient client) {
            Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            super(deviceName, null, null);
            Sequence processes2 = SequencesKt.sortedWith(client.getProcesses(stream), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{processes.1.INSTANCE, processes.2.INSTANCE}));
            for (Common.Process process2 : processes2) {
                this.add((AnAction)new ConnectAction(process2, stream, client));
            }
            if (this.getChildrenCount() == 0) {
                this.add(SelectProcessActionKt.getNO_PROCESS_ACTION());
            }
        }
    }
}

