/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.mlkit;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.mlkit.LightModelClass;
import com.android.tools.idea.mlkit.LightModelClassConfig;
import com.android.tools.idea.mlkit.MlModelClassGenerator;
import com.android.tools.idea.mlkit.MlModelFileIndex;
import com.android.tools.idea.mlkit.MlModelMetadata;
import com.android.tools.idea.mlkit.MlkitUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class MlkitModuleService {
    private final Module myModule;
    private final ModelFileModificationTracker myModelFileModificationTracker;
    private final Map<MlModelMetadata, LightModelClass> myLightModelClassMap;

    public static MlkitModuleService getInstance(@NotNull Module module) {
        if (module == null) {
            MlkitModuleService.$$$reportNull$$$0(0);
        }
        return Objects.requireNonNull((MlkitModuleService)ModuleServiceManager.getService((Module)module, MlkitModuleService.class));
    }

    public MlkitModuleService(@NotNull Module module) {
        if (module == null) {
            MlkitModuleService.$$$reportNull$$$0(1);
        }
        this.myLightModelClassMap = new ConcurrentHashMap<MlModelMetadata, LightModelClass>();
        this.myModule = module;
        this.myModelFileModificationTracker = new ModelFileModificationTracker(module);
    }

    @NotNull
    public LightModelClass getOrCreateLightModelClass(@NotNull MlModelMetadata modelMetadata) {
        if (modelMetadata == null) {
            MlkitModuleService.$$$reportNull$$$0(2);
        }
        LightModelClass lightModelClass = this.myLightModelClassMap.computeIfAbsent(modelMetadata, modelMetadata1 -> {
            LightModelClassConfig classConfig = MlModelClassGenerator.generateLightModelClass(this.myModule, modelMetadata1);
            return new LightModelClass(this.myModule, classConfig);
        });
        if (lightModelClass == null) {
            MlkitModuleService.$$$reportNull$$$0(3);
        }
        return lightModelClass;
    }

    @NotNull
    public List<LightModelClass> getLightModelClassList() {
        if (AndroidFacet.getInstance((Module)this.myModule) == null) {
            List<LightModelClass> list = Collections.emptyList();
            if (list == null) {
                MlkitModuleService.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)this.myModule.getProject()).getCachedValue((UserDataHolder)this.myModule, () -> {
            ArrayList lightModelClassList = new ArrayList();
            FileBasedIndex index = FileBasedIndex.getInstance();
            index.processAllKeys(MlModelFileIndex.INDEX_ID, key -> {
                index.processValues(MlModelFileIndex.INDEX_ID, key, null, (file, value2) -> {
                    lightModelClassList.add(this.getOrCreateLightModelClass((MlModelMetadata)value2));
                    return true;
                }, this.myModule.getModuleScope(false));
                return true;
            }, this.myModule.getModuleScope(false), null);
            return CachedValueProvider.Result.create(lightModelClassList, (Object[])new Object[]{this.myModelFileModificationTracker});
        });
        if (list == null) {
            MlkitModuleService.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelMetadata";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/mlkit/MlkitModuleService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/mlkit/MlkitModuleService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLightModelClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightModelClassList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLightModelClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ModelFileModificationTracker
    implements ModificationTracker {
        private int myModificationCount;

        private ModelFileModificationTracker(final Module module) {
            if (((Boolean)StudioFlags.MLKIT_LIGHT_CLASSES.get()).booleanValue()) {
                MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
                connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                    public void after(@NotNull List<? extends VFileEvent> events) {
                        if (events == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        for (VFileEvent vFileEvent : events) {
                            if (vFileEvent.getFile() == null || !MlkitUtils.isMlModelFileInAssetsFolder(vFileEvent.getFile())) continue;
                            PsiManager.getInstance((Project)module.getProject()).dropResolveCaches();
                            MlkitModuleService.getInstance((Module)module).myLightModelClassMap.clear();
                            ++myModificationCount;
                            return;
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/mlkit/MlkitModuleService$ModelFileModificationTracker$1", "after"));
                    }
                });
            }
        }

        public long getModificationCount() {
            return this.myModificationCount;
        }
    }
}

