/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.ndk.includes.resolver;

import com.android.repository.Revision;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.PackageType;
import com.android.tools.idea.navigator.nodes.ndk.includes.model.SimpleIncludeValue;
import com.android.tools.idea.navigator.nodes.ndk.includes.resolver.RegularExpressionIncludeResolver;
import com.android.tools.idea.navigator.nodes.ndk.includes.utils.LexicalIncludePaths;
import java.io.File;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedRegularExpressionIncludeResolver
extends RegularExpressionIncludeResolver {
    @NotNull
    private final PackageType myKind;
    @NotNull
    private final String myPattern;
    @Nullable
    private final String myLibraryName;

    IndexedRegularExpressionIncludeResolver(@NotNull PackageType kind, @NotNull String pattern, @Nullable String libraryName) {
        if (kind == null) {
            IndexedRegularExpressionIncludeResolver.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            IndexedRegularExpressionIncludeResolver.$$$reportNull$$$0(1);
        }
        this.myKind = kind;
        this.myPattern = pattern;
        this.myLibraryName = libraryName;
    }

    @Override
    @NotNull
    String getMatchRegexTemplate() {
        String string = this.myPattern;
        if (string == null) {
            IndexedRegularExpressionIncludeResolver.$$$reportNull$$$0(2);
        }
        return string;
    }

    private String groupOrNull(Matcher match2, String name) {
        if (this.myPattern.contains(String.format("?<%s>", name))) {
            return match2.group(name);
        }
        return null;
    }

    @Override
    @Nullable
    public SimpleIncludeValue resolve(@NotNull File includeFolder) {
        Matcher match2;
        if (includeFolder == null) {
            IndexedRegularExpressionIncludeResolver.$$$reportNull$$$0(3);
        }
        if (!(match2 = LexicalIncludePaths.matchFolderToRegex(this.getCompiledMatchPattern(), includeFolder)).find()) {
            return null;
        }
        try {
            String relativeFolder = match2.group("relative");
            String libraryName = this.myLibraryName;
            if (libraryName == null) {
                libraryName = match2.group("library");
            }
            String homeFolder = match2.group("home");
            Object description = this.myKind.myDescription;
            String version2 = this.groupOrNull(match2, "ndk");
            if (version2 != null) {
                Revision revision = Revision.parseRevision((String)version2);
                if (revision.getMinor() == 0) {
                    description = (String)description + String.format(" r%s", revision.getMajor());
                } else {
                    char minor = (char)(97 + revision.getMinor());
                    description = (String)description + String.format(" r%s%s", revision.getMajor(), Character.valueOf(minor));
                }
            }
            return new SimpleIncludeValue(this.myKind, (String)description, libraryName, relativeFolder, includeFolder, new File(homeFolder));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("Pattern %s is missing a group name", this.myPattern), e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/ndk/includes/resolver/IndexedRegularExpressionIncludeResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/ndk/includes/resolver/IndexedRegularExpressionIncludeResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchRegexTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

