/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.resources.Density;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.npw.assetstudio.AnnotatedImage;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.TransformedImageAsset;
import com.android.tools.idea.npw.assetstudio.assets.ImageAsset;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AdaptiveIconGenerator
extends IconGenerator {
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(4054148);
    private final BoolProperty myShowSafeZone;
    private final ObjectProperty<Color> myBackgroundColor;
    private final OptionalProperty<ImageAsset> myBackgroundImageAsset;
    private final StringProperty myForegroundLayerName;
    private final StringProperty myBackgroundLayerName;
    private final BoolProperty myGenerateLegacyIcon;

    public AdaptiveIconGenerator(@NotNull Project project, int minSdkVersion2, @NotNull GraphicGeneratorContext context) {
        if (project == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(1);
        }
        super(project, minSdkVersion2, context);
        this.myShowSafeZone = new BoolValueProperty(true);
        this.myBackgroundColor = new ObjectValueProperty<Color>(DEFAULT_BACKGROUND_COLOR);
        this.myBackgroundImageAsset = new OptionalValueProperty<ImageAsset>();
        this.myForegroundLayerName = new StringValueProperty();
        this.myBackgroundLayerName = new StringValueProperty();
        this.myGenerateLegacyIcon = new BoolValueProperty(true);
    }

    @NotNull
    public ObjectProperty<Color> backgroundColor() {
        ObjectProperty<Color> objectProperty = this.myBackgroundColor;
        if (objectProperty == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(2);
        }
        return objectProperty;
    }

    @NotNull
    public OptionalProperty<ImageAsset> backgroundImageAsset() {
        OptionalProperty<ImageAsset> optionalProperty = this.myBackgroundImageAsset;
        if (optionalProperty == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(3);
        }
        return optionalProperty;
    }

    @NotNull
    public StringProperty foregroundLayerName() {
        StringProperty stringProperty = this.myForegroundLayerName;
        if (stringProperty == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(4);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty backgroundLayerName() {
        StringProperty stringProperty = this.myBackgroundLayerName;
        if (stringProperty == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(5);
        }
        return stringProperty;
    }

    @NotNull
    public BoolProperty generateLegacyIcon() {
        BoolProperty boolProperty = this.myGenerateLegacyIcon;
        if (boolProperty == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(6);
        }
        return boolProperty;
    }

    @NotNull
    protected String getAdaptiveIconXml(@NotNull AdaptiveIconOptions options) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(7);
        }
        String backgroundType = options.backgroundImage == null ? "color" : (options.backgroundImage.isDrawable() ? "drawable" : "mipmap");
        String foregroundType = options.foregroundImage != null && options.foregroundImage.isDrawable() ? "drawable" : "mipmap";
        String format = "<?xml version=\"1.0\" encoding=\"utf-8\"?>%1$s<adaptive-icon xmlns:android=\"http://schemas.android.com/apk/res/android\">%1$s    <background android:drawable=\"@%2$s/%3$s\"/>%1$s    <foreground android:drawable=\"@%4$s/%5$s\"/>%1$s</adaptive-icon>";
        String string = String.format(format, this.myLineSeparator, backgroundType, options.backgroundLayerName, foregroundType, options.foregroundLayerName);
        if (string == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static double getRectangleInsideScale(@NotNull Rectangle source, @NotNull Rectangle destination) {
        if (source == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(9);
        }
        if (destination == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(10);
        }
        double scaleWidth = destination.getWidth() / source.getWidth();
        double scaleHeight = destination.getHeight() / source.getHeight();
        return Math.min(scaleWidth, scaleHeight);
    }

    @NotNull
    protected static BufferedImage scaledImage(@NotNull BufferedImage image, double scale) {
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(11);
        }
        int width = AssetStudioUtils.roundToInt((double)image.getWidth() * scale);
        int height = AssetStudioUtils.roundToInt((double)image.getHeight() * scale);
        BufferedImage bufferedImage = AssetUtil.scaledImage((BufferedImage)image, (int)width, (int)height);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(12);
        }
        return bufferedImage;
    }

    @NotNull
    protected static BufferedImage scaledPreviewImage(@NotNull BufferedImage image, double scale) {
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(13);
        }
        int width = AssetStudioUtils.roundToInt((double)image.getWidth() * scale);
        int height = AssetStudioUtils.roundToInt((double)image.getHeight() * scale);
        return AdaptiveIconGenerator.scaledPreviewImage(image, width, height);
    }

    @NotNull
    private static BufferedImage scaledPreviewImage(@NotNull BufferedImage source, int width, int height) {
        if (source == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(14);
        }
        if (source.getWidth() == width && source.getHeight() == height) {
            BufferedImage bufferedImage = source;
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(15);
            }
            return bufferedImage;
        }
        BufferedImage scaledBufImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D g = scaledBufImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(source, 0, 0, width, height, null);
        g.dispose();
        BufferedImage bufferedImage = scaledBufImage;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(16);
        }
        return bufferedImage;
    }

    @NotNull
    protected static AnnotatedImage mergeLayers(@NotNull Layers layers, @Nullable Color fillColor) {
        if (layers == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(17);
        }
        BufferedImage backgroundImage = layers.background.getImage();
        BufferedImage foregroundImage = layers.foreground.getImage();
        int width = Math.max(backgroundImage.getWidth(), foregroundImage.getWidth());
        int height = Math.max(backgroundImage.getHeight(), foregroundImage.getHeight());
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gOut = (Graphics2D)outImage.getGraphics();
        if (fillColor != null) {
            gOut.setPaint(fillColor);
            gOut.fillRect(0, 0, width, height);
        }
        gOut.drawImage((Image)backgroundImage, 0, 0, null);
        gOut.drawImage((Image)foregroundImage, 0, 0, null);
        gOut.dispose();
        String errorMessage = layers.foreground.getErrorMessage();
        if (errorMessage == null) {
            errorMessage = layers.background.getErrorMessage();
        }
        return new AnnotatedImage(outImage, errorMessage);
    }

    @NotNull
    private Layers generateIconLayers(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(18);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(19);
        }
        AnnotatedImage backgroundImage = this.generateIconBackgroundLayer(context, options);
        AnnotatedImage foregroundImage = this.generateIconForegroundLayer(context, options);
        return new Layers(backgroundImage, foregroundImage);
    }

    @NotNull
    protected AnnotatedImage generateMergedLayers(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options, @Nullable Color fillColor) {
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(20);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(21);
        }
        Layers layers = this.generateIconLayers(context, options);
        return AdaptiveIconGenerator.mergeLayers(layers, fillColor);
    }

    @NotNull
    public BoolProperty showSafeZone() {
        BoolProperty boolProperty = this.myShowSafeZone;
        if (boolProperty == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(22);
        }
        return boolProperty;
    }

    @NotNull
    protected abstract Rectangle getFullBleedRectangle(@NotNull AdaptiveIconOptions var1);

    @NotNull
    protected abstract Rectangle getViewportRectangle(@NotNull AdaptiveIconOptions var1);

    @NotNull
    protected abstract Rectangle getLegacyRectangle(@NotNull AdaptiveIconOptions var1);

    @NotNull
    protected AnnotatedImage generateIconBackgroundLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        BufferedImage image;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(23);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(24);
        }
        if (options.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(25);
            }
            return annotatedImage;
        }
        String errorMessage = null;
        Rectangle imageRect = this.getFullBleedRectangle(options);
        TransformedImageAsset imageAsset = options.backgroundImage;
        if (imageAsset == null) {
            image = AdaptiveIconGenerator.generateFlatColorRectangle(new Color(options.backgroundColor), imageRect);
        } else {
            try {
                image = this.generateIconLayer(context, imageAsset, imageRect, false, 0, !options.generateOutputIcons);
            }
            catch (RuntimeException e) {
                errorMessage = AdaptiveIconGenerator.composeErrorMessage(e, "background", imageAsset);
                image = imageAsset.createErrorImage(imageRect.getSize());
            }
        }
        return new AnnotatedImage(image, errorMessage);
    }

    @NotNull
    protected AnnotatedImage generateIconForegroundLayer(@NotNull GraphicGeneratorContext context, @NotNull AdaptiveIconOptions options) {
        BufferedImage image;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(26);
        }
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(27);
        }
        if (options.usePlaceholders) {
            AnnotatedImage annotatedImage = PLACEHOLDER_IMAGE;
            if (annotatedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(28);
            }
            return annotatedImage;
        }
        String errorMessage = null;
        Rectangle imageRect = this.getFullBleedRectangle(options);
        TransformedImageAsset imageAsset = options.foregroundImage;
        if (imageAsset == null) {
            image = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        } else {
            try {
                image = this.generateIconLayer(context, imageAsset, imageRect, options.useForegroundColor, options.foregroundColor, !options.generateOutputIcons);
            }
            catch (RuntimeException e) {
                errorMessage = AdaptiveIconGenerator.composeErrorMessage(e, "foreground", imageAsset);
                image = imageAsset.createErrorImage(imageRect.getSize());
            }
        }
        return new AnnotatedImage(image, errorMessage);
    }

    @NotNull
    private static String composeErrorMessage(@NotNull Exception e, @NotNull String role, @NotNull TransformedImageAsset imageAsset) {
        if (e == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(29);
        }
        if (role == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(30);
        }
        if (imageAsset == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(31);
        }
        String errorMessage = imageAsset.isDrawable() ? String.format("Unable to generate image, possibly invalid %s drawable", role) : String.format("Failed to transform %s image", role);
        String exceptionMessage = e.getMessage();
        Object object = exceptionMessage == null ? errorMessage : errorMessage + ": " + exceptionMessage;
        if (object == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(32);
        }
        return object;
    }

    protected BufferedImage cropImageToViewport(@NotNull AdaptiveIconOptions options, @NotNull BufferedImage image) {
        if (options == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(33);
        }
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(34);
        }
        return AdaptiveIconGenerator.cropImage(image, this.getViewportRectangle(options));
    }

    private static BufferedImage cropImage(@NotNull BufferedImage image, @NotNull Rectangle targetRect) {
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(35);
        }
        if (targetRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(36);
        }
        int width = Math.min(targetRect.width, image.getWidth());
        int height = Math.min(targetRect.height, image.getHeight());
        BufferedImage subImage = image.getSubimage((image.getWidth() - width) / 2, (image.getHeight() - height) / 2, width, height);
        BufferedImage viewportImage = AssetUtil.newArgbBufferedImage((int)width, (int)height);
        Graphics2D gViewport = (Graphics2D)viewportImage.getGraphics();
        gViewport.drawImage((Image)subImage, 0, 0, null);
        gViewport.dispose();
        return viewportImage;
    }

    @NotNull
    private static BufferedImage generateFlatColorRectangle(@NotNull Color color, @NotNull Rectangle imageRect) {
        if (color == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(37);
        }
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(38);
        }
        BufferedImage result2 = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)result2.getGraphics();
        gTemp.setPaint(color);
        gTemp.fillRect(0, 0, imageRect.width, imageRect.height);
        gTemp.dispose();
        BufferedImage bufferedImage = result2;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(39);
        }
        return bufferedImage;
    }

    @NotNull
    protected static BufferedImage applyMask(@NotNull BufferedImage image, @Nullable BufferedImage mask) {
        if (image == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(40);
        }
        if (mask == null) {
            BufferedImage bufferedImage = image;
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(41);
            }
            return bufferedImage;
        }
        Rectangle imageRect = new Rectangle(0, 0, image.getWidth(), image.getHeight());
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D gTemp = (Graphics2D)tempImage.getGraphics();
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)mask, (Rectangle)imageRect);
        gTemp.setComposite(AlphaComposite.SrcIn);
        AssetUtil.drawCentered((Graphics2D)gTemp, (BufferedImage)image, (Rectangle)imageRect);
        gTemp.dispose();
        BufferedImage bufferedImage = tempImage;
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(42);
        }
        return bufferedImage;
    }

    @NotNull
    private BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull TransformedImageAsset sourceImage, @NotNull Rectangle imageRect, boolean useFillColor, int fillColor, boolean forPreview) {
        String scaledDrawable;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(43);
        }
        if (sourceImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(44);
        }
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(45);
        }
        if ((scaledDrawable = sourceImage.getTransformedDrawable()) != null) {
            return AdaptiveIconGenerator.generateIconLayer(context, scaledDrawable, imageRect);
        }
        BufferedImage trimmedImage = sourceImage.getTrimmedImage();
        if (trimmedImage != null) {
            return this.generateIconLayer(context, trimmedImage, imageRect, sourceImage.getScaleFactor(), useFillColor, fillColor, forPreview);
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(46);
        }
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull String xmlDrawable, @NotNull Rectangle imageRect) {
        block8: {
            BufferedImage bufferedImage;
            if (context == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(47);
            }
            if (xmlDrawable == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(48);
            }
            if (imageRect == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(49);
            }
            Future<BufferedImage> imageFuture = context.renderDrawable(xmlDrawable, imageRect.getSize());
            try {
                BufferedImage image = imageFuture.get();
                if (image == null) break block8;
                bufferedImage = image;
            }
            catch (ExecutionException e) {
                ExceptionUtil.rethrow((Throwable)e.getCause());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (bufferedImage == null) {
                AdaptiveIconGenerator.$$$reportNull$$$0(50);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(51);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int fillColor, boolean bl) {
        void forPreview;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(52);
        }
        if (sourceImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(53);
        }
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(54);
        }
        if (forPreview != false && (double)Math.max(sourceImage.getWidth(), sourceImage.getHeight()) > this.getMaxIconRectangle().getWidth() * 1.5) {
            sourceImage = AdaptiveIconGenerator.generateIconLayer(context, sourceImage, this.getMaxIconRectangle(), 1.0, false, 0);
        }
        return AdaptiveIconGenerator.generateIconLayer(context, sourceImage, imageRect, scaleFactor, useFillColor, fillColor);
    }

    protected abstract Rectangle getMaxIconRectangle();

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage generateIconLayer(@NotNull GraphicGeneratorContext context, @NotNull BufferedImage sourceImage, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int n) {
        void fillColor;
        if (context == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(55);
        }
        if (sourceImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(56);
        }
        if (imageRect == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(57);
        }
        Callable<Future> generator2 = () -> AdaptiveIconGenerator.lambda$generateIconLayer$1(imageRect, scaleFactor, sourceImage, useFillColor, (int)fillColor);
        class CacheKey {
            @NotNull
            private final Object mySource;
            @NotNull
            private final Rectangle myImageRect;
            private final int myScaleFactorTimes1000;
            private final boolean myUseFillColor;
            private final int myFillColor;

            /*
             * WARNING - void declaration
             */
            CacheKey(@NotNull Object source, @NotNull Rectangle imageRect, double scaleFactor, boolean useFillColor, int n) {
                void fillColor;
                if (source == null) {
                    CacheKey.$$$reportNull$$$0(0);
                }
                if (imageRect == null) {
                    CacheKey.$$$reportNull$$$0(1);
                }
                this.mySource = source;
                this.myImageRect = imageRect;
                this.myScaleFactorTimes1000 = AssetStudioUtils.roundToInt(scaleFactor * 1000.0);
                this.myUseFillColor = useFillColor;
                this.myFillColor = fillColor;
            }

            public int hashCode() {
                return Objects.hash(this.mySource, this.myImageRect, this.myScaleFactorTimes1000, this.myUseFillColor, this.myFillColor);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)obj;
                return Objects.equals(this.mySource, other.mySource) && Objects.equals(this.myImageRect, other.myImageRect) && this.myScaleFactorTimes1000 == other.myScaleFactorTimes1000 && this.myUseFillColor == other.myUseFillColor && this.myFillColor == other.myFillColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "imageRect";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator$1CacheKey";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        CacheKey cacheKey = new CacheKey(sourceImage, imageRect, scaleFactor, useFillColor, (int)fillColor);
        Future<BufferedImage> imageFuture = context.getFromCacheOrCreate(cacheKey, generator2);
        BufferedImage bufferedImage = (BufferedImage)Futures.getUnchecked(imageFuture);
        if (bufferedImage == null) {
            AdaptiveIconGenerator.$$$reportNull$$$0(58);
        }
        return bufferedImage;
    }

    private static /* synthetic */ Future lambda$generateIconLayer$1(Rectangle imageRect, double scaleFactor, BufferedImage sourceImage, boolean useFillColor, int fillColor) throws Exception {
        return FutureUtils.executeOnPooledThread(() -> {
            BufferedImage iconImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gIcon = (Graphics2D)iconImage.getGraphics();
            Rectangle rect = AssetStudioUtils.scaleRectangleAroundCenter(imageRect, scaleFactor);
            AssetUtil.drawCenterInside((Graphics2D)gIcon, (BufferedImage)sourceImage, (Rectangle)rect);
            gIcon.dispose();
            if (!useFillColor) {
                return iconImage;
            }
            BufferedImage effectImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
            Graphics2D gEffect = (Graphics2D)effectImage.getGraphics();
            AssetUtil.Effect[] effects = new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new Color(fillColor), 1.0)};
            AssetUtil.drawEffects((Graphics2D)gEffect, (BufferedImage)iconImage, (int)0, (int)0, (AssetUtil.Effect[])effects);
            gEffect.dispose();
            return effectImage;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 39: 
            case 41: 
            case 42: 
            case 46: 
            case 50: 
            case 51: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 39: 
            case 41: 
            case 42: 
            case 46: 
            case 50: 
            case 51: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 43: 
            case 47: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 39: 
            case 41: 
            case 42: 
            case 46: 
            case 50: 
            case 51: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator";
                break;
            }
            case 7: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 11: 
            case 13: 
            case 34: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layers";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageAsset";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRect";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 38: 
            case 45: 
            case 49: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageRect";
                break;
            }
            case 44: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceImage";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundImageAsset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "foregroundLayerName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "backgroundLayerName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateLegacyIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdaptiveIconXml";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "scaledImage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "scaledPreviewImage";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "showSafeZone";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconBackgroundLayer";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconForegroundLayer";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "composeErrorMessage";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFlatColorRectangle";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "applyMask";
                break;
            }
            case 46: 
            case 50: 
            case 51: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconLayer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 39: 
            case 41: 
            case 42: 
            case 46: 
            case 50: 
            case 51: 
            case 58: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAdaptiveIconXml";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRectangleInsideScale";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scaledImage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "scaledPreviewImage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "mergeLayers";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateIconLayers";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "generateMergedLayers";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "generateIconBackgroundLayer";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "generateIconForegroundLayer";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "composeErrorMessage";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "cropImageToViewport";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "cropImage";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "generateFlatColorRectangle";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "applyMask";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "generateIconLayer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 22: 
            case 25: 
            case 28: 
            case 32: 
            case 39: 
            case 41: 
            case 42: 
            case 46: 
            case 50: 
            case 51: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Layers {
        @NotNull
        public AnnotatedImage background;
        @NotNull
        public AnnotatedImage foreground;

        Layers(@NotNull AnnotatedImage background, @NotNull AnnotatedImage foreground) {
            if (background == null) {
                Layers.$$$reportNull$$$0(0);
            }
            if (foreground == null) {
                Layers.$$$reportNull$$$0(1);
            }
            this.background = background;
            this.foreground = foreground;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "background";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "foreground";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator$Layers";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AdaptiveIconOptions
    extends IconGenerator.IconOptions
    implements Cloneable {
        public String foregroundLayerName;
        public String backgroundLayerName;
        public boolean useForegroundColor = true;
        public int foregroundColor = 0;
        @Nullable
        public TransformedImageAsset foregroundImage;
        public int backgroundColor = 0;
        @Nullable
        public TransformedImageAsset backgroundImage;
        public boolean generateLegacyIcon = true;
        public Density previewDensity;
        public boolean showSafeZone;

        public AdaptiveIconOptions(boolean forPreview) {
            super(forPreview);
            this.iconFolderKind = IconGenerator.IconFolderKind.MIPMAP;
        }

        @Override
        @NotNull
        public AdaptiveIconOptions clone() {
            AdaptiveIconOptions adaptiveIconOptions = (AdaptiveIconOptions)super.clone();
            if (adaptiveIconOptions == null) {
                AdaptiveIconOptions.$$$reportNull$$$0(0);
            }
            return adaptiveIconOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/AdaptiveIconGenerator$AdaptiveIconOptions", "clone"));
        }
    }
}

