/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutPsiPullParser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class DrawableRenderer
implements Disposable {
    @NotNull
    private final CompletableFuture<RenderTask> myRenderTaskFuture;
    @NotNull
    private final Object myRenderLock;
    @NotNull
    private final MyLayoutPullParserFactory myParserFactory;
    @NotNull
    private final AtomicInteger myCounter;

    public DrawableRenderer(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            DrawableRenderer.$$$reportNull$$$0(0);
        }
        this(facet2, ThemeEditorUtils.getConfigurationForModule(facet2.getModule()));
    }

    public DrawableRenderer(@NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        if (facet2 == null) {
            DrawableRenderer.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            DrawableRenderer.$$$reportNull$$$0(2);
        }
        this.myRenderLock = new Object();
        this.myCounter = new AtomicInteger();
        Module module = facet2.getModule();
        RenderLogger logger2 = new RenderLogger(LauncherIconGenerator.class.getSimpleName(), module);
        this.myParserFactory = new MyLayoutPullParserFactory(module.getProject(), logger2);
        this.myRenderTaskFuture = CompletableFuture.supplyAsync(() -> {
            try {
                RenderService service = RenderService.getInstance(module.getProject());
                RenderTask renderTask = service.taskBuilder(facet2, configuration).withLogger(logger2).withParserFactory(this.myParserFactory).buildSynchronously();
                assert (renderTask != null);
                renderTask.getLayoutlibCallback().setLogger(logger2);
                if (logger2.hasProblems()) {
                    DrawableRenderer.getLog().error(RenderProblem.format(logger2.getMessages()));
                }
                return renderTask;
            }
            catch (Error | RuntimeException e) {
                DrawableRenderer.getLog().error(e);
                return null;
            }
        }, PooledThreadExecutor.INSTANCE);
    }

    @NotNull
    public CompletableFuture<BufferedImage> renderDrawable(@NotNull String xmlDrawableText, @NotNull Dimension size) {
        if (xmlDrawableText == null) {
            DrawableRenderer.$$$reportNull$$$0(3);
        }
        if (size == null) {
            DrawableRenderer.$$$reportNull$$$0(4);
        }
        String xmlText = VectorDrawableTransformer.transform(xmlDrawableText, size);
        String resourceName = String.format("preview_%x.xml", this.myCounter.getAndIncrement());
        ResourceValueImpl value2 = new ResourceValueImpl(ResourceNamespace.RES_AUTO, ResourceType.DRAWABLE, "ic_image_preview", "file://" + resourceName);
        CompletionStage completionStage = this.myRenderTaskFuture.thenCompose(arg_0 -> this.lambda$renderDrawable$1(resourceName, xmlText, size, (ResourceValue)value2, arg_0));
        if (completionStage == null) {
            DrawableRenderer.$$$reportNull$$$0(5);
        }
        return completionStage;
    }

    public void dispose() {
        this.myRenderTaskFuture.whenComplete((renderTask, throwable) -> {
            if (renderTask != null) {
                Object object = this.myRenderLock;
                synchronized (object) {
                    renderTask.dispose();
                }
            }
        });
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(DrawableRenderer.class);
        if (logger2 == null) {
            DrawableRenderer.$$$reportNull$$$0(6);
        }
        return logger2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ CompletionStage lambda$renderDrawable$1(String resourceName, String xmlText, Dimension size, ResourceValue value2, RenderTask renderTask) {
        if (renderTask == null) {
            return CompletableFuture.completedFuture(AssetStudioUtils.createDummyImage());
        }
        Object object = this.myRenderLock;
        synchronized (object) {
            this.myParserFactory.addFileContent(new PathString(resourceName), xmlText);
            renderTask.setOverrideRenderSize(size.width, size.height);
            renderTask.setMaxRenderSize(size.width, size.height);
            return renderTask.renderDrawable(value2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawableText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/DrawableRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/DrawableRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDrawable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "renderDrawable";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLayoutPullParserFactory
    implements ILayoutPullParserFactory {
        @NotNull
        private final ConcurrentMap<PathString, String> myFileContent;
        @NotNull
        private final Project myProject;
        @NotNull
        private final RenderLogger myLogger;

        MyLayoutPullParserFactory(@NotNull Project project, @NotNull RenderLogger logger2) {
            if (project == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(0);
            }
            if (logger2 == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(1);
            }
            this.myFileContent = new ConcurrentHashMap<PathString, String>();
            this.myProject = project;
            this.myLogger = logger2;
        }

        @Override
        @Nullable
        public ILayoutPullParser create(@NotNull PathString file, @NotNull LayoutlibCallback layoutlibCallback) {
            String content2;
            if (file == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(2);
            }
            if (layoutlibCallback == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(3);
            }
            if ((content2 = (String)this.myFileContent.remove(file)) == null) {
                return null;
            }
            XmlFile xmlFile = (XmlFile)MyLayoutPullParserFactory.createEphemeralPsiFile(this.myProject, file.getFileName(), StdFileTypes.XML, content2);
            return LayoutPsiPullParser.create(xmlFile, this.myLogger);
        }

        void addFileContent(@NotNull PathString file, @NotNull String content2) {
            if (file == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(4);
            }
            if (content2 == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(5);
            }
            this.myFileContent.put(file, content2);
        }

        @NotNull
        private static PsiFile createEphemeralPsiFile(@NotNull Project project, @NotNull String filename, @NotNull LanguageFileType fileType, @NotNull String contents) {
            LightVirtualFile virtualFile;
            PsiManager psiManager;
            SingleRootFileViewProvider viewProvider;
            PsiFile psiFile2;
            if (project == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(6);
            }
            if (filename == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(7);
            }
            if (fileType == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(8);
            }
            if (contents == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(9);
            }
            if ((psiFile2 = (viewProvider = new SingleRootFileViewProvider(psiManager = PsiManager.getInstance((Project)project), (VirtualFile)(virtualFile = new LightVirtualFile(filename, (FileType)fileType, (CharSequence)contents)))).getPsi(fileType.getLanguage())) == null) {
                throw new IllegalArgumentException("Unsupported language: " + fileType.getLanguage().getDisplayName());
            }
            PsiFile psiFile3 = psiFile2;
            if (psiFile3 == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(10);
            }
            return psiFile3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logger";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layoutlibCallback";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filename";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contents";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/DrawableRenderer$MyLayoutPullParserFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/DrawableRenderer$MyLayoutPullParserFactory";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEphemeralPsiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addFileContent";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createEphemeralPsiFile";
                    break;
                }
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

