/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.Gravity;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.CharSequences;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableSet;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public final class VectorDrawableTransformer {
    private static final ImmutableSet<String> NAMES_OF_HANDLED_ATTRIBUTES = ImmutableSet.of((Object)"width", (Object)"height", (Object)"viewportWidth", (Object)"viewportHeight", (Object)"tint", (Object)"alpha", (Object[])new String[0]);
    private static final String INDENT = "  ";
    private static final String DOUBLE_INDENT = "    ";

    private VectorDrawableTransformer() {
    }

    @NotNull
    public static String transform(@NotNull String originalDrawable, @NotNull Dimension targetSize) {
        if (originalDrawable == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(0);
        }
        if (targetSize == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(1);
        }
        return VectorDrawableTransformer.transform(originalDrawable, targetSize, Gravity.CENTER, 1.0, null, null, null, 1.0);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static String transform(@NotNull String originalDrawable, @NotNull Dimension targetSize, @NotNull Gravity gravity, double scaleFactor, @Nullable Rectangle2D clipRectangle, @Nullable Point2D shift, @Nullable Color tint, double var8_7) {
        block39: {
            block38: {
                if (originalDrawable == null) {
                    VectorDrawableTransformer.$$$reportNull$$$0(2);
                }
                if (targetSize == null) {
                    VectorDrawableTransformer.$$$reportNull$$$0(3);
                }
                if (gravity == null) {
                    VectorDrawableTransformer.$$$reportNull$$$0(4);
                }
                parser = new KXmlParser();
                parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                parser.setInput((Reader)CharSequences.getReader((CharSequence)originalDrawable, (boolean)true));
                startLine = 1;
                startColumn = 1;
                while ((token = parser.nextToken()) != 1 && token != 2) {
                    startLine = parser.getLineNumber();
                    startColumn = parser.getColumnNumber();
                }
                if (parser.getEventType() == 2 && "vector".equals(parser.getName()) && parser.getPrefix() == null) break block38;
                v0 = originalDrawable;
                if (v0 == null) {
                    VectorDrawableTransformer.$$$reportNull$$$0(5);
                }
                return v0;
            }
            originalTintValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "tint");
            tintValue = tint == null ? originalTintValue : ResourceHelper.colorToString(tint);
            originalAlphaValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "alpha");
            if (originalAlphaValue != null) {
                opacity *= VectorDrawableTransformer.parseDoubleValue(originalAlphaValue, "");
            }
            if ((alphaValue = XmlUtils.formatFloatValue((double)opacity)).equals("1")) {
                alphaValue = null;
            }
            targetWidth = targetSize.getWidth();
            targetHeight = targetSize.getHeight();
            width = targetWidth;
            height = targetHeight;
            originalViewportWidth = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportWidth", "");
            originalViewportHeight = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportHeight", "");
            widthValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "width");
            if (widthValue == null) ** GOTO lbl52
            suffix = VectorDrawableTransformer.getSuffix(widthValue);
            width = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "width", suffix);
            height = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "height", suffix);
            if (!suffix.equals("dp") || width != targetWidth || height != targetHeight || originalViewportWidth != targetWidth || originalViewportHeight != targetHeight || scaleFactor != 1.0 || clipRectangle != null || !Objects.equals(tintValue, originalTintValue) || !Objects.equals(alphaValue, originalAlphaValue)) break block39;
            v1 = originalDrawable;
            if (v1 == null) {
                VectorDrawableTransformer.$$$reportNull$$$0(6);
            }
            return v1;
        }
        try {
            if (Double.isNaN(width) || width == 0.0 || Double.isNaN(height) || height == 0.0) {
                width = targetWidth;
                height = targetHeight;
            }
lbl52:
            // 4 sources

            x = 0.0;
            y = 0.0;
            if (clipRectangle != null) {
                x += (0.5 - clipRectangle.getCenterX()) * targetWidth * (scaleFactor /= Math.max(clipRectangle.getWidth(), clipRectangle.getHeight()));
                y += (0.5 - clipRectangle.getCenterY()) * targetHeight * scaleFactor;
            }
            if (Double.isNaN(originalViewportWidth) || originalViewportWidth == 0.0 || Double.isNaN(originalViewportHeight) || originalViewportHeight == 0.0) {
                originalViewportWidth = width;
                originalViewportHeight = height;
            }
            if ((ratio = width * originalViewportHeight / (height * originalViewportWidth)) > 1.0) {
                y += 0.5 * targetWidth * ratio;
            } else if (ratio < 1.0) {
                x += 0.5 * targetHeight / ratio;
            }
            x += 0.5 * targetWidth * (1.0 - scaleFactor);
            y += 0.5 * targetHeight * (1.0 - scaleFactor);
            ratio = targetWidth * originalViewportHeight / (targetHeight * originalViewportWidth);
            if (ratio > 1.0) {
                alignmentScale = (double)(gravity.getHorizontalAlignment() + 1) / 2.0;
                x += alignmentScale * targetWidth * (1.0 - 1.0 / ratio) * scaleFactor;
            } else if (ratio < 1.0) {
                alignmentScale = (double)(gravity.getVerticalAlignment() + 1) / 2.0;
                y += alignmentScale * targetHeight * (1.0 - ratio) * scaleFactor;
            }
            scaleFactor *= Math.min(targetWidth / originalViewportWidth, targetHeight / originalViewportHeight);
            if (shift != null) {
                x += targetWidth * shift.getX();
                y += targetHeight * shift.getY();
            }
            result = new StringBuilder(originalDrawable.length() + originalDrawable.length() / 8);
            indenter = new Indenter(originalDrawable);
            indenter.copy(1, 1, startLine, startColumn, "", result);
            lineSeparator = VectorDrawableTransformer.detectLineSeparator(originalDrawable);
            result.append(String.format("<vector %s:%s=\"%s\"", new Object[]{"xmlns", "android", "http://schemas.android.com/apk/res/android"}));
            for (i = 0; i < parser.getNamespaceCount(1); ++i) {
                prefix = parser.getNamespacePrefix(i);
                uri = parser.getNamespaceUri(i);
                if ("android".equals(prefix) && "http://schemas.android.com/apk/res/android".equals(uri)) continue;
                result.append(String.format("%s%s%s:%s=\"%s\"", new Object[]{lineSeparator, "    ", "xmlns", prefix, uri}));
            }
            result.append(String.format("%s%sandroid:width=\"%sdp\"", new Object[]{lineSeparator, "    ", XmlUtils.formatFloatValue((double)targetWidth)}));
            result.append(String.format("%s%sandroid:height=\"%sdp\"", new Object[]{lineSeparator, "    ", XmlUtils.formatFloatValue((double)targetHeight)}));
            result.append(String.format("%s%sandroid:viewportWidth=\"%s\"", new Object[]{lineSeparator, "    ", XmlUtils.formatFloatValue((double)targetWidth)}));
            result.append(String.format("%s%sandroid:viewportHeight=\"%s\"", new Object[]{lineSeparator, "    ", XmlUtils.formatFloatValue((double)targetHeight)}));
            if (tintValue != null) {
                result.append(String.format("%s%sandroid:tint=\"%s\"", new Object[]{lineSeparator, "    ", tintValue}));
            }
            if (alphaValue != null) {
                result.append(String.format("%s%sandroid:alpha=\"%s\"", new Object[]{lineSeparator, "    ", alphaValue}));
            }
            for (i = 0; i < parser.getAttributeCount(); ++i) {
                prefix = parser.getAttributePrefix(i);
                name = parser.getAttributeName(i);
                if ("android".equals(prefix) && VectorDrawableTransformer.NAMES_OF_HANDLED_ATTRIBUTES.contains(name)) continue;
                if (prefix != null) {
                    name = prefix + ":" + (String)name;
                }
                result.append(String.format("%s%s%s=\"%s\"", new Object[]{lineSeparator, "    ", name, parser.getAttributeValue(i)}));
            }
            result.append('>');
            indent = "";
            copyDepth = 2;
            startLine = parser.getLineNumber();
            startColumn = parser.getColumnNumber();
            translateX = VectorDrawableTransformer.isSignificantlyDifferentFromZero(x / targetWidth) != false ? XmlUtils.formatFloatValue((double)x) : null;
            translateY = VectorDrawableTransformer.isSignificantlyDifferentFromZero(y / targetHeight) != false ? XmlUtils.formatFloatValue((double)y) : null;
            scale = XmlUtils.formatFloatValue((double)scaleFactor);
            if (!scale.equals("1") || translateX != null || translateY != null) {
                result.append(lineSeparator).append("  ");
                result.append("<group");
                delimiter = " ";
                if (!scale.equals("1")) {
                    result.append(String.format("%sandroid:scaleX=\"%s\"", new Object[]{delimiter, scale}));
                    delimiter = lineSeparator + "      ";
                    result.append(String.format("%sandroid:scaleY=\"%s\"", new Object[]{delimiter, scale}));
                }
                if (translateX != null) {
                    result.append(String.format("%sandroid:translateX=\"%s\"", new Object[]{delimiter, translateX}));
                    delimiter = lineSeparator + "      ";
                }
                if (translateY != null) {
                    result.append(String.format("%sandroid:translateY=\"%s\"", new Object[]{delimiter, translateY}));
                }
                result.append('>');
                indent = "  ";
            }
            while ((token = parser.nextToken()) != 1 && token != 3 || parser.getDepth() >= copyDepth) {
                endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, token == 5 ? "" : indent, result);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            if (startColumn > "  ".length() + 1) {
                result.append(lineSeparator);
                startColumn = 1;
            }
            if (!scale.equals("1") || translateX != null || translateY != null) {
                if (startColumn == 1) {
                    result.append("  ");
                }
                result.append(String.format("</group>%s", new Object[]{lineSeparator}));
            }
            while (token != 1) {
                endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
                token = parser.nextToken();
            }
            v2 = result.toString();
        }
        catch (IOException | XmlPullParserException e) {
            v3 = originalDrawable;
            if (v3 == null) {
                VectorDrawableTransformer.$$$reportNull$$$0(8);
            }
            return v3;
        }
        if (v2 == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(7);
        }
        return v2;
    }

    public static String merge(@NotNull String drawable1, @NotNull String drawable2) {
        if (drawable1 == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(9);
        }
        if (drawable2 == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(10);
        }
        KXmlParser parser = new KXmlParser();
        try {
            int endColumnNumber;
            int endLineNumber;
            int token;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)drawable1, (boolean)true));
            while ((token = parser.nextToken()) != 1 && token != 2) {
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return drawable1;
            }
            StringBuilder result2 = new StringBuilder(drawable1.length() + drawable2.length());
            Indenter indenter = new Indenter(drawable1);
            int startLine = 1;
            int startColumn = 1;
            while ((token = parser.nextToken()) != 1 && token != 3 || parser.getDepth() > 1) {
                endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            parser.setInput((Reader)CharSequences.getReader((CharSequence)drawable2, (boolean)true));
            while ((token = parser.nextToken()) != 1 && token != 2) {
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return drawable1;
            }
            startLine = parser.getLineNumber();
            startColumn = parser.getColumnNumber();
            indenter = new Indenter(drawable2);
            while (parser.nextToken() != 1) {
                endLineNumber = parser.getLineNumber();
                endColumnNumber = parser.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            return result2.toString();
        }
        catch (IOException | XmlPullParserException e) {
            return drawable1;
        }
    }

    @Nullable
    public static Point2D getViewportSize(@NotNull String drawable) {
        if (drawable == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(11);
        }
        KXmlParser parser = new KXmlParser();
        try {
            int token;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)drawable, (boolean)true));
            while ((token = parser.nextToken()) != 1 && token != 2) {
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return null;
            }
            double viewportWidth = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportWidth", "");
            double viewportHeight = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "viewportHeight", "");
            return new Point2D.Double(viewportWidth, viewportHeight);
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    @Nullable
    public static Dimension getSizeDp(@NotNull String drawable) {
        if (drawable == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(12);
        }
        KXmlParser parser = new KXmlParser();
        try {
            String suffix;
            int token;
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput((Reader)CharSequences.getReader((CharSequence)drawable, (boolean)true));
            while ((token = parser.nextToken()) != 1 && token != 2) {
            }
            if (parser.getEventType() != 2 || !"vector".equals(parser.getName()) || parser.getPrefix() != null) {
                return null;
            }
            String widthValue = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "width");
            if (widthValue != null && (suffix = VectorDrawableTransformer.getSuffix(widthValue)).equals("dp")) {
                double width = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "width", suffix);
                double height = VectorDrawableTransformer.getDoubleAttributeValue(parser, "http://schemas.android.com/apk/res/android", "height", suffix);
                return new Dimension(AssetStudioUtils.roundToInt(width), AssetStudioUtils.roundToInt(height));
            }
            return null;
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    private static String detectLineSeparator(@NotNull CharSequence str) {
        LineSeparator separator;
        if (str == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(13);
        }
        if ((separator = StringUtil.detectSeparators((CharSequence)str)) != null) {
            return separator.getSeparatorString();
        }
        return CodeStyle.getDefaultSettings().getLineSeparator();
    }

    private static double getDoubleAttributeValue(@NotNull KXmlParser parser, @NotNull String namespaceUri, @NotNull String attributeName, @NotNull String expectedSuffix) {
        if (parser == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(14);
        }
        if (namespaceUri == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(15);
        }
        if (attributeName == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(16);
        }
        if (expectedSuffix == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(17);
        }
        String value2 = parser.getAttributeValue(namespaceUri, attributeName);
        return VectorDrawableTransformer.parseDoubleValue(value2, expectedSuffix);
    }

    private static double parseDoubleValue(String value2, @NotNull String expectedSuffix) {
        if (expectedSuffix == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(18);
        }
        if (value2 == null || !value2.endsWith(expectedSuffix)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(value2.substring(0, value2.length() - expectedSuffix.length()));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @NotNull
    private static String getSuffix(@NotNull String value2) {
        if (value2 == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(19);
        }
        int i2 = value2.length();
        while (--i2 >= 0 && !Character.isDigit(value2.charAt(i2))) {
        }
        String string = value2.substring(++i2);
        if (string == null) {
            VectorDrawableTransformer.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static boolean isSignificantlyDifferentFromZero(double value2) {
        return Math.abs(value2) >= 1.0E-6;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDrawable";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetSize";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gravity";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/VectorDrawableTransformer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawable1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawable2";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceUri";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedSuffix";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/VectorDrawableTransformer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "transform";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getViewportSize";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSizeDp";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "detectLineSeparator";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDoubleAttributeValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseDoubleValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSuffix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Indenter {
        private int myLine;
        private int myColumn;
        private int myOffset;
        @NotNull
        private final CharSequence myText;

        Indenter(@NotNull CharSequence text) {
            if (text == null) {
                Indenter.$$$reportNull$$$0(0);
            }
            this.myText = text;
            this.myLine = 1;
            this.myColumn = 1;
        }

        void copy(int fromLine, int fromColumn, int toLine, int toColumn, @NotNull String indent, @NotNull StringBuilder out) {
            char c;
            if (indent == null) {
                Indenter.$$$reportNull$$$0(1);
            }
            if (out == null) {
                Indenter.$$$reportNull$$$0(2);
            }
            if (this.myLine != fromLine) {
                if (this.myLine > fromLine) {
                    this.myLine = 1;
                    this.myColumn = 1;
                    this.myOffset = 0;
                }
                while (this.myLine < fromLine) {
                    c = this.myText.charAt(this.myOffset);
                    if (c == '\n') {
                        ++this.myLine;
                        this.myColumn = 1;
                    } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                        ++this.myColumn;
                    }
                    ++this.myOffset;
                }
            }
            this.myOffset += fromColumn - this.myColumn;
            this.myColumn = fromColumn;
            while (this.myLine < toLine || this.myLine == toLine && this.myColumn < toColumn) {
                c = this.myText.charAt(this.myOffset);
                if (c == '\n') {
                    ++this.myLine;
                    this.myColumn = 1;
                } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                    if (this.myColumn == 1) {
                        out.append(indent);
                    }
                    ++this.myColumn;
                }
                ++this.myOffset;
                out.append(c);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/npw/assetstudio/VectorDrawableTransformer$Indenter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "copy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

