/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.annotation.concurrent.GuardedBy;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageAsset
extends BaseAsset {
    private static final String IMAGE_PATH_PROPERTY = "imagePath";
    @NotNull
    private final OptionalValueProperty<File> myImagePath;
    @NotNull
    private final ObservableBool myIsResizable;
    @NotNull
    private final BoolValueProperty myXmlDrawableIsResizable = new BoolValueProperty();
    @NotNull
    private final ObjectValueProperty<Validator.Result> myValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    @NotNull
    private String myRole = "image";
    @Nullable
    private File myDefaultImagePath;
    private boolean isClipart;
    @NotNull
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    @Nullable
    private File myImageFile;
    @GuardedBy(value="myLock")
    @Nullable
    private ListenableFuture<String> myXmlDrawableFuture;
    @GuardedBy(value="myLock")
    @Nullable
    private ListenableFuture<BufferedImage> myImageFuture;

    @UiThread
    public ImageAsset() {
        this.myImagePath = new OptionalValueProperty();
        this.myImagePath.addListener(() -> {
            this.myXmlDrawableIsResizable.set(false);
            Object object = this.myLock;
            synchronized (object) {
                this.myImageFile = (File)this.myImagePath.getValueOrNull();
                this.myXmlDrawableFuture = null;
                this.myImageFuture = null;
            }
        });
        this.myIsResizable = new BooleanExpression(new ObservableValue[]{this.myImagePath, this.myXmlDrawableIsResizable}){

            @Override
            @NotNull
            public Boolean get() {
                FileType fileType = ImageAsset.getFileType((File)ImageAsset.this.myImagePath.getValueOrNull());
                if (fileType == null) {
                    Boolean bl = false;
                    if (bl == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return bl;
                }
                if (fileType == FileType.RASTER_IMAGE_CANDIDATE) {
                    Boolean bl = true;
                    if (bl == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return bl;
                }
                ImageAsset.this.getXmlDrawable();
                Boolean bl = ImageAsset.this.myXmlDrawableIsResizable.get();
                if (bl == null) {
                    1.$$$reportNull$$$0(2);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ImageAsset$1", "get"));
            }
        };
    }

    @UiThread
    public void setRole(@NotNull String role) {
        if (role == null) {
            ImageAsset.$$$reportNull$$$0(0);
        }
        this.myRole = role;
    }

    @UiThread
    public void setDefaultImagePath(@Nullable File file) {
        boolean wasDefault = FileUtil.filesEqual((File)((File)this.myImagePath.getValueOrNull()), (File)this.myDefaultImagePath);
        this.myDefaultImagePath = file;
        if (wasDefault) {
            this.myImagePath.setNullableValue(this.myDefaultImagePath);
        }
    }

    @UiThread
    public void setClipart(boolean clipart) {
        this.isClipart = clipart;
    }

    @UiThread
    public boolean isClipart() {
        return this.isClipart;
    }

    @Override
    @UiThread
    public boolean isColorable() {
        return this.isClipart;
    }

    @UiThread
    @NotNull
    public OptionalValueProperty<File> imagePath() {
        OptionalValueProperty<File> optionalValueProperty = this.myImagePath;
        if (optionalValueProperty == null) {
            ImageAsset.$$$reportNull$$$0(1);
        }
        return optionalValueProperty;
    }

    @Override
    @UiThread
    @NotNull
    public ObservableBool isResizable() {
        ObservableBool observableBool = this.myIsResizable;
        if (observableBool == null) {
            ImageAsset.$$$reportNull$$$0(2);
        }
        return observableBool;
    }

    @UiThread
    @NotNull
    public ObjectValueProperty<Validator.Result> getValidityState() {
        ObjectValueProperty<Validator.Result> objectValueProperty = this.myValidityState;
        if (objectValueProperty == null) {
            ImageAsset.$$$reportNull$$$0(3);
        }
        return objectValueProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UiThread
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myImageFuture == null) {
                File file = this.myImageFile;
                if (file == null || ImageAsset.isVectorGraphics(FileType.fromFile(file))) {
                    return null;
                }
                this.myImageFuture = FutureUtils.executeOnPooledThread(() -> this.loadImage(file));
            }
            return this.myImageFuture;
        }
    }

    @Override
    @UiThread
    public PersistentState getState() {
        PersistentState state = super.getState();
        state.setEncoded(IMAGE_PATH_PROPERTY, (File)this.myImagePath.getValueOrNull(), file -> FileUtil.filesEqual((File)file, (File)this.myDefaultImagePath) ? null : file.getPath());
        return state;
    }

    @Override
    @UiThread
    public void loadState(@NotNull PersistentState state) {
        if (state == null) {
            ImageAsset.$$$reportNull$$$0(4);
        }
        super.loadState(state);
        File file = (File)state.getDecoded(IMAGE_PATH_PROPERTY, path2 -> path2 == null ? this.myDefaultImagePath : new File((String)path2));
        if (file != null) {
            this.myImagePath.setValue(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    @Nullable
    public ListenableFuture<String> getXmlDrawable() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myXmlDrawableFuture == null) {
                if (this.myImageFile == null) {
                    return null;
                }
                FileType fileType = FileType.fromFile(this.myImageFile);
                if (!ImageAsset.isVectorGraphics(fileType)) {
                    return null;
                }
                File file = this.myImageFile;
                this.myXmlDrawableFuture = FutureUtils.executeOnPooledThread(() -> this.loadXmlDrawable(file));
            }
            return this.myXmlDrawableFuture;
        }
    }

    @Nullable
    private String loadXmlDrawable(@NotNull File file) {
        if (file == null) {
            ImageAsset.$$$reportNull$$$0(5);
        }
        String xmlText = null;
        Validator.Result validityState = this.checkFileExistence(file);
        if (validityState.getSeverity() == Validator.Severity.OK) {
            FileType fileType = FileType.fromFile(file);
            try {
                switch (fileType) {
                    case XML_DRAWABLE: {
                        xmlText = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                        break;
                    }
                    case SVG: {
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        String message2 = Svg2Vector.parseSvgToXml((File)file, (OutputStream)outStream);
                        xmlText = outStream.toString(StandardCharsets.UTF_8.name());
                        if (xmlText.isEmpty()) {
                            xmlText = null;
                        }
                        if (message2.isEmpty()) break;
                        Validator.Severity severity = xmlText == null ? Validator.Severity.ERROR : Validator.Severity.WARNING;
                        validityState = this.createValidatorResult(severity, message2);
                        break;
                    }
                    case LAYERED_IMAGE: {
                        xmlText = new LayeredImageConverter().toVectorDrawableXml(file);
                        break;
                    }
                }
            }
            catch (Exception e) {
                StringBuilder message3 = new StringBuilder();
                message3.append("Error while parsing ").append(file.getName());
                String errorDetail = e.getLocalizedMessage();
                if (errorDetail != null) {
                    message3.append(" - ").append(errorDetail);
                }
                validityState = Validator.Result.fromNullableMessage((String)message3.toString());
            }
        }
        if (xmlText == null && validityState.getSeverity() == Validator.Severity.OK) {
            validityState = Validator.Result.fromNullableMessage((String)("The " + this.myRole + " file could not be parsed. Please choose another file."));
        }
        boolean resizable = xmlText != null && "vector".equals(XmlUtils.getRootTagName(xmlText));
        this.updateValidityStateAndResizability(file, validityState, resizable);
        return xmlText;
    }

    @NotNull
    private Validator.Result createValidatorResult(@NotNull Validator.Severity severity, @NotNull String errors) {
        if (severity == null) {
            ImageAsset.$$$reportNull$$$0(6);
        }
        if (errors == null) {
            ImageAsset.$$$reportNull$$$0(7);
        }
        if (errors.indexOf(10) < 0) {
            return new Validator.Result(severity, "The " + this.myRole + " may be incomplete: " + errors);
        }
        String shortMessage = "<html>The " + this.myRole + " may be incomplete due to encountered <a href=\"issues\">issues</a></html>";
        return new Validator.Result(severity, shortMessage, errors);
    }

    @Nullable
    private BufferedImage loadImage(@NotNull File file) {
        FileType fileType;
        if (file == null) {
            ImageAsset.$$$reportNull$$$0(8);
        }
        BufferedImage image = null;
        Validator.Result validityState = this.checkFileExistence(file);
        if (validityState.getSeverity() == Validator.Severity.OK && (fileType = FileType.fromFile(file)) == FileType.RASTER_IMAGE_CANDIDATE) {
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                validityState = Validator.Result.fromThrowable((Throwable)e);
            }
        }
        this.updateValidityStateAndResizability(file, validityState, image != null);
        return image;
    }

    @NotNull
    private Validator.Result checkFileExistence(@NotNull File file) {
        if (file == null) {
            ImageAsset.$$$reportNull$$$0(9);
        }
        if (!file.exists()) {
            Validator.Result result2 = Validator.Result.fromNullableMessage((String)("File " + file.getName() + " does not exist"));
            if (result2 == null) {
                ImageAsset.$$$reportNull$$$0(10);
            }
            return result2;
        }
        if (file.isDirectory()) {
            return new Validator.Result(Validator.Severity.WARNING, "Please select " + ImageAsset.getIndefiniteArticlePrefixFor(this.myRole) + this.myRole + " file");
        }
        Validator.Result result3 = Validator.Result.OK;
        if (result3 == null) {
            ImageAsset.$$$reportNull$$$0(11);
        }
        return result3;
    }

    @NotNull
    private static String getIndefiniteArticlePrefixFor(@NotNull String nounClause) {
        if (nounClause == null) {
            ImageAsset.$$$reportNull$$$0(12);
        }
        if (nounClause.isEmpty()) {
            return "";
        }
        return StringUtil.isVowel((char)Character.toLowerCase(nounClause.charAt(0))) ? "an " : "a ";
    }

    @AnyThread
    private void updateValidityStateAndResizability(@NotNull File file, @NotNull Validator.Result validityState, boolean resizable) {
        if (file == null) {
            ImageAsset.$$$reportNull$$$0(13);
        }
        if (validityState == null) {
            ImageAsset.$$$reportNull$$$0(14);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (FileUtil.filesEqual((File)file, (File)((File)this.myImagePath.getValueOrNull()))) {
                this.myValidityState.set(validityState);
                this.myXmlDrawableIsResizable.set(resizable);
            }
        });
    }

    private static boolean isVectorGraphics(@Nullable FileType fileType) {
        return fileType == FileType.XML_DRAWABLE || fileType == FileType.SVG || fileType == FileType.LAYERED_IMAGE;
    }

    @Nullable
    private static FileType getFileType(@Nullable File file) {
        return file == null ? null : FileType.fromFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/ImageAsset";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nounClause";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/ImageAsset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = IMAGE_PATH_PROPERTY;
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "isResizable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidityState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFileExistence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRole";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadXmlDrawable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createValidatorResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkFileExistence";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIndefiniteArticlePrefixFor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateValidityStateAndResizability";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum FileType {
        XML_DRAWABLE,
        SVG,
        LAYERED_IMAGE,
        RASTER_IMAGE_CANDIDATE;


        @NotNull
        static FileType fromFile(@NotNull File file) {
            String path2;
            if (file == null) {
                FileType.$$$reportNull$$$0(0);
            }
            if (SdkUtils.endsWithIgnoreCase((String)(path2 = file.getPath()), (String)".xml")) {
                FileType fileType = XML_DRAWABLE;
                if (fileType == null) {
                    FileType.$$$reportNull$$$0(1);
                }
                return fileType;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path2, (String)".svg")) {
                FileType fileType = SVG;
                if (fileType == null) {
                    FileType.$$$reportNull$$$0(2);
                }
                return fileType;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path2, (String)".psd")) {
                FileType fileType = LAYERED_IMAGE;
                if (fileType == null) {
                    FileType.$$$reportNull$$$0(3);
                }
                return fileType;
            }
            FileType fileType = RASTER_IMAGE_CANDIDATE;
            if (fileType == null) {
                FileType.$$$reportNull$$$0(4);
            }
            return fileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/ImageAsset$FileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/ImageAsset$FileType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

