/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.dynamicapp;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.dynamicapp.DeviceFeatureKind;
import com.android.tools.idea.npw.dynamicapp.DeviceFeatureModel;
import com.android.tools.idea.npw.dynamicapp.ModuleDownloadDeviceFeatureListener;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.core.ObservableString;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.bool.AndExpression;
import com.android.tools.idea.observable.expressions.string.IsEmptyExpression;
import com.android.tools.idea.observable.expressions.string.TrimExpression;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ModuleDownloadDeviceFeature {
    private JPanel myRootPanel;
    private JComboBox<DeviceFeatureKind> myFeatureNameCombo;
    private JPanel myFeatureValueContainer;
    private TextFieldWithAutoCompletion<String> myFeatureValueTextField;
    private LinkLabel<Void> myRemoveFeatureLinkLabel;
    private ObservableString deviceFeatureValueTrim;
    private static final CharMatcher DISALLOWED_IN_DEVICE_VALUE = CharMatcher.anyOf((CharSequence)"<&\"");
    @NotNull
    private final DeviceFeatureModel myModel;
    @NotNull
    private final List<ModuleDownloadDeviceFeatureListener> myListeners;
    @NotNull
    private final BindingsManager myBindings;
    @NotNull
    private final ListenerManager myBindingsListeners;

    public ModuleDownloadDeviceFeature(@NotNull Project project, @NotNull DeviceFeatureModel model2, @NotNull ObservableValue<Boolean> isActive, @NotNull ValidatorPanel validator) {
        if (project == null) {
            ModuleDownloadDeviceFeature.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            ModuleDownloadDeviceFeature.$$$reportNull$$$0(1);
        }
        if (isActive == null) {
            ModuleDownloadDeviceFeature.$$$reportNull$$$0(2);
        }
        if (validator == null) {
            ModuleDownloadDeviceFeature.$$$reportNull$$$0(3);
        }
        this.$$$setupUI$$$();
        this.myListeners = new ArrayList<ModuleDownloadDeviceFeatureListener>();
        this.myBindings = new BindingsManager();
        this.myBindingsListeners = new ListenerManager();
        this.myModel = model2;
        this.myFeatureNameCombo.setModel(new DefaultComboBoxModel<DeviceFeatureKind>(DeviceFeatureKind.values()));
        this.myFeatureValueTextField = TextFieldWithAutoCompletion.create((Project)project, new ArrayList(), (boolean)true, null);
        this.myFeatureValueContainer.add((Component)this.myFeatureValueTextField, "Center");
        this.myRemoveFeatureLinkLabel.setIcon(StudioIcons.Common.CLOSE);
        UIUtil.addParentChangeListener((Component)this.myRootPanel, (PropertyChangeListener)new ActivationListener());
        this.myRemoveFeatureLinkLabel.setListener((aSource, aLinkData) -> this.myListeners.forEach(x -> x.removeFeatureInvoked()), null);
        this.deviceFeatureValueTrim = new TrimExpression((ObservableValue<String>)this.myModel.deviceFeatureValue);
        AndExpression isInvalidExpression = new AndExpression(isActive, (ObservableValue<Boolean>)new IsEmptyExpression((ObservableValue<String>)this.deviceFeatureValueTrim));
        validator.registerValidator((ObservableValue)isInvalidExpression, isInvalid -> isInvalid != false ? new Validator.Result(Validator.Severity.ERROR, "Device feature value must be set") : Validator.Result.OK, new ObservableValue[0]);
        validator.registerValidator((ObservableValue)this.deviceFeatureValueTrim, value2 -> {
            int illegalCharIdx = DISALLOWED_IN_DEVICE_VALUE.indexIn((CharSequence)value2);
            if (illegalCharIdx < 0) {
                return Validator.Result.OK;
            }
            return new Validator.Result(Validator.Severity.ERROR, String.format("Illegal character '%c' in %s '%s'", Character.valueOf(value2.charAt(illegalCharIdx)), this.myModel.deviceFeatureType, this.myModel.deviceFeatureValue));
        }, new ObservableValue[0]);
    }

    @NotNull
    private static List<String> getModelForFeatureType(DeviceFeatureKind featureType) {
        switch (featureType) {
            case GL_ES_VERSION: {
                ImmutableList immutableList = ImmutableList.of((Object)"0x00020000", (Object)"0x00030000", (Object)"0x00030001");
                if (immutableList == null) {
                    ModuleDownloadDeviceFeature.$$$reportNull$$$0(4);
                }
                return immutableList;
            }
            case NAME: {
                ImmutableList immutableList = ImmutableList.of((Object)"android.hardware.audio.low_latency", (Object)"android.hardware.audio.output", (Object)"android.hardware.audio.pro", (Object)"android.hardware.bluetooth", (Object)"android.hardware.bluetooth_le", (Object)"android.hardware.camera", (Object)"android.hardware.camera.any", (Object)"android.hardware.camera.ar", (Object)"android.hardware.camera.autofocus", (Object)"android.hardware.camera.capability.manual_post_processing", (Object)"android.hardware.camera.capability.manual_sensor", (Object)"android.hardware.camera.capability.raw", (Object[])new String[]{"android.hardware.camera.external", "android.hardware.camera.flash", "android.hardware.camera.front", "android.hardware.camera.level.full", "android.hardware.consumerir", "android.hardware.ethernet", "android.hardware.faketouch", "android.hardware.faketouch.multitouch.distinct", "android.hardware.faketouch.multitouch.jazzhand", "android.hardware.fingerprint", "android.hardware.gamepad", "android.hardware.location", "android.hardware.location.gps", "android.hardware.location.network", "android.hardware.microphone", "android.hardware.nfc", "android.hardware.nfc.hce", "android.hardware.nfc.hcef", "android.hardware.opengles.aep", "android.hardware.ram.low", "android.hardware.ram.normal", "android.hardware.screen.landscape", "android.hardware.screen.portrait", "android.hardware.sensor.accelerometer", "android.hardware.sensor.ambient_temperature", "android.hardware.sensor.barometer", "android.hardware.sensor.compass", "android.hardware.sensor.gyroscope", "android.hardware.sensor.heartrate", "android.hardware.sensor.heartrate.ecg", "android.hardware.sensor.hifi_sensors", "android.hardware.sensor.light", "android.hardware.sensor.proximity", "android.hardware.sensor.relative_humidity", "android.hardware.sensor.stepcounter", "android.hardware.sensor.stepdetector", "android.hardware.strongbox_keystore", "android.hardware.telephony", "android.hardware.telephony.cdma", "android.hardware.telephony.euicc", "android.hardware.telephony.gsm", "android.hardware.telephony.mbms", "android.hardware.touchscreen", "android.hardware.touchscreen.multitouch", "android.hardware.touchscreen.multitouch.distinct", "android.hardware.touchscreen.multitouch.jazzhand", "android.hardware.type.automotive", "android.hardware.type.embedded", "android.hardware.type.pc", "android.hardware.type.television", "android.hardware.type.watch", "android.hardware.usb.accessory", "android.hardware.usb.host", "android.hardware.vr.headtracking", "android.hardware.vr.high_performance", "android.hardware.vulkan.compute", "android.hardware.vulkan.level", "android.hardware.vulkan.version", "android.hardware.wifi", "android.hardware.wifi.aware", "android.hardware.wifi.direct", "android.hardware.wifi.passpoint", "android.hardware.wifi.rtt", "android.software.activities_on_secondary_displays", "android.software.app_widgets", "android.software.autofill", "android.software.backup", "android.software.cant_save_state", "android.software.companion_device_setup", "android.software.connectionservice", "android.software.device_admin", "android.software.freeform_window_management", "android.software.home_screen", "android.software.input_methods", "android.software.leanback", "android.software.leanback_only", "android.software.live_tv", "android.software.live_wallpaper", "android.software.managed_users", "android.software.midi", "android.software.picture_in_picture", "android.software.print", "android.software.securely_removes_users", "android.software.sip", "android.software.sip.voip", "android.software.verified_boot", "android.software.vr.mode", "android.software.webview"});
                if (immutableList == null) {
                    ModuleDownloadDeviceFeature.$$$reportNull$$$0(5);
                }
                return immutableList;
            }
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            ModuleDownloadDeviceFeature.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    public void addListener(@NotNull ModuleDownloadDeviceFeatureListener listener2) {
        if (listener2 == null) {
            ModuleDownloadDeviceFeature.$$$reportNull$$$0(7);
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull ModuleDownloadDeviceFeatureListener listener2) {
        if (listener2 == null) {
            ModuleDownloadDeviceFeature.$$$reportNull$$$0(8);
        }
        this.myListeners.remove(listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isActive";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/dynamicapp/ModuleDownloadDeviceFeature";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/dynamicapp/ModuleDownloadDeviceFeature";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelForFeatureType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LinkLabel linkLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), 2, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("device-feature");
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myFeatureNameCombo = jComboBox;
        jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null, 1));
        this.myFeatureValueContainer = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 3, null, null, null));
        this.myRemoveFeatureLinkLabel = linkLabel = new LinkLabel();
        jPanel2.add((Component)linkLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 3, null, null, null));
        jBLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static final class TextFieldProperty<T>
    extends StringProperty {
        @NotNull
        private TextFieldWithAutoCompletion<T> myTextField;

        private TextFieldProperty(@NotNull TextFieldWithAutoCompletion<T> textField2) {
            if (textField2 == null) {
                TextFieldProperty.$$$reportNull$$$0(0);
            }
            this.myTextField = textField2;
            this.myTextField.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.notifyInvalidated();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/npw/dynamicapp/ModuleDownloadDeviceFeature$TextFieldProperty$1", "documentChanged"));
                }
            });
        }

        @Override
        protected void setDirectly(@NotNull String value2) {
            if (value2 == null) {
                TextFieldProperty.$$$reportNull$$$0(1);
            }
            this.myTextField.setText(value2);
        }

        @Override
        @NotNull
        public String get() {
            String string = this.myTextField.getText();
            if (string == null) {
                TextFieldProperty.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textField";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/dynamicapp/ModuleDownloadDeviceFeature$TextFieldProperty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/dynamicapp/ModuleDownloadDeviceFeature$TextFieldProperty";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDirectly";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class ActivationListener
    implements PropertyChangeListener {
        @NotNull
        private TextFieldProperty<String> myDeviceFeatureValueComboTextProperty;
        @NotNull
        private ObjectProperty<DeviceFeatureKind> myFeatureNameComboSelectedItem;

        private ActivationListener() {
            this.myDeviceFeatureValueComboTextProperty = new TextFieldProperty<String>(ModuleDownloadDeviceFeature.this.myFeatureValueTextField);
            this.myFeatureNameComboSelectedItem = ObjectProperty.wrap(new SelectedItemProperty(ModuleDownloadDeviceFeature.this.myFeatureNameCombo));
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            if (evt == null) {
                ActivationListener.$$$reportNull$$$0(0);
            }
            if (evt.getNewValue() == null) {
                ModuleDownloadDeviceFeature.this.myBindings.releaseAll();
                ModuleDownloadDeviceFeature.this.myBindingsListeners.releaseAll();
            } else {
                ModuleDownloadDeviceFeature.this.myBindings.bindTwoWay(this.myFeatureNameComboSelectedItem, ModuleDownloadDeviceFeature.this.myModel.deviceFeatureType);
                ModuleDownloadDeviceFeature.this.myBindings.bindTwoWay(this.myDeviceFeatureValueComboTextProperty, ModuleDownloadDeviceFeature.this.myModel.deviceFeatureValue);
                ArrayList<StringValueProperty> tempValues = new ArrayList<StringValueProperty>();
                for (DeviceFeatureKind value3 : DeviceFeatureKind.values()) {
                    StringValueProperty tempProp = value3.newStringValueProperty();
                    tempValues.add(tempProp);
                    ModuleDownloadDeviceFeature.this.myBindings.bind(tempProp, this.myDeviceFeatureValueComboTextProperty, ModuleDownloadDeviceFeature.this.myModel.deviceFeatureType.isEqualTo(value3));
                }
                ModuleDownloadDeviceFeature.this.myBindingsListeners.listenAndFire(ModuleDownloadDeviceFeature.this.myModel.deviceFeatureType, value2 -> {
                    int index = 0;
                    for (DeviceFeatureKind featureType : DeviceFeatureKind.values()) {
                        if (value2 == featureType) {
                            ModuleDownloadDeviceFeature.this.myFeatureValueTextField.setVariants(ModuleDownloadDeviceFeature.getModelForFeatureType(featureType));
                            ModuleDownloadDeviceFeature.this.myFeatureValueTextField.setText((String)((StringProperty)tempValues.get(index)).get());
                        }
                        ++index;
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/android/tools/idea/npw/dynamicapp/ModuleDownloadDeviceFeature$ActivationListener", "propertyChange"));
        }
    }
}

