/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.importing;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileDependencyModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.npw.importing.ArchiveToGradleModuleModelKt;
import com.android.tools.idea.npw.importing.ArchiveToGradleModuleModelKt$sam$com_android_tools_idea_observable_AbstractProperty_Constraint$0;
import com.android.tools.idea.npw.importing.ArchiveToGradleModuleModelKt$sam$java_lang_Runnable$0;
import com.android.tools.idea.npw.model.ProjectSyncInvoker;
import com.android.tools.idea.npw.project.AndroidGradleModuleUtils;
import com.android.tools.idea.observable.AbstractProperty;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0002J2\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0002J2\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0015H\u0002J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0015H\u0002R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/npw/importing/ArchiveToGradleModuleModel;", "Lcom/android/tools/idea/wizard/model/WizardModel;", "Lcom/intellij/openapi/vfs/LargeFileWriteRequestor;", "project", "Lcom/intellij/openapi/project/Project;", "projectSyncInvoker", "Lcom/android/tools/idea/npw/model/ProjectSyncInvoker;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/npw/model/ProjectSyncInvoker;)V", "archive", "Lcom/android/tools/idea/observable/core/StringProperty;", "gradlePath", "moveArchive", "Lcom/android/tools/idea/observable/core/BoolProperty;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addDependency", "", "projectBuildModel", "Lcom/android/tools/idea/gradle/dsl/api/ProjectBuildModel;", "module", "Lcom/intellij/openapi/module/Module;", "", "archivePath", "Ljava/io/File;", "relativePathString", "createModuleFromArchive", "", "move", "containingModule", "doCreateModuleFromArchive", "handleFinished", "inModule", "Lcom/android/tools/idea/observable/expressions/bool/BooleanExpression;", "registerModuleInSettingsFile", "showErrorDialog", "error", "intellij.android.core"})
public final class ArchiveToGradleModuleModel
extends WizardModel
implements LargeFileWriteRequestor {
    @JvmField
    @NotNull
    public final StringProperty archive;
    @JvmField
    @NotNull
    public final StringProperty gradlePath;
    @JvmField
    @NotNull
    public final BoolProperty moveArchive;
    @NotNull
    private final Project project;
    private final ProjectSyncInvoker projectSyncInvoker;

    @NotNull
    public final BooleanExpression inModule() {
        return new BooleanExpression(this, new ObservableValue[]{this.archive}){
            final /* synthetic */ ArchiveToGradleModuleModel this$0;

            @NotNull
            public Boolean get() {
                return AndroidGradleModuleUtils.getContainingModule(new File((String)this.this$0.archive.get()), this.this$0.getProject()) != null;
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        };
    }

    @Override
    public void handleFinished() {
        StringBuilder stringBuilder = new StringBuilder().append(":");
        Object t = this.gradlePath.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"gradlePath.get()");
        String string = stringBuilder.append(StringsKt.removePrefix((String)((String)t), (CharSequence)":")).toString();
        File file = new File((String)this.archive.get());
        Object t2 = this.moveArchive.get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"moveArchive.get()");
        this.createModuleFromArchive(this.project, string, file, (Boolean)t2, AndroidGradleModuleUtils.getContainingModule(new File((String)this.archive.get()), this.project));
    }

    private final void createModuleFromArchive(Project project, String gradlePath, File archivePath, boolean move, Module containingModule) {
        ProgressWindow progressWindow = new ProgressWindow(false, project);
        Function0 process2 = (Function0)new Function0<Unit>(this, project, gradlePath, archivePath, move, containingModule){
            final /* synthetic */ ArchiveToGradleModuleModel this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $gradlePath;
            final /* synthetic */ File $archivePath;
            final /* synthetic */ boolean $move;
            final /* synthetic */ Module $containingModule;

            public final void invoke() {
                ArchiveToGradleModuleModel.access$doCreateModuleFromArchive(this.this$0, this.$project, this.$gradlePath, this.$archivePath, this.$move, this.$containingModule);
            }
            {
                this.this$0 = archiveToGradleModuleModel;
                this.$project = project;
                this.$gradlePath = string;
                this.$archivePath = file;
                this.$move = bl;
                this.$containingModule = module;
                super(0);
            }
        };
        progressWindow.setTitle("Creating Module from Archive");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            Intrinsics.checkNotNullExpressionValue((Object)ApplicationManager.getApplication().executeOnPooledThread(new Runnable(process2, progressWindow){
                final /* synthetic */ Function0 $process;
                final /* synthetic */ ProgressWindow $progressWindow;

                public final void run() {
                    ProgressManager progressManager = ProgressManager.getInstance();
                    Object object = this.$process;
                    if (object != null) {
                        Function0 function0 = object;
                        object = new ArchiveToGradleModuleModelKt$sam$java_lang_Runnable$0(function0);
                    }
                    progressManager.runProcess((Runnable)object, (ProgressIndicator)this.$progressWindow);
                }
                {
                    this.$process = function0;
                    this.$progressWindow = progressWindow;
                }
            }), (String)"ApplicationManager.getAp\u2026, progressWindow)\n      }");
        } else {
            process2.invoke();
        }
    }

    private final void doCreateModuleFromArchive(Project project, String gradlePath, File archivePath, boolean move, Module containingModule) {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            virtualFile = project.getBaseDir();
        }
        VirtualFile projectBaseDir = virtualFile;
        Path path2 = GradleUtil.getModuleDefaultPath(projectBaseDir.toNioPath(), gradlePath);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"GradleUtil.getModuleDefa\u2026.toNioPath(), gradlePath)");
        Path moduleLocation = path2;
        try {
            VirtualFile modulePathVirtualFile;
            VirtualFile virtualFile2 = FileExtensions.toVirtualFile(archivePath, true);
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile sourceFile = virtualFile2;
            File modulePath = containingModule == null ? null : AndroidRootUtil.findModuleRootFolderPath(containingModule);
            String relativePathString = null;
            if (modulePath != null && (modulePathVirtualFile = FileExtensions.toVirtualFile(modulePath, true)) != null) {
                relativePathString = VfsUtilCore.findRelativePath((VirtualFile)modulePathVirtualFile, (VirtualFile)sourceFile, (char)File.separatorChar);
            }
            ProjectBuildModel projectBuildModel2 = ProjectBuildModel.get((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel2, (String)"ProjectBuildModel.get(project)");
            ProjectBuildModel projectBuildModel3 = projectBuildModel2;
            if (!this.registerModuleInSettingsFile(projectBuildModel3, gradlePath)) {
                return;
            }
            if (move && containingModule != null && !this.addDependency(projectBuildModel3, containingModule, gradlePath, archivePath, relativePathString)) {
                return;
            }
            WriteCommandAction.writeCommandAction((Project)project).withName("Create module " + gradlePath + " from Archive").withGlobalUndo().withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run((ThrowableRunnable)new ThrowableRunnable<Throwable>(this, moduleLocation, move, sourceFile, archivePath, projectBuildModel3){
                final /* synthetic */ ArchiveToGradleModuleModel this$0;
                final /* synthetic */ Path $moduleLocation;
                final /* synthetic */ boolean $move;
                final /* synthetic */ VirtualFile $sourceFile;
                final /* synthetic */ File $archivePath;
                final /* synthetic */ ProjectBuildModel $projectBuildModel;

                public final void run() {
                    VirtualFile moduleRoot = VfsUtil.createDirectoryIfMissing((String)((Object)this.$moduleLocation.toAbsolutePath()).toString());
                    if (moduleRoot != null) {
                        if (this.$move) {
                            this.$sourceFile.move((Object)this.this$0, moduleRoot);
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)this.$sourceFile.copy((Object)this.this$0, moduleRoot, this.$sourceFile.getName()), (String)"sourceFile.copy(this, moduleRoot, sourceFile.name)");
                        }
                        VirtualFile virtualFile = moduleRoot.createChildData((Object)this.this$0, "build.gradle");
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"moduleRoot.createChildDa\u2026onstants.FN_BUILD_GRADLE)");
                        VirtualFile buildGradle2 = virtualFile;
                        VfsUtil.saveText((VirtualFile)buildGradle2, (String)ArchiveToGradleModuleModelKt.getBuildGradleText(this.$archivePath));
                        this.$projectBuildModel.applyChanges();
                    }
                }
                {
                    this.this$0 = archiveToGradleModuleModel;
                    this.$moduleLocation = path2;
                    this.$move = bl;
                    this.$sourceFile = virtualFile;
                    this.$archivePath = file;
                    this.$projectBuildModel = projectBuildModel2;
                }
            });
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (!application.isUnitTestMode()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(this, project){
                    final /* synthetic */ ArchiveToGradleModuleModel this$0;
                    final /* synthetic */ Project $project;

                    public final void run() {
                        ArchiveToGradleModuleModel.access$getProjectSyncInvoker$p(this.this$0).syncProject(this.$project);
                    }
                    {
                        this.this$0 = archiveToGradleModuleModel;
                        this.$project = project;
                    }
                });
            } else {
                this.projectSyncInvoker.syncProject(project);
            }
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(ArchiveToGradleModuleModel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
            logger2.error((Throwable)e);
        }
    }

    private final boolean registerModuleInSettingsFile(ProjectBuildModel projectBuildModel2, String gradlePath) {
        GradleSettingsModel settingsModel = projectBuildModel2.getProjectSettingsModel();
        if (settingsModel == null) {
            this.showErrorDialog("Can't understand Gradle settings file, please add the path '" + gradlePath + "' manually.");
            return false;
        }
        settingsModel.addModulePath(gradlePath);
        return true;
    }

    private final void showErrorDialog(String error) {
        ApplicationManager.getApplication().invokeLater(new Runnable(this, error){
            final /* synthetic */ ArchiveToGradleModuleModel this$0;
            final /* synthetic */ String $error;

            public final void run() {
                Messages.showErrorDialog((Project)this.this$0.getProject(), (String)this.$error, (String)"Create Module from Archive");
            }
            {
                this.this$0 = archiveToGradleModuleModel;
                this.$error = string;
            }
        });
    }

    private final boolean addDependency(ProjectBuildModel projectBuildModel2, Module module, String gradlePath, File archivePath, String relativePathString) {
        GradleBuildModel gradleBuildModel = projectBuildModel2.getModuleBuildModel(module);
        if (gradleBuildModel == null) {
            this.showErrorDialog("Couldn't add dependency from module '" + module.getName() + "' to module '" + gradlePath + "', please add manually");
            return false;
        }
        DependenciesModel dependenciesModel = gradleBuildModel.dependencies();
        Intrinsics.checkNotNullExpressionValue((Object)dependenciesModel, (String)"gradleBuildModel.dependencies()");
        DependenciesModel dependencies2 = dependenciesModel;
        String scope = GradleUtil.useCompatibilityConfigurationNames(this.project) ? "compile" : "implementation";
        dependencies2.addModule(scope, gradlePath);
        String archivePathString = archivePath.getAbsolutePath();
        for (FileDependencyModel fileDependency : dependencies2.files()) {
            String dependencyPath;
            if (fileDependency.file().valueAsString() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)dependencyPath, (String)"fileDependency.file().valueAsString() ?: continue");
            if (!Intrinsics.areEqual((Object)dependencyPath, (Object)relativePathString) && !Intrinsics.areEqual((Object)dependencyPath, (Object)archivePathString)) continue;
            dependencies2.remove((DependencyModel)fileDependency);
        }
        return true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ArchiveToGradleModuleModel(@NotNull Project project, @NotNull ProjectSyncInvoker projectSyncInvoker) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectSyncInvoker, (String)"projectSyncInvoker");
        this.project = project;
        this.projectSyncInvoker = projectSyncInvoker;
        this.archive = new StringValueProperty();
        this.gradlePath = new StringValueProperty();
        this.moveArchive = new BoolValueProperty();
        Object object = 1.INSTANCE;
        if (object != null) {
            function1 = object;
            object = new ArchiveToGradleModuleModelKt$sam$com_android_tools_idea_observable_AbstractProperty_Constraint$0(function1);
        }
        this.archive.addConstraint((AbstractProperty.Constraint)object);
        Object object2 = 2.INSTANCE;
        if (object2 != null) {
            function1 = object2;
            object2 = new ArchiveToGradleModuleModelKt$sam$com_android_tools_idea_observable_AbstractProperty_Constraint$0(function1);
        }
        this.gradlePath.addConstraint((AbstractProperty.Constraint)object2);
        String string = this.project.getBasePath();
        Intrinsics.checkNotNull((Object)string);
        this.archive.set(string);
    }

    public static final /* synthetic */ void access$doCreateModuleFromArchive(ArchiveToGradleModuleModel $this, Project project, String gradlePath, File archivePath, boolean move, Module containingModule) {
        $this.doCreateModuleFromArchive(project, gradlePath, archivePath, move, containingModule);
    }

    public static final /* synthetic */ ProjectSyncInvoker access$getProjectSyncInvoker$p(ArchiveToGradleModuleModel $this) {
        return $this.projectSyncInvoker;
    }
}

