/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0003\u001a \u0010\b\u001a\u00020\u0007*\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"getModuleTemplates", "", "Lcom/android/tools/idea/projectsystem/NamedModuleTemplate;", "Lorg/jetbrains/android/facet/AndroidFacet;", "targetDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPackageForApplication", "", "getPackageForPath", "moduleTemplates", "intellij.android.core"})
@JvmName(name="AndroidPackageUtils")
public final class AndroidPackageUtils {
    @NotNull
    public static final String getPackageForApplication(@NotNull AndroidFacet $this$getPackageForApplication) {
        Intrinsics.checkNotNullParameter((Object)$this$getPackageForApplication, (String)"$this$getPackageForApplication");
        AndroidModel androidModel = AndroidModel.get($this$getPackageForApplication);
        Intrinsics.checkNotNull((Object)androidModel);
        Intrinsics.checkNotNullExpressionValue((Object)androidModel, (String)"AndroidModel.get(this)!!");
        String string = androidModel.getApplicationId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AndroidModel.get(this)!!.applicationId");
        return string;
    }

    @NotNull
    public static final String getPackageForPath(@NotNull AndroidFacet $this$getPackageForPath, @NotNull List<NamedModuleTemplate> moduleTemplates, @NotNull VirtualFile targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$getPackageForPath, (String)"$this$getPackageForPath");
        Intrinsics.checkNotNullParameter(moduleTemplates, (String)"moduleTemplates");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        if (moduleTemplates.isEmpty()) {
            return AndroidPackageUtils.getPackageForApplication($this$getPackageForPath);
        }
        File file = moduleTemplates.get(0).getPaths().getSrcDirectory(null);
        if (file == null) {
            return AndroidPackageUtils.getPackageForApplication($this$getPackageForPath);
        }
        File srcDirectory = file;
        Path srcPath = srcDirectory.toPath().toAbsolutePath();
        Path targetPath = FileExtensions.toIoFile(targetDirectory).toPath().toAbsolutePath();
        if (targetPath.startsWith(srcPath)) {
            Module module = $this$getPackageForPath.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)module.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(module.project)");
            String suggestedPackage = projectRootManager.getFileIndex().getPackageNameByDirectory(targetDirectory);
            CharSequence charSequence = suggestedPackage;
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                return suggestedPackage;
            }
        }
        return AndroidPackageUtils.getPackageForApplication($this$getPackageForPath);
    }

    @NotNull
    public static final List<NamedModuleTemplate> getModuleTemplates(@NotNull AndroidFacet $this$getModuleTemplates, @Nullable VirtualFile targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$getModuleTemplates, (String)"$this$getModuleTemplates");
        Module module = $this$getModuleTemplates.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"module");
        return ProjectSystemUtil.getModuleSystem(module).getModuleTemplates(targetDirectory);
    }
}

