/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/npw/template/TemplateHandle;", "", "rootPath", "Ljava/io/File;", "(Ljava/io/File;)V", "metadata", "Lcom/android/tools/idea/templates/TemplateMetadata;", "getMetadata", "()Lcom/android/tools/idea/templates/TemplateMetadata;", "getRootPath", "()Ljava/io/File;", "template", "Lcom/android/tools/idea/templates/Template;", "getTemplate", "()Lcom/android/tools/idea/templates/Template;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.core"})
public final class TemplateHandle {
    @NotNull
    private final Template template;
    @NotNull
    private final TemplateMetadata metadata;
    @NotNull
    private final File rootPath;

    @NotNull
    public final Template getTemplate() {
        return this.template;
    }

    @NotNull
    public final TemplateMetadata getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rootPath, this.metadata.getTitle()});
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (other == null || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(other.getClass()), (Object)Reflection.getOrCreateKotlinClass(this.getClass())) ^ true) {
            bl = false;
        } else if (other == this) {
            bl = true;
        } else {
            TemplateHandle another = (TemplateHandle)other;
            bl = Objects.equal((Object)this.rootPath, (Object)another.rootPath) && Objects.equal((Object)this.metadata.getTitle(), (Object)another.metadata.getTitle());
        }
        return bl;
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)this).add("title", (Object)this.metadata.getTitle()).add("path", (Object)this.rootPath.getAbsolutePath()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MoreObjects.toStringHelp\u2026.absolutePath).toString()");
        return string;
    }

    @NotNull
    public final File getRootPath() {
        return this.rootPath;
    }

    public TemplateHandle(@NotNull File rootPath) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.rootPath = rootPath;
        Template template = Template.createFromPath(this.rootPath);
        Intrinsics.checkNotNullExpressionValue((Object)template, (String)"Template.createFromPath(rootPath)");
        this.template = template;
        TemplateMetadata templateMetadata = TemplateManager.getInstance().getTemplateMetadata(this.rootPath);
        Intrinsics.checkNotNull((Object)templateMetadata);
        this.metadata = templateMetadata;
    }
}

