/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.analytics;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Cpu;
import com.android.tools.profiler.proto.Energy;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.analytics.energy.EnergyEventMetadata;
import com.android.tools.profilers.analytics.energy.EnergyRangeMetadata;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureSessionArtifact;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.energy.EnergyDuration;
import com.android.tools.profilers.energy.EnergyProfilerStage;
import com.android.tools.profilers.memory.HprofSessionArtifact;
import com.android.tools.profilers.memory.LegacyAllocationsSessionArtifact;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.instancefilters.ActivityFragmentLeakInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.CaptureObjectInstanceFilter;
import com.android.tools.profilers.memory.adapters.instancefilters.ProjectClassesInstanceFilter;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.sessions.SessionArtifact;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.CpuApiTracingMetadata;
import com.google.wireless.android.sdk.stats.CpuCaptureMetadata;
import com.google.wireless.android.sdk.stats.CpuImportTraceMetadata;
import com.google.wireless.android.sdk.stats.CpuProfilingConfig;
import com.google.wireless.android.sdk.stats.CpuStartupProfilingMetadata;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.EnergyEvent;
import com.google.wireless.android.sdk.stats.EnergyEventCount;
import com.google.wireless.android.sdk.stats.EnergyEventMetadata;
import com.google.wireless.android.sdk.stats.EnergyRangeMetadata;
import com.google.wireless.android.sdk.stats.FilterMetadata;
import com.google.wireless.android.sdk.stats.MemoryInstanceFilterMetadata;
import com.google.wireless.android.sdk.stats.ProfilerSessionCreationMetaData;
import com.google.wireless.android.sdk.stats.ProfilerSessionSelectionMetaData;
import com.google.wireless.android.sdk.stats.TransportFailureMetadata;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StudioFeatureTracker
implements FeatureTracker {
    @Nullable
    private Common.Device myActiveDevice;
    @Nullable
    private Common.Process myActiveProcess;
    @NotNull
    private Project myTrackingProject;
    private final ImmutableMap<Class<? extends Stage>, AndroidProfilerEvent.Stage> STAGE_MAP;
    private final ImmutableMap<Common.SessionMetaData.SessionType, ProfilerSessionCreationMetaData.SessionType> SESSION_TYPE_MAP;
    private final ImmutableMap<SessionsManager.SessionCreationSource, ProfilerSessionCreationMetaData.CreationSource> SESSION_CREATION_SOURCE_MAP;
    private final ImmutableMap<Class<? extends SessionArtifact>, ProfilerSessionSelectionMetaData.ArtifactType> SESSION_ARTIFACT_MAP;
    private final ImmutableMap<Class<? extends Exception>, TransportFailureMetadata.FailureType> TRANSPORT_FAILURE_MAP;
    private static final ImmutableMap<CpuCaptureMetadata.CaptureStatus, CpuCaptureMetadata.CaptureStatus> CPU_CAPTURE_STATUS_MAP = ImmutableMap.builder().put((Object)CpuCaptureMetadata.CaptureStatus.SUCCESS, (Object)CpuCaptureMetadata.CaptureStatus.SUCCESS).put((Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING, (Object)CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING).put((Object)CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE, (Object)CpuCaptureMetadata.CaptureStatus.PREPROCESS_FAILURE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_NO_GOING_PROFILING, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_NO_GOING_PROFILING).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PROCESS_DIED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PROCESS_DIED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PID_CHANGED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_APP_PID_CHANGED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_PROFILER_PROCESS_DIED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_PROFILER_PROCESS_DIED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STOP_COMMAND_FAILED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STOP_COMMAND_FAILED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STILL_PROFILING_AFTER_STOP, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_STILL_PROFILING_AFTER_STOP).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_START_WAITING, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_START_WAITING).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_TIMEOUT, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_TIMEOUT).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_FAILED, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_WAIT_FAILED).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_WAIT_EVENT, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_WAIT_EVENT).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_COPY_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_COPY_FILE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_FORM_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_FORM_FILE).put((Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_FILE, (Object)CpuCaptureMetadata.CaptureStatus.STOP_FAILED_CANNOT_READ_FILE).build();
    private final ImmutableMap<Class<? extends CaptureObjectInstanceFilter>, MemoryInstanceFilterMetadata.FilterType> MEMORY_INSTANCE_FILTER_MAP;
    @NotNull
    private AndroidProfilerEvent.Stage myCurrStage;

    public StudioFeatureTracker(@NotNull Project trackingProject) {
        if (trackingProject == null) {
            StudioFeatureTracker.$$$reportNull$$$0(0);
        }
        this.STAGE_MAP = ImmutableMap.builder().put(NullMonitorStage.class, (Object)AndroidProfilerEvent.Stage.NULL_STAGE).put(StudioMonitorStage.class, (Object)AndroidProfilerEvent.Stage.OVERVIEW_STAGE).put(CpuProfilerStage.class, (Object)AndroidProfilerEvent.Stage.CPU_STAGE).put(MemoryProfilerStage.class, (Object)AndroidProfilerEvent.Stage.MEMORY_STAGE).put(NetworkProfilerStage.class, (Object)AndroidProfilerEvent.Stage.NETWORK_STAGE).put(EnergyProfilerStage.class, (Object)AndroidProfilerEvent.Stage.ENERGY_STAGE).build();
        this.SESSION_TYPE_MAP = ImmutableMap.of((Object)Common.SessionMetaData.SessionType.FULL, (Object)ProfilerSessionCreationMetaData.SessionType.FULL_SESSION, (Object)Common.SessionMetaData.SessionType.MEMORY_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.MEMORY_CAPTURE, (Object)Common.SessionMetaData.SessionType.CPU_CAPTURE, (Object)ProfilerSessionCreationMetaData.SessionType.CPU_CAPTURE);
        this.SESSION_CREATION_SOURCE_MAP = ImmutableMap.of((Object)SessionsManager.SessionCreationSource.MANUAL, (Object)ProfilerSessionCreationMetaData.CreationSource.MANUAL);
        this.SESSION_ARTIFACT_MAP = ImmutableMap.of(SessionItem.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_SESSION, HprofSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_HPROF, CpuCaptureSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_CPU_CAPTURE, LegacyAllocationsSessionArtifact.class, (Object)ProfilerSessionSelectionMetaData.ArtifactType.ARTIFACT_LEGACY_ALLOCATIONS);
        this.TRANSPORT_FAILURE_MAP = ImmutableMap.builder().put(TimeoutException.class, (Object)TransportFailureMetadata.FailureType.TIMEOUT).put(InterruptedException.class, (Object)TransportFailureMetadata.FailureType.INTERRUPTED).put(IOException.class, (Object)TransportFailureMetadata.FailureType.IO).put(SyncException.class, (Object)TransportFailureMetadata.FailureType.SYNC).put(ShellCommandUnresponsiveException.class, (Object)TransportFailureMetadata.FailureType.SHELL_COMMAND_UNRESPONSIVE).put(AdbCommandRejectedException.class, (Object)TransportFailureMetadata.FailureType.ADB_COMMAND_REJECTED).build();
        this.MEMORY_INSTANCE_FILTER_MAP = ImmutableMap.builder().put(ActivityFragmentLeakInstanceFilter.class, (Object)MemoryInstanceFilterMetadata.FilterType.ACTIVITY_FRAGMENT_LEAKS).put(ProjectClassesInstanceFilter.class, (Object)MemoryInstanceFilterMetadata.FilterType.PROJECT_CLASSES).build();
        this.myCurrStage = AndroidProfilerEvent.Stage.UNKNOWN_STAGE;
        this.myTrackingProject = trackingProject;
    }

    public void trackPreTransportDaemonStarts(@NotNull Common.Device transportDevice) {
        if (transportDevice == null) {
            StudioFeatureTracker.$$$reportNull$$$0(1);
        }
        this.newTracker(AndroidProfilerEvent.Type.PRE_TRANSPORT_DAEMON_STARTS).setDevice(transportDevice).track();
    }

    public void trackTransportDaemonFailed(@NotNull Common.Device transportDevice, Exception exception) {
        if (transportDevice == null) {
            StudioFeatureTracker.$$$reportNull$$$0(2);
        }
        TransportFailureMetadata.FailureType failureType = (TransportFailureMetadata.FailureType)this.TRANSPORT_FAILURE_MAP.getOrDefault(exception.getClass(), (Object)TransportFailureMetadata.FailureType.UNKNOWN_FAILURE_TYPE);
        this.newTracker(AndroidProfilerEvent.Type.TRANSPORT_DAEMON_FAILED).setDevice(transportDevice).setTransportFailureMetadata(TransportFailureMetadata.newBuilder().setFailureType(failureType).build()).track();
    }

    public void trackTransportProxyCreationFailed(@NotNull Common.Device transportDevice, Exception exception) {
        if (transportDevice == null) {
            StudioFeatureTracker.$$$reportNull$$$0(3);
        }
        TransportFailureMetadata.FailureType failureType = (TransportFailureMetadata.FailureType)this.TRANSPORT_FAILURE_MAP.getOrDefault(exception.getClass(), (Object)TransportFailureMetadata.FailureType.UNKNOWN_FAILURE_TYPE);
        this.newTracker(AndroidProfilerEvent.Type.TRANSPORT_PROXY_FAILED).setDevice(transportDevice).setTransportFailureMetadata(TransportFailureMetadata.newBuilder().setFailureType(failureType).build()).track();
    }

    public void trackProfilerInitializationFailed() {
        this.track(AndroidProfilerEvent.Type.PROFILER_INITIALIZATION_FAILED);
    }

    public void trackEnterStage(@NotNull Class<? extends Stage> stage) {
        if (stage == null) {
            StudioFeatureTracker.$$$reportNull$$$0(4);
        }
        this.myCurrStage = (AndroidProfilerEvent.Stage)this.STAGE_MAP.getOrDefault(stage, (Object)AndroidProfilerEvent.Stage.UNKNOWN_STAGE);
        this.track(AndroidProfilerEvent.Type.STAGE_ENTERED);
    }

    public void trackRunWithProfiling() {
        this.track(AndroidProfilerEvent.Type.RUN_WITH_PROFILING);
    }

    public void trackAutoProfilingRequested() {
        this.track(AndroidProfilerEvent.Type.AUTO_PROFILING_REQUESTED);
    }

    public void trackAutoProfilingSucceeded() {
        this.track(AndroidProfilerEvent.Type.AUTO_PROFILING_SUCCEEDED);
    }

    public void trackProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackAdvancedProfilingStarted() {
        this.newTracker(AndroidProfilerEvent.Type.ADVANCED_PROFILING_STARTED).setDevice(this.myActiveDevice).track();
    }

    public void trackChangeDevice(@Nullable Common.Device device) {
        if (this.myActiveDevice != device) {
            this.myActiveDevice = device;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_DEVICE).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackChangeProcess(@Nullable Common.Process process2) {
        if (this.myActiveProcess != process2) {
            this.myActiveProcess = process2;
            this.newTracker(AndroidProfilerEvent.Type.CHANGE_PROCESS).setDevice(this.myActiveDevice).track();
        }
    }

    public void trackSessionDropdownClicked() {
        this.track(AndroidProfilerEvent.Type.SESSION_DROPDOWN_CLICKED);
    }

    public void trackCreateSession(Common.SessionMetaData.SessionType sessionType, SessionsManager.SessionCreationSource sourceType) {
        ProfilerSessionCreationMetaData.Builder builder2 = ProfilerSessionCreationMetaData.newBuilder().setCreatedType((ProfilerSessionCreationMetaData.SessionType)this.SESSION_TYPE_MAP.getOrDefault((Object)sessionType, (Object)ProfilerSessionCreationMetaData.SessionType.UNKNOWN_SESSION)).setCreationSource((ProfilerSessionCreationMetaData.CreationSource)this.SESSION_CREATION_SOURCE_MAP.getOrDefault((Object)sourceType, (Object)ProfilerSessionCreationMetaData.CreationSource.UNKNOWN_SOURCE));
        this.newTracker(AndroidProfilerEvent.Type.SESSION_CREATED).setSessionCreationMetadata(builder2.build()).track();
    }

    public void trackStopSession() {
        this.track(AndroidProfilerEvent.Type.SESSION_STOPPED);
    }

    public void trackSessionsPanelStateChanged(boolean isExpanded) {
        this.track(isExpanded ? AndroidProfilerEvent.Type.SESSION_UI_EXPANDED : AndroidProfilerEvent.Type.SESSION_UI_COLLAPSED);
    }

    public void trackSessionsPanelResized() {
        this.track(AndroidProfilerEvent.Type.SESSION_UI_RESIZED);
    }

    public void trackSessionArtifactSelected(@NotNull SessionArtifact artifact, boolean isSessionLive) {
        if (artifact == null) {
            StudioFeatureTracker.$$$reportNull$$$0(5);
        }
        ProfilerSessionSelectionMetaData.Builder builder2 = ProfilerSessionSelectionMetaData.newBuilder().setSelectedType((ProfilerSessionSelectionMetaData.ArtifactType)this.SESSION_ARTIFACT_MAP.getOrDefault(artifact.getClass(), (Object)ProfilerSessionSelectionMetaData.ArtifactType.UNKNOWN_ARTIFACT_TYPE)).setIsSessionAlive(isSessionLive);
        this.newTracker(AndroidProfilerEvent.Type.SESSION_ARTIFACT_SELECTED).setSessionSelectionMetadata(builder2.build()).track();
    }

    public void trackGoBack() {
        this.track(AndroidProfilerEvent.Type.GO_BACK);
    }

    public void trackSelectMonitor() {
        this.track(AndroidProfilerEvent.Type.SELECT_MONITOR);
    }

    public void trackZoomIn() {
        this.track(AndroidProfilerEvent.Type.ZOOM_IN);
    }

    public void trackZoomOut() {
        this.track(AndroidProfilerEvent.Type.ZOOM_OUT);
    }

    public void trackResetZoom() {
        this.track(AndroidProfilerEvent.Type.ZOOM_RESET);
    }

    public void trackToggleStreaming() {
        this.track(AndroidProfilerEvent.Type.GO_LIVE);
    }

    public void trackNavigateToCode() {
        this.track(AndroidProfilerEvent.Type.NAVIGATE_TO_CODE);
    }

    public void trackSelectCpuKernelElement() {
        this.track(AndroidProfilerEvent.Type.KERNEL_VIEW_CLICKED);
    }

    public void trackToggleCpuKernelHideablePanel() {
        this.track(AndroidProfilerEvent.Type.KERNEL_VIEW_TOGGLED);
    }

    public void trackToggleCpuThreadsHideablePanel() {
        this.track(AndroidProfilerEvent.Type.THREADS_VIEW_TOGGLED);
    }

    public void trackSelectRange() {
        this.newTracker(AndroidProfilerEvent.Type.SELECT_RANGE).setDevice(this.myActiveDevice).track();
    }

    public void trackCaptureTrace(@NotNull com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
        if (cpuCaptureMetadata == null) {
            StudioFeatureTracker.$$$reportNull$$$0(6);
        }
        this.newTracker(AndroidProfilerEvent.Type.CAPTURE_TRACE).setDevice(this.myActiveDevice).setCpuCaptureMetadata(cpuCaptureMetadata).track();
    }

    public void trackImportTrace(@NotNull Cpu.CpuTraceType profilerType, boolean success2) {
        if (profilerType == null) {
            StudioFeatureTracker.$$$reportNull$$$0(7);
        }
        CpuImportTraceMetadata.Builder metadata = CpuImportTraceMetadata.newBuilder();
        metadata.setImportStatus(success2 ? CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_SUCCESS : CpuImportTraceMetadata.ImportStatus.IMPORT_TRACE_FAILURE);
        switch (profilerType) {
            case ART: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.ART_TECHNOLOGY);
                break;
            }
            case SIMPLEPERF: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.SIMPLEPERF_TECHNOLOGY);
                break;
            }
            case ATRACE: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.ATRACE_TECHNOLOGY);
                break;
            }
            default: {
                metadata.setTechnology(CpuImportTraceMetadata.Technology.UNKNOWN_TECHNOLOGY);
            }
        }
        this.newTracker(AndroidProfilerEvent.Type.CPU_IMPORT_TRACE).setDevice(this.myActiveDevice).setCpuImportTraceMetadata(metadata.build()).track();
    }

    public void trackCpuStartupProfiling(@NotNull Common.Device device, @NotNull ProfilingConfiguration configuration) {
        if (device == null) {
            StudioFeatureTracker.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            StudioFeatureTracker.$$$reportNull$$$0(9);
        }
        this.newTracker(AndroidProfilerEvent.Type.CPU_STARTUP_PROFILING).setDevice(device).setCpuStartupProfilingConfiguration(configuration).track();
    }

    public void trackCpuApiTracing(boolean sampling, boolean pathProvided, int bufferSize, int flags, int intervalUs) {
        CpuApiTracingMetadata metadata = CpuApiTracingMetadata.newBuilder().setUseSampling(sampling).setArgTracePath(pathProvided).setArgBufferSize(bufferSize).setArgFlags(flags).setArgIntervalUs(intervalUs).build();
        this.newTracker(AndroidProfilerEvent.Type.CPU_API_TRACING).setDevice(this.myActiveDevice).setCpuApiTracingMetadata(metadata).track();
    }

    public void trackSelectThread() {
        this.track(AndroidProfilerEvent.Type.SELECT_THREAD);
    }

    public void trackSelectCaptureTopDown() {
        this.track(AndroidProfilerEvent.Type.SELECT_TOP_DOWN);
    }

    public void trackSelectCaptureBottomUp() {
        this.track(AndroidProfilerEvent.Type.SELECT_BOTTOM_UP);
    }

    public void trackSelectCaptureFlameChart() {
        this.track(AndroidProfilerEvent.Type.SELECT_FLAME_CHART);
    }

    public void trackSelectCaptureCallChart() {
        this.track(AndroidProfilerEvent.Type.SELECT_CALL_CHART);
    }

    public void trackForceGc() {
        this.track(AndroidProfilerEvent.Type.FORCE_GC);
    }

    public void trackDumpHeap() {
        this.track(AndroidProfilerEvent.Type.SNAPSHOT_HPROF);
    }

    public void trackRecordAllocations() {
        this.track(AndroidProfilerEvent.Type.CAPTURE_ALLOCATIONS);
    }

    public void trackExportHeap() {
        this.track(AndroidProfilerEvent.Type.EXPORT_HPROF);
    }

    public void trackExportAllocation() {
        this.track(AndroidProfilerEvent.Type.EXPORT_ALLOCATION);
    }

    public void trackChangeClassArrangment() {
        this.track(AndroidProfilerEvent.Type.ARRANGE_CLASSES);
    }

    public void trackSelectMemoryStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_STACK);
    }

    public void trackSelectMemoryReferences() {
        this.track(AndroidProfilerEvent.Type.SELECT_MEMORY_REFERENCES);
    }

    public void trackSelectMemoryHeap(@NotNull String heapName) {
        AndroidProfilerEvent.MemoryHeap heapType;
        if (heapName == null) {
            StudioFeatureTracker.$$$reportNull$$$0(10);
        }
        switch (heapName) {
            case "default": {
                heapType = AndroidProfilerEvent.MemoryHeap.DEFAULT_HEAP;
                break;
            }
            case "app": {
                heapType = AndroidProfilerEvent.MemoryHeap.APP_HEAP;
                break;
            }
            case "image": {
                heapType = AndroidProfilerEvent.MemoryHeap.IMAGE_HEAP;
                break;
            }
            case "zygote": {
                heapType = AndroidProfilerEvent.MemoryHeap.ZYGOTE_HEAP;
                break;
            }
            case "JNI": {
                heapType = AndroidProfilerEvent.MemoryHeap.JNI_HEAP;
                break;
            }
            default: {
                StudioFeatureTracker.getLogger().error("Attempt to report selection of unknown heap name: " + heapName);
                return;
            }
        }
        this.newTracker(AndroidProfilerEvent.Type.SELECT_MEMORY_HEAP).setMemoryHeapId(heapType).track();
    }

    public void trackSelectNetworkRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTION);
    }

    public void trackSelectNetworkDetailsOverview() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_OVERVIEW);
    }

    public void trackSelectNetworkDetailsHeaders() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_HEADERS);
    }

    public void trackSelectNetworkDetailsResponse() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_RESPONSE);
    }

    public void trackSelectNetworkDetailsRequest() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_REQUEST);
    }

    public void trackSelectNetworkDetailsStack() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_STACK);
    }

    public void trackSelectNetworkDetailsError() {
        this.track(AndroidProfilerEvent.Type.SELECT_DETAILS_ERROR);
    }

    public void trackSelectNetworkConnectionsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_CONNECTION_VIEW);
    }

    public void trackSelectNetworkThreadsView() {
        this.track(AndroidProfilerEvent.Type.SELECT_CONNECTIONS_THREADS_VIEW);
    }

    public void trackOpenProfilingConfigDialog() {
        this.track(AndroidProfilerEvent.Type.OPEN_CPU_CONFIG_DIALOG);
    }

    public void trackCreateCustomProfilingConfig() {
        this.track(AndroidProfilerEvent.Type.CREATE_CPU_CONFIG);
    }

    public void trackSelectEnergyRange(@NotNull EnergyRangeMetadata rangeMetadata) {
        if (rangeMetadata == null) {
            StudioFeatureTracker.$$$reportNull$$$0(11);
        }
        this.newTracker(AndroidProfilerEvent.Type.SELECT_ENERGY_RANGE).setEnergyRangeMetadata(rangeMetadata).track();
    }

    public void trackSelectEnergyEvent(@NotNull EnergyEventMetadata eventMetadata) {
        if (eventMetadata == null) {
            StudioFeatureTracker.$$$reportNull$$$0(12);
        }
        this.newTracker(AndroidProfilerEvent.Type.SELECT_ENERGY_EVENT).setEnergyEventMetadata(eventMetadata).track();
    }

    public void trackFilterMetadata(@NotNull FilterMetadata filterMetadata) {
        if (filterMetadata == null) {
            StudioFeatureTracker.$$$reportNull$$$0(13);
        }
        this.newTracker(AndroidProfilerEvent.Type.FILTER).setFilterMetadata(filterMetadata).track();
    }

    public void trackMemoryProfilerInstanceFilter(@NotNull CaptureObjectInstanceFilter filter2) {
        if (filter2 == null) {
            StudioFeatureTracker.$$$reportNull$$$0(14);
        }
        MemoryInstanceFilterMetadata.Builder builder2 = MemoryInstanceFilterMetadata.newBuilder().setFilterType((MemoryInstanceFilterMetadata.FilterType)this.MEMORY_INSTANCE_FILTER_MAP.getOrDefault(filter2.getClass(), (Object)MemoryInstanceFilterMetadata.FilterType.UNKNOWN_FILTER_TYPE));
        this.newTracker(AndroidProfilerEvent.Type.MEMORY_INSTANCE_FILTER).setMemoryInstanceFilterMetadata(builder2.build()).track();
    }

    @NotNull
    private Tracker newTracker(AndroidProfilerEvent.Type eventType) {
        return new Tracker(this.myTrackingProject, eventType, this.myCurrStage);
    }

    private void track(AndroidProfilerEvent.Type eventType) {
        this.newTracker(eventType).track();
    }

    private static Logger getLogger() {
        return Logger.getInstance(StudioFeatureTracker.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackingProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transportDevice";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cpuCaptureMetadata";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heapName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMetadata";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventMetadata";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterMetadata";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/profilers/analytics/StudioFeatureTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "trackPreTransportDaemonStarts";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "trackTransportDaemonFailed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "trackTransportProxyCreationFailed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "trackEnterStage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "trackSessionArtifactSelected";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trackCaptureTrace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "trackImportTrace";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "trackCpuStartupProfiling";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "trackSelectMemoryHeap";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "trackSelectEnergyRange";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "trackSelectEnergyEvent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "trackFilterMetadata";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "trackMemoryProfilerInstanceFilter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Tracker {
        @NotNull
        private final AndroidProfilerEvent.Type myEventType;
        @NotNull
        private final AndroidProfilerEvent.Stage myCurrStage;
        @NotNull
        private final Project myTrackingProject;
        @Nullable
        private Common.Device myDevice;
        @Nullable
        private com.android.tools.profilers.cpu.CpuCaptureMetadata myCpuCaptureMetadata;
        @Nullable
        private CpuImportTraceMetadata myCpuImportTraceMetadata;
        @Nullable
        private FilterMetadata myFeatureMetadata;
        @Nullable
        private CpuApiTracingMetadata myCpuApiTracingMetadata;
        @Nullable
        private EnergyRangeMetadata myEnergyRangeMetadata;
        @Nullable
        private EnergyEventMetadata myEnergyEventMetadata;
        @Nullable
        private ProfilerSessionCreationMetaData mySessionCreationMetadata;
        @Nullable
        private ProfilerSessionSelectionMetaData mySessionArtifactMetadata;
        @Nullable
        private ProfilingConfiguration myCpuStartupProfilingConfiguration;
        @Nullable
        private TransportFailureMetadata myTransportFailureMetadata;
        @Nullable
        private MemoryInstanceFilterMetadata myMemoryInstanceFilterMetadata;
        private AndroidProfilerEvent.MemoryHeap myMemoryHeap;

        public Tracker(@NotNull Project trackingProject, @NotNull AndroidProfilerEvent.Type eventType, @NotNull AndroidProfilerEvent.Stage stage) {
            if (trackingProject == null) {
                Tracker.$$$reportNull$$$0(0);
            }
            if (eventType == null) {
                Tracker.$$$reportNull$$$0(1);
            }
            if (stage == null) {
                Tracker.$$$reportNull$$$0(2);
            }
            this.myMemoryHeap = AndroidProfilerEvent.MemoryHeap.UNKNOWN_HEAP;
            this.myEventType = eventType;
            this.myCurrStage = stage;
            this.myTrackingProject = trackingProject;
        }

        @NotNull
        public Tracker setDevice(@Nullable Common.Device device) {
            this.myDevice = device;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(3);
            }
            return tracker;
        }

        @NotNull
        public Tracker setCpuCaptureMetadata(@Nullable com.android.tools.profilers.cpu.CpuCaptureMetadata cpuCaptureMetadata) {
            this.myCpuCaptureMetadata = cpuCaptureMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(4);
            }
            return tracker;
        }

        @NotNull
        public Tracker setCpuImportTraceMetadata(CpuImportTraceMetadata cpuImportTraceMetadata) {
            this.myCpuImportTraceMetadata = cpuImportTraceMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(5);
            }
            return tracker;
        }

        @NotNull
        public Tracker setCpuStartupProfilingConfiguration(@Nullable ProfilingConfiguration configuration) {
            this.myCpuStartupProfilingConfiguration = configuration;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(6);
            }
            return tracker;
        }

        @NotNull
        public Tracker setCpuApiTracingMetadata(@Nullable CpuApiTracingMetadata metadata) {
            this.myCpuApiTracingMetadata = metadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(7);
            }
            return tracker;
        }

        @NotNull
        public Tracker setFilterMetadata(@Nullable FilterMetadata filterMetadata) {
            this.myFeatureMetadata = filterMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(8);
            }
            return tracker;
        }

        @NotNull
        public Tracker setEnergyRangeMetadata(@Nullable EnergyRangeMetadata energyRangeMetadata) {
            this.myEnergyRangeMetadata = energyRangeMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(9);
            }
            return tracker;
        }

        @NotNull
        public Tracker setEnergyEventMetadata(@Nullable EnergyEventMetadata energyEventMetadata) {
            this.myEnergyEventMetadata = energyEventMetadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(10);
            }
            return tracker;
        }

        @NotNull
        public Tracker setMemoryHeapId(AndroidProfilerEvent.MemoryHeap heap) {
            this.myMemoryHeap = heap;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(11);
            }
            return tracker;
        }

        @NotNull
        public Tracker setSessionCreationMetadata(ProfilerSessionCreationMetaData metadata) {
            this.mySessionCreationMetadata = metadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(12);
            }
            return tracker;
        }

        @NotNull
        public Tracker setSessionSelectionMetadata(ProfilerSessionSelectionMetaData metadata) {
            this.mySessionArtifactMetadata = metadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(13);
            }
            return tracker;
        }

        @NotNull
        public Tracker setTransportFailureMetadata(TransportFailureMetadata metadata) {
            this.myTransportFailureMetadata = metadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(14);
            }
            return tracker;
        }

        @NotNull
        public Tracker setMemoryInstanceFilterMetadata(MemoryInstanceFilterMetadata metadata) {
            this.myMemoryInstanceFilterMetadata = metadata;
            Tracker tracker = this;
            if (tracker == null) {
                Tracker.$$$reportNull$$$0(15);
            }
            return tracker;
        }

        public void track() {
            AndroidProfilerEvent.Builder profilerEvent = AndroidProfilerEvent.newBuilder().setStage(this.myCurrStage).setType(this.myEventType);
            this.populateCpuCaptureMetadata(profilerEvent);
            this.populateFilterMetadata(profilerEvent);
            this.populateEnergyRangeMetadata(profilerEvent);
            this.populateEnergyEventMetadata(profilerEvent);
            this.populateMemoryInstanceFilterMetadata(profilerEvent);
            switch (this.myEventType) {
                case SELECT_MEMORY_HEAP: {
                    profilerEvent.setMemoryHeap(this.myMemoryHeap);
                    break;
                }
                case SESSION_CREATED: {
                    profilerEvent.setSessionStartMetadata(this.mySessionCreationMetadata);
                    break;
                }
                case SESSION_ARTIFACT_SELECTED: {
                    profilerEvent.setSessionArtifactMetadata(this.mySessionArtifactMetadata);
                    break;
                }
                case TRANSPORT_DAEMON_FAILED: 
                case TRANSPORT_PROXY_FAILED: {
                    assert (this.myTransportFailureMetadata != null);
                    profilerEvent.setTransportFailureMetadata(this.myTransportFailureMetadata);
                    break;
                }
                case CPU_API_TRACING: {
                    profilerEvent.setCpuApiTracingMetadata(this.myCpuApiTracingMetadata);
                    break;
                }
                case CPU_STARTUP_PROFILING: {
                    profilerEvent.setCpuStartupProfilingMetadata(CpuStartupProfilingMetadata.newBuilder().setProfilingConfig(Tracker.toStatsCpuProfilingConfig(this.myCpuStartupProfilingConfiguration)));
                    break;
                }
                case CPU_IMPORT_TRACE: {
                    assert (this.myCpuImportTraceMetadata != null);
                    profilerEvent.setCpuImportTraceMetadata(this.myCpuImportTraceMetadata);
                    break;
                }
            }
            AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.ANDROID_PROFILER).setAndroidProfilerEvent(profilerEvent);
            if (this.myDevice != null) {
                event.setDeviceInfo(DeviceInfo.newBuilder().setManufacturer(this.myDevice.getManufacturer()).setModel(this.myDevice.getModel()).setBuildVersionRelease(this.myDevice.getVersion()).setBuildApiLevelFull(new AndroidVersion(this.myDevice.getApiLevel(), this.myDevice.getCodename()).getApiString()).setDeviceType(this.myDevice.getIsEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).build());
            }
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(event, this.myTrackingProject));
        }

        private void populateEnergyRangeMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (profilerEvent == null) {
                Tracker.$$$reportNull$$$0(16);
            }
            if (this.myEnergyRangeMetadata == null) {
                return;
            }
            EnergyRangeMetadata.Builder builder2 = com.google.wireless.android.sdk.stats.EnergyRangeMetadata.newBuilder();
            this.myEnergyRangeMetadata.getEventCounts().forEach(eventCount -> builder2.addEventCounts(EnergyEventCount.newBuilder().setType(Tracker.toEnergyType(eventCount.getKind())).setCount(eventCount.getCount()).build()));
            profilerEvent.setEnergyRangeMetadata(builder2.build());
        }

        private void populateEnergyEventMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (profilerEvent == null) {
                Tracker.$$$reportNull$$$0(17);
            }
            if (this.myEnergyEventMetadata == null || this.myEnergyEventMetadata.getSubevents().isEmpty()) {
                return;
            }
            EnergyEventMetadata.Builder builder2 = com.google.wireless.android.sdk.stats.EnergyEventMetadata.newBuilder();
            List subevents = this.myEnergyEventMetadata.getSubevents();
            Common.Event firstEvent = (Common.Event)subevents.get(0);
            builder2.setType(Tracker.toEnergyType(firstEvent.getEnergyEvent()));
            EnergyEvent.Subtype eventSubtype = Tracker.toEnergySubtype(firstEvent.getEnergyEvent());
            if (eventSubtype != null) {
                builder2.setSubtype(eventSubtype);
            }
            for (Common.Event event : subevents) {
                builder2.addSubevents(Tracker.toEnergySubevent(event.getEnergyEvent()));
            }
            profilerEvent.setEnergyEventMetadata(builder2);
        }

        private void populateMemoryInstanceFilterMetadata(@NotNull AndroidProfilerEvent.Builder profilerEvent) {
            if (profilerEvent == null) {
                Tracker.$$$reportNull$$$0(18);
            }
            if (this.myMemoryInstanceFilterMetadata == null) {
                return;
            }
            profilerEvent.setMemoryInstanceFilterMetadata(this.myMemoryInstanceFilterMetadata);
        }

        private void populateFilterMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myFeatureMetadata != null) {
                FilterMetadata.Builder filterMetadata = com.google.wireless.android.sdk.stats.FilterMetadata.newBuilder();
                filterMetadata.setFeaturesUsed((long)this.myFeatureMetadata.getFeaturesUsed());
                filterMetadata.setMatchedElements(this.myFeatureMetadata.getMatchedElementCount());
                filterMetadata.setTotalElements(this.myFeatureMetadata.getTotalElementCount());
                filterMetadata.setSearchLength(this.myFeatureMetadata.getFilterTextLength());
                switch (this.myFeatureMetadata.getView()) {
                    case UNKNOWN_FILTER_VIEW: {
                        filterMetadata.setActiveView(FilterMetadata.View.UNKNOWN_FILTER_VIEW);
                        break;
                    }
                    case CPU_TOP_DOWN: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_TOP_DOWN);
                        break;
                    }
                    case CPU_BOTTOM_UP: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_BOTTOM_UP);
                        break;
                    }
                    case CPU_FLAME_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_FLAME_CHART);
                        break;
                    }
                    case CPU_CALL_CHART: {
                        filterMetadata.setActiveView(FilterMetadata.View.CPU_CALL_CHART);
                        break;
                    }
                    case MEMORY_CALLSTACK: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CALLSTACK);
                        break;
                    }
                    case MEMORY_PACKAGE: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_PACKAGE);
                        break;
                    }
                    case MEMORY_CLASS: {
                        filterMetadata.setActiveView(FilterMetadata.View.MEMORY_CLASS);
                        break;
                    }
                    case NETWORK_CONNECTIONS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_CONNECTIONS);
                        break;
                    }
                    case NETWORK_THREADS: {
                        filterMetadata.setActiveView(FilterMetadata.View.NETWORK_THREADS);
                    }
                }
                profilerEvent.setFilterMetadata(filterMetadata);
            }
        }

        private void populateCpuCaptureMetadata(AndroidProfilerEvent.Builder profilerEvent) {
            if (this.myCpuCaptureMetadata != null) {
                CpuCaptureMetadata.Builder captureMetadata = CpuCaptureMetadata.newBuilder().setCaptureDurationMs(this.myCpuCaptureMetadata.getCaptureDurationMs()).setRecordDurationMs(this.myCpuCaptureMetadata.getRecordDurationMs()).setTraceFileSizeBytes(this.myCpuCaptureMetadata.getTraceFileSizeBytes()).setParsingTimeMs(this.myCpuCaptureMetadata.getParsingTimeMs()).setStoppingTimeMs(this.myCpuCaptureMetadata.getStoppingTimeMs()).setCaptureStatus((CpuCaptureMetadata.CaptureStatus)CPU_CAPTURE_STATUS_MAP.getOrDefault((Object)this.myCpuCaptureMetadata.getStatus(), (Object)CpuCaptureMetadata.CaptureStatus.SUCCESS));
                captureMetadata.setProfilingConfig(Tracker.toStatsCpuProfilingConfig(this.myCpuCaptureMetadata.getProfilingConfiguration()));
                if (this.myCpuCaptureMetadata.getProfilingConfiguration().getTraceType() == Cpu.CpuTraceType.ART) {
                    captureMetadata.setArtStopTimeoutSec(CpuProfilerStage.CPU_ART_STOP_TIMEOUT_SEC);
                }
                profilerEvent.setCpuCaptureMetadata(captureMetadata);
            }
        }

        @NotNull
        private static CpuProfilingConfig toStatsCpuProfilingConfig(@NotNull ProfilingConfiguration config) {
            if (config == null) {
                Tracker.$$$reportNull$$$0(19);
            }
            CpuProfilingConfig.Builder cpuConfigInfo = CpuProfilingConfig.newBuilder().setSampleInterval(config.getProfilingSamplingIntervalUs()).setSizeLimit(config.getProfilingBufferSizeInMb());
            switch (config.getTraceType()) {
                case ART: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ART);
                    break;
                }
                case SIMPLEPERF: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.SIMPLE_PERF);
                    break;
                }
                case ATRACE: {
                    cpuConfigInfo.setType(CpuProfilingConfig.Type.ATRACE);
                    break;
                }
            }
            switch (config.getMode()) {
                case SAMPLED: {
                    cpuConfigInfo.setMode(CpuProfilingConfig.Mode.SAMPLED);
                    break;
                }
                case INSTRUMENTED: {
                    cpuConfigInfo.setMode(CpuProfilingConfig.Mode.INSTRUMENTED);
                    break;
                }
            }
            CpuProfilingConfig cpuProfilingConfig = cpuConfigInfo.build();
            if (cpuProfilingConfig == null) {
                Tracker.$$$reportNull$$$0(20);
            }
            return cpuProfilingConfig;
        }

        @NotNull
        private static EnergyEvent.Type toEnergyType(@NotNull Energy.EnergyEventData energyEvent) {
            if (energyEvent == null) {
                Tracker.$$$reportNull$$$0(21);
            }
            return Tracker.toEnergyType(EnergyDuration.Kind.from((Energy.EnergyEventData)energyEvent));
        }

        @NotNull
        private static EnergyEvent.Type toEnergyType(@NotNull EnergyDuration.Kind energyKind) {
            if (energyKind == null) {
                Tracker.$$$reportNull$$$0(22);
            }
            switch (energyKind) {
                case WAKE_LOCK: {
                    EnergyEvent.Type type = EnergyEvent.Type.WAKE_LOCK;
                    if (type == null) {
                        Tracker.$$$reportNull$$$0(23);
                    }
                    return type;
                }
                case ALARM: {
                    EnergyEvent.Type type = EnergyEvent.Type.ALARM;
                    if (type == null) {
                        Tracker.$$$reportNull$$$0(24);
                    }
                    return type;
                }
                case JOB: {
                    EnergyEvent.Type type = EnergyEvent.Type.JOB;
                    if (type == null) {
                        Tracker.$$$reportNull$$$0(25);
                    }
                    return type;
                }
                case LOCATION: {
                    EnergyEvent.Type type = EnergyEvent.Type.LOCATION;
                    if (type == null) {
                        Tracker.$$$reportNull$$$0(26);
                    }
                    return type;
                }
            }
            EnergyEvent.Type type = EnergyEvent.Type.UNKNOWN_EVENT_TYPE;
            if (type == null) {
                Tracker.$$$reportNull$$$0(27);
            }
            return type;
        }

        @Nullable
        private static EnergyEvent.Subtype toEnergySubtype(@NotNull Energy.EnergyEventData eventData) {
            if (eventData == null) {
                Tracker.$$$reportNull$$$0(28);
            }
            if (eventData.getMetadataCase() == Energy.EnergyEventData.MetadataCase.WAKE_LOCK_ACQUIRED) {
                Energy.WakeLockAcquired wakeLockAcquired = eventData.getWakeLockAcquired();
                switch (wakeLockAcquired.getLevel()) {
                    case PARTIAL_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_PARTIAL;
                    }
                    case SCREEN_DIM_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_SCREEN_DIM;
                    }
                    case SCREEN_BRIGHT_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_SCREEN_BRIGHT;
                    }
                    case FULL_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_FULL;
                    }
                    case PROXIMITY_SCREEN_OFF_WAKE_LOCK: {
                        return EnergyEvent.Subtype.WAKE_LOCK_PROXIMITY_SCREEN_OFF;
                    }
                }
                return EnergyEvent.Subtype.UNKNOWN_EVENT_SUBTYPE;
            }
            if (eventData.getMetadataCase() == Energy.EnergyEventData.MetadataCase.ALARM_SET) {
                Energy.AlarmSet alarmSet = eventData.getAlarmSet();
                switch (alarmSet.getType()) {
                    case RTC: {
                        return EnergyEvent.Subtype.ALARM_RTC;
                    }
                    case RTC_WAKEUP: {
                        return EnergyEvent.Subtype.ALARM_RTC_WAKEUP;
                    }
                    case ELAPSED_REALTIME: {
                        return EnergyEvent.Subtype.ALARM_ELAPSED_REALTIME;
                    }
                    case ELAPSED_REALTIME_WAKEUP: {
                        return EnergyEvent.Subtype.ALARM_ELAPSED_REALTIME_WAKEUP;
                    }
                }
                return EnergyEvent.Subtype.UNKNOWN_EVENT_SUBTYPE;
            }
            return null;
        }

        @NotNull
        private static EnergyEvent.Subevent toEnergySubevent(@NotNull Energy.EnergyEventData eventData) {
            if (eventData == null) {
                Tracker.$$$reportNull$$$0(29);
            }
            switch (eventData.getMetadataCase()) {
                case WAKE_LOCK_ACQUIRED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.WAKE_LOCK_ACQUIRED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(30);
                    }
                    return subevent;
                }
                case WAKE_LOCK_RELEASED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.WAKE_LOCK_RELEASED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(31);
                    }
                    return subevent;
                }
                case ALARM_SET: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.ALARM_SET;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(32);
                    }
                    return subevent;
                }
                case ALARM_CANCELLED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.ALARM_CANCELLED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(33);
                    }
                    return subevent;
                }
                case ALARM_FIRED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.ALARM_FIRED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(34);
                    }
                    return subevent;
                }
                case JOB_SCHEDULED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.JOB_SCHEDULED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(35);
                    }
                    return subevent;
                }
                case JOB_STARTED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.JOB_STARTED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(36);
                    }
                    return subevent;
                }
                case JOB_STOPPED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.JOB_STOPPED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(37);
                    }
                    return subevent;
                }
                case JOB_FINISHED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.JOB_FINISHED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(38);
                    }
                    return subevent;
                }
                case LOCATION_UPDATE_REQUESTED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.LOCATION_UPDATE_REQUESTED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(39);
                    }
                    return subevent;
                }
                case LOCATION_UPDATE_REMOVED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.LOCATION_UPDATE_REMOVED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(40);
                    }
                    return subevent;
                }
                case LOCATION_CHANGED: {
                    EnergyEvent.Subevent subevent = EnergyEvent.Subevent.LOCATION_CHANGED;
                    if (subevent == null) {
                        Tracker.$$$reportNull$$$0(41);
                    }
                    return subevent;
                }
            }
            EnergyEvent.Subevent subevent = EnergyEvent.Subevent.UNKNOWN_ENERGY_SUBEVENT;
            if (subevent == null) {
                Tracker.$$$reportNull$$$0(42);
            }
            return subevent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trackingProject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/profilers/analytics/StudioFeatureTracker$Tracker";
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerEvent";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "energyEvent";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "energyKind";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eventData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/profilers/analytics/StudioFeatureTracker$Tracker";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDevice";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpuCaptureMetadata";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpuImportTraceMetadata";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpuStartupProfilingConfiguration";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCpuApiTracingMetadata";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFilterMetadata";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnergyRangeMetadata";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnergyEventMetadata";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMemoryHeapId";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSessionCreationMetadata";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSessionSelectionMetadata";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTransportFailureMetadata";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMemoryInstanceFilterMetadata";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toStatsCpuProfilingConfig";
                    break;
                }
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toEnergyType";
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toEnergySubevent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "populateEnergyRangeMetadata";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "populateEnergyEventMetadata";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "populateMemoryInstanceFilterMetadata";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "toStatsCpuProfilingConfig";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "toEnergyType";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "toEnergySubtype";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "toEnergySubevent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 20: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

