/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.tools.idea.rendering.GutterIconFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconCache {
    private static final Logger LOG = Logger.getInstance(GutterIconCache.class);
    private static final Icon NONE = AndroidIcons.Android;
    @VisibleForTesting
    static final int MAX_WIDTH = JBUI.scale((int)16);
    @VisibleForTesting
    static final int MAX_HEIGHT = JBUI.scale((int)16);
    private static final GutterIconCache ourInstance = new GutterIconCache();
    private Map<String, Icon> myThumbnailCache = Maps.newHashMap();
    private Map<String, Long> myModificationStampCache = Maps.newHashMap();
    private boolean myRetina;

    @NotNull
    public static GutterIconCache getInstance() {
        GutterIconCache gutterIconCache = ourInstance;
        if (gutterIconCache == null) {
            GutterIconCache.$$$reportNull$$$0(0);
        }
        return gutterIconCache;
    }

    @VisibleForTesting
    boolean isIconUpToDate(@NotNull VirtualFile file) {
        String path2;
        if (file == null) {
            GutterIconCache.$$$reportNull$$$0(1);
        }
        if (this.myModificationStampCache.containsKey(path2 = file.getPath())) {
            return this.myModificationStampCache.get(path2).longValue() == file.getModificationStamp() && !FileDocumentManager.getInstance().isFileModified(file);
        }
        return false;
    }

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file, @Nullable RenderResources resolver, @NotNull AndroidFacet facet2) {
        String path2;
        Icon myIcon;
        boolean isRetina;
        if (file == null) {
            GutterIconCache.$$$reportNull$$$0(2);
        }
        if (facet2 == null) {
            GutterIconCache.$$$reportNull$$$0(3);
        }
        if (this.myRetina != (isRetina = UIUtil.isRetina())) {
            this.myRetina = isRetina;
            this.myThumbnailCache.clear();
        }
        if ((myIcon = this.myThumbnailCache.get(path2 = file.getPath())) == null || !this.isIconUpToDate(file)) {
            myIcon = GutterIconFactory.createIcon(file, resolver, MAX_WIDTH, MAX_HEIGHT, facet2);
            if (myIcon == null) {
                myIcon = NONE;
            }
            this.myThumbnailCache.put(path2, myIcon);
            this.myModificationStampCache.put(path2, file.getModificationStamp());
        }
        return myIcon != NONE ? myIcon : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/GutterIconCache";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/GutterIconCache";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIconUpToDate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

