/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.google.common.collect.ImmutableCollection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.uipreview.ModuleClassLoaderManager;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class RefreshRenderAction
extends AnAction {
    private final EditorDesignSurface mySurface;

    public RefreshRenderAction(EditorDesignSurface surface2) {
        super(AndroidBundle.message("android.layout.preview.refresh.action.text", new Object[0]), null, null);
        this.mySurface = surface2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshRenderAction.$$$reportNull$$$0(0);
        }
        RefreshRenderAction.clearCacheAndRefreshSurface(this.mySurface);
    }

    @NotNull
    public static CompletableFuture<Void> clearCacheAndRefreshSurface(@NotNull EditorDesignSurface surface2) {
        if (surface2 == null) {
            RefreshRenderAction.$$$reportNull$$$0(1);
        }
        RefreshRenderAction.clearCache(surface2.getConfigurations());
        CompletableFuture<Void> completableFuture = surface2.forceUserRequestedRefresh();
        if (completableFuture == null) {
            RefreshRenderAction.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    public static void clearCache(@NotNull ImmutableCollection<Configuration> configurations) {
        if (configurations == null) {
            RefreshRenderAction.$$$reportNull$$$0(3);
        }
        ModuleClassLoaderManager.get().clearCache();
        configurations.stream().forEach(configuration -> {
            IAndroidTarget target = configuration.getTarget();
            Module module = configuration.getModule();
            if (module != null) {
                AndroidTargetData targetData;
                ResourceIdManager.get(module).resetDynamicIds();
                if (target != null && (targetData = AndroidTargetData.getTargetData(target, module)) != null) {
                    targetData.clearAllCaches(module);
                }
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
                Stream.concat(AndroidUtils.getAllAndroidDependencies(module, true).stream(), Stream.of(facet2)).filter(Objects::nonNull).forEach(f -> ResourceRepositoryManager.getInstance(f).resetAllCaches());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RefreshRenderAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RefreshRenderAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clearCacheAndRefreshSurface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clearCacheAndRefreshSurface";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

