/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.intellij.ProjectTopics;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceFolderRegistry
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> myNamespacedCache;
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> myNonNamespacedCache;
    @NotNull
    private final ImmutableList<Cache<VirtualFile, ResourceFolderRepository>> myCaches;

    public ResourceFolderRegistry(@NotNull Project project) {
        if (project == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(0);
        }
        this.myNamespacedCache = ResourceFolderRegistry.buildCache();
        this.myNonNamespacedCache = ResourceFolderRegistry.buildCache();
        this.myCaches = ImmutableList.of(this.myNamespacedCache, this.myNonNamespacedCache);
        this.myProject = project;
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ResourceFolderRegistry.this.removeStaleEntries();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/res/ResourceFolderRegistry$1", "rootsChanged"));
            }
        });
    }

    @NotNull
    private static Cache<VirtualFile, ResourceFolderRepository> buildCache() {
        Cache cache = CacheBuilder.newBuilder().build();
        if (cache == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(1);
        }
        return cache;
    }

    @NotNull
    public static ResourceFolderRegistry getInstance(@NotNull Project project) {
        if (project == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(2);
        }
        ResourceFolderRegistry resourceFolderRegistry = (ResourceFolderRegistry)ServiceManager.getService((Project)project, ResourceFolderRegistry.class);
        if (resourceFolderRegistry == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(3);
        }
        return resourceFolderRegistry;
    }

    @NotNull
    public ResourceFolderRepository get(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir) {
        if (facet2 == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(4);
        }
        if (dir == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(5);
        }
        ResourceFolderRepository resourceFolderRepository = (ResourceFolderRepository)ReadAction.compute(() -> this.get(facet2, dir, ResourceRepositoryManager.getInstance(facet2).getNamespace()));
        if (resourceFolderRepository == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(6);
        }
        return resourceFolderRepository;
    }

    @VisibleForTesting
    @NotNull
    ResourceFolderRepository get(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        if (facet2 == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(8);
        }
        if (namespace == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(9);
        }
        Cache<VirtualFile, ResourceFolderRepository> cache = namespace == ResourceNamespace.RES_AUTO ? this.myNonNamespacedCache : this.myNamespacedCache;
        ResourceFolderRepository repository = (ResourceFolderRepository)CacheUtils.getAndUnwrap(cache, (Object)dir, () -> ResourceFolderRegistry.createRepository(facet2, dir, namespace));
        assert (repository.getNamespace().equals((Object)namespace));
        ResourceFolderRepository resourceFolderRepository = repository;
        if (resourceFolderRepository == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(10);
        }
        return resourceFolderRepository;
    }

    @NotNull
    private static ResourceFolderRepository createRepository(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        if (facet2 == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(11);
        }
        if (dir == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(12);
        }
        if (namespace == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(13);
        }
        ResourceFolderRepositoryCachingData cachingData = ResourceFolderRepositoryFileCacheService.get().getCachingData(facet2.getModule().getProject(), dir, AndroidIoManager.getInstance().getBackgroundDiskIoExecutor());
        ResourceFolderRepository resourceFolderRepository = ResourceFolderRepository.create(facet2, dir, namespace, cachingData);
        if (resourceFolderRepository == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(14);
        }
        return resourceFolderRepository;
    }

    @Nullable
    public CachedRepositories getCached(@NotNull VirtualFile directory) {
        if (directory == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(15);
        }
        ResourceFolderRepository namespaced = (ResourceFolderRepository)this.myNamespacedCache.getIfPresent((Object)directory);
        ResourceFolderRepository nonNamespaced = (ResourceFolderRepository)this.myNonNamespacedCache.getIfPresent((Object)directory);
        return namespaced == null && nonNamespaced == null ? null : new CachedRepositories(namespaced, nonNamespaced);
    }

    public void reset() {
        this.myNamespacedCache.invalidateAll();
        this.myNonNamespacedCache.invalidateAll();
    }

    private void removeStaleEntries() {
        this.myNamespacedCache.asMap().keySet().removeIf(dir -> this.isStale((VirtualFile)dir));
        this.myNonNamespacedCache.asMap().keySet().removeIf(dir -> this.isStale((VirtualFile)dir));
    }

    private boolean isStale(@NotNull VirtualFile dir) {
        AndroidFacet facet2;
        if (dir == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(16);
        }
        if ((facet2 = AndroidFacet.getInstance((VirtualFile)dir, (Project)this.myProject)) == null) {
            return true;
        }
        ResourceFolderManager folderManager = ResourceFolderManager.getInstance(facet2);
        return !folderManager.getFolders().contains(dir) && !folderManager.getTestFolders().contains(dir);
    }

    public void dispose() {
        this.reset();
    }

    void dispatchToRepositories(@NotNull VirtualFile file, @NotNull BiConsumer<ResourceFolderRepository, VirtualFile> handler) {
        VirtualFile dir;
        if (file == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(17);
        }
        if (handler == null) {
            ResourceFolderRegistry.$$$reportNull$$$0(18);
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        while (dir != null) {
            for (Cache cache : this.myCaches) {
                ResourceFolderRepository repository = (ResourceFolderRepository)cache.getIfPresent((Object)dir);
                if (repository == null) continue;
                handler.accept(repository, file);
            }
            dir = dir.getParent();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ResourceFolderRegistry";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRegistry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRepository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRepository";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCached";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isStale";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "dispatchToRepositories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class CachedRepositories {
        @Nullable
        public final ResourceFolderRepository namespaced;
        @Nullable
        public final ResourceFolderRepository nonNamespaced;

        public CachedRepositories(@Nullable ResourceFolderRepository namespaced, @Nullable ResourceFolderRepository nonNamespaced) {
            this.namespaced = namespaced;
            this.nonNamespaced = nonNamespaced;
        }
    }

    public static class PopulateCachesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        public PopulateCachesTask(@NotNull Project project) {
            if (project == null) {
                PopulateCachesTask.$$$reportNull$$$0(0);
            }
            super((Object)project);
            this.myProject = project;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            List facets;
            if (indicator == null) {
                PopulateCachesTask.$$$reportNull$$$0(1);
            }
            if ((facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID)).isEmpty()) {
                return;
            }
            indicator.setText("Indexing resources");
            indicator.setIndeterminate(false);
            Map<VirtualFile, AndroidFacet> resDirectories = AndroidResourceUtil.getResourceDirectoriesForFacets(facets);
            if (resDirectories.isEmpty()) {
                return;
            }
            try {
                ResourceFolderRepositoryFileCacheService.get().createDirForProject(this.myProject);
            }
            catch (IOException e) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            assert (!application.isWriteAccessAllowed());
            int numDone = 0;
            ExecutorService parallelExecutor = AndroidIoManager.getInstance().getBackgroundDiskIoExecutor();
            ArrayList<Future<ResourceFolderRepository>> repositoryJobs = new ArrayList<Future<ResourceFolderRepository>>();
            for (Map.Entry<VirtualFile, AndroidFacet> entry : resDirectories.entrySet()) {
                AndroidFacet facet2 = entry.getValue();
                VirtualFile dir = entry.getKey();
                ResourceFolderRegistry registry = ResourceFolderRegistry.getInstance(this.myProject);
                repositoryJobs.add(parallelExecutor.submit(() -> registry.get(facet2, dir)));
            }
            for (Future future2 : repositoryJobs) {
                if (indicator.isCanceled()) break;
                indicator.setFraction((double)numDone / (double)resDirectories.size());
                try {
                    future2.get();
                }
                catch (ExecutionException facet2) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++numDone;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/res/ResourceFolderRegistry$PopulateCachesTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

