/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resources.base;

import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.Arity;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.tools.idea.resources.base.Base128InputStream;
import com.android.tools.idea.resources.base.Base128OutputStream;
import com.android.tools.idea.resources.base.BasicValueResourceItemBase;
import com.android.tools.idea.resources.base.ResourceSourceFile;
import com.intellij.util.ArrayUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicPluralsResourceItem
extends BasicValueResourceItemBase
implements PluralsResourceValue {
    @NotNull
    private final Arity[] myArities;
    @NotNull
    private final String[] myValues;
    private final int myDefaultIndex;

    public BasicPluralsResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull Map<Arity, String> quantityValues, @Nullable Arity defaultArity) {
        if (name == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(0);
        }
        if (sourceFile == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(1);
        }
        if (visibility == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(2);
        }
        if (quantityValues == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(3);
        }
        this(name, sourceFile, visibility, quantityValues.keySet().toArray(Arity.EMPTY_ARRAY), quantityValues.values().toArray(ArrayUtil.EMPTY_STRING_ARRAY), BasicPluralsResourceItem.getIndex(defaultArity, quantityValues.keySet()));
    }

    private BasicPluralsResourceItem(@NotNull String name, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceVisibility visibility, @NotNull Arity[] arities, @NotNull String[] values, int defaultIndex) {
        if (name == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(4);
        }
        if (sourceFile == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(5);
        }
        if (visibility == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(6);
        }
        if (arities == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(7);
        }
        if (values == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(8);
        }
        super(ResourceType.PLURALS, name, sourceFile, visibility);
        assert (arities.length == values.length);
        this.myArities = arities;
        this.myValues = values;
        assert (values.length == 0 || defaultIndex < values.length);
        this.myDefaultIndex = defaultIndex;
    }

    private static int getIndex(@Nullable Arity arity, @NotNull Collection<Arity> arities) {
        if (arities == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(9);
        }
        if (arity == null || arities.isEmpty()) {
            return 0;
        }
        int index = 0;
        for (Arity ar : arities) {
            if (ar == arity) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException();
    }

    public int getPluralsCount() {
        return this.myArities.length;
    }

    @NotNull
    public String getQuantity(int index) {
        String string = this.myArities[index].getName();
        if (string == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getValue(int index) {
        String string = this.myValues[index];
        if (string == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public String getValue(@NotNull String quantity) {
        if (quantity == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(12);
        }
        int n = this.myArities.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (!quantity.equals(this.myArities[i2].getName())) continue;
            return this.myValues[i2];
        }
        return null;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.myValues.length == 0 ? null : this.myValues[this.myDefaultIndex];
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicPluralsResourceItem other = (BasicPluralsResourceItem)obj;
        return Arrays.equals(this.myArities, other.myArities) && Arrays.equals(this.myValues, other.myValues);
    }

    @Override
    public void serialize(@NotNull Base128OutputStream stream, @NotNull Object2IntMap<String> configIndexes, @NotNull Object2IntMap<ResourceSourceFile> sourceFileIndexes, @NotNull Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        if (stream == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(13);
        }
        if (configIndexes == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(14);
        }
        if (sourceFileIndexes == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(15);
        }
        if (namespaceResolverIndexes == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(16);
        }
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        int n = this.myArities.length;
        stream.writeInt(n);
        for (int i2 = 0; i2 < n; ++i2) {
            stream.writeInt(this.myArities[i2].ordinal());
            stream.writeString(this.myValues[i2]);
        }
        stream.writeInt(this.myDefaultIndex);
    }

    @NotNull
    static BasicPluralsResourceItem deserialize(@NotNull Base128InputStream stream, @NotNull String name, @NotNull ResourceVisibility visibility, @NotNull ResourceSourceFile sourceFile, @NotNull ResourceNamespace.Resolver resolver) throws IOException {
        int n;
        if (stream == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(17);
        }
        if (name == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(18);
        }
        if (visibility == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(19);
        }
        if (sourceFile == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(20);
        }
        if (resolver == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(21);
        }
        Arity[] arities = (n = stream.readInt()) == 0 ? Arity.EMPTY_ARRAY : new Arity[n];
        String[] values = n == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : new String[n];
        for (int i2 = 0; i2 < n; ++i2) {
            arities[i2] = Arity.values()[stream.readInt()];
            values[i2] = stream.readString();
        }
        int defaultIndex = stream.readInt();
        if (values.length != 0 && defaultIndex >= values.length) {
            throw Base128InputStream.StreamFormatException.invalidFormat();
        }
        BasicPluralsResourceItem item = new BasicPluralsResourceItem(name, sourceFile, visibility, arities, values, defaultIndex);
        item.setNamespaceResolver(resolver);
        BasicPluralsResourceItem basicPluralsResourceItem = item;
        if (basicPluralsResourceItem == null) {
            BasicPluralsResourceItem.$$$reportNull$$$0(22);
        }
        return basicPluralsResourceItem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 2: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quantityValues";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arities";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 10: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/resources/base/BasicPluralsResourceItem";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quantity";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configIndexes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileIndexes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceResolverIndexes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/resources/base/BasicPluralsResourceItem";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuantity";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "deserialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 10: 
            case 11: 
            case 22: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

