/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.android.tools.idea.room.migrations.generators.GeneratorsUtil;
import com.android.tools.idea.room.migrations.generators.MigrationClassGenerator;
import com.android.tools.idea.room.migrations.generators.SqlStatementsGenerator;
import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class JavaMigrationClassGenerator
implements MigrationClassGenerator<PsiClass> {
    private static final String NOT_NULL_ANNOTATION = "androidx.annotation.NonNull";
    private static final String OVERRIDE_ANNOTATION = "java.lang.Override";
    private static final String SUPER_CONSTRUCTOR_CALL_TEMPLATE = "super(%d, %d);";
    private static final String DATABASE_UPDATE_STATEMENT_TEMPLATE = "database.execSQL(\"%s\");";
    private JavaPsiFacade myJavaPsiFacade;
    private PsiElementFactory myPsiElementFactory;
    private Project myProject;

    public JavaMigrationClassGenerator(@NotNull Project project) {
        if (project == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myJavaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        this.myPsiElementFactory = this.myJavaPsiFacade.getElementFactory();
    }

    @Override
    @NotNull
    public PsiClass createMigrationClass(@NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, @NotNull DatabaseUpdate databaseUpdate) {
        if (targetPackage == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(1);
        }
        if (targetDirectory == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(2);
        }
        if (databaseUpdate == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(3);
        }
        String migrationClassName = MigrationClassGenerator.getMigrationClassName(databaseUpdate.getPreviousVersion(), databaseUpdate.getCurrentVersion());
        PsiClass migrationClass = JavaDirectoryService.getInstance().createClass(targetDirectory, migrationClassName);
        GeneratorsUtil.makePublic(migrationClass);
        this.addSuperClass(migrationClass);
        this.addMigrationConstructor(migrationClass, databaseUpdate);
        this.addMigrationMethod(migrationClass, databaseUpdate);
        JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)migrationClass);
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)migrationClass);
        migrationClass.navigate(true);
        PsiClass psiClass = migrationClass;
        if (psiClass == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(4);
        }
        return psiClass;
    }

    private void addSuperClass(@NotNull PsiClass migrationClass) {
        if (migrationClass == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(5);
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        PsiReferenceList extendsList = migrationClass.getExtendsList();
        assert (extendsList != null);
        PsiJavaCodeReferenceElement superClassRef = this.myPsiElementFactory.createFQClassNameReferenceElement("androidx.room.migration.Migration", scope);
        extendsList.add((PsiElement)superClassRef);
    }

    private void addMigrationMethod(@NotNull PsiClass migrationClass, @NotNull DatabaseUpdate databaseUpdate) {
        if (migrationClass == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(6);
        }
        if (databaseUpdate == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(7);
        }
        PsiMethod migrationMethod = this.myPsiElementFactory.createMethod("migrate", (PsiType)PsiType.VOID);
        migrationMethod.getModifierList().addAnnotation(OVERRIDE_ANNOTATION);
        PsiClassType parameterType = this.myPsiElementFactory.createTypeByFQClassName("androidx.sqlite.db.SupportSQLiteDatabase", migrationClass.getResolveScope());
        PsiParameter parameter = this.myPsiElementFactory.createParameter("database", (PsiType)parameterType);
        assert (parameter.getModifierList() != null);
        if (this.myJavaPsiFacade.findClass(NOT_NULL_ANNOTATION, migrationClass.getResolveScope()) != null) {
            parameter.getModifierList().addAnnotation(NOT_NULL_ANNOTATION);
        }
        migrationMethod.getParameterList().add((PsiElement)parameter);
        List<String> sqlUpdateStatements = SqlStatementsGenerator.getMigrationStatements(databaseUpdate);
        for (String sqlStatement : sqlUpdateStatements) {
            this.addMigrationStatement(migrationMethod, sqlStatement);
        }
        migrationClass.add((PsiElement)migrationMethod);
    }

    private void addMigrationStatement(@NotNull PsiMethod migrationMethod, @NotNull String sqlStatement) {
        if (migrationMethod == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(8);
        }
        if (sqlStatement == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(9);
        }
        PsiStatement migrationStatement = this.myPsiElementFactory.createStatementFromText(MigrationClassGenerator.trimSqlStatement(String.format(DATABASE_UPDATE_STATEMENT_TEMPLATE, sqlStatement)), null);
        PsiCodeBlock methodBody = migrationMethod.getBody();
        assert (methodBody != null);
        methodBody.addAfter((PsiElement)migrationStatement, methodBody.getLastBodyElement());
    }

    private void addMigrationConstructor(@NotNull PsiClass migrationClass, @NotNull DatabaseUpdate databaseUpdate) {
        if (migrationClass == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(10);
        }
        if (databaseUpdate == null) {
            JavaMigrationClassGenerator.$$$reportNull$$$0(11);
        }
        PsiMethod migrationConstructor = this.myPsiElementFactory.createConstructor();
        assert (migrationConstructor.getBody() != null);
        migrationConstructor.getBody().add((PsiElement)this.myPsiElementFactory.createStatementFromText(String.format(Locale.US, SUPER_CONSTRUCTOR_CALL_TEMPLATE, databaseUpdate.getPreviousVersion(), databaseUpdate.getCurrentVersion()), null));
        migrationClass.add((PsiElement)migrationConstructor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseUpdate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/room/migrations/generators/JavaMigrationClassGenerator";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationMethod";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/room/migrations/generators/JavaMigrationClassGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createMigrationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMigrationClass";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addSuperClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMigrationMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addMigrationStatement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addMigrationConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

