/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.android.tools.idea.room.migrations.generators.MigrationTestGenerator;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.ImportPath;

public class KotlinMigrationTestGenerator
implements MigrationTestGenerator {
    private static final String MIGRATION_FILE_NAME_TEMPLATE = "%s.kt";
    private static final String MIGRATION_TEST_CLASS_TEMPLATE = "class %s {}";
    private static final String MIGRATION_TEST_FUNCTION_TEMPLATE = " fun %s() {}";
    private Project project;
    private KtPsiFactory ktPsiFactory;

    public KotlinMigrationTestGenerator(@NotNull Project project) {
        if (project == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.ktPsiFactory = new KtPsiFactory(project);
    }

    @Override
    public void createMigrationTest(@NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, @NotNull String databaseClassFullyQualifiedName, @NotNull String migrationClassFullyQualifiedName, int migrationStartVersion, int migrationEndVersion) {
        if (targetPackage == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(1);
        }
        if (targetDirectory == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(2);
        }
        if (databaseClassFullyQualifiedName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(3);
        }
        if (migrationClassFullyQualifiedName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(4);
        }
        String migrationClassName = MigrationTestGenerator.getMigrationTestName(migrationStartVersion, migrationEndVersion);
        KtClass ktMigrationTest = this.ktPsiFactory.createClass(String.format(MIGRATION_TEST_CLASS_TEMPLATE, migrationClassName));
        KtAnnotationEntry runnerAnnotation = this.ktPsiFactory.createAnnotationEntry(KotlinMigrationTestGenerator.getAnnotationWithParameter("org.junit.runner.RunWith", MigrationTestGenerator.selectRunnerClass(JavaPsiFacade.getInstance((Project)this.project), ktMigrationTest.getResolveScope())));
        ktMigrationTest.addAnnotationEntry(runnerAnnotation);
        this.addTestDatabaseNameField(ktMigrationTest, StringUtil.getShortName((String)databaseClassFullyQualifiedName));
        this.addMigrationTestHelperField(ktMigrationTest, databaseClassFullyQualifiedName);
        this.addMigrationTestFunction(ktMigrationTest, StringUtil.getShortName((String)databaseClassFullyQualifiedName), migrationClassFullyQualifiedName, migrationStartVersion, migrationEndVersion);
        this.prepareKotlinFile(targetPackage, targetDirectory, ktMigrationTest);
    }

    private void prepareKotlinFile(@NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, @NotNull KtClass ktMigrationTest) {
        if (targetPackage == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(5);
        }
        if (targetDirectory == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(6);
        }
        if (ktMigrationTest == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(7);
        }
        PsiFile ktMigrationTestFile = PsiFileFactory.getInstance((Project)this.project).createFileFromText(String.format(MIGRATION_FILE_NAME_TEMPLATE, ktMigrationTest.getName()), (Language)KotlinLanguage.INSTANCE, (CharSequence)"");
        KtPackageDirective packageDirective = this.ktPsiFactory.createPackageDirectiveIfNeeded(new FqName(targetPackage.getQualifiedName()));
        if (packageDirective != null) {
            ktMigrationTestFile.add((PsiElement)packageDirective);
            ktMigrationTestFile.add(this.ktPsiFactory.createNewLine());
        }
        this.addIncludeDirective(ktMigrationTestFile, new FqName("androidx.room.testing.MigrationTestHelper"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("androidx.test.platform.app.InstrumentationRegistry"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName(MigrationTestGenerator.selectRunnerClass(JavaPsiFacade.getInstance((Project)this.project), ktMigrationTestFile.getResolveScope())));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("java.io.IOException"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("org.junit.Assert"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("org.junit.runner.RunWith"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("org.junit.Rule"));
        this.addIncludeDirective(ktMigrationTestFile, new FqName("org.junit.Test"));
        ktMigrationTestFile.add(this.ktPsiFactory.createNewLine());
        ktMigrationTestFile.add((PsiElement)ktMigrationTest);
        PsiElement element = targetDirectory.add((PsiElement)ktMigrationTestFile);
        CodeStyleManager.getInstance((Project)this.project).reformat(element);
        if (element instanceof PsiFile) {
            ((PsiFile)element).navigate(true);
        }
    }

    private void addIncludeDirective(@NotNull PsiFile ktMigrationFile, @NotNull FqName qualifiedName) {
        if (ktMigrationFile == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(8);
        }
        if (qualifiedName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(9);
        }
        KtImportDirective importDirective = this.ktPsiFactory.createImportDirective(new ImportPath(qualifiedName, false, null));
        ktMigrationFile.add((PsiElement)importDirective);
        ktMigrationFile.add(this.ktPsiFactory.createNewLine());
    }

    private void addTestDatabaseNameField(@NotNull KtClass ktMigrationTest, @NotNull String databaseName) {
        if (ktMigrationTest == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(10);
        }
        if (databaseName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(11);
        }
        KtDeclaration testDatabaseNameFieldDeclaration = this.ktPsiFactory.createDeclaration(String.format("private val %s = %s", MigrationTestGenerator.getTestDatabaseFieldName(databaseName), MigrationTestGenerator.getTestDatabaseName(databaseName)));
        KotlinMigrationTestGenerator.addElementToTestClass((PsiElement)testDatabaseNameFieldDeclaration, ktMigrationTest);
        KotlinMigrationTestGenerator.addElementToTestClass(this.ktPsiFactory.createNewLine(), ktMigrationTest);
        KotlinMigrationTestGenerator.addElementToTestClass(this.ktPsiFactory.createNewLine(), ktMigrationTest);
    }

    private void addMigrationTestHelperField(@NotNull KtClass ktMigrationTest, @NotNull String databaseClassQualifiedName) {
        if (ktMigrationTest == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(12);
        }
        if (databaseClassQualifiedName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(13);
        }
        KtDeclaration migrationTestHelperFieldDeclaration = this.ktPsiFactory.createDeclaration(MigrationTestGenerator.getHelperInitializationExpression(MigrationTestGenerator.CodeType.KOTLIN_CODE, databaseClassQualifiedName));
        KtAnnotationEntry ruleAnnotation = this.ktPsiFactory.createAnnotationEntry(KotlinMigrationTestGenerator.getAnnotationName("org.junit.Rule"));
        ruleAnnotation = migrationTestHelperFieldDeclaration.addAnnotationEntry(ruleAnnotation);
        ruleAnnotation.add(this.ktPsiFactory.createNewLine());
        KotlinMigrationTestGenerator.addElementToTestClass((PsiElement)migrationTestHelperFieldDeclaration, ktMigrationTest);
        KotlinMigrationTestGenerator.addElementToTestClass(this.ktPsiFactory.createNewLine(), ktMigrationTest);
        KotlinMigrationTestGenerator.addElementToTestClass(this.ktPsiFactory.createNewLine(), ktMigrationTest);
    }

    private void addMigrationTestFunction(@NotNull KtClass ktMigrationTest, @NotNull String databaseName, @NotNull String migrationQualifiedName, int startVersion, int endVersion) {
        if (ktMigrationTest == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(14);
        }
        if (databaseName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(15);
        }
        if (migrationQualifiedName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(16);
        }
        String testMethodName = MigrationTestGenerator.getMigrationTestMethodName(startVersion, endVersion);
        KtNamedFunction ktMigrationFunction = this.ktPsiFactory.createFunction(String.format(MIGRATION_TEST_FUNCTION_TEMPLATE, testMethodName));
        KtAnnotationEntry testAnnotation = this.ktPsiFactory.createAnnotationEntry(KotlinMigrationTestGenerator.getAnnotationName("org.junit.Test"));
        KtAnnotationEntry throwsAnnotation = this.ktPsiFactory.createAnnotationEntry(KotlinMigrationTestGenerator.getAnnotationWithParameter("Throws", "java.io.IOException"));
        ktMigrationFunction.addAnnotationEntry(throwsAnnotation);
        ktMigrationFunction.addAnnotationEntry(testAnnotation);
        this.addExpressionToMethod((KtExpression)this.ktPsiFactory.createDeclaration(MigrationTestGenerator.getCreateDatabaseStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE, databaseName, startVersion)), this.ktPsiFactory.createComment(MigrationTestGenerator.getCreateDatabaseComment(startVersion)), (KtFunction)ktMigrationFunction);
        this.addExpressionToMethod(this.ktPsiFactory.createExpression(MigrationTestGenerator.getExecSqlStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE)), this.ktPsiFactory.createComment("// TODO: Insert data in the test database using SQL queries."), (KtFunction)ktMigrationFunction);
        this.addExpressionToMethod(this.ktPsiFactory.createExpression(MigrationTestGenerator.getCloseStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE)), this.ktPsiFactory.createComment("// Prepare for the next version."), (KtFunction)ktMigrationFunction);
        this.addExpressionToMethod(this.ktPsiFactory.createExpression(MigrationTestGenerator.getRunAndValidateMigrationStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE, databaseName, migrationQualifiedName, endVersion)), this.ktPsiFactory.createComment(MigrationTestGenerator.getRunAndValidateMigrationComment(StringUtil.getShortName((String)migrationQualifiedName), endVersion)), (KtFunction)ktMigrationFunction);
        this.addExpressionToMethod(this.ktPsiFactory.createExpression(MigrationTestGenerator.getAssertStatement(MigrationTestGenerator.CodeType.KOTLIN_CODE)), this.ktPsiFactory.createComment("// MigrationTestHelper automatically verifies the schema changes, but you need to validate that the data was migrated properly."), (KtFunction)ktMigrationFunction);
        KotlinMigrationTestGenerator.addElementToTestClass((PsiElement)ktMigrationFunction, ktMigrationTest);
    }

    private void addExpressionToMethod(@NotNull KtExpression expression, @NotNull PsiComment comment, @NotNull KtFunction ktMigrationTestFunction) {
        if (expression == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(17);
        }
        if (comment == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(18);
        }
        if (ktMigrationTestFunction == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(19);
        }
        KtBlockExpression functionBody = ktMigrationTestFunction.getBodyBlockExpression();
        assert (functionBody != null);
        functionBody.addBefore(this.ktPsiFactory.createNewLine(), functionBody.getRBrace());
        functionBody.addBefore((PsiElement)comment, functionBody.getRBrace());
        functionBody.addBefore(this.ktPsiFactory.createNewLine(), functionBody.getRBrace());
        functionBody.addBefore((PsiElement)expression, functionBody.getRBrace());
    }

    private static void addElementToTestClass(@NotNull PsiElement psiElement, @NotNull KtClass ktMigrationTest) {
        if (psiElement == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(20);
        }
        if (ktMigrationTest == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(21);
        }
        KtClassBody ktMigrationClassBody = ktMigrationTest.getBody();
        assert (ktMigrationClassBody != null);
        ktMigrationClassBody.addBefore(psiElement, ktMigrationClassBody.getRBrace());
    }

    private static String getAnnotationName(@NotNull String annotationQualifiedName) {
        if (annotationQualifiedName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(22);
        }
        return String.format("@%s", StringUtil.getShortName((String)annotationQualifiedName));
    }

    private static String getAnnotationWithParameter(@NotNull String annotationQualifiedName, @NotNull String qualifiedParameterName) {
        if (annotationQualifiedName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(23);
        }
        if (qualifiedParameterName == null) {
            KotlinMigrationTestGenerator.$$$reportNull$$$0(24);
        }
        return String.format("@%s(%s::class)", StringUtil.getShortName((String)annotationQualifiedName), StringUtil.getShortName((String)qualifiedParameterName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackage";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseClassFullyQualifiedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationClassFullyQualifiedName";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktMigrationTest";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktMigrationFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseClassQualifiedName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationQualifiedName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktMigrationTestFunction";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationQualifiedName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedParameterName";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/room/migrations/generators/KotlinMigrationTestGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createMigrationTest";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareKotlinFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addIncludeDirective";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addTestDatabaseNameField";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addMigrationTestHelperField";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addMigrationTestFunction";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addExpressionToMethod";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "addElementToTestClass";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotationName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnnotationWithParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

