/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidLaunchTasksProvider;
import com.android.tools.idea.run.AndroidRunState;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.GradleApkProvider;
import com.android.tools.idea.run.GradleApplicationIdProvider;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.LaunchOptionsProvider;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.NonGradleApplicationIdProvider;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.ValidationUtil;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.stats.RunStatsService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>
implements PreferGradleMake {
    private static final String GRADLE_SYNC_FAILED_ERR_MSG = "Gradle project sync failed. Please fix your project and try again.";
    private static final String PROFILERS_ELEMENT_NAME = "Profilers";
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = false;
    public boolean SKIP_NOOP_APK_INSTALLATIONS = true;
    public boolean FORCE_STOP_RUNNING_APP = true;
    private final ProfilerState myProfilerState;
    private final boolean myAndroidTests;
    private final DeployTargetContext myDeployTargetContext = new DeployTargetContext();
    private final AndroidDebuggerContext myAndroidDebuggerContext = new AndroidDebuggerContext("Java");
    @Transient
    @NotNull
    protected final transient DefaultPostBuildModelProvider myOutputProvider = new DefaultPostBuildModelProvider();

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory, boolean androidTests) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
        this.myProfilerState = new ProfilerState();
        this.myAndroidTests = androidTests;
        if (((Boolean)StudioFlags.MULTIDEVICE_INSTRUMENTATION_TESTS.get()).booleanValue()) {
            this.getOptions().setAllowRunningInParallel(true);
        } else {
            this.getOptions().setAllowRunningInParallel(!androidTests);
        }
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors = this.validate(null);
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        switch (topError.getSeverity()) {
            case FATAL: {
                throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
            }
            case WARNING: {
                throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
            }
        }
    }

    public List<ValidationError> validate(@Nullable Executor executor) {
        AndroidFacet facet2;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors.add(ValidationError.fromException(e));
        }
        Module module = configurationModule.getModule();
        if (module == null) {
            return errors;
        }
        Project project = module.getProject();
        if (AndroidProjectInfo.getInstance(project).requiredAndroidModelMissing()) {
            errors.add(ValidationError.fatal(GRADLE_SYNC_FAILED_ERR_MSG));
        }
        if ((facet2 = AndroidFacet.getInstance((Module)module)) == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("no.facet.error", module.getName())));
        }
        switch (((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType()) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                Pair<Boolean, String> result2 = this.supportsRunningLibraryProjects(facet2);
                if (((Boolean)result2.getFirst()).booleanValue()) break;
                errors.add(ValidationError.fatal((String)result2.getSecond()));
                break;
            }
            default: {
                errors.add(ValidationError.fatal(AndroidBundle.message("run.error.apk.not.valid", new Object[0])));
                return errors;
            }
        }
        if (AndroidPlatform.getInstance(facet2.getModule()) == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("select.platform.error", new Object[0])));
        }
        if (Manifest.getMainManifest(facet2) == null && ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() != 4) {
            errors.add(ValidationError.fatal(AndroidBundle.message("android.manifest.not.found.error", new Object[0])));
        }
        errors.addAll(this.getDeployTargetContext().getCurrentDeployTargetState().validate(facet2));
        errors.addAll(this.getApkProvider(facet2, this.getApplicationIdProvider(facet2), new ArrayList<AndroidDevice>()).validate());
        errors.addAll(this.checkConfiguration(facet2));
        Object androidDebuggerState = this.myAndroidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            errors.addAll(((AndroidDebuggerState)androidDebuggerState).validate(facet2, executor));
        }
        errors.addAll(this.myProfilerState.validate());
        return errors;
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet var1);

    @NotNull
    protected abstract List<ValidationError> checkConfiguration(@NotNull AndroidFacet var1);

    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        LaunchOptions.Builder builder2 = LaunchOptions.builder().setClearLogcatBeforeStart(this.CLEAR_LOGCAT).setSkipNoopApkInstallations(this.SKIP_NOOP_APK_INSTALLATIONS).setForceStopRunningApp(this.FORCE_STOP_RUNNING_APP);
        if (builder2 == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(0);
        }
        return builder2;
    }

    public Collection<Module> getValidModules() {
        Module[] modules;
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (AndroidFacet.getInstance((Module)module) == null) continue;
            result2.add(module);
        }
        return result2;
    }

    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        List<DeployTargetProvider> list = this.getDeployTargetContext().getApplicableDeployTargetProviders(this.myAndroidTests);
        if (list == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(1);
        }
        return list;
    }

    protected void validateBeforeRun(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(2);
        }
        List<ValidationError> errors = this.validate(executor);
        ValidationUtil.promptAndQuickFixErrors(this.getProject(), errors);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(3);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(4);
        }
        RunStats stats = RunStatsService.get(this.getProject()).create();
        try {
            stats.start();
            RunProfileState state = this.doGetState(executor, env, stats);
            stats.markStateCreated();
            return state;
        }
        catch (Throwable t) {
            stats.abort();
            throw t;
        }
    }

    @Nullable
    public RunProfileState doGetState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull RunStats stats) throws ExecutionException {
        String error;
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(5);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(6);
        }
        if (stats == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(7);
        }
        this.validateBeforeRun(executor);
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module != null) : "Enforced by fatal validation check in checkConfiguration.";
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        assert (facet2 != null) : "Enforced by fatal validation check in checkConfiguration.";
        stats.setDebuggable(LaunchUtils.canDebugApp(facet2));
        stats.setExecutor(executor.getId());
        this.updateExtraRunStats(stats);
        boolean isDebugging = executor instanceof DefaultDebugExecutor;
        DeployTargetContext context = this.getDeployTargetContext();
        stats.setUserSelectedTarget(context.getCurrentDeployTargetProvider().requiresRuntimePrompt(facet2.getModule().getProject()));
        DeployTarget deployTarget = this.getDeployTarget(executor, env, isDebugging, facet2);
        if (deployTarget == null) {
            return null;
        }
        DeployTargetState deployTargetState = context.getCurrentDeployTargetState();
        if (deployTarget.hasCustomRunProfileState(executor)) {
            return deployTarget.getRunProfileState(executor, env, deployTargetState);
        }
        DeviceFutures deviceFutures = deployTarget.getDevices(deployTargetState, facet2, this.getDeviceCount(isDebugging), isDebugging, this.hashCode());
        if (deviceFutures == null) {
            return null;
        }
        stats.setLaunchedDevices(deviceFutures.getDevices().stream().anyMatch(device -> device instanceof LaunchableAndroidDevice));
        if (deviceFutures.get().isEmpty()) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        if (isDebugging && (error = AndroidRunConfigurationBase.canDebug(deviceFutures, facet2, module.getName())) != null) {
            throw new ExecutionException(error);
        }
        env.putCopyableUserData(DeviceFutures.KEY, (Object)deviceFutures);
        env.putUserData(RunStats.KEY, (Object)stats);
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider(facet2);
        LaunchOptions.Builder launchOptions = this.getLaunchOptions().setDebug(isDebugging);
        if (executor instanceof LaunchOptionsProvider) {
            launchOptions.addExtraOptions(((LaunchOptionsProvider)executor).getLaunchOptions());
        }
        ApkProvider apkProvider = this.getApkProvider(facet2, applicationIdProvider, deviceFutures.getDevices());
        AndroidLaunchTasksProvider launchTasksProvider = new AndroidLaunchTasksProvider(this, env, facet2, applicationIdProvider, apkProvider, launchOptions.build());
        return new AndroidRunState(env, this.getName(), module, applicationIdProvider, this.getConsoleProvider(), deviceFutures, launchTasksProvider);
    }

    private static String canDebug(@NotNull DeviceFutures deviceFutures, @NotNull AndroidFacet facet2, @NotNull String moduleName2) {
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(8);
        }
        if (facet2 == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(9);
        }
        if (moduleName2 == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(10);
        }
        for (AndroidDevice androidDevice : deviceFutures.getDevices()) {
            String deviceName;
            if (androidDevice.isDebuggable() || LaunchUtils.canDebugApp(facet2)) continue;
            if (!androidDevice.getLaunchedDevice().isDone()) {
                deviceName = androidDevice.getName();
            } else {
                IDevice device = (IDevice)Futures.getUnchecked(androidDevice.getLaunchedDevice());
                deviceName = device.getName();
            }
            return AndroidBundle.message("android.cannot.debug.noDebugPermissions", moduleName2, deviceName);
        }
        return null;
    }

    @Nullable
    private DeployTarget getDeployTarget(@NotNull Executor executor, @NotNull ExecutionEnvironment env, boolean debug, @NotNull AndroidFacet facet2) {
        DeployTarget deployTarget;
        Project project;
        DeployTargetProvider currentTargetProvider;
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(11);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(12);
        }
        if (facet2 == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(13);
        }
        if ((currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider()).requiresRuntimePrompt(project = this.getProject())) {
            deployTarget = currentTargetProvider.showPrompt(executor, env, facet2, this.getDeviceCount(debug), this.myAndroidTests, this.getDeployTargetContext().getDeployTargetStates(), this.hashCode(), LaunchCompatibilityCheckerImpl.create(facet2, env, this));
            if (deployTarget == null) {
                return null;
            }
        } else {
            deployTarget = currentTargetProvider.getDeployTarget(project);
        }
        return deployTarget;
    }

    @Nullable
    public ApplicationIdProvider getApplicationIdProvider() {
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module == null) {
            return null;
        }
        Project project = module.getProject();
        if (AndroidProjectInfo.getInstance(project).requiredAndroidModelMissing()) {
            return null;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
        if (facet2 == null) {
            return null;
        }
        if (facet2.isDisposed()) {
            Logger.getInstance(AndroidRunConfigurationBase.class).warn("Can't get application ID: Facet already disposed");
            return null;
        }
        return this.getApplicationIdProvider(facet2);
    }

    @NotNull
    public ApplicationIdProvider getApplicationIdProvider(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(14);
        }
        if (AndroidModel.get(facet2) != null && AndroidModel.get(facet2) instanceof AndroidModuleModel) {
            return new GradleApplicationIdProvider(facet2, this.myOutputProvider);
        }
        return new NonGradleApplicationIdProvider(facet2);
    }

    @NotNull
    protected abstract ApkProvider getApkProvider(@NotNull AndroidFacet var1, @NotNull ApplicationIdProvider var2, @NotNull List<AndroidDevice> var3);

    @NotNull
    protected abstract ConsoleProvider getConsoleProvider();

    @Nullable
    protected abstract LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider var1, @NotNull AndroidFacet var2, @NotNull String var3, boolean var4, @NotNull LaunchStatus var5);

    @NotNull
    protected ApkProvider createGradleApkProvider(@NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, boolean test, @NotNull List<AndroidDevice> targetDevices) {
        if (facet2 == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(15);
        }
        if (applicationIdProvider == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(16);
        }
        if (targetDevices == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(17);
        }
        Computable outputKindProvider = () -> {
            if (DynamicAppUtils.useSelectApksFromBundleBuilder(facet2.getModule(), (RunConfiguration)this, targetDevices)) {
                return GradleApkProvider.OutputKind.AppBundleOutputModel;
            }
            return GradleApkProvider.OutputKind.Default;
        };
        return new GradleApkProvider(facet2, applicationIdProvider, this.myOutputProvider, test, (Computable<GradleApkProvider.OutputKind>)outputKindProvider);
    }

    @NotNull
    public final DeviceCount getDeviceCount(boolean debug) {
        DeviceCount deviceCount = DeviceCount.fromBoolean(this.supportMultipleDevices() && !debug);
        if (deviceCount == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(18);
        }
        return deviceCount;
    }

    protected abstract boolean supportMultipleDevices();

    public void updateExtraRunStats(RunStats runStats) {
    }

    public void setOutputModel(@NotNull PostBuildModel outputModel) {
        if (outputModel == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(19);
        }
        this.myOutputProvider.setOutputModel(outputModel);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(20);
        }
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.myDeployTargetContext.readExternal(element);
        this.myAndroidDebuggerContext.readExternal(element);
        Element profilersElement = element.getChild(PROFILERS_ELEMENT_NAME);
        if (profilersElement != null) {
            this.myProfilerState.readExternal(profilersElement);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(21);
        }
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.myDeployTargetContext.writeExternal(element);
        this.myAndroidDebuggerContext.writeExternal(element);
        Element profilersElement = new Element(PROFILERS_ELEMENT_NAME);
        element.addContent(profilersElement);
        this.myProfilerState.writeExternal(profilersElement);
    }

    public boolean isNativeLaunch() {
        AndroidDebugger androidDebugger = this.myAndroidDebuggerContext.getAndroidDebugger();
        if (androidDebugger == null) {
            return false;
        }
        return !androidDebugger.getId().equals("Java");
    }

    @NotNull
    public DeployTargetContext getDeployTargetContext() {
        DeployTargetContext deployTargetContext = this.myDeployTargetContext;
        if (deployTargetContext == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(22);
        }
        return deployTargetContext;
    }

    @NotNull
    public AndroidDebuggerContext getAndroidDebuggerContext() {
        AndroidDebuggerContext androidDebuggerContext = this.myAndroidDebuggerContext;
        if (androidDebuggerContext == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(23);
        }
        return androidDebuggerContext;
    }

    @NotNull
    public ProfilerState getProfilerState() {
        ProfilerState profilerState = this.myProfilerState;
        if (profilerState == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(24);
        }
        return profilerState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidRunConfigurationBase";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stats";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFutures";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDevices";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputModel";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableDeployTargetProviders";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidRunConfigurationBase";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceCount";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetContext";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidDebuggerContext";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateBeforeRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGetState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canDebug";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTarget";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationIdProvider";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createGradleApkProvider";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setOutputModel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultPostBuildModelProvider
    implements PostBuildModelProvider {
        @Transient
        @Nullable
        private transient PostBuildModel myBuildOutputs = null;

        private DefaultPostBuildModelProvider() {
        }

        public void setOutputModel(@NotNull PostBuildModel postBuildModel) {
            if (postBuildModel == null) {
                DefaultPostBuildModelProvider.$$$reportNull$$$0(0);
            }
            this.myBuildOutputs = postBuildModel;
        }

        @Override
        @Nullable
        public PostBuildModel getPostBuildModel() {
            return this.myBuildOutputs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "postBuildModel", "com/android/tools/idea/run/AndroidRunConfigurationBase$DefaultPostBuildModelProvider", "setOutputModel"));
        }
    }
}

