/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.stats.RunStats;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchTaskRunner
extends Task.Backgroundable {
    @NotNull
    private final String myConfigName;
    @NotNull
    private final String myApplicationId;
    @Nullable
    private final String myExecutionTargetName;
    @NotNull
    private final LaunchInfo myLaunchInfo;
    @NotNull
    private final ProcessHandler myProcessHandler;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProvider myLaunchTasksProvider;
    @NotNull
    private final RunStats myStats;
    @NotNull
    private final BiConsumer<String, HyperlinkInfo> myConsoleConsumer;
    @NotNull
    private final List<Runnable> myOnFinished;
    @Nullable
    private String myError;
    @Nullable
    private NotificationListener myErrorNotificationListener;

    public LaunchTaskRunner(@NotNull Project project, @NotNull String configName, @NotNull String applicationId2, @Nullable String executionTargetName, @NotNull LaunchInfo launchInfo, @NotNull ProcessHandler processHandler, @NotNull DeviceFutures deviceFutures, @NotNull LaunchTasksProvider launchTasksProvider, @NotNull RunStats stats, @NotNull BiConsumer<String, HyperlinkInfo> consoleConsumer) {
        if (project == null) {
            LaunchTaskRunner.$$$reportNull$$$0(0);
        }
        if (configName == null) {
            LaunchTaskRunner.$$$reportNull$$$0(1);
        }
        if (applicationId2 == null) {
            LaunchTaskRunner.$$$reportNull$$$0(2);
        }
        if (launchInfo == null) {
            LaunchTaskRunner.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            LaunchTaskRunner.$$$reportNull$$$0(4);
        }
        if (deviceFutures == null) {
            LaunchTaskRunner.$$$reportNull$$$0(5);
        }
        if (launchTasksProvider == null) {
            LaunchTaskRunner.$$$reportNull$$$0(6);
        }
        if (stats == null) {
            LaunchTaskRunner.$$$reportNull$$$0(7);
        }
        if (consoleConsumer == null) {
            LaunchTaskRunner.$$$reportNull$$$0(8);
        }
        super(project, "Launching " + configName);
        this.myConfigName = configName;
        this.myApplicationId = applicationId2;
        this.myExecutionTargetName = executionTargetName;
        this.myLaunchInfo = launchInfo;
        this.myProcessHandler = processHandler;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProvider = launchTasksProvider;
        this.myStats = stats;
        this.myConsoleConsumer = consoleConsumer;
        this.myOnFinished = new ArrayList<Runnable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            LaunchTaskRunner.$$$reportNull$$$0(9);
        }
        boolean destroyProcessOnCancellation = !this.isSwap();
        indicator.setText(this.getTitle());
        indicator.setIndeterminate(false);
        this.myStats.beginLaunchTasks();
        try {
            DebugConnectorTask debugSessionTask;
            ProcessHandlerLaunchStatus launchStatus = new ProcessHandlerLaunchStatus(this.myProcessHandler);
            ProcessHandlerConsolePrinter consolePrinter = new ProcessHandlerConsolePrinter(this.myProcessHandler);
            List<ListenableFuture<IDevice>> listenableDeviceFutures = this.myDeviceFutures.get();
            AndroidVersion androidVersion = this.myDeviceFutures.getDevices().size() == 1 ? this.myDeviceFutures.getDevices().get(0).getVersion() : null;
            DebugConnectorTask debugConnectorTask = debugSessionTask = this.isSwap() ? null : this.myLaunchTasksProvider.getConnectDebuggerTask(launchStatus, androidVersion);
            if (debugSessionTask != null) {
                if (listenableDeviceFutures.size() != 1) {
                    launchStatus.terminateLaunch("Cannot launch a debug session on more than 1 device.", true);
                    return;
                }
                AndroidProcessText.attach(this.myProcessHandler);
            }
            this.printLaunchTaskStartedMessage(consolePrinter);
            indicator.setText("Waiting for all target devices to come online");
            List devices2 = listenableDeviceFutures.stream().map(deviceFuture -> this.waitForDevice((ListenableFuture<IDevice>)deviceFuture, indicator, launchStatus, destroyProcessOnCancellation)).filter(Objects::nonNull).collect(Collectors.toList());
            if (devices2.size() != listenableDeviceFutures.size()) {
                return;
            }
            if (!this.isSwap() && this.myProcessHandler instanceof AndroidProcessHandler) {
                for (IDevice device : devices2) {
                    ApplicationTerminationWaiter listener2 = new ApplicationTerminationWaiter(device, this.myApplicationId);
                    try {
                        if (!listener2.await(10L, TimeUnit.SECONDS)) {
                            launchStatus.terminateLaunch(String.format("%s is already running.", this.myApplicationId), true);
                            return;
                        }
                    }
                    catch (InterruptedException ignored) {
                        launchStatus.terminateLaunch(String.format("%s is already running.", this.myApplicationId), true);
                        return;
                    }
                    if (!listener2.getIsDeviceAlive()) continue;
                    AndroidProcessHandler procHandler = (AndroidProcessHandler)this.myProcessHandler;
                    procHandler.addTargetDevice(device);
                }
            }
            for (int deviceIndex = 0; deviceIndex < devices2.size(); ++deviceIndex) {
                IDevice device;
                device = (IDevice)devices2.get(deviceIndex);
                List<LaunchTask> launchTasks = null;
                try {
                    this.myLaunchTasksProvider.fillStats(this.myStats);
                    launchTasks = this.myLaunchTasksProvider.getTasks(device, launchStatus, consolePrinter);
                }
                catch (com.intellij.execution.ExecutionException e) {
                    launchStatus.terminateLaunch(e.getMessage(), !this.isSwap());
                    this.myStats.endLaunchTasks();
                    return;
                }
                catch (IllegalStateException e) {
                    launchStatus.terminateLaunch(e.getMessage(), !this.isSwap());
                    Logger.getInstance(LaunchTaskRunner.class).error((Throwable)e);
                    this.myStats.endLaunchTasks();
                    return;
                }
                int totalDuration = LaunchTaskRunner.getTotalDuration(launchTasks, debugSessionTask);
                int elapsed = 0;
                for (LaunchTask task2 : launchTasks) {
                    if (!LaunchTaskRunner.checkIfLaunchIsAliveAndTerminateIfCancelIsRequested(indicator, launchStatus, destroyProcessOnCancellation)) {
                        return;
                    }
                    LaunchTaskDetail.Builder details = this.myStats.beginLaunchTask(task2);
                    indicator.setText(task2.getDescription());
                    LaunchResult result2 = task2.run(this.myLaunchInfo.executor, device, launchStatus, consolePrinter);
                    this.myOnFinished.addAll(result2.onFinishedCallbacks());
                    boolean success2 = result2.getSuccess();
                    this.myStats.endLaunchTask(task2, details, success2);
                    if (!success2) {
                        this.myErrorNotificationListener = result2.getNotificationListener();
                        this.myError = result2.getError();
                        launchStatus.terminateLaunch(result2.getConsoleError(), !this.isSwap());
                        if (result2.getConsoleHyperlinkInfo() != null) {
                            this.myConsoleConsumer.accept(result2.getConsoleHyperlinkText() + "\n", result2.getConsoleHyperlinkInfo());
                        }
                        RunContentManager.getInstance((Project)this.myProject).toFrontRunContent(this.myLaunchInfo.executor, this.myProcessHandler);
                        this.myStats.setErrorId(result2.getErrorId());
                        return;
                    }
                    indicator.setFraction((double)((elapsed += task2.getDuration()) / totalDuration + deviceIndex) / (double)devices2.size());
                }
                if (debugSessionTask == null) continue;
                debugSessionTask.perform(this.myLaunchInfo, device, launchStatus, consolePrinter);
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.myStats.endLaunchTasks();
        }
    }

    private void printLaunchTaskStartedMessage(ConsolePrinter consolePrinter) {
        StringBuilder launchString = new StringBuilder("\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd HH:mm:ss");
        launchString.append(dateFormat.format(new Date())).append(": ");
        launchString.append(this.getLaunchVerb()).append(" ");
        launchString.append("'").append(this.myConfigName).append("'");
        if (!StringUtil.isEmpty((String)this.myExecutionTargetName)) {
            launchString.append(" on ");
            launchString.append(this.myExecutionTargetName);
        }
        launchString.append(".");
        consolePrinter.stdout(launchString.toString());
    }

    public void onSuccess() {
        if (this.myError == null) {
            this.myStats.success();
        } else {
            this.myStats.fail();
            LaunchUtils.showNotification(this.myProject, this.myLaunchInfo.executor, this.myConfigName, this.myError, NotificationType.ERROR, this.myErrorNotificationListener);
        }
    }

    public void onFinished() {
        super.onFinished();
        for (Runnable runnable2 : this.myOnFinished) {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    @Nullable
    private IDevice waitForDevice(@NotNull ListenableFuture<IDevice> deviceFuture, @NotNull ProgressIndicator indicator, @NotNull LaunchStatus launchStatus, boolean destroyProcess) {
        if (deviceFuture == null) {
            LaunchTaskRunner.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            LaunchTaskRunner.$$$reportNull$$$0(11);
        }
        if (launchStatus == null) {
            LaunchTaskRunner.$$$reportNull$$$0(12);
        }
        this.myStats.beginWaitForDevice();
        IDevice device = null;
        while (LaunchTaskRunner.checkIfLaunchIsAliveAndTerminateIfCancelIsRequested(indicator, launchStatus, destroyProcess)) {
            try {
                device = (IDevice)deviceFuture.get(1L, TimeUnit.SECONDS);
                break;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException e) {
                launchStatus.terminateLaunch("Interrupted while waiting for device", destroyProcess);
                break;
            }
            catch (ExecutionException e) {
                launchStatus.terminateLaunch("Error while waiting for device: " + e.getCause().getMessage(), destroyProcess);
                break;
            }
        }
        this.myStats.endWaitForDevice(device);
        return device;
    }

    private static boolean checkIfLaunchIsAliveAndTerminateIfCancelIsRequested(@NotNull ProgressIndicator indicator, @NotNull LaunchStatus launchStatus, boolean destroyProcess) {
        if (indicator == null) {
            LaunchTaskRunner.$$$reportNull$$$0(13);
        }
        if (launchStatus == null) {
            LaunchTaskRunner.$$$reportNull$$$0(14);
        }
        if (launchStatus.isLaunchTerminated()) {
            return false;
        }
        if (indicator.isCanceled()) {
            launchStatus.terminateLaunch("User cancelled launch", destroyProcess);
            return false;
        }
        return true;
    }

    private static int getTotalDuration(@NotNull List<LaunchTask> launchTasks, @Nullable DebugConnectorTask debugSessionTask) {
        if (launchTasks == null) {
            LaunchTaskRunner.$$$reportNull$$$0(15);
        }
        int total = 0;
        for (LaunchTask task2 : launchTasks) {
            total += task2.getDuration();
        }
        if (debugSessionTask != null) {
            total += debugSessionTask.getDuration();
        }
        return total;
    }

    private boolean isSwap() {
        return this.myLaunchInfo.env.getUserData(SwapInfo.SWAP_INFO_KEY) != null;
    }

    @NotNull
    private String getLaunchVerb() {
        SwapInfo swapInfo = (SwapInfo)this.myLaunchInfo.env.getUserData(SwapInfo.SWAP_INFO_KEY);
        if (swapInfo != null) {
            if (swapInfo.getType() == SwapInfo.SwapType.APPLY_CHANGES) {
                return "Applying changes to";
            }
            if (swapInfo.getType() == SwapInfo.SwapType.APPLY_CODE_CHANGES) {
                return "Applying code changes to";
            }
        }
        return "Launching";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFutures";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchTasksProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stats";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleConsumer";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFuture";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchTasks";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/LaunchTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForDevice";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfLaunchIsAliveAndTerminateIfCancelIsRequested";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getTotalDuration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ApplicationTerminationWaiter
    implements AndroidDebugBridge.IDeviceChangeListener {
        @NotNull
        private final IDevice myIDevice;
        @NotNull
        private final List<Client> myClientsToWaitFor;
        @NotNull
        private final CountDownLatch myProcessKilledLatch;
        private volatile boolean myIsDeviceAlive;

        private ApplicationTerminationWaiter(@NotNull IDevice iDevice, @NotNull String applicationId2) {
            if (iDevice == null) {
                ApplicationTerminationWaiter.$$$reportNull$$$0(0);
            }
            if (applicationId2 == null) {
                ApplicationTerminationWaiter.$$$reportNull$$$0(1);
            }
            this.myProcessKilledLatch = new CountDownLatch(1);
            this.myIsDeviceAlive = true;
            this.myIDevice = iDevice;
            this.myClientsToWaitFor = Collections.synchronizedList(DeploymentApplicationService.getInstance().findClient(this.myIDevice, applicationId2));
            if (!this.myIDevice.isOnline() || this.myClientsToWaitFor.isEmpty()) {
                this.myProcessKilledLatch.countDown();
            } else {
                AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
                iDevice.forceStop(applicationId2);
                this.myClientsToWaitFor.forEach(Client::kill);
                this.checkDone();
            }
        }

        /*
         * WARNING - void declaration
         */
        public boolean await(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
            void unit;
            if (timeUnit == null) {
                ApplicationTerminationWaiter.$$$reportNull$$$0(2);
            }
            return this.myProcessKilledLatch.await(timeout, (TimeUnit)unit);
        }

        public boolean getIsDeviceAlive() {
            return this.myIsDeviceAlive;
        }

        public void deviceConnected(IDevice device) {
        }

        public void deviceDisconnected(IDevice device) {
            this.myIsDeviceAlive = false;
            this.myProcessKilledLatch.countDown();
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }

        public void deviceChanged(IDevice changedDevice, int changeMask) {
            if (changedDevice != this.myIDevice || (changeMask & 2) == 0) {
                this.checkDone();
                return;
            }
            this.myClientsToWaitFor.retainAll(Arrays.asList(changedDevice.getClients()));
            this.checkDone();
        }

        private void checkDone() {
            if (this.myClientsToWaitFor.isEmpty()) {
                this.myProcessKilledLatch.countDown();
                AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iDevice";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "applicationId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/run/LaunchTaskRunner$ApplicationTerminationWaiter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "await";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

