/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.ConsolePrinter;
import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessHandlerConsolePrinter
implements ConsolePrinter {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final List<Message> myStoredMessages = new ArrayList<Message>();
    @Nullable
    private ProcessHandler myProcessHandler;

    public ProcessHandlerConsolePrinter(@Nullable ProcessHandler processHandler) {
        this.myProcessHandler = processHandler;
    }

    @Override
    public void stdout(@NotNull String text) {
        if (text == null) {
            ProcessHandlerConsolePrinter.$$$reportNull$$$0(0);
        }
        this.print(text, ProcessOutputTypes.STDOUT);
    }

    @Override
    public void stderr(@NotNull String text) {
        if (text == null) {
            ProcessHandlerConsolePrinter.$$$reportNull$$$0(1);
        }
        this.print(text, ProcessOutputTypes.STDERR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessHandler(@NotNull ProcessHandler processHandler) {
        ArrayList storedMessages;
        if (processHandler == null) {
            ProcessHandlerConsolePrinter.$$$reportNull$$$0(2);
        }
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            this.myProcessHandler = processHandler;
            storedMessages = Lists.newArrayList(this.myStoredMessages);
            this.myStoredMessages.clear();
        }
        for (Message message2 : storedMessages) {
            this.print(message2.text, message2.outputType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(@NotNull String text, @NotNull Key outputType) {
        ProcessHandler processHandler;
        if (text == null) {
            ProcessHandlerConsolePrinter.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            ProcessHandlerConsolePrinter.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myProcessHandler == null) {
                this.myStoredMessages.add(new Message(text, outputType));
                return;
            }
            processHandler = this.myProcessHandler;
        }
        assert (!Thread.holdsLock(this.myLock));
        processHandler.notifyTextAvailable(text + "\n", outputType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/ProcessHandlerConsolePrinter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "stdout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "stderr";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setProcessHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Message {
        @NotNull
        final String text;
        @NotNull
        final Key outputType;

        Message(@NotNull String text, @NotNull Key outputType) {
            if (text == null) {
                Message.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                Message.$$$reportNull$$$0(1);
            }
            this.text = text;
            this.outputType = outputType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/run/ProcessHandlerConsolePrinter$Message";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

