/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.model.AndroidManifestIndex;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.utils.concurrency.AsyncSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DefaultActivityLocatorStats;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.ActivityAlias;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultActivityLocator
extends ActivityLocator {
    private static final Logger LOG = Logger.getInstance(DefaultActivityLocator.class);
    @NotNull
    private final AndroidFacet myFacet;

    public DefaultActivityLocator(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            DefaultActivityLocator.$$$reportNull$$$0(0);
        }
        this.myFacet = facet2;
    }

    @Override
    @Slow
    @WorkerThread
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device) throws ActivityLocator.ActivityLocatorException {
        if (device == null) {
            DefaultActivityLocator.$$$reportNull$$$0(1);
        }
        assert (!this.myFacet.getProperties().USE_CUSTOM_COMPILER_MANIFEST);
        String defaultActivity = DefaultActivityLocator.computeDefaultActivityWithDevicePreference(DefaultActivityLocator.getActivitiesFromMergedManifest(this.myFacet), device);
        if (defaultActivity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
        String string = defaultActivity;
        if (string == null) {
            DefaultActivityLocator.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        assert (!this.myFacet.getProperties().USE_CUSTOM_COMPILER_MANIFEST);
        boolean usePotentiallyStaleManifest = ApplicationManager.getApplication().isDispatchThread();
        MergedManifestSnapshot mergedManifest = DefaultActivityLocator.getMergedManifest(this.myFacet, usePotentiallyStaleManifest);
        List<ActivityWrapper> activities = mergedManifest == null ? Collections.emptyList() : ActivityWrapper.get(mergedManifest.getActivities(), mergedManifest.getActivityAliases());
        String defaultActivity = DefaultActivityLocator.computeDefaultActivity(activities);
        if (defaultActivity == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("default.activity.not.found.error", new Object[0]));
        }
    }

    @VisibleForTesting
    static List<ActivityWrapper> getActivitiesFromMergedManifest(@NotNull AndroidFacet facet2) {
        StudioFlags.DefaultActivityLocatorStrategy strategy;
        if (facet2 == null) {
            DefaultActivityLocator.$$$reportNull$$$0(3);
        }
        if ((strategy = (StudioFlags.DefaultActivityLocatorStrategy)StudioFlags.DEFAULT_ACTIVITY_LOCATOR_STRATEGY.get()) == StudioFlags.DefaultActivityLocatorStrategy.INDEX && AndroidManifestIndex.indexEnabled()) {
            return (List)DumbService.getInstance((Project)facet2.getModule().getProject()).runReadActionInSmartMode(() -> DefaultActivityLocator.getActivitiesFromManifestIndex(facet2));
        }
        boolean onEdt = ApplicationManager.getApplication().isDispatchThread();
        boolean usePotentiallyStaleManifest = onEdt && strategy == StudioFlags.DefaultActivityLocatorStrategy.STALE;
        Stopwatch timer2 = Stopwatch.createStarted();
        MergedManifestSnapshot mergedManifest = DefaultActivityLocator.getMergedManifest(facet2, usePotentiallyStaleManifest);
        List<ActivityWrapper> activities = mergedManifest == null ? Collections.emptyList() : ActivityWrapper.get(mergedManifest.getActivities(), mergedManifest.getActivityAliases());
        DefaultActivityLocator.logManifestLatency(onEdt, false, usePotentiallyStaleManifest, timer2.elapsed(TimeUnit.MILLISECONDS));
        return activities;
    }

    @Nullable
    private static MergedManifestSnapshot getMergedManifest(@NotNull AndroidFacet facet2, boolean usePotentiallyStaleManifest) {
        if (facet2 == null) {
            DefaultActivityLocator.$$$reportNull$$$0(4);
        }
        if (usePotentiallyStaleManifest) {
            AsyncSupplier<MergedManifestSnapshot> manifestSupplier = MergedManifestManager.getMergedManifestSupplier(facet2.getModule());
            manifestSupplier.get();
            return (MergedManifestSnapshot)manifestSupplier.getNow();
        }
        return MergedManifestManager.getFreshSnapshot(facet2.getModule());
    }

    @NotNull
    private static List<ActivityWrapper> getActivitiesFromManifestIndex(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            DefaultActivityLocator.$$$reportNull$$$0(5);
        }
        boolean onEdt = ApplicationManager.getApplication().isDispatchThread();
        Stopwatch timer2 = Stopwatch.createStarted();
        LinkedList<ActivityWrapper> activityWrappers = AndroidManifestIndexQueryUtils.queryActivitiesFromManifestIndex(facet2);
        DefaultActivityLocator.logManifestLatency(onEdt, true, false, timer2.elapsed(TimeUnit.MILLISECONDS));
        LinkedList<ActivityWrapper> linkedList = activityWrappers;
        if (linkedList == null) {
            DefaultActivityLocator.$$$reportNull$$$0(6);
        }
        return linkedList;
    }

    private static void logManifestLatency(boolean blocksUiThread, boolean indexBased, boolean usedPotentiallyStaleManifest, long latencyMs) {
        AndroidStudioEvent.Builder proto = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEFAULT_ACTIVITY_LOCATOR_STATS).setDefaultActivityLocatorStats(DefaultActivityLocatorStats.newBuilder().setBlocksUiThread(blocksUiThread).setIndexBased(indexBased).setUsedPotentiallyStaleManifest(usedPotentiallyStaleManifest).setLatencyMs(latencyMs));
        UsageTracker.log((AndroidStudioEvent.Builder)proto);
    }

    @Nullable
    public static String getDefaultLauncherActivityName(@NotNull Project project, @NotNull Manifest manifest) {
        if (project == null) {
            DefaultActivityLocator.$$$reportNull$$$0(7);
        }
        if (manifest == null) {
            DefaultActivityLocator.$$$reportNull$$$0(8);
        }
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> DefaultActivityLocator.getDefaultLauncherActivityName(project, manifest));
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && DumbService.isDumb((Project)project)) {
            LOG.warn("Cannot locate default activity when indices are not available");
            return null;
        }
        return DefaultActivityLocator.computeDefaultActivity(DefaultActivityLocator.merge(application.getActivities(), application.getActivityAliases()));
    }

    @Nullable
    @VisibleForTesting
    public static String computeDefaultActivity(@NotNull List<ActivityWrapper> activities) {
        List<ActivityWrapper> launchableActivities;
        if (activities == null) {
            DefaultActivityLocator.$$$reportNull$$$0(9);
        }
        if ((launchableActivities = DefaultActivityLocator.getLaunchableActivities(activities)).isEmpty()) {
            return null;
        }
        if (launchableActivities.size() == 1) {
            return launchableActivities.get(0).getQualifiedName();
        }
        ActivityWrapper defaultLauncher = DefaultActivityLocator.findDefaultLauncher(launchableActivities);
        if (defaultLauncher != null) {
            return defaultLauncher.getQualifiedName();
        }
        return launchableActivities.get(0).getQualifiedName();
    }

    @Slow
    @WorkerThread
    @Nullable
    public static String computeDefaultActivityWithDevicePreference(@NotNull List<ActivityWrapper> activities, @NotNull IDevice device) {
        List<ActivityWrapper> launchableActivities;
        if (activities == null) {
            DefaultActivityLocator.$$$reportNull$$$0(10);
        }
        if (device == null) {
            DefaultActivityLocator.$$$reportNull$$$0(11);
        }
        if ((launchableActivities = DefaultActivityLocator.getLaunchableActivities(activities)).isEmpty()) {
            return null;
        }
        if (launchableActivities.size() == 1) {
            return launchableActivities.get(0).getQualifiedName();
        }
        ActivityWrapper activity = DefaultActivityLocator.findLauncherActivityForDevice(launchableActivities, device);
        if (activity != null) {
            return activity.getQualifiedName();
        }
        ActivityWrapper defaultLauncher = DefaultActivityLocator.findDefaultLauncher(launchableActivities);
        if (defaultLauncher != null) {
            return defaultLauncher.getQualifiedName();
        }
        return launchableActivities.get(0).getQualifiedName();
    }

    @Slow
    @WorkerThread
    @Nullable
    private static ActivityWrapper findLauncherActivityForDevice(@NotNull List<ActivityWrapper> launchableActivities, @NotNull IDevice device) {
        if (launchableActivities == null) {
            DefaultActivityLocator.$$$reportNull$$$0(12);
        }
        if (device == null) {
            DefaultActivityLocator.$$$reportNull$$$0(13);
        }
        if (device.supportsFeature(IDevice.HardwareFeature.TV)) {
            return DefaultActivityLocator.findLeanbackLauncher(launchableActivities);
        }
        return null;
    }

    @Nullable
    private static ActivityWrapper findLeanbackLauncher(@NotNull List<ActivityWrapper> launcherActivities) {
        if (launcherActivities == null) {
            DefaultActivityLocator.$$$reportNull$$$0(14);
        }
        for (ActivityWrapper activity : launcherActivities) {
            if (!activity.hasCategory("android.intent.category.LEANBACK_LAUNCHER")) continue;
            return activity;
        }
        return null;
    }

    @Nullable
    private static ActivityWrapper findDefaultLauncher(@NotNull List<ActivityWrapper> launcherActivities) {
        if (launcherActivities == null) {
            DefaultActivityLocator.$$$reportNull$$$0(15);
        }
        for (ActivityWrapper activity : launcherActivities) {
            if (!activity.hasCategory("android.intent.category.DEFAULT")) continue;
            return activity;
        }
        return null;
    }

    @NotNull
    private static List<ActivityWrapper> getLaunchableActivities(@NotNull List<ActivityWrapper> allActivities) {
        List<ActivityWrapper> launchableActivities;
        if (allActivities == null) {
            DefaultActivityLocator.$$$reportNull$$$0(16);
        }
        if ((launchableActivities = allActivities.stream().filter(activity -> ActivityLocatorUtils.containsLauncherIntent(activity) && activity.isEnabled()).collect(Collectors.toList())).isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug("No launchable activities found, total # of activities: " + allActivities.size());
            allActivities.forEach(wrapper -> LOG.debug(String.format("activity: %1$s, isEnabled: %2$s, containsLauncherIntent: %3$s", wrapper.getQualifiedName(), wrapper.isEnabled(), ActivityLocatorUtils.containsLauncherIntent(wrapper))));
        }
        List<ActivityWrapper> list = launchableActivities;
        if (list == null) {
            DefaultActivityLocator.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static List<ActivityWrapper> merge(List<Activity> activities, List<ActivityAlias> activityAliases) {
        ArrayList activityWrappers = Lists.newArrayListWithExpectedSize((int)(activities.size() + activityAliases.size()));
        for (Activity activity : activities) {
            activityWrappers.add(ActivityWrapper.get(activity));
        }
        for (ActivityAlias activityAlias : activityAliases) {
            activityWrappers.add(ActivityWrapper.get(activityAlias));
        }
        return activityWrappers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: 
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/activity/DefaultActivityLocator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activities";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchableActivities";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherActivities";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allActivities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/activity/DefaultActivityLocator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedActivityName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivitiesFromManifestIndex";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchableActivities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedActivityName";
                break;
            }
            case 2: 
            case 6: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActivitiesFromMergedManifest";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMergedManifest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getActivitiesFromManifestIndex";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLauncherActivityName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeDefaultActivity";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeDefaultActivityWithDevicePreference";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findLauncherActivityForDevice";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findLeanbackLauncher";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultLauncher";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchableActivities";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementActivityWrapper
    extends ActivityWrapper {
        private final Element myActivity;

        public ElementActivityWrapper(Element activity) {
            this.myActivity = activity;
        }

        @Override
        public boolean hasCategory(@NotNull String name) {
            if (name == null) {
                ElementActivityWrapper.$$$reportNull$$$0(0);
            }
            for (Node node = this.myActivity.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element filter2;
                if (node.getNodeType() != 1 || !"intent-filter".equals(node.getNodeName()) || !ActivityLocatorUtils.containsCategory(filter2 = (Element)node, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAction(@NotNull String name) {
            if (name == null) {
                ElementActivityWrapper.$$$reportNull$$$0(1);
            }
            for (Node node = this.myActivity.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element filter2;
                if (node.getNodeType() != 1 || !"intent-filter".equals(node.getNodeName()) || !ActivityLocatorUtils.containsAction(filter2 = (Element)node, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            String enabledAttr = this.myActivity.getAttributeNS("http://schemas.android.com/apk/res/android", "enabled");
            return StringUtil.isEmpty((String)enabledAttr) || Boolean.valueOf(enabledAttr) != false || enabledAttr.startsWith("@");
        }

        @Override
        @Nullable
        public Boolean getExported() {
            String exportedAttr = this.myActivity.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
            return StringUtil.isEmpty((String)exportedAttr) ? null : Boolean.valueOf(exportedAttr);
        }

        @Override
        public boolean hasIntentFilter() {
            for (Node node = this.myActivity.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !"intent-filter".equals(node.getNodeName())) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myActivity);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/android/tools/idea/run/activity/DefaultActivityLocator$ElementActivityWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasCategory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ActivityAliasWrapper
    extends ActivityWrapper {
        private final ActivityAlias myAlias;

        public ActivityAliasWrapper(ActivityAlias activityAlias) {
            this.myAlias = activityAlias;
        }

        @Override
        public boolean hasCategory(@NotNull String name) {
            if (name == null) {
                ActivityAliasWrapper.$$$reportNull$$$0(0);
            }
            for (IntentFilter filter2 : this.myAlias.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAction(@NotNull String name) {
            if (name == null) {
                ActivityAliasWrapper.$$$reportNull$$$0(1);
            }
            for (IntentFilter filter2 : this.myAlias.getIntentFilters()) {
                if (!AndroidDomUtil.containsAction(filter2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            AndroidAttributeValue<String> enabled = this.myAlias.getEnabled();
            if (enabled == null) {
                return true;
            }
            String stringValue = enabled.getStringValue();
            return stringValue == null || Boolean.valueOf(stringValue) != false || stringValue.startsWith("@");
        }

        @Override
        @Nullable
        public Boolean getExported() {
            AndroidAttributeValue<String> exported = this.myAlias.getExported();
            if (exported == null || exported.getValue() == null || ((String)exported.getValue()).isEmpty()) {
                return null;
            }
            return Boolean.valueOf((String)exported.getValue());
        }

        @Override
        public boolean hasIntentFilter() {
            return !this.myAlias.getIntentFilters().isEmpty();
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myAlias);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityAliasWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasCategory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RealActivityWrapper
    extends ActivityWrapper {
        private final Activity myActivity;

        public RealActivityWrapper(Activity activity) {
            this.myActivity = activity;
        }

        @Override
        public boolean hasCategory(@NotNull String name) {
            if (name == null) {
                RealActivityWrapper.$$$reportNull$$$0(0);
            }
            for (IntentFilter filter2 : this.myActivity.getIntentFilters()) {
                if (!AndroidDomUtil.containsCategory(filter2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAction(@NotNull String name) {
            if (name == null) {
                RealActivityWrapper.$$$reportNull$$$0(1);
            }
            for (IntentFilter filter2 : this.myActivity.getIntentFilters()) {
                if (!AndroidDomUtil.containsAction(filter2, name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            AndroidAttributeValue<String> enabled = this.myActivity.getEnabled();
            if (enabled == null) {
                return true;
            }
            String stringValue = enabled.getStringValue();
            return stringValue == null || Boolean.valueOf(stringValue) != false || stringValue.startsWith("@");
        }

        @Override
        @Nullable
        public Boolean getExported() {
            AndroidAttributeValue<String> exported = this.myActivity.getExported();
            if (exported == null || exported.getValue() == null || ((String)exported.getValue()).isEmpty()) {
                return null;
            }
            return Boolean.valueOf((String)exported.getValue());
        }

        @Override
        public boolean hasIntentFilter() {
            return !this.myActivity.getIntentFilters().isEmpty();
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return ActivityLocatorUtils.getQualifiedName(this.myActivity);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/android/tools/idea/run/activity/DefaultActivityLocator$RealActivityWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasCategory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ActivityWrapper {
        public abstract boolean hasCategory(@NotNull String var1);

        public abstract boolean hasAction(@NotNull String var1);

        public abstract boolean isEnabled();

        @Nullable
        public abstract Boolean getExported();

        public boolean isLogicallyExported() {
            return Boolean.TRUE.equals(this.getExported()) || this.hasIntentFilter();
        }

        public abstract boolean hasIntentFilter();

        @Nullable
        public abstract String getQualifiedName();

        public static ActivityWrapper get(@NotNull Activity activity) {
            if (activity == null) {
                ActivityWrapper.$$$reportNull$$$0(0);
            }
            return new RealActivityWrapper(activity);
        }

        public static ActivityWrapper get(@NotNull ActivityAlias activityAlias) {
            if (activityAlias == null) {
                ActivityWrapper.$$$reportNull$$$0(1);
            }
            return new ActivityAliasWrapper(activityAlias);
        }

        public static ActivityWrapper get(@NotNull Element activityOrAlias) {
            if (activityOrAlias == null) {
                ActivityWrapper.$$$reportNull$$$0(2);
            }
            return new ElementActivityWrapper(activityOrAlias);
        }

        public static List<ActivityWrapper> get(@NotNull List<Element> activities, @NotNull List<Element> aliases) {
            if (activities == null) {
                ActivityWrapper.$$$reportNull$$$0(3);
            }
            if (aliases == null) {
                ActivityWrapper.$$$reportNull$$$0(4);
            }
            ArrayList list = Lists.newArrayListWithCapacity((int)(activities.size() + aliases.size()));
            for (Element element : activities) {
                list.add(new ElementActivityWrapper(element));
            }
            for (Element element : aliases) {
                list.add(new ElementActivityWrapper(element));
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "activity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "activityAlias";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "activityOrAlias";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "activities";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aliases";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/run/activity/DefaultActivityLocator$ActivityWrapper";
            objectArray[2] = "get";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

