/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployable;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.deployable.Device;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationIdResolver
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final Map<IDevice, Device> myDevices = new ConcurrentHashMap<IDevice, Device>();
    @NotNull
    private final ExecutorService myApplicationIdResolverExecutor = new ThreadPoolExecutor(0, 4, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("package-name-resolver-%d").build());

    public ApplicationIdResolver() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.myApplicationIdResolverExecutor.shutdownNow();
    }

    @NotNull
    public List<Client> resolve(@NotNull IDevice iDevice, @NotNull String applicationId2) {
        Device device;
        if (iDevice == null) {
            ApplicationIdResolver.$$$reportNull$$$0(0);
        }
        if (applicationId2 == null) {
            ApplicationIdResolver.$$$reportNull$$$0(1);
        }
        List<Client> list = (device = this.myDevices.get(iDevice)) == null ? Collections.emptyList() : device.findClientWithApplicationId(applicationId2);
        if (list == null) {
            ApplicationIdResolver.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
        if (bridge != null && bridge.isConnected() && bridge.hasInitialDeviceList()) {
            for (IDevice iDevice : bridge.getDevices()) {
                this.refresh(iDevice);
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            ApplicationIdResolver.$$$reportNull$$$0(3);
        }
        this.refresh(device);
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            ApplicationIdResolver.$$$reportNull$$$0(4);
        }
        this.myDevices.remove(device);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            ApplicationIdResolver.$$$reportNull$$$0(5);
        }
        if ((changeMask & 3) != 0) {
            this.refresh(device);
        }
    }

    private void refresh(@NotNull IDevice iDevice) {
        if (iDevice == null) {
            ApplicationIdResolver.$$$reportNull$$$0(6);
        }
        this.myDevices.compute(iDevice, (ignored, device) -> {
            if (!iDevice.isOnline()) {
                return null;
            }
            Device newDevice = device;
            if (newDevice == null) {
                newDevice = new Device(this.myApplicationIdResolverExecutor, iDevice);
            }
            newDevice.refresh();
            return newDevice;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iDevice";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployable/ApplicationIdResolver";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployable/ApplicationIdResolver";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deviceConnected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deviceDisconnected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deviceChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

