/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevice
extends Device {
    private static final Icon ourConnectedIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE);
    @Nullable
    private final Snapshot mySnapshot;

    @NotNull
    static VirtualDevice newConnectedDevice(@NotNull ConnectedDevice connectedDevice, @NotNull KeyToConnectionTimeMap map2, @Nullable VirtualDevice virtualDevice) {
        if (connectedDevice == null) {
            VirtualDevice.$$$reportNull$$$0(0);
        }
        if (map2 == null) {
            VirtualDevice.$$$reportNull$$$0(1);
        }
        Device device = virtualDevice == null ? connectedDevice : virtualDevice;
        Key key = device.getKey();
        VirtualDevice virtualDevice2 = new Builder().setName(device.getName()).setValid(connectedDevice.isValid()).setValidityReason(connectedDevice.getValidityReason()).setKey(key).setConnectionTime(map2.get(key)).setAndroidDevice(connectedDevice.getAndroidDevice()).setSnapshot(device.getSnapshot()).build();
        if (virtualDevice2 == null) {
            VirtualDevice.$$$reportNull$$$0(2);
        }
        return virtualDevice2;
    }

    private VirtualDevice(@NotNull Builder builder2) {
        if (builder2 == null) {
            VirtualDevice.$$$reportNull$$$0(3);
        }
        super(builder2);
        this.mySnapshot = builder2.mySnapshot;
    }

    @Override
    @NotNull
    Icon getIcon() {
        Icon icon2 = this.isConnected() ? ourConnectedIcon : StudioIcons.DeviceExplorer.VIRTUAL_DEVICE_PHONE;
        if (icon2 == null) {
            VirtualDevice.$$$reportNull$$$0(4);
        }
        return icon2;
    }

    @Override
    boolean isConnected() {
        return this.getConnectionTime() != null;
    }

    @Override
    @Nullable
    Snapshot getSnapshot() {
        return this.mySnapshot;
    }

    @Override
    @NotNull
    Future<AndroidVersion> getAndroidVersion() {
        AndroidDevice androidDevice = this.getAndroidDevice();
        if (androidDevice instanceof LaunchableAndroidDevice) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)((LaunchableAndroidDevice)androidDevice).getAvdInfo().getAndroidVersion());
            if (listenableFuture == null) {
                VirtualDevice.$$$reportNull$$$0(5);
            }
            return listenableFuture;
        }
        IDevice ddmlibDevice = this.getDdmlibDevice();
        assert (ddmlibDevice != null);
        Future<AndroidVersion> future2 = DeploymentApplicationService.getInstance().getVersion(ddmlibDevice);
        if (future2 == null) {
            VirtualDevice.$$$reportNull$$$0(6);
        }
        return future2;
    }

    @Override
    void addTo(@NotNull DeviceFutures futures, @NotNull Project project) {
        if (futures == null) {
            VirtualDevice.$$$reportNull$$$0(7);
        }
        if (project == null) {
            VirtualDevice.$$$reportNull$$$0(8);
        }
        AndroidDevice device = this.getAndroidDevice();
        if (!this.isConnected()) {
            device.launch(project, this.getEmulatorCommandArguments());
        }
        futures.getDevices().add(device);
    }

    @NotNull
    private List<String> getEmulatorCommandArguments() {
        if (this.mySnapshot == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                VirtualDevice.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = Arrays.asList("-snapshot", this.mySnapshot.getDirectory().toString(), "-id", this.getKey().toString());
        if (list == null) {
            VirtualDevice.$$$reportNull$$$0(10);
        }
        return list;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof VirtualDevice)) {
            return false;
        }
        VirtualDevice device = (VirtualDevice)object;
        return this.getName().equals(device.getName()) && this.isValid() == device.isValid() && Objects.equals(this.getValidityReason(), device.getValidityReason()) && this.getKey().equals(device.getKey()) && Objects.equals(this.getConnectionTime(), device.getConnectionTime()) && this.getAndroidDevice().equals(device.getAndroidDevice()) && Objects.equals(this.mySnapshot, device.mySnapshot);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.isValid(), this.getValidityReason(), this.getKey(), this.getConnectionTime(), this.getAndroidDevice(), this.mySnapshot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectedDevice";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/VirtualDevice";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/VirtualDevice";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "newConnectedDevice";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmulatorCommandArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newConnectedDevice";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Builder
    extends Device.Builder {
        @Nullable
        private Snapshot mySnapshot;

        Builder() {
        }

        @NotNull
        Builder setName(@NotNull String name) {
            if (name == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myName = name;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder2;
        }

        @NotNull
        Builder setValid(boolean valid) {
            this.myValid = valid;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        Builder setValidityReason(@Nullable String validityReason) {
            this.myValidityReason = validityReason;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        Builder setKey(@NotNull Key key) {
            if (key == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myKey = key;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        @VisibleForTesting
        Builder setConnectionTime(@NotNull Instant connectionTime) {
            if (connectionTime == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myConnectionTime = connectionTime;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            if (androidDevice == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myAndroidDevice = androidDevice;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        Builder setSnapshot(@Nullable Snapshot snapshot) {
            this.mySnapshot = snapshot;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @Override
        @NotNull
        VirtualDevice build() {
            return new VirtualDevice(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/deployment/VirtualDevice$Builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connectionTime";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidDevice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/deployment/VirtualDevice$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setValid";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setValidityReason";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setKey";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setConnectionTime";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAndroidDevice";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSnapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setKey";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setConnectionTime";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setAndroidDevice";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

