/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ProfilerState {
    public static final String ANDROID_PROFILER_STATE_ID = "android.profilers.state";
    public static final String ANDROID_ADVANCED_PROFILING_TRANSFORMS = "android.advanced.profiling.transforms";
    public boolean ADVANCED_PROFILING_ENABLED = false;
    public static final String ENABLE_ADVANCED_PROFILING_NAME = "android.profiler.enabled";
    public boolean STARTUP_CPU_PROFILING_ENABLED = false;
    public String STARTUP_CPU_PROFILING_CONFIGURATION_NAME = CpuProfilerConfig.Technology.SAMPLED_JAVA.getName();
    private boolean PROFILING_OKHTTP_ENABLED = true;
    public static final String ENABLE_ADVANCED_OKHTTP_PROFILING_NAME = "android.profiler.okhttp.enabled";
    public static final String ENABLE_UNIFIED_PIPELINE_NAME = "android.profiler.unifiedpipeline.enabled";
    private boolean myCheckAdvancedProfiling;

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public Properties toProperties() {
        Properties result2 = new Properties();
        result2.setProperty(ENABLE_ADVANCED_PROFILING_NAME, String.valueOf(this.ADVANCED_PROFILING_ENABLED));
        result2.setProperty(ENABLE_UNIFIED_PIPELINE_NAME, String.valueOf(StudioFlags.PROFILER_UNIFIED_PIPELINE.get()));
        result2.setProperty(ENABLE_ADVANCED_OKHTTP_PROFILING_NAME, String.valueOf(this.PROFILING_OKHTTP_ENABLED));
        return result2;
    }

    public void setCheckAdvancedProfiling(boolean checkAdvancedProfiling) {
        this.myCheckAdvancedProfiling = checkAdvancedProfiling;
    }

    @NotNull
    public List<ValidationError> validate() {
        LinkedList<ValidationError> errors = new LinkedList<ValidationError>();
        if (this.myCheckAdvancedProfiling) {
            errors.add(ValidationError.info("Check advanced profiling status", ValidationError.Category.PROFILER, null));
        }
        LinkedList<ValidationError> linkedList = errors;
        if (linkedList == null) {
            ProfilerState.$$$reportNull$$$0(0);
        }
        return linkedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/ProfilerState", "validate"));
    }
}

