/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.AdbClient;
import com.android.tools.deployer.AdbInstaller;
import com.android.tools.deployer.DeployMetric;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.Installer;
import com.android.tools.deployer.UIService;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeploymentService;
import com.android.tools.idea.run.IdeService;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.ui.BaseAction;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.utils.ILogger;
import com.google.common.base.Stopwatch;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDeployTask
implements LaunchTask {
    public static final int MIN_API_VERSION = 26;
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"UnifiedDeployTask", (String)"Run");
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, List<File>> myPackages;
    @NotNull
    protected List<LaunchTaskDetail> mySubTaskDetails;
    private final boolean myFallback;
    private final Computable<String> myInstallPathProvider;
    public static final Logger LOG = Logger.getInstance(AbstractDeployTask.class);

    public AbstractDeployTask(@NotNull Project project, @NotNull Map<String, List<File>> packages, boolean fallback, Computable<String> installPathProvider) {
        if (project == null) {
            AbstractDeployTask.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            AbstractDeployTask.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myPackages = packages;
        this.myFallback = fallback;
        this.myInstallPathProvider = installPathProvider;
        this.mySubTaskDetails = new ArrayList<LaunchTaskDetail>();
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public LaunchResult run(@NotNull Executor executor, @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (executor == null) {
            AbstractDeployTask.$$$reportNull$$$0(2);
        }
        if (device == null) {
            AbstractDeployTask.$$$reportNull$$$0(3);
        }
        if (launchStatus == null) {
            AbstractDeployTask.$$$reportNull$$$0(4);
        }
        if (printer == null) {
            AbstractDeployTask.$$$reportNull$$$0(5);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        LogWrapper logger2 = new LogWrapper(LOG);
        ArrayList<DeployMetric> metrics = new ArrayList<DeployMetric>();
        long vmClockStartNs = System.nanoTime();
        long wallClockStartMs = System.currentTimeMillis();
        AdbClient adb = new AdbClient(device, (ILogger)logger2);
        AdbInstaller installer = new AdbInstaller(this.getLocalInstaller(), adb, metrics, (ILogger)logger2);
        DeploymentService service = DeploymentService.getInstance(this.myProject);
        IdeService ideService = new IdeService(this.myProject);
        Deployer deployer = new Deployer(adb, service.getDexDatabase(), service.getTaskRunner(), (Installer)installer, (UIService)ideService, metrics, (ILogger)logger2);
        ArrayList<String> idsSkippedInstall = new ArrayList<String>();
        for (Map.Entry<String, List<File>> entry : this.myPackages.entrySet()) {
            String applicationId2 = entry.getKey();
            List<File> apkFiles = entry.getValue();
            try {
                Deployer.Result result2 = this.perform(device, deployer, applicationId2, apkFiles);
                this.addSubTaskDetails(metrics, vmClockStartNs, wallClockStartMs);
                if (!result2.skippedInstall) continue;
                idsSkippedInstall.add(applicationId2);
            }
            catch (DeployerException e) {
                logger2.warning("%s failed: %s %s", new Object[]{this.getDescription(), e.getMessage(), e.getDetails()});
                return this.toLaunchResult(executor, e, printer);
            }
        }
        stopwatch.stop();
        long duration = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        if (idsSkippedInstall.isEmpty()) {
            String content2 = String.format("%s successfully finished in %s.", this.getDescription(), StringUtil.formatDuration((long)duration));
            NOTIFICATION_GROUP.createNotification(content2, NotificationType.INFORMATION).setImportant(false).notify(this.myProject);
            logger2.info("%s", new Object[]{content2});
        } else {
            String title = String.format("%s successfully finished in %s.", this.getDescription(), StringUtil.formatDuration((long)duration));
            String content3 = this.createSkippedApkInstallMessage(idsSkippedInstall, idsSkippedInstall.size() == this.myPackages.size());
            NOTIFICATION_GROUP.createNotification(title, content3, NotificationType.INFORMATION, null).setImportant(false).notify(this.myProject);
            logger2.info("%s. %s", new Object[]{title, content3});
        }
        return new LaunchResult();
    }

    protected abstract String getFailureTitle();

    protected abstract Deployer.Result perform(IDevice var1, Deployer var2, String var3, List<File> var4) throws DeployerException;

    private String getLocalInstaller() {
        return (String)this.myInstallPathProvider.compute();
    }

    protected static List<String> getPathsToInstall(@NotNull List<File> apkFiles) {
        if (apkFiles == null) {
            AbstractDeployTask.$$$reportNull$$$0(6);
        }
        return apkFiles.stream().map(File::getPath).collect(Collectors.toList());
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractDeployTask.$$$reportNull$$$0(7);
        }
        return project;
    }

    /*
     * WARNING - void declaration
     */
    private void addSubTaskDetails(@NotNull Collection<DeployMetric> metrics, long startNanoTime, long l) {
        if (metrics == null) {
            AbstractDeployTask.$$$reportNull$$$0(8);
        }
        for (DeployMetric metric : metrics) {
            void startWallClockMs;
            if (metric.getName().isEmpty()) continue;
            LaunchTaskDetail.Builder detail = LaunchTaskDetail.newBuilder();
            long startOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getStartTimeNs() - startNanoTime);
            long endOffsetMs = TimeUnit.NANOSECONDS.toMillis(metric.getEndTimeNs() - startNanoTime);
            detail.setId(this.getId() + "." + metric.getName()).setStartTimestampMs((long)(startWallClockMs + startOffsetMs)).setEndTimestampMs((long)(startWallClockMs + endOffsetMs)).setTid((int)metric.getThreadId());
            if (metric.hasStatus()) {
                detail.setStatus(metric.getStatus());
            }
            this.mySubTaskDetails.add(detail.build());
        }
    }

    @Override
    @NotNull
    public Collection<LaunchTaskDetail> getSubTaskDetails() {
        List<LaunchTaskDetail> list = this.mySubTaskDetails;
        if (list == null) {
            AbstractDeployTask.$$$reportNull$$$0(9);
        }
        return list;
    }

    public LaunchResult toLaunchResult(@NotNull Executor executor, @NotNull DeployerException e, @NotNull ConsolePrinter printer) {
        if (executor == null) {
            AbstractDeployTask.$$$reportNull$$$0(10);
        }
        if (e == null) {
            AbstractDeployTask.$$$reportNull$$$0(11);
        }
        if (printer == null) {
            AbstractDeployTask.$$$reportNull$$$0(12);
        }
        LaunchResult result2 = new LaunchResult();
        result2.setSuccess(false);
        StringBuilder bubbleError = new StringBuilder(this.getFailureTitle());
        bubbleError.append("\n");
        bubbleError.append(e.getMessage());
        DeployerException.Error error = e.getError();
        if (error.getResolution() != DeployerException.ResolutionAction.NONE) {
            if (!this.myFallback) {
                bubbleError.append(String.format("\n<a href='%s'>%s</a>", error.getResolution(), error.getCallToAction()));
            } else {
                bubbleError.append(String.format("\n%s will be done automatically</a>", error.getCallToAction()));
            }
        }
        result2.setError(bubbleError.toString());
        result2.setConsoleError(this.getFailureTitle() + "\n" + e.getMessage() + "\n" + e.getDetails());
        result2.setErrorId(e.getId());
        DeploymentHyperlinkInfo hyperlinkInfo = new DeploymentHyperlinkInfo(executor, error.getResolution(), printer);
        result2.setConsoleHyperlink(error.getCallToAction(), hyperlinkInfo);
        result2.setNotificationListener(new DeploymentErrorNotificationListener(error.getResolution(), hyperlinkInfo));
        if (this.myFallback) {
            result2.addOnFinishedCallback(() -> hyperlinkInfo.navigate(this.myProject));
        }
        return result2;
    }

    protected abstract String createSkippedApkInstallMessage(List<String> var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apkFiles";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/AbstractDeployTask";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/AbstractDeployTask";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubTaskDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToInstall";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSubTaskDetails";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toLaunchResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DeploymentHyperlinkInfo
    implements HyperlinkInfo {
        @Nullable
        private final String myActionId;
        @NotNull
        private final ConsolePrinter myPrinter;

        public DeploymentHyperlinkInfo(@NotNull Executor executor, @NotNull DeployerException.ResolutionAction resolutionAction, ConsolePrinter printer) {
            if (executor == null) {
                DeploymentHyperlinkInfo.$$$reportNull$$$0(0);
            }
            if (resolutionAction == null) {
                DeploymentHyperlinkInfo.$$$reportNull$$$0(1);
            }
            if (printer == null) {
                DeploymentHyperlinkInfo.$$$reportNull$$$0(2);
            }
            this.myPrinter = printer;
            switch (resolutionAction) {
                case APPLY_CHANGES: {
                    this.myActionId = "android.deploy.ApplyChanges";
                    break;
                }
                case RUN_APP: {
                    this.myActionId = "Debug".equals(executor.getId()) ? "Debug" : "Run";
                    break;
                }
                case RETRY: {
                    this.myActionId = executor.getActionName();
                    break;
                }
                default: {
                    this.myActionId = null;
                }
            }
        }

        public void navigate(@NotNull Project project) {
            BaseAction.DisableMessage message2;
            if (project == null) {
                DeploymentHyperlinkInfo.$$$reportNull$$$0(3);
            }
            if (this.myActionId == null) {
                return;
            }
            ActionManager manager = ActionManager.getInstance();
            AnAction action2 = manager.getAction(this.myActionId);
            if (action2 == null) {
                return;
            }
            if (action2 instanceof BaseAction && (message2 = BaseAction.getDisableMessage(project)) != null) {
                this.myPrinter.stderr(String.format("%s is disabled because %s.", action2.getTemplatePresentation().getText(), message2.getDescription()));
                return;
            }
            manager.tryToExecute(action2, ActionCommand.getInputEvent((String)this.myActionId), null, "unknown", true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolutionAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/run/tasks/AbstractDeployTask$DeploymentHyperlinkInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "navigate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DeploymentErrorNotificationListener
    implements NotificationListener {
        @NotNull
        private final DeployerException.ResolutionAction myResolutionAction;
        @NotNull
        private final DeploymentHyperlinkInfo myHyperlinkInfo;

        public DeploymentErrorNotificationListener(@NotNull DeployerException.ResolutionAction resolutionAction, DeploymentHyperlinkInfo hyperlinkInfo) {
            if (resolutionAction == null) {
                DeploymentErrorNotificationListener.$$$reportNull$$$0(0);
            }
            if (hyperlinkInfo == null) {
                DeploymentErrorNotificationListener.$$$reportNull$$$0(1);
            }
            this.myResolutionAction = resolutionAction;
            this.myHyperlinkInfo = hyperlinkInfo;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                DeploymentErrorNotificationListener.$$$reportNull$$$0(2);
            }
            if (event == null) {
                DeploymentErrorNotificationListener.$$$reportNull$$$0(3);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals(this.myResolutionAction.name())) {
                this.myHyperlinkInfo.navigate(AbstractDeployTask.this.myProject);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolutionAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlinkInfo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/run/tasks/AbstractDeployTask$DeploymentErrorNotificationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

