/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ApplyChangesTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(ApplyChangesTask.class);
    private static final String ID = "APPLY_CHANGES";

    public ApplyChangesTask(@NotNull Project project, @NotNull Map<String, List<File>> packages, boolean fallback, Computable<String> installPathProvider) {
        if (project == null) {
            ApplyChangesTask.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            ApplyChangesTask.$$$reportNull$$$0(1);
        }
        super(project, packages, fallback, installPathProvider);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Apply Changes";
    }

    @Override
    @NotNull
    public String getFailureTitle() {
        return "Changes were not applied.";
    }

    @Override
    protected Deployer.Result perform(IDevice device, Deployer deployer, String applicationId2, List<File> files2) throws DeployerException {
        LOG.info("Applying changes to application: " + applicationId2);
        return deployer.fullSwap(ApplyChangesTask.getPathsToInstall(files2));
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "Activity restarted. No code or resource changes detected.";
        }
        String string = "Activity restarted without re-installing the following APK(s): " + skippedApkList.stream().collect(Collectors.joining(", "));
        if (string == null) {
            ApplyChangesTask.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/ApplyChangesTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/ApplyChangesTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSkippedApkInstallMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

