/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.deployer.ClassRedefiner;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.idea.run.tasks.AbstractDeployTask;
import com.android.tools.idea.run.util.DebuggerRedefiner;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ApplyCodeChangesTask
extends AbstractDeployTask {
    private static final Logger LOG = Logger.getInstance(ApplyCodeChangesTask.class);
    private static final String ID = "APPLY_CODE_CHANGES";

    public ApplyCodeChangesTask(@NotNull Project project, @NotNull Map<String, List<File>> packages, boolean fallback, Computable<String> installPathProvider) {
        if (project == null) {
            ApplyCodeChangesTask.$$$reportNull$$$0(0);
        }
        if (packages == null) {
            ApplyCodeChangesTask.$$$reportNull$$$0(1);
        }
        super(project, packages, fallback, installPathProvider);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private ImmutableMap<Integer, ClassRedefiner> makeSpecificRedefiners(Project project, IDevice device) {
        if (!DebuggerRedefiner.hasDebuggersAttached(project)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder debugRedefiners = ImmutableMap.builder();
        for (Client client : device.getClients()) {
            int port;
            if (!client.isDebuggerAttached() || DebuggerRedefiner.getDebuggerSession(project, port = client.getDebuggerListenPort()) == null) continue;
            DebuggerRedefiner debugRedefiner = new DebuggerRedefiner(project, port);
            debugRedefiners.put((Object)client.getClientData().getPid(), (Object)debugRedefiner);
        }
        return debugRedefiners.build();
    }

    @Override
    protected Deployer.Result perform(IDevice device, Deployer deployer, String applicationId2, List<File> files2) throws DeployerException {
        LOG.info("Applying code changes to application: " + applicationId2);
        ImmutableMap<Integer, ClassRedefiner> redefiners = this.makeSpecificRedefiners(this.getProject(), device);
        return deployer.codeSwap(ApplyCodeChangesTask.getPathsToInstall(files2), redefiners);
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Apply Code Changes";
    }

    @Override
    @NotNull
    public String getFailureTitle() {
        return "Changes were not applied.";
    }

    @Override
    @NotNull
    protected String createSkippedApkInstallMessage(List<String> skippedApkList, boolean all) {
        if (all) {
            return "No code changes detected.";
        }
        String string = "No code changes detected. The ollowing APK(s) are not installed: " + skippedApkList.stream().collect(Collectors.joining(", "));
        if (string == null) {
            ApplyCodeChangesTask.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/ApplyCodeChangesTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/ApplyCodeChangesTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSkippedApkInstallMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

