/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata;

import com.android.ide.common.util.PathString;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.sampledata.CsvEditor;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/sampledata/CsvEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "file", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.android.designer"})
public final class CsvEditorProvider
implements FileEditorProvider,
DumbAware {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean accept(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        PsiFile psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)virtualFile);
        if (!(psiFile2 instanceof PsiPlainTextFile)) return false;
        String string2 = virtualFile.getExtension();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string = null;
        }
        if (!Intrinsics.areEqual((Object)"csv", string)) return false;
        Module module = AndroidPsiUtils.getModuleSafely((PsiElement)((PsiElement)psiFile2));
        Object object = module;
        if (module == null) return false;
        AndroidModuleSystem androidModuleSystem = ProjectSystemUtil.getModuleSystem((Module)object);
        object = androidModuleSystem;
        if (androidModuleSystem == null) return false;
        PathString pathString = object.getSampleDataDirectory();
        PathString sampleDataDirectory = pathString;
        if (sampleDataDirectory == null) return false;
        PathString pathString2 = FileExtensions.toPathString(virtualFile);
        boolean bl = false;
        boolean bl2 = false;
        PathString it = pathString2;
        boolean bl3 = false;
        if (!it.startsWith(sampleDataDirectory)) return false;
        if (!(Intrinsics.areEqual((Object)it, (Object)sampleDataDirectory) ^ true)) return false;
        return true;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiFile psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)file);
        if (psiFile2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiPlainTextFile");
        }
        return new CsvEditor((PsiPlainTextFile)psiFile2, project);
    }

    @NotNull
    public String getEditorTypeId() {
        return "sample-data-csv-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }
}

