/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.OptionalLibrary;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.serviceContainer.NonInjectable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdks {
    @NonNls
    public static final String SDK_NAME_PREFIX = "Android ";
    @NotNull
    private final IdeInfo myIdeInfo;
    @Nullable
    private AndroidSdkData mySdkData;

    @NotNull
    public static AndroidSdks getInstance() {
        AndroidSdks androidSdks = (AndroidSdks)ApplicationManager.getApplication().getService(AndroidSdks.class);
        if (androidSdks == null) {
            AndroidSdks.$$$reportNull$$$0(0);
        }
        return androidSdks;
    }

    public AndroidSdks() {
        this(IdeInfo.getInstance());
    }

    @NonInjectable
    @VisibleForTesting
    AndroidSdks(@NotNull IdeInfo ideInfo) {
        if (ideInfo == null) {
            AndroidSdks.$$$reportNull$$$0(1);
        }
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public File findPathOfSdkWithoutAddonsFolder(@NotNull Project project) {
        if (project == null) {
            AndroidSdks.$$$reportNull$$$0(2);
        }
        if (this.myIdeInfo.isAndroidStudio()) {
            File sdkPath = IdeSdks.getInstance().getAndroidSdkPath();
            if (sdkPath != null && AndroidSdks.isMissingAddonsFolder(sdkPath)) {
                return sdkPath;
            }
        } else {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            for (Module module : moduleManager.getModules()) {
                File sdkHomePath;
                String homePath;
                Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (moduleSdk == null || !this.isAndroidSdk(moduleSdk) || (homePath = moduleSdk.getHomePath()) == null || !AndroidSdks.isMissingAddonsFolder(sdkHomePath = FilePaths.toSystemDependentPath((String)homePath))) continue;
                return sdkHomePath;
            }
        }
        return null;
    }

    private static boolean isMissingAddonsFolder(@NotNull File sdkHomePath) {
        File addonsFolder;
        if (sdkHomePath == null) {
            AndroidSdks.$$$reportNull$$$0(3);
        }
        return !(addonsFolder = new File(sdkHomePath, "add-ons")).isDirectory() || FileUtil.notNullize((File[])addonsFolder.listFiles()).length == 0;
    }

    @Nullable
    public Sdk findSuitableAndroidSdk(@NotNull String targetHash) {
        if (targetHash == null) {
            AndroidSdks.$$$reportNull$$$0(4);
        }
        for (Sdk sdk : this.getAllAndroidSdks()) {
            AndroidSdkAdditionalData originalData = this.getAndroidSdkAdditionalData(sdk);
            if (originalData == null || !targetHash.equals(originalData.getBuildTargetHashString())) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    public AndroidSdkAdditionalData getAndroidSdkAdditionalData(@NotNull Sdk sdk) {
        SdkAdditionalData data;
        if (sdk == null) {
            AndroidSdks.$$$reportNull$$$0(5);
        }
        return (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData ? (AndroidSdkAdditionalData)data : null;
    }

    public void setSdkData(@Nullable AndroidSdkData data) {
        this.mySdkData = data;
    }

    @NotNull
    public AndroidSdkHandler tryToChooseSdkHandler() {
        AndroidSdkData data = this.tryToChooseAndroidSdk();
        AndroidSdkHandler androidSdkHandler = data != null ? data.getSdkHandler() : AndroidSdkHandler.getInstance(null);
        if (androidSdkHandler == null) {
            AndroidSdks.$$$reportNull$$$0(6);
        }
        return androidSdkHandler;
    }

    public boolean hasValidDocs(@NotNull Sdk sdk, @NotNull IAndroidTarget target) {
        File sdkDir;
        File javaDocPath;
        if (sdk == null) {
            AndroidSdks.$$$reportNull$$$0(7);
        }
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(8);
        }
        if ((javaDocPath = AndroidSdks.findJavadocFolder(new File(AndroidSdks.getPlatformPath(target)))) == null && (sdkDir = FilePaths.toSystemDependentPath((String)sdk.getHomePath())) != null) {
            javaDocPath = AndroidSdks.findJavadocFolder(sdkDir);
        }
        String javaDocUrl = javaDocPath == null ? "http://developer.android.com/reference/" : FilePaths.pathToIdeaUrl((File)javaDocPath);
        for (String rootUrl : sdk.getRootProvider().getUrls(JavadocOrderRootType.getInstance())) {
            if (!javaDocUrl.equals(rootUrl)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public AndroidSdkData tryToChooseAndroidSdk() {
        if (this.mySdkData == null) {
            File path2;
            if (this.myIdeInfo.isAndroidStudio() && (path2 = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                this.mySdkData = AndroidSdkData.getSdkData(path2);
                if (this.mySdkData != null) {
                    return this.mySdkData;
                }
            }
            for (File path3 : this.getAndroidSdkPathsFromExistingPlatforms()) {
                this.mySdkData = AndroidSdkData.getSdkData(path3);
                if (this.mySdkData == null) continue;
                break;
            }
        }
        return this.mySdkData;
    }

    @NotNull
    public Collection<File> getAndroidSdkPathsFromExistingPlatforms() {
        ArrayList<File> result2 = new ArrayList<File>();
        for (Sdk androidSdk : this.getAllAndroidSdks()) {
            File sdkPath;
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(androidSdk);
            if (androidPlatform == null || result2.contains(sdkPath = androidPlatform.getSdkData().getLocation())) continue;
            if (androidSdk.getName().startsWith(SDK_NAME_PREFIX)) {
                result2.add(0, sdkPath);
                continue;
            }
            result2.add(sdkPath);
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            AndroidSdks.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public List<Sdk> getAllAndroidSdks() {
        List list = (List)ReadAction.compute(() -> ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)AndroidSdkType.getInstance()));
        if (list == null) {
            AndroidSdks.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public Sdk tryToCreate(@NotNull File sdkPath, @NotNull String targetHashString) {
        AndroidSdkData sdkData;
        if (sdkPath == null) {
            AndroidSdks.$$$reportNull$$$0(11);
        }
        if (targetHashString == null) {
            AndroidSdks.$$$reportNull$$$0(12);
        }
        if ((sdkData = AndroidSdkData.getSdkData(sdkPath)) != null) {
            sdkData.getSdkHandler().getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(AndroidSdks.class)).markInvalid();
            IAndroidTarget target = sdkData.findTargetByHashString(targetHashString);
            if (target != null) {
                return this.create(target, sdkData.getLocation(), true);
            }
        }
        return null;
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, boolean addRoots) {
        Sdk jdk;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(13);
        }
        if (sdkPath == null) {
            AndroidSdks.$$$reportNull$$$0(14);
        }
        return (jdk = this.getJdk()) != null ? this.create(target, sdkPath, jdk, addRoots) : null;
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, @NotNull Sdk jdk, boolean addRoots) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(15);
        }
        if (sdkPath == null) {
            AndroidSdks.$$$reportNull$$$0(16);
        }
        if (jdk == null) {
            AndroidSdks.$$$reportNull$$$0(17);
        }
        return this.create(target, sdkPath, this.chooseNameForNewLibrary(target), jdk, addRoots);
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, @NotNull String sdkName, @NotNull Sdk jdk, boolean addRoots) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(18);
        }
        if (sdkPath == null) {
            AndroidSdks.$$$reportNull$$$0(19);
        }
        if (sdkName == null) {
            AndroidSdks.$$$reportNull$$$0(20);
        }
        if (jdk == null) {
            AndroidSdks.$$$reportNull$$$0(21);
        }
        if (!target.getAdditionalLibraries().isEmpty()) {
            String parentHashString;
            String string = parentHashString = target.getParent() == null ? null : target.getParent().hashString();
            if (parentHashString != null && this.findSuitableAndroidSdk(parentHashString) == null) {
                this.tryToCreate(sdkPath, parentHashString);
            }
            return null;
        }
        ProjectJdkTable table2 = ProjectJdkTable.getInstance();
        String tempName = SdkConfigurationUtil.createUniqueSdkName((String)"Android SDK", Arrays.asList(table2.getAllJdks()));
        Sdk sdk = table2.createSdk(tempName, (SdkTypeId)AndroidSdkType.getInstance());
        SdkModificator sdkModificator = AndroidSdks.getAndInitialiseSdkModificator(sdk, target, jdk);
        sdkModificator.setHomePath(FileUtil.toSystemIndependentName((String)sdkPath.getPath()));
        this.setUpSdkAndCommit(sdkModificator, sdkName, Arrays.asList(table2.getAllJdks()), addRoots);
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk));
        return sdk;
    }

    public void setUpSdk(@NotNull Sdk androidSdk, @NotNull IAndroidTarget target, @NotNull String sdkName, @NotNull Collection<Sdk> allSdks, @Nullable Sdk jdk) {
        if (androidSdk == null) {
            AndroidSdks.$$$reportNull$$$0(22);
        }
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(23);
        }
        if (sdkName == null) {
            AndroidSdks.$$$reportNull$$$0(24);
        }
        if (allSdks == null) {
            AndroidSdks.$$$reportNull$$$0(25);
        }
        this.setUpSdkAndCommit(AndroidSdks.getAndInitialiseSdkModificator(androidSdk, target, jdk), sdkName, allSdks, true);
    }

    @NotNull
    private static SdkModificator getAndInitialiseSdkModificator(@NotNull Sdk androidSdk, @NotNull IAndroidTarget target, @Nullable Sdk jdk) {
        if (androidSdk == null) {
            AndroidSdks.$$$reportNull$$$0(26);
        }
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(27);
        }
        SdkModificator sdkModificator = androidSdk.getSdkModificator();
        AndroidSdkAdditionalData data = new AndroidSdkAdditionalData(androidSdk, jdk);
        data.setBuildTarget(target);
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)data);
        if (jdk != null) {
            sdkModificator.setVersionString(jdk.getVersionString());
        }
        SdkModificator sdkModificator2 = sdkModificator;
        if (sdkModificator2 == null) {
            AndroidSdks.$$$reportNull$$$0(28);
        }
        return sdkModificator2;
    }

    private void setUpSdkAndCommit(@NotNull SdkModificator sdkModificator, @NotNull String sdkName, @NotNull Collection<Sdk> allSdks, boolean addRoots) {
        if (sdkModificator == null) {
            AndroidSdks.$$$reportNull$$$0(29);
        }
        if (sdkName == null) {
            AndroidSdks.$$$reportNull$$$0(30);
        }
        if (allSdks == null) {
            AndroidSdks.$$$reportNull$$$0(31);
        }
        AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)sdkModificator.getSdkAdditionalData();
        assert (data != null);
        AndroidSdkData androidSdkData = AndroidSdkData.getSdkData(sdkModificator.getHomePath());
        assert (androidSdkData != null);
        IAndroidTarget target = data.getBuildTarget(androidSdkData);
        assert (target != null);
        String name = SdkConfigurationUtil.createUniqueSdkName((String)sdkName, allSdks);
        sdkModificator.setName(name);
        if (addRoots) {
            List<OrderRoot> newRoots = this.getLibraryRootsForTarget(target, FilePaths.toSystemDependentPath((String)sdkModificator.getHomePath()), true);
            sdkModificator.removeAllRoots();
            for (OrderRoot orderRoot : newRoots) {
                sdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
            }
            this.findAndSetPlatformSources(target, sdkModificator);
            ExternalAnnotationsSupport.attachJdkAnnotations(sdkModificator);
        }
        sdkModificator.commitChanges();
    }

    public void findAndSetPlatformSources(@NotNull IAndroidTarget target, @NotNull SdkModificator sdkModificator) {
        VirtualFile virtualFile;
        File sources;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(32);
        }
        if (sdkModificator == null) {
            AndroidSdks.$$$reportNull$$$0(33);
        }
        if ((sources = this.findPlatformSources(target)) != null && (virtualFile = VfsUtil.findFileByIoFile((File)sources, (boolean)true)) != null) {
            for (VirtualFile file : sdkModificator.getRoots(OrderRootType.SOURCES)) {
                if (!file.equals(virtualFile)) continue;
                return;
            }
            sdkModificator.addRoot(virtualFile, OrderRootType.SOURCES);
        }
    }

    @Nullable
    public File findPlatformSources(@NotNull IAndroidTarget target) {
        File platformSource;
        String path2;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(34);
        }
        if ((path2 = target.getPath(18)) != null && (platformSource = new File(path2)).isDirectory()) {
            return platformSource;
        }
        return null;
    }

    @NotNull
    public List<OrderRoot> getLibraryRootsForTarget(@NotNull IAndroidTarget target, @Nullable File sdkPath, boolean addPlatformAndAddOnJars) {
        File annotationsJarPath;
        VirtualFile annotationsJar;
        String resFolderPath;
        VirtualFile resFolder;
        VirtualFile javadoc;
        VirtualFile platformSourcesDir;
        VirtualFile platformFolder;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(35);
        }
        ArrayList<OrderRoot> result2 = new ArrayList<OrderRoot>();
        if (addPlatformAndAddOnJars) {
            for (VirtualFile file : this.getPlatformAndAddOnJars(target)) {
                result2.add(new OrderRoot(file, OrderRootType.CLASSES));
            }
        }
        if ((platformFolder = AndroidSdks.getPlatformFolder(target)) == null) {
            ArrayList<OrderRoot> arrayList = result2;
            if (arrayList == null) {
                AndroidSdks.$$$reportNull$$$0(36);
            }
            return arrayList;
        }
        VirtualFile targetDir = platformFolder;
        if (!target.isPlatform()) {
            targetDir = AndroidSdks.findFileInLocalFileSystem(target.getLocation());
        }
        boolean docsOrSourcesFound = false;
        if (targetDir != null) {
            docsOrSourcesFound = AndroidSdks.addJavaDocAndSources(result2, targetDir);
        }
        VirtualFile sdkDir = sdkPath != null ? ExternalSystemUtil.refreshAndFindFileByIoFile((File)sdkPath) : null;
        VirtualFile sourcesDir = null;
        if (sdkDir != null) {
            docsOrSourcesFound = AndroidSdks.addJavaDocAndSources(result2, sdkDir) || docsOrSourcesFound;
            sourcesDir = VfsUtil.refreshAndFindChild((VirtualFile)sdkDir, (String)"sources");
        }
        if (sourcesDir != null && sourcesDir.isDirectory() && (platformSourcesDir = VfsUtil.refreshAndFindChild(sourcesDir, (String)platformFolder.getName())) != null && platformSourcesDir.isDirectory()) {
            result2.add(new OrderRoot(platformSourcesDir, OrderRootType.SOURCES));
            docsOrSourcesFound = true;
        }
        if (!docsOrSourcesFound && (javadoc = VirtualFileManager.getInstance().findFileByUrl("http://developer.android.com/reference/")) != null) {
            result2.add(new OrderRoot(javadoc, JavadocOrderRootType.getInstance()));
        }
        if ((resFolder = AndroidSdks.findFileInLocalFileSystem(resFolderPath = target.getPath(11))) != null) {
            result2.add(new OrderRoot(resFolder, OrderRootType.CLASSES));
        }
        if (sdkPath != null && this.needsAnnotationsJarInClasspath(target) && (annotationsJar = AndroidSdks.findFileInJarFileSystem(annotationsJarPath = new File(sdkPath, FileUtil.toSystemDependentName((String)"/tools/support/annotations.jar")))) != null) {
            result2.add(new OrderRoot(annotationsJar, OrderRootType.CLASSES));
        }
        ArrayList<OrderRoot> arrayList = result2;
        if (arrayList == null) {
            AndroidSdks.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    public List<VirtualFile> getPlatformAndAddOnJars(@NotNull IAndroidTarget target) {
        VirtualFile androidJar;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(38);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        VirtualFile platformFolder = AndroidSdks.getPlatformFolder(target);
        if (platformFolder != null && (androidJar = VfsUtil.refreshAndFindChild((VirtualFile)platformFolder, (String)"android.jar")) != null) {
            File androidJarPath = VfsUtilCore.virtualToIoFile((VirtualFile)androidJar);
            VirtualFile androidJarRoot = AndroidSdks.findFileInJarFileSystem(androidJarPath);
            if (androidJarRoot != null) {
                result2.add(androidJarRoot);
            }
            List libraries = target.getAdditionalLibraries();
            for (OptionalLibrary library : libraries) {
                VirtualFile root2 = AndroidSdks.getRoot(library);
                if (root2 == null) continue;
                result2.add(root2);
            }
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            AndroidSdks.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @NotNull
    private static String getPlatformPath(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(40);
        }
        String string = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        if (string == null) {
            AndroidSdks.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Nullable
    private static VirtualFile getPlatformFolder(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(42);
        }
        String platformPath = AndroidSdks.getPlatformPath(target);
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)platformPath));
    }

    @Nullable
    private static VirtualFile getRoot(@NotNull OptionalLibrary library) {
        File jar;
        if (library == null) {
            AndroidSdks.$$$reportNull$$$0(43);
        }
        if ((jar = library.getJar()) != null) {
            return AndroidSdks.findFileInJarFileSystem(jar);
        }
        return null;
    }

    private static boolean addJavaDocAndSources(@NotNull List<OrderRoot> orderRoots, @NotNull VirtualFile sdkFolder) {
        VirtualFile sourcesFolder;
        if (orderRoots == null) {
            AndroidSdks.$$$reportNull$$$0(44);
        }
        if (sdkFolder == null) {
            AndroidSdks.$$$reportNull$$$0(45);
        }
        boolean found = false;
        VirtualFile javadocFolder = AndroidSdks.findJavadocFolder(sdkFolder);
        if (javadocFolder != null) {
            orderRoots.add(new OrderRoot(javadocFolder, JavadocOrderRootType.getInstance()));
            found = true;
        }
        if ((sourcesFolder = VfsUtil.refreshAndFindChild((VirtualFile)sdkFolder, (String)"src")) != null) {
            orderRoots.add(new OrderRoot(sourcesFolder, OrderRootType.SOURCES));
            found = true;
        }
        return found;
    }

    @Nullable
    private static VirtualFile findJavadocFolder(@NotNull VirtualFile folder) {
        VirtualFile docsFolder;
        if (folder == null) {
            AndroidSdks.$$$reportNull$$$0(46);
        }
        return (docsFolder = VfsUtil.refreshAndFindChild((VirtualFile)folder, (String)"docs")) != null ? VfsUtil.refreshAndFindChild((VirtualFile)docsFolder, (String)"reference") : null;
    }

    @Nullable
    private static File findJavadocFolder(@NotNull File folder) {
        File docsFolder;
        if (folder == null) {
            AndroidSdks.$$$reportNull$$$0(47);
        }
        return (docsFolder = new File(folder, FileUtil.join((String[])new String[]{"docs", "reference"}))).isDirectory() ? docsFolder : null;
    }

    @Nullable
    private static VirtualFile findFileInLocalFileSystem(@NotNull String path2) {
        if (path2 == null) {
            AndroidSdks.$$$reportNull$$$0(48);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path2));
    }

    @Nullable
    private static VirtualFile findFileInJarFileSystem(@NotNull File path2) {
        if (path2 == null) {
            AndroidSdks.$$$reportNull$$$0(49);
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)path2.getPath());
        return JarFileSystem.getInstance().refreshAndFindFileByPath(canonicalPath + "!/");
    }

    @NotNull
    public String chooseNameForNewLibrary(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(50);
        }
        if (target.isPlatform()) {
            String string = SDK_NAME_PREFIX + target.getVersion().toString() + " Platform";
            if (string == null) {
                AndroidSdks.$$$reportNull$$$0(51);
            }
            return string;
        }
        IAndroidTarget parentTarget = target.getParent();
        Object name = SDK_NAME_PREFIX;
        if (parentTarget != null) {
            name = (String)name + parentTarget.getVersionName() + " ";
        }
        String string = (String)name + target.getName();
        if (string == null) {
            AndroidSdks.$$$reportNull$$$0(52);
        }
        return string;
    }

    public boolean isAndroidSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            AndroidSdks.$$$reportNull$$$0(53);
        }
        return sdk.getSdkType() == AndroidSdkType.getInstance();
    }

    public boolean needsAnnotationsJarInClasspath(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(54);
        }
        return target.getVersion().getApiLevel() <= 15;
    }

    public void refreshLibrariesIn(@NotNull Sdk sdk) {
        if (sdk == null) {
            AndroidSdks.$$$reportNull$$$0(55);
        }
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        this.replaceLibraries(sdk, libraries);
    }

    @VisibleForTesting
    void replaceLibraries(@NotNull Sdk sdk, @NotNull VirtualFile[] libraries) {
        if (sdk == null) {
            AndroidSdks.$$$reportNull$$$0(56);
        }
        if (libraries == null) {
            AndroidSdks.$$$reportNull$$$0(57);
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }

    public boolean isInAndroidSdk(PsiElement element) {
        VirtualFile file = AndroidSdks.getVirtualFile(element);
        if (file == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        List entries = projectFileIndex.getOrderEntriesForFile(file);
        for (OrderEntry entry : entries) {
            Sdk sdk;
            if (!(entry instanceof JdkOrderEntry) || (sdk = ((JdkOrderEntry)entry).getJdk()) == null || !(sdk.getSdkType() instanceof AndroidSdkType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            AndroidSdks.$$$reportNull$$$0(58);
        }
        return (file = element.getContainingFile()) != null ? file.getVirtualFile() : null;
    }

    Sdk getJdk() {
        return IdeSdks.getInstance().getJdk();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/AndroidSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetHash";
                break;
            }
            case 5: 
            case 7: 
            case 53: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 23: 
            case 27: 
            case 32: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetHashString";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 20: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdk";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSdks";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRoots";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkFolder";
                break;
            }
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/AndroidSdks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToChooseSdkHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidSdkPathsFromExistingPlatforms";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAndroidSdks";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndInitialiseSdkModificator";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRootsForTarget";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformAndAddOnJars";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformPath";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseNameForNewLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPathOfSdkWithoutAddonsFolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMissingAddonsFolder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableAndroidSdk";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidSdkAdditionalData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasValidDocs";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToCreate";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setUpSdk";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAndInitialiseSdkModificator";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setUpSdkAndCommit";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findAndSetPlatformSources";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findPlatformSources";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRootsForTarget";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformAndAddOnJars";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformPath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformFolder";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addJavaDocAndSources";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findJavadocFolder";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLocalFileSystem";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findFileInJarFileSystem";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "chooseNameForNewLibrary";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidSdk";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "needsAnnotationsJarInClasspath";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "refreshLibrariesIn";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibraries";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

