/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.ui.validation.validators.PathValidator;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkPaths {
    private SdkPaths() {
    }

    @NotNull
    public static ValidationResult validateAndroidSdk(@Nullable File sdkPath, boolean includePathInMessage) {
        return SdkPaths.validatedSdkPath(sdkPath, "SDK", false, includePathInMessage);
    }

    @NotNull
    public static ValidationResult validateAndroidNdk(@Nullable File ndkPath, boolean includePathInMessage) {
        File toolchainsDirPath;
        Validator.Result result2;
        Validator.Severity severity;
        if (ndkPath != null && (severity = (result2 = PathValidator.forAndroidNdkLocation().validate(ndkPath)).getSeverity()) == Validator.Severity.ERROR) {
            ValidationResult validationResult = ValidationResult.error(result2.getMessage());
            if (validationResult == null) {
                SdkPaths.$$$reportNull$$$0(0);
            }
            return validationResult;
        }
        ValidationResult validationResult = SdkPaths.validatedSdkPath(ndkPath, "NDK", false, includePathInMessage);
        if (validationResult.success && ndkPath != null && !(toolchainsDirPath = new File(ndkPath, "toolchains")).isDirectory()) {
            String message2 = includePathInMessage ? String.format("The NDK at\n'%1$s'\ndoes not contain any toolchains.", ndkPath.getPath()) : "NDK does not contain any toolchains.";
            ValidationResult validationResult2 = ValidationResult.error(message2);
            if (validationResult2 == null) {
                SdkPaths.$$$reportNull$$$0(1);
            }
            return validationResult2;
        }
        ValidationResult validationResult3 = validationResult;
        if (validationResult3 == null) {
            SdkPaths.$$$reportNull$$$0(2);
        }
        return validationResult3;
    }

    @NotNull
    private static ValidationResult validatedSdkPath(@Nullable File sdkPath, @NotNull String sdkName, boolean checkForWritable, boolean includePathInMessage) {
        if (sdkName == null) {
            SdkPaths.$$$reportNull$$$0(3);
        }
        if (sdkPath == null) {
            ValidationResult validationResult = ValidationResult.error("");
            if (validationResult == null) {
                SdkPaths.$$$reportNull$$$0(4);
            }
            return validationResult;
        }
        String cause = null;
        if (!sdkPath.isDirectory()) {
            cause = "does not belong to a directory.";
        } else if (!sdkPath.canRead()) {
            cause = "is not readable.";
        } else if (checkForWritable && !sdkPath.canWrite()) {
            cause = "is not writable.";
        }
        if (StringUtil.isNotEmpty((String)cause)) {
            String message2 = includePathInMessage ? String.format("The path\n'%1$s'\n%2$s", sdkPath.getPath(), cause) : String.format("The path %1$s", cause);
            ValidationResult validationResult = ValidationResult.error(message2);
            if (validationResult == null) {
                SdkPaths.$$$reportNull$$$0(5);
            }
            return validationResult;
        }
        File platformsDirPath = new File(sdkPath, "platforms");
        if (!platformsDirPath.isDirectory()) {
            String message3 = includePathInMessage ? String.format("The %1$s at\n'%2$s'\ndoes not contain any platforms.", sdkName, sdkPath.getPath()) : String.format("%1$s does not contain any platforms.", sdkName);
            ValidationResult validationResult = ValidationResult.error(message3);
            if (validationResult == null) {
                SdkPaths.$$$reportNull$$$0(6);
            }
            return validationResult;
        }
        ValidationResult validationResult = ValidationResult.SUCCESS;
        if (validationResult == null) {
            SdkPaths.$$$reportNull$$$0(7);
        }
        return validationResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/SdkPaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "validateAndroidNdk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/SdkPaths";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "validatedSdkPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "validatedSdkPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ValidationResult {
        @NotNull
        public static final ValidationResult SUCCESS = new ValidationResult(true, null);
        public final boolean success;
        @Nullable
        public final String message;

        @NotNull
        static ValidationResult error(@NotNull String message2) {
            if (message2 == null) {
                ValidationResult.$$$reportNull$$$0(0);
            }
            return new ValidationResult(false, message2);
        }

        private ValidationResult(boolean success2, @Nullable String message2) {
            this.success = success2;
            this.message = message2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/sdk/SdkPaths$ValidationResult", "error"));
        }
    }
}

