/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Dependency;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerFactory;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import com.android.tools.idea.sdk.install.patch.PatchRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchInstallerUtil {
    public static final String PATCHER_PATH_PREFIX = "patcher";
    static final String PATCHES_DIR_NAME = ".patches";
    static final String PATCH_JAR_FN = "patch.jar";
    static final String PATCH_DIR_PREFIX = PatchInstallerFactory.class.getSimpleName();
    private static final String PATCH_ZIP_FN = "patch-file.zip";

    @Nullable
    static LocalPackage getDependantPatcher(@NotNull RemotePackage remote, @NotNull RepoManager mgr) {
        if (remote == null) {
            PatchInstallerUtil.$$$reportNull$$$0(0);
        }
        if (mgr == null) {
            PatchInstallerUtil.$$$reportNull$$$0(1);
        }
        for (Dependency d : remote.getAllDependencies()) {
            LocalPackage patcher;
            if (!d.getPath().startsWith("patcher;") || (patcher = (LocalPackage)mgr.getPackages().getLocalPackages().get(d.getPath())) == null) continue;
            return patcher;
        }
        return null;
    }

    @Nullable
    static LocalPackage getLatestPatcher(@NotNull RepoManager mgr) {
        if (mgr == null) {
            PatchInstallerUtil.$$$reportNull$$$0(2);
        }
        LocalPackage patcher = null;
        for (LocalPackage p : mgr.getPackages().getLocalPackagesForPrefix(PATCHER_PATH_PREFIX)) {
            if (patcher != null && PatchInstallerUtil.comparePatcherPaths(p.getPath(), patcher.getPath()) <= 0) continue;
            patcher = p;
        }
        return patcher;
    }

    static int comparePatcherPaths(@NotNull String path1, @NotNull String path2) {
        if (path1 == null) {
            PatchInstallerUtil.$$$reportNull$$$0(3);
        }
        if (path2 == null) {
            PatchInstallerUtil.$$$reportNull$$$0(4);
        }
        int v1 = -1;
        int v2 = -1;
        try {
            v1 = Integer.parseInt(path1.substring(path1.lastIndexOf(118) + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            v2 = Integer.parseInt(path2.substring(path2.lastIndexOf(118) + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Integer.compare(v1, v2);
    }

    static boolean installPatch(@NotNull PatchOperation op, @Nullable File patch, @NotNull FileOp fop, @NotNull ProgressIndicator progress) {
        boolean result2;
        if (op == null) {
            PatchInstallerUtil.$$$reportNull$$$0(5);
        }
        if (fop == null) {
            PatchInstallerUtil.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            PatchInstallerUtil.$$$reportNull$$$0(7);
        }
        if (patch == null) {
            return false;
        }
        LocalPackage patcherPackage = op.getPatcher(progress);
        if (patcherPackage == null) {
            return false;
        }
        PatchRunner patcher = new PatchRunner.DefaultFactory().getPatchRunner(patcherPackage, progress, fop);
        if (patcher == null) {
            return false;
        }
        fop.deleteFileOrFolder(new File(op.getLocation(progress), ".installer"));
        File tempPath = patch.getParentFile();
        File existingPackageXml = new File(op.getLocation(progress), "package.xml");
        File tempPackageXml = new File(tempPath, "package.xml");
        fop.renameTo(existingPackageXml, tempPackageXml);
        try {
            result2 = patcher.run(op.getLocation(progress), patch, progress);
        }
        catch (PatchRunner.RestartRequiredException e) {
            PatchInstallerUtil.askAboutRestart(patcher, op, patch, fop, progress);
            result2 = false;
        }
        if (!result2) {
            fop.renameTo(tempPackageXml, existingPackageXml);
            return false;
        }
        progress.logInfo("Done");
        return true;
    }

    private static void askAboutRestart(@NotNull PatchRunner patchRunner, @NotNull PatchOperation op, @NotNull File patchFile, @NotNull FileOp fop, @NotNull ProgressIndicator progress) {
        if (patchRunner == null) {
            PatchInstallerUtil.$$$reportNull$$$0(8);
        }
        if (op == null) {
            PatchInstallerUtil.$$$reportNull$$$0(9);
        }
        if (patchFile == null) {
            PatchInstallerUtil.$$$reportNull$$$0(10);
        }
        if (fop == null) {
            PatchInstallerUtil.$$$reportNull$$$0(11);
        }
        if (progress == null) {
            PatchInstallerUtil.$$$reportNull$$$0(12);
        }
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.invokeLater(() -> {
            ApplicationNamesInfo names = ApplicationNamesInfo.getInstance();
            boolean restartable = application.isRestartCapable();
            String[] options = restartable ? new String[]{"Cancel", "Restart Later", "Restart Now"} : new String[]{"Cancel", String.format("Exit %s", names.getProductName())};
            String message2 = op.getExisting() != null ? String.format("%1$s is currently in use by %2$s and cannot be updated. Please restart to complete installation.", op.getExisting().getDisplayName(), names.getFullProductName()) : String.format("Some files in the destination are currently in use by %1$s. Please restart to complete installation.", names.getFullProductName());
            int result2 = Messages.showDialog((Project)null, (String)message2, (String)"Restart Required", (String[])options, (int)(options.length - 1), (Icon)AllIcons.General.QuestionDialog);
            if (result2 == 0) {
                progress.logInfo("Cancelled");
            } else if (PatchInstallerUtil.setupPatchDir(patchFile, patchRunner.getPatcherJar(), op.getPackage(), op.getRepoManager(), fop, progress)) {
                if (result2 == 1 && restartable) {
                    progress.logInfo("Installation will continue after restart");
                } else {
                    application.exit(true, true);
                }
            }
        }, ModalityState.any());
    }

    private static boolean setupPatchDir(@NotNull File patchFile, @NotNull File patcherFile, @NotNull RepoPackage toInstallOrDelete, @NotNull RepoManager mgr, @NotNull FileOp fop, @NotNull ProgressIndicator progress) {
        File patchDir;
        if (patchFile == null) {
            PatchInstallerUtil.$$$reportNull$$$0(13);
        }
        if (patcherFile == null) {
            PatchInstallerUtil.$$$reportNull$$$0(14);
        }
        if (toInstallOrDelete == null) {
            PatchInstallerUtil.$$$reportNull$$$0(15);
        }
        if (mgr == null) {
            PatchInstallerUtil.$$$reportNull$$$0(16);
        }
        if (fop == null) {
            PatchInstallerUtil.$$$reportNull$$$0(17);
        }
        if (progress == null) {
            PatchInstallerUtil.$$$reportNull$$$0(18);
        }
        File patchesDir = new File(mgr.getLocalPath(), PATCHES_DIR_NAME);
        int i2 = 1;
        while (true) {
            if (!fop.exists(patchDir = new File(patchesDir, PATCH_DIR_PREFIX + i2))) break;
            ++i2;
        }
        fop.mkdirs(patchDir);
        try {
            File completePatch = new File(patchDir, PATCH_JAR_FN);
            fop.copyFile(patcherFile, completePatch);
            try (FileSystem completeFs = FileSystems.newFileSystem(URI.create("jar:" + completePatch.toURI()), new HashMap());
                 FileSystem patchFs = FileSystems.newFileSystem(URI.create("jar:" + patchFile.toURI()), new HashMap());){
                Files.copy(patchFs.getPath(PATCH_ZIP_FN, new String[0]), completeFs.getPath(PATCH_ZIP_FN, new String[0]), new CopyOption[0]);
            }
            InstallerUtil.writePendingPackageXml((RepoPackage)toInstallOrDelete, (File)patchDir, (RepoManager)mgr, (FileOp)fop, (ProgressIndicator)progress);
        }
        catch (IOException e) {
            progress.logWarning("Error while setting up patch.", (Throwable)e);
            return false;
        }
        return true;
    }

    public static File generatePatch(PatchOperation patchOp, File destDir, FileOp fop, ProgressIndicator progress) {
        LocalPackage patcher = patchOp.getPatcher(progress.createSubProgress(0.1));
        progress.setFraction(0.1);
        if (patcher == null) {
            return null;
        }
        PatchRunner runner = new PatchRunner.DefaultFactory().getPatchRunner(patcher, progress, fop);
        if (runner == null) {
            return null;
        }
        LocalPackage existing2 = patchOp.getExisting();
        File existingRoot = existing2 == null ? null : existing2.getLocation();
        String existingDescription = existing2 == null ? "None" : existing2.getDisplayName() + " Version " + existing2.getVersion();
        String description = patchOp.getNewVersionName();
        File destination = new File(destDir, PATCH_JAR_FN);
        File newFilesRoot = patchOp.getNewFilesRoot();
        if (runner.generatePatch(existingRoot, newFilesRoot, existingDescription, description, destination, progress.createSubProgress(1.0))) {
            progress.setFraction(1.0);
            return destination;
        }
        progress.setFraction(1.0);
        return null;
    }

    @Nullable
    public static PackageOperation getInProgressDependantPatcherInstall(@NotNull RemotePackage remote, @NotNull RepoManager mgr) {
        if (remote == null) {
            PatchInstallerUtil.$$$reportNull$$$0(19);
        }
        if (mgr == null) {
            PatchInstallerUtil.$$$reportNull$$$0(20);
        }
        Map remotePackages = mgr.getPackages().getRemotePackages();
        for (Dependency dependency : remote.getAllDependencies()) {
            PackageOperation inProgress;
            RemotePackage remotePatcher;
            if (!dependency.getPath().startsWith("patcher;") || (remotePatcher = (RemotePackage)remotePackages.get(dependency.getPath())) == null || (inProgress = mgr.getInProgressInstallOperation((RepoPackage)remotePatcher)) == null || inProgress.getInstallStatus() == PackageOperation.InstallStatus.FAILED) continue;
            return inProgress;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 1: 
            case 2: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mgr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchRunner";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcherFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInstallOrDelete";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/sdk/install/patch/PatchInstallerUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependantPatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLatestPatcher";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "comparePatcherPaths";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "installPatch";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "askAboutRestart";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "setupPatchDir";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getInProgressDependantPatcherInstall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

