/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.appinspection.api.AppInspectorClient;
import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.device.fs.DeviceFileDownloaderService;
import com.android.tools.idea.device.fs.DeviceFileId;
import com.android.tools.idea.device.fs.DownloadProgress;
import com.android.tools.idea.device.fs.DownloadedFileData;
import com.android.tools.idea.sqlite.DatabaseInspectorProjectService;
import com.android.tools.idea.sqlite.DatabaseInspectorProjectServiceImpl;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorController;
import com.android.tools.idea.sqlite.controllers.DatabaseInspectorControllerImpl;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnectionFactory;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnectionFactoryImpl;
import com.android.tools.idea.sqlite.model.FileSqliteDatabase;
import com.android.tools.idea.sqlite.model.LiveSqliteDatabase;
import com.android.tools.idea.sqlite.model.SqliteDatabase;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.ui.DatabaseInspectorViewsFactory;
import com.android.tools.idea.sqlite.ui.DatabaseInspectorViewsFactoryImpl;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001>B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nBq\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\"H\u0017J\b\u0010)\u001a\u00020*H\u0017J&\u0010+\u001a\b\u0012\u0004\u0012\u00020(0,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0017J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020(0,2\u0006\u00103\u001a\u00020\u0011H\u0017J\u001c\u00104\u001a\b\u0012\u0004\u0012\u00020(0,2\f\u00105\u001a\b\u0012\u0004\u0012\u00020(0,H\u0002J\u001e\u00106\u001a\b\u0012\u0004\u0012\u0002070,2\u0006\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020:H\u0017J\u0018\u0010;\u001a\u0002072\u0006\u00108\u001a\u00020(2\u0006\u0010<\u001a\u00020=H\u0017R\u001b\u0010\u0018\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001e\u001a&\u0012\f\u0012\n !*\u0004\u0018\u00010 0  !*\u0012\u0012\f\u0012\n !*\u0004\u0018\u00010 0 \u0018\u00010\"0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020$8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010\u0006\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/tools/idea/sqlite/DatabaseInspectorProjectServiceImpl;", "Lcom/android/tools/idea/sqlite/DatabaseInspectorProjectService;", "project", "Lcom/intellij/openapi/project/Project;", "edtExecutor", "Ljava/util/concurrent/Executor;", "taskExecutor", "viewFactory", "Lcom/android/tools/idea/sqlite/ui/DatabaseInspectorViewsFactory;", "(Lcom/intellij/openapi/project/Project;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Lcom/android/tools/idea/sqlite/ui/DatabaseInspectorViewsFactory;)V", "(Lcom/intellij/openapi/project/Project;)V", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "databaseConnectionFactory", "Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnectionFactory;", "fileOpener", "Ljava/util/function/Consumer;", "Lcom/intellij/openapi/vfs/VirtualFile;", "model", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$Model;", "createController", "Lkotlin/Function1;", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindowManager;Ljava/util/concurrent/Executor;Ljava/util/concurrent/Executor;Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnectionFactory;Ljava/util/function/Consumer;Lcom/android/tools/idea/sqlite/ui/DatabaseInspectorViewsFactory;Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$Model;Lkotlin/jvm/functions/Function1;)V", "controller", "getController", "()Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController;", "controller$delegate", "Lkotlin/Lazy;", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "openFileSqliteDatabases", "", "Lcom/android/tools/idea/sqlite/model/FileSqliteDatabase;", "kotlin.jvm.PlatformType", "", "sqliteInspectorComponent", "Ljavax/swing/JComponent;", "getSqliteInspectorComponent", "()Ljavax/swing/JComponent;", "getOpenDatabases", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "hasOpenDatabase", "", "openSqliteDatabase", "Lcom/google/common/util/concurrent/ListenableFuture;", "messenger", "Lcom/android/tools/idea/appinspection/api/AppInspectorClient$CommandMessenger;", "id", "", "name", "", "file", "openSqliteDatabaseInInspector", "databaseFuture", "reDownloadAndOpenFile", "", "database", "progress", "Lcom/android/tools/idea/device/fs/DownloadProgress;", "runSqliteStatement", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "ModelImpl", "intellij.android.debuggers"})
public final class DatabaseInspectorProjectServiceImpl
implements DatabaseInspectorProjectService {
    private final FutureCallbackExecutor edtExecutor;
    private final FutureCallbackExecutor taskExecutor;
    private final Set<FileSqliteDatabase> openFileSqliteDatabases;
    private final Lazy controller$delegate;
    private final Project project;
    private final ToolWindowManager toolWindowManager;
    private final DatabaseConnectionFactory databaseConnectionFactory;
    private final Consumer<VirtualFile> fileOpener;
    private final DatabaseInspectorViewsFactory viewFactory;
    private final DatabaseInspectorController.Model model;
    private final Function1<DatabaseInspectorController.Model, DatabaseInspectorController> createController;

    private final DatabaseInspectorController getController() {
        Lazy lazy = this.controller$delegate;
        DatabaseInspectorProjectServiceImpl databaseInspectorProjectServiceImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DatabaseInspectorController)lazy.getValue();
    }

    @Override
    @UiThread
    @NotNull
    public JComponent getSqliteInspectorComponent() {
        return this.getController().getComponent();
    }

    @Override
    @AnyThread
    @NotNull
    public ListenableFuture<SqliteDatabase> openSqliteDatabase(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ListenableFuture<DatabaseConnection> databaseConnectionFuture = this.databaseConnectionFactory.getDatabaseConnection(file, this.taskExecutor);
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        String string2 = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)string, (String[])new String[]{"data/data/"}, (boolean)false, (int)0, (int)6, null), (int)1);
        if (string2 == null || (string2 = StringsKt.replace$default((String)string2, (String)"databases/", (String)"", (boolean)false, (int)4, null)) == null) {
            String string3 = file.getPath();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
        }
        String name = string2;
        ListenableFuture listenableFuture = this.taskExecutor.transform(databaseConnectionFuture, (FutureCallbackExecutor.ThrowableFunction)new FutureCallbackExecutor.ThrowableFunction<DatabaseConnection, SqliteDatabase>(name, file){
            final /* synthetic */ String $name;
            final /* synthetic */ VirtualFile $file;

            public final SqliteDatabase apply(DatabaseConnection databaseConnection) {
                DatabaseConnection databaseConnection2 = databaseConnection;
                Intrinsics.checkNotNullExpressionValue((Object)databaseConnection2, (String)"databaseConnection");
                return new FileSqliteDatabase(this.$name, databaseConnection2, this.$file);
            }
            {
                this.$name = string;
                this.$file = virtualFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"taskExecutor.transform(d\u2026seConnection, file)\n    }");
        ListenableFuture databaseFuture2 = listenableFuture;
        return this.openSqliteDatabaseInInspector((ListenableFuture<SqliteDatabase>)databaseFuture2);
    }

    @Override
    @AnyThread
    @NotNull
    public ListenableFuture<SqliteDatabase> openSqliteDatabase(@NotNull AppInspectorClient.CommandMessenger messenger, int id, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)messenger, (String)"messenger");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ListenableFuture<DatabaseConnection> databaseConnectionFuture = this.databaseConnectionFactory.getLiveDatabaseConnection(messenger, id, this.taskExecutor);
        ListenableFuture listenableFuture = this.taskExecutor.transform(databaseConnectionFuture, (FutureCallbackExecutor.ThrowableFunction)new FutureCallbackExecutor.ThrowableFunction<DatabaseConnection, SqliteDatabase>(name){
            final /* synthetic */ String $name;

            public final SqliteDatabase apply(DatabaseConnection databaseConnection) {
                DatabaseConnection databaseConnection2 = databaseConnection;
                Intrinsics.checkNotNullExpressionValue((Object)databaseConnection2, (String)"databaseConnection");
                return new LiveSqliteDatabase(this.$name, databaseConnection2);
            }
            {
                this.$name = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"taskExecutor.transform(d\u2026databaseConnection)\n    }");
        ListenableFuture databaseFuture2 = listenableFuture;
        return this.openSqliteDatabaseInInspector((ListenableFuture<SqliteDatabase>)databaseFuture2);
    }

    private final ListenableFuture<SqliteDatabase> openSqliteDatabaseInInspector(ListenableFuture<SqliteDatabase> databaseFuture2) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, databaseFuture2){
            final /* synthetic */ DatabaseInspectorProjectServiceImpl this$0;
            final /* synthetic */ ListenableFuture $databaseFuture;

            public final void run() {
                block0: {
                    ToolWindow toolWindow = DatabaseInspectorProjectServiceImpl.access$getToolWindowManager$p(this.this$0).getToolWindow("Database Inspector");
                    if (toolWindow == null) break block0;
                    toolWindow.show(new Runnable(this){
                        final /* synthetic */ openSqliteDatabaseInInspector.1 this$0;

                        public final void run() {
                            DatabaseInspectorProjectServiceImpl.access$getController$p(this.this$0.this$0).addSqliteDatabase((ListenableFuture<SqliteDatabase>)this.this$0.$databaseFuture);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = databaseInspectorProjectServiceImpl;
                this.$databaseFuture = listenableFuture;
            }
        });
        return databaseFuture2;
    }

    @Override
    @UiThread
    public void runSqliteStatement(@NotNull SqliteDatabase database, @NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        this.getController().runSqlStatement(database, sqliteStatement);
    }

    @Override
    @AnyThread
    @NotNull
    public ListenableFuture<Unit> reDownloadAndOpenFile(@NotNull FileSqliteDatabase database, @NotNull DownloadProgress progress) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        DeviceFileId deviceFileId = DeviceFileId.Companion.fromVirtualFile(database.getVirtualFile());
        if (deviceFileId == null) {
            ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new IllegalStateException("DeviceFileId not found"));
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFailedF\u2026DeviceFileId not found\"))");
            return listenableFuture;
        }
        DeviceFileId deviceFileId2 = deviceFileId;
        ListenableFuture<DownloadedFileData> downloadFuture2 = DeviceFileDownloaderService.Companion.getInstance(this.project).downloadFile(deviceFileId2, progress);
        ListenableFuture listenableFuture = this.edtExecutor.transform(downloadFuture2, (FutureCallbackExecutor.ThrowableFunction)new FutureCallbackExecutor.ThrowableFunction<DownloadedFileData, Unit>(this){
            final /* synthetic */ DatabaseInspectorProjectServiceImpl this$0;

            public final void apply(DownloadedFileData downloadedFileData) {
                DatabaseInspectorProjectServiceImpl.access$getFileOpener$p(this.this$0).accept(downloadedFileData.getVirtualFile());
            }
            {
                this.this$0 = databaseInspectorProjectServiceImpl;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"edtExecutor.transform(do\u2026   return@transform\n    }");
        return listenableFuture;
    }

    @Override
    @AnyThread
    public boolean hasOpenDatabase() {
        Map map2 = this.model.getOpenDatabases();
        boolean bl = false;
        return !map2.isEmpty();
    }

    @Override
    @AnyThread
    @NotNull
    public Set<SqliteDatabase> getOpenDatabases() {
        Set<SqliteDatabase> set = this.model.getOpenDatabases().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"model.openDatabases.keys");
        return set;
    }

    @NonInjectable
    @TestOnly
    public DatabaseInspectorProjectServiceImpl(@NotNull Project project, @NotNull ToolWindowManager toolWindowManager, @NotNull Executor edtExecutor, @NotNull Executor taskExecutor, @NotNull DatabaseConnectionFactory databaseConnectionFactory, @NotNull Consumer<VirtualFile> fileOpener, @NotNull DatabaseInspectorViewsFactory viewFactory, @NotNull DatabaseInspectorController.Model model2, @NotNull Function1<? super DatabaseInspectorController.Model, ? extends DatabaseInspectorController> createController) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        Intrinsics.checkNotNullParameter((Object)edtExecutor, (String)"edtExecutor");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)databaseConnectionFactory, (String)"databaseConnectionFactory");
        Intrinsics.checkNotNullParameter(fileOpener, (String)"fileOpener");
        Intrinsics.checkNotNullParameter((Object)viewFactory, (String)"viewFactory");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter(createController, (String)"createController");
        this.project = project;
        this.toolWindowManager = toolWindowManager;
        this.databaseConnectionFactory = databaseConnectionFactory;
        this.fileOpener = fileOpener;
        this.viewFactory = viewFactory;
        this.model = model2;
        this.createController = createController;
        FutureCallbackExecutor futureCallbackExecutor = FutureCallbackExecutor.wrap((Executor)edtExecutor);
        Intrinsics.checkNotNullExpressionValue((Object)futureCallbackExecutor, (String)"FutureCallbackExecutor.wrap(edtExecutor)");
        this.edtExecutor = futureCallbackExecutor;
        FutureCallbackExecutor futureCallbackExecutor2 = FutureCallbackExecutor.wrap((Executor)taskExecutor);
        Intrinsics.checkNotNullExpressionValue((Object)futureCallbackExecutor2, (String)"FutureCallbackExecutor.wrap(taskExecutor)");
        this.taskExecutor = futureCallbackExecutor2;
        this.openFileSqliteDatabases = Sets.newConcurrentHashSet();
        this.controller$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DatabaseInspectorController>(this){
            final /* synthetic */ DatabaseInspectorProjectServiceImpl this$0;

            @UiThread
            @NotNull
            public final DatabaseInspectorController invoke() {
                ApplicationManager.getApplication().assertIsDispatchThread();
                return (DatabaseInspectorController)DatabaseInspectorProjectServiceImpl.access$getCreateController$p(this.this$0).invoke((Object)DatabaseInspectorProjectServiceImpl.access$getModel$p(this.this$0));
            }
            {
                this.this$0 = databaseInspectorProjectServiceImpl;
                super(0);
            }
        }));
        this.model.addListener(new DatabaseInspectorController.Model.Listener(){

            @Override
            public void onDatabaseAdded(@NotNull SqliteDatabase database) {
                Intrinsics.checkNotNullParameter((Object)database, (String)"database");
                if (database instanceof FileSqliteDatabase) {
                    openFileSqliteDatabases.add(database);
                }
            }

            @Override
            public void onDatabaseRemoved(@NotNull SqliteDatabase database) {
                Intrinsics.checkNotNullParameter((Object)database, (String)"database");
                if (database instanceof FileSqliteDatabase) {
                    openFileSqliteDatabases.remove(database);
                }
            }
        });
        BulkFileListener virtualFileListener2 = new BulkFileListener(this){
            final /* synthetic */ DatabaseInspectorProjectServiceImpl this$0;

            public void before(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                if (DatabaseInspectorProjectServiceImpl.access$getOpenFileSqliteDatabases$p(this.this$0).isEmpty()) {
                    return;
                }
                boolean bl = false;
                List toClose = new ArrayList<E>();
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    for (FileSqliteDatabase database : DatabaseInspectorProjectServiceImpl.access$getOpenFileSqliteDatabases$p(this.this$0)) {
                        if (!VfsUtil.isAncestor((VirtualFile)((VFileDeleteEvent)vFileEvent).getFile(), (VirtualFile)database.getVirtualFile(), (boolean)false)) continue;
                        FileSqliteDatabase fileSqliteDatabase = database;
                        Intrinsics.checkNotNullExpressionValue((Object)fileSqliteDatabase, (String)"database");
                        toClose.add(fileSqliteDatabase);
                    }
                }
                Iterable iterable = toClose;
                boolean $i$f$forEach = false;
                for (T element$iv : iterable) {
                    SqliteDatabase it = (SqliteDatabase)element$iv;
                    boolean bl2 = false;
                    DatabaseInspectorProjectServiceImpl.access$getController$p(this.this$0).closeDatabase(it);
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(project)");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        messageBusConnection2.subscribe(VirtualFileManager.VFS_CHANGES, (Object)virtualFileListener2);
    }

    public /* synthetic */ DatabaseInspectorProjectServiceImpl(final Project project, ToolWindowManager toolWindowManager, final Executor executor, final Executor executor2, DatabaseConnectionFactory databaseConnectionFactory, Consumer consumer, final DatabaseInspectorViewsFactory databaseInspectorViewsFactory, DatabaseInspectorController.Model model2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        }
        if ((n & 4) != 0) {
            EdtExecutorService edtExecutorService = EdtExecutorService.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)edtExecutorService, (String)"EdtExecutorService.getInstance()");
            executor = (Executor)edtExecutorService;
        }
        if ((n & 8) != 0) {
            ExecutorService executorService = PooledThreadExecutor.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"PooledThreadExecutor.INSTANCE");
            executor2 = executorService;
        }
        if ((n & 0x10) != 0) {
            databaseConnectionFactory = new DatabaseConnectionFactoryImpl();
        }
        if ((n & 0x20) != 0) {
            consumer = new Consumer<VirtualFile>(){

                @Override
                public final void accept(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    OpenFileAction.openFile((VirtualFile)it, (Project)project);
                }
            };
        }
        if ((n & 0x40) != 0) {
            databaseInspectorViewsFactory = new DatabaseInspectorViewsFactoryImpl();
        }
        if ((n & 0x80) != 0) {
            model2 = new ModelImpl();
        }
        if ((n & 0x100) != 0) {
            function1 = (Function1)new Function1<DatabaseInspectorController.Model, DatabaseInspectorControllerImpl>(){

                @NotNull
                public final DatabaseInspectorControllerImpl invoke(@NotNull DatabaseInspectorController.Model myModel) {
                    Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
                    DatabaseInspectorControllerImpl databaseInspectorControllerImpl = new DatabaseInspectorControllerImpl(project, myModel, databaseInspectorViewsFactory, executor, executor2);
                    boolean bl = false;
                    boolean bl2 = false;
                    DatabaseInspectorControllerImpl it = databaseInspectorControllerImpl;
                    boolean bl3 = false;
                    it.setUp();
                    Disposer.register((Disposable)((Disposable)project), (Disposable)it);
                    return databaseInspectorControllerImpl;
                }
            };
        }
        this(project, toolWindowManager, executor, executor2, databaseConnectionFactory, consumer, databaseInspectorViewsFactory, model2, (Function1<? super DatabaseInspectorController.Model, ? extends DatabaseInspectorController>)function1);
    }

    @NonInjectable
    @TestOnly
    public DatabaseInspectorProjectServiceImpl(final @NotNull Project project, final @NotNull Executor edtExecutor, final @NotNull Executor taskExecutor, final @NotNull DatabaseInspectorViewsFactory viewFactory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)edtExecutor, (String)"edtExecutor");
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)viewFactory, (String)"viewFactory");
        this(project, ToolWindowManager.Companion.getInstance(project), edtExecutor, taskExecutor, new DatabaseConnectionFactoryImpl(), new Consumer<VirtualFile>(){

            @Override
            public final void accept(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                OpenFileAction.openFile((VirtualFile)it, (Project)project);
            }
        }, viewFactory, new ModelImpl(), (Function1<? super DatabaseInspectorController.Model, ? extends DatabaseInspectorController>)((Function1)new Function1<DatabaseInspectorController.Model, DatabaseInspectorController>(){

            @NotNull
            public final DatabaseInspectorController invoke(@NotNull DatabaseInspectorController.Model myModel) {
                Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
                DatabaseInspectorControllerImpl databaseInspectorControllerImpl = new DatabaseInspectorControllerImpl(project, myModel, viewFactory, edtExecutor, taskExecutor);
                boolean bl = false;
                boolean bl2 = false;
                DatabaseInspectorControllerImpl it = databaseInspectorControllerImpl;
                boolean bl3 = false;
                it.setUp();
                Disposer.register((Disposable)((Disposable)project), (Disposable)it);
                return databaseInspectorControllerImpl;
            }
        }));
    }

    public DatabaseInspectorProjectServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EdtExecutorService edtExecutorService = EdtExecutorService.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)edtExecutorService, (String)"EdtExecutorService.getInstance()");
        Executor executor = (Executor)edtExecutorService;
        ExecutorService executorService = PooledThreadExecutor.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"PooledThreadExecutor.INSTANCE");
        this(project, executor, executorService, new DatabaseInspectorViewsFactoryImpl());
    }

    public static final /* synthetic */ ToolWindowManager access$getToolWindowManager$p(DatabaseInspectorProjectServiceImpl $this) {
        return $this.toolWindowManager;
    }

    public static final /* synthetic */ DatabaseInspectorController access$getController$p(DatabaseInspectorProjectServiceImpl $this) {
        return $this.getController();
    }

    public static final /* synthetic */ Consumer access$getFileOpener$p(DatabaseInspectorProjectServiceImpl $this) {
        return $this.fileOpener;
    }

    public static final /* synthetic */ Function1 access$getCreateController$p(DatabaseInspectorProjectServiceImpl $this) {
        return $this.createController;
    }

    public static final /* synthetic */ DatabaseInspectorController.Model access$getModel$p(DatabaseInspectorProjectServiceImpl $this) {
        return $this.model;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000bH\u0017J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\nH\u0017J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0017J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/sqlite/DatabaseInspectorProjectServiceImpl$ModelImpl;", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$Model;", "()V", "listeners", "", "Lcom/android/tools/idea/sqlite/controllers/DatabaseInspectorController$Model$Listener;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "openDatabases", "Ljava/util/TreeMap;", "Lcom/android/tools/idea/sqlite/model/SqliteDatabase;", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "getOpenDatabases", "()Ljava/util/TreeMap;", "add", "", "database", "sqliteSchema", "addListener", "modelListener", "getSortedIndexOf", "", "remove", "removeListener", "intellij.android.debuggers"})
    private static final class ModelImpl
    implements DatabaseInspectorController.Model {
        private final ReentrantLock lock = new ReentrantLock();
        private final List<DatabaseInspectorController.Model.Listener> listeners;
        @NotNull
        private final TreeMap<SqliteDatabase, SqliteSchema> openDatabases;

        @Override
        @NotNull
        public TreeMap<SqliteDatabase, SqliteSchema> getOpenDatabases() {
            return this.openDatabases;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @AnyThread
        public int getSortedIndexOf(@NotNull SqliteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Lock lock = this.lock;
            boolean bl = false;
            int n = 0;
            lock.lock();
            try {
                boolean bl2 = false;
                n = this.getOpenDatabases().headMap(database).size();
            }
            finally {
                lock.unlock();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @AnyThread
        public void add(@NotNull SqliteDatabase database, @NotNull SqliteSchema sqliteSchema) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)sqliteSchema, (String)"sqliteSchema");
            Lock lock = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            lock.lock();
            try {
                boolean bl3 = false;
                ((Map)this.getOpenDatabases()).put(database, sqliteSchema);
                Iterable $this$forEach$iv = this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DatabaseInspectorController.Model.Listener it = (DatabaseInspectorController.Model.Listener)element$iv;
                    boolean bl4 = false;
                    it.onDatabaseAdded(database);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @AnyThread
        public void remove(@NotNull SqliteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Lock lock = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            lock.lock();
            try {
                boolean bl3 = false;
                this.getOpenDatabases().remove(database);
                Iterable $this$forEach$iv = this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DatabaseInspectorController.Model.Listener it = (DatabaseInspectorController.Model.Listener)element$iv;
                    boolean bl4 = false;
                    it.onDatabaseRemoved(database);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(@NotNull DatabaseInspectorController.Model.Listener modelListener) {
            Intrinsics.checkNotNullParameter((Object)modelListener, (String)"modelListener");
            Lock lock = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            lock.lock();
            try {
                boolean bl3 = false;
                this.listeners.add(modelListener);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(@NotNull DatabaseInspectorController.Model.Listener modelListener) {
            Intrinsics.checkNotNullParameter((Object)modelListener, (String)"modelListener");
            Lock lock = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            lock.lock();
            try {
                boolean bl3 = false;
                this.listeners.remove(modelListener);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        public ModelImpl() {
            boolean bl = false;
            this.listeners = new ArrayList();
            this.openDatabases = new TreeMap(Comparator.comparing(openDatabases.1.INSTANCE));
        }
    }
}

