/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.jdbc;

import com.android.tools.idea.concurrency.FutureCallbackExecutor;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcUtilsKt;
import com.android.tools.idea.sqlite.model.RowIdName;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcDatabaseConnection;", "Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnection;", "connection", "Ljava/sql/Connection;", "sqliteFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "pooledExecutor", "Ljava/util/concurrent/Executor;", "(Ljava/sql/Connection;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/concurrent/Executor;)V", "sequentialTaskExecutor", "Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "getSequentialTaskExecutor", "()Lcom/android/tools/idea/concurrency/FutureCallbackExecutor;", "close", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "execute", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "readColumnDefinitions", "", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "tableName", "", "readSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "Companion", "intellij.android.debuggers"})
public final class JdbcDatabaseConnection
implements DatabaseConnection {
    @NotNull
    private final FutureCallbackExecutor sequentialTaskExecutor;
    private final Connection connection;
    private final VirtualFile sqliteFile;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final FutureCallbackExecutor getSequentialTaskExecutor() {
        return this.sequentialTaskExecutor;
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> close() {
        ListenableFuture listenableFuture = this.sequentialTaskExecutor.executeAsync((Callable)new Callable<Unit>(this){
            final /* synthetic */ JdbcDatabaseConnection this$0;

            public final void call() {
                JdbcDatabaseConnection.access$getConnection$p(this.this$0).close();
                JdbcDatabaseConnection.access$getLogger$cp().info("Successfully closed database: " + JdbcDatabaseConnection.access$getSqliteFile$p(this.this$0).getPath());
            }
            {
                this.this$0 = jdbcDatabaseConnection;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"sequentialTaskExecutor.e\u2026 ${sqliteFile.path}\")\n  }");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteSchema> readSchema() {
        ListenableFuture listenableFuture = this.sequentialTaskExecutor.executeAsync((Callable)new Callable<SqliteSchema>(this){
            final /* synthetic */ JdbcDatabaseConnection this$0;

            public final SqliteSchema call() {
                ResultSet tables = JdbcDatabaseConnection.access$getConnection$p(this.this$0).getMetaData().getTables(null, null, null, null);
                boolean bl = false;
                List sqliteTables = new ArrayList<E>();
                while (tables.next()) {
                    RowIdName rowIdName;
                    boolean bl2;
                    List columns2;
                    block19: {
                        Connection connection = JdbcDatabaseConnection.access$getConnection$p(this.this$0);
                        String string = tables.getString("TABLE_NAME");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tables.getString(\"TABLE_NAME\")");
                        columns2 = JdbcDatabaseConnection.access$readColumnDefinitions(this.this$0, connection, string);
                        Iterable $this$any$iv = columns2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                SqliteColumn it = (SqliteColumn)element$iv;
                                boolean bl3 = false;
                                if (!(it.getInPrimaryKey() && it.getType() == JDBCType.INTEGER)) continue;
                                bl2 = true;
                                break block19;
                            }
                            bl2 = false;
                        }
                    }
                    boolean hasIntegerPrimaryKey = bl2;
                    if (hasIntegerPrimaryKey) {
                        rowIdName = null;
                    } else {
                        boolean bl4;
                        boolean $i$f$none;
                        Iterable $this$none$iv;
                        block20: {
                            $this$none$iv = columns2;
                            $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl4 = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    SqliteColumn it = (SqliteColumn)element$iv;
                                    boolean bl5 = false;
                                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)RowIdName._ROWID_.getStringName())) continue;
                                    bl4 = false;
                                    break block20;
                                }
                                bl4 = true;
                            }
                        }
                        if (bl4) {
                            rowIdName = RowIdName._ROWID_;
                        } else {
                            boolean bl6;
                            block21: {
                                $this$none$iv = columns2;
                                $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl6 = true;
                                } else {
                                    for (T element$iv : $this$none$iv) {
                                        SqliteColumn it = (SqliteColumn)element$iv;
                                        boolean bl7 = false;
                                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)RowIdName.ROWID.getStringName())) continue;
                                        bl6 = false;
                                        break block21;
                                    }
                                    bl6 = true;
                                }
                            }
                            if (bl6) {
                                rowIdName = RowIdName.ROWID;
                            } else {
                                boolean bl8;
                                block22: {
                                    $this$none$iv = columns2;
                                    $i$f$none = false;
                                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                        bl8 = true;
                                    } else {
                                        for (T element$iv : $this$none$iv) {
                                            SqliteColumn it = (SqliteColumn)element$iv;
                                            boolean bl9 = false;
                                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)RowIdName.OID.getStringName())) continue;
                                            bl8 = false;
                                            break block22;
                                        }
                                        bl8 = true;
                                    }
                                }
                                rowIdName = bl8 ? RowIdName.OID : null;
                            }
                        }
                    }
                    RowIdName rowIdName2 = rowIdName;
                    String string = tables.getString("TABLE_NAME");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tables.getString(\"TABLE_NAME\")");
                    sqliteTables.add(new SqliteTable(string, columns2, rowIdName2, Intrinsics.areEqual((Object)tables.getString("TABLE_TYPE"), (Object)"VIEW")));
                }
                SqliteSchema sqliteSchema = new SqliteSchema(sqliteTables);
                boolean bl10 = false;
                boolean bl11 = false;
                SqliteSchema $this$apply = sqliteSchema;
                boolean bl12 = false;
                JdbcDatabaseConnection.access$getLogger$cp().info("Successfully read database schema: " + JdbcDatabaseConnection.access$getSqliteFile$p(this.this$0).getPath());
                return sqliteSchema;
            }
            {
                this.this$0 = jdbcDatabaseConnection;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"sequentialTaskExecutor.e\u2026{sqliteFile.path}\") }\n  }");
        return listenableFuture;
    }

    private final List<SqliteColumn> readColumnDefinitions(Connection connection, String tableName) {
        ResultSet columnsSet = connection.getMetaData().getColumns(null, null, tableName, null);
        List<String> keyColumnsNames = JdbcUtilsKt.getColumnNamesInPrimaryKey(connection, tableName);
        ResultSet resultSet = columnsSet;
        Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"columnsSet");
        return SequencesKt.toList(JdbcUtilsKt.map(resultSet, (Function1)new Function1<ResultSet, SqliteColumn>(columnsSet, keyColumnsNames){
            final /* synthetic */ ResultSet $columnsSet;
            final /* synthetic */ List $keyColumnsNames;

            @NotNull
            public final SqliteColumn invoke(@NotNull ResultSet $this$map) {
                String columnName;
                Intrinsics.checkNotNullParameter((Object)$this$map, (String)"$receiver");
                String string = columnName = this.$columnsSet.getString("COLUMN_NAME");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"columnName");
                JDBCType jDBCType = JDBCType.valueOf(this.$columnsSet.getInt("DATA_TYPE"));
                Intrinsics.checkNotNullExpressionValue((Object)jDBCType, (String)"JDBCType.valueOf(columnsSet.getInt(\"DATA_TYPE\"))");
                return new SqliteColumn(string, jDBCType, this.$keyColumnsNames.contains(columnName));
            }
            {
                this.$columnsSet = resultSet;
                this.$keyColumnsNames = list;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteResultSet> execute(@NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        ListenableFuture listenableFuture = this.sequentialTaskExecutor.executeAsync((Callable)new Callable<SqliteResultSet>(this, sqliteStatement){
            final /* synthetic */ JdbcDatabaseConnection this$0;
            final /* synthetic */ SqliteStatement $sqliteStatement;

            @Nullable
            public final SqliteResultSet call() {
                PreparedStatement preparedStatement = JdbcUtilsKt.resolvePreparedStatement(JdbcDatabaseConnection.access$getConnection$p(this.this$0), this.$sqliteStatement);
                boolean bl = preparedStatement.execute();
                boolean bl2 = false;
                boolean bl3 = false;
                boolean it = bl;
                boolean bl4 = false;
                JdbcDatabaseConnection.access$getLogger$cp().info("SQL statement \"" + this.$sqliteStatement.getSqliteStatementText() + "\" executed with success.");
                boolean hasResultSet = bl;
                return hasResultSet ? new JdbcSqliteResultSet(this.this$0, JdbcDatabaseConnection.access$getConnection$p(this.this$0), this.$sqliteStatement) : null;
            }
            {
                this.this$0 = jdbcDatabaseConnection;
                this.$sqliteStatement = sqliteStatement;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"sequentialTaskExecutor.e\u2026       null\n      }\n    }");
        return listenableFuture;
    }

    public JdbcDatabaseConnection(@NotNull Connection connection, @NotNull VirtualFile sqliteFile, @NotNull Executor pooledExecutor) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqliteFile, (String)"sqliteFile");
        Intrinsics.checkNotNullParameter((Object)pooledExecutor, (String)"pooledExecutor");
        this.connection = connection;
        this.sqliteFile = sqliteFile;
        FutureCallbackExecutor futureCallbackExecutor = FutureCallbackExecutor.wrap((Executor)SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Sqlite JDBC service", (Executor)pooledExecutor));
        Intrinsics.checkNotNullExpressionValue((Object)futureCallbackExecutor, (String)"FutureCallbackExecutor.w\u2026ice\", pooledExecutor)\n  )");
        this.sequentialTaskExecutor = futureCallbackExecutor;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(JdbcDatabaseConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(JdbcD\u2026seConnection::class.java)");
        logger = logger2;
    }

    @Override
    public void dispose() {
        DatabaseConnection.DefaultImpls.dispose(this);
    }

    public static final /* synthetic */ Connection access$getConnection$p(JdbcDatabaseConnection $this) {
        return $this.connection;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ VirtualFile access$getSqliteFile$p(JdbcDatabaseConnection $this) {
        return $this.sqliteFile;
    }

    public static final /* synthetic */ List access$readColumnDefinitions(JdbcDatabaseConnection $this, Connection connection, String tableName) {
        return $this.readColumnDefinitions(connection, tableName);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcDatabaseConnection$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.android.debuggers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

