/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.tableView;

import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteRow;
import com.android.tools.idea.sqlite.ui.UtilsKt;
import com.android.tools.idea.sqlite.ui.tableView.TablePanel;
import com.android.tools.idea.sqlite.ui.tableView.TableView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u000256B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\u001a\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020\u001eH\u0016J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\rH\u0016J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020\rH\u0016J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\u0015H\u0016J\u0016\u0010/\u001a\u00020\u001e2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0016\u00100\u001a\u00020\u001e2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u0004H\u0016J\b\u00103\u001a\u00020\u001eH\u0016J\b\u00104\u001a\u00020\u001eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl;", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView;", "()V", "columns", "", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "firstRowsPageButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "isLoading", "", "lastRowsPageButton", "listeners", "", "Lcom/android/tools/idea/sqlite/ui/tableView/TableView$Listener;", "nextRowsPageButton", "pageSizeComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "", "pageSizeDefaultValues", "panel", "Lcom/android/tools/idea/sqlite/ui/tableView/TablePanel;", "previousRowsPageButton", "refreshButton", "table", "Lcom/intellij/ui/table/JBTable;", "addListener", "", "listener", "removeListener", "removeRows", "reportError", "message", "", "t", "", "resetView", "setEditable", "isEditable", "setFetchNextRowsButtonState", "enable", "setFetchPreviousRowsButtonState", "showPageSizeValue", "maxRowCount", "showTableColumns", "showTableRowBatch", "rows", "Lcom/android/tools/idea/sqlite/model/SqliteRow;", "startTableLoading", "stopTableLoading", "MyTableHeaderRenderer", "MyTableModel", "intellij.android.debuggers"})
public final class TableViewImpl
implements TableView {
    private final List<TableView.Listener> listeners;
    private final List<Integer> pageSizeDefaultValues;
    private boolean isLoading;
    private List<SqliteColumn> columns;
    private final TablePanel panel;
    @NotNull
    private final JComponent component;
    private final CommonButton firstRowsPageButton;
    private final CommonButton lastRowsPageButton;
    private final CommonButton previousRowsPageButton;
    private final CommonButton nextRowsPageButton;
    private final ComboBox<Integer> pageSizeComboBox;
    private final CommonButton refreshButton;
    private final JBTable table;

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void showPageSizeValue(int maxRowCount) {
        this.pageSizeComboBox.setSelectedItem((Object)maxRowCount);
    }

    @Override
    public void resetView() {
        this.table.setModel((TableModel)new MyTableModel(CollectionsKt.emptyList()));
    }

    @Override
    public void removeRows() {
        TableModel tableModel2 = this.table.getModel();
        if (tableModel2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
        }
        ((MyTableModel)tableModel2).removeAllRows();
    }

    @Override
    public void startTableLoading() {
        this.isLoading = true;
    }

    @Override
    public void showTableColumns(@NotNull List<SqliteColumn> columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        this.columns = columns2;
        this.table.setModel((TableModel)new MyTableModel(columns2));
    }

    @Override
    public void showTableRowBatch(@NotNull List<SqliteRow> rows) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        TableModel tableModel2 = this.table.getModel();
        if (tableModel2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
        }
        ((MyTableModel)tableModel2).addRows(rows);
    }

    @Override
    public void stopTableLoading() {
        this.table.setPaintBusy(false);
        this.isLoading = false;
    }

    @Override
    public void reportError(@NotNull String message2, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        UtilsKt.notifyError(message2, t);
    }

    @Override
    public void setFetchPreviousRowsButtonState(boolean enable) {
        this.previousRowsPageButton.setEnabled(enable);
        this.firstRowsPageButton.setEnabled(enable);
    }

    @Override
    public void setFetchNextRowsButtonState(boolean enable) {
        this.nextRowsPageButton.setEnabled(enable);
        this.lastRowsPageButton.setEnabled(enable);
    }

    @Override
    public void setEditable(boolean isEditable) {
        TableModel tableModel2 = this.table.getModel();
        if (tableModel2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.tableView.TableViewImpl.MyTableModel");
        }
        ((MyTableModel)tableModel2).setEditable(isEditable);
    }

    @Override
    public void addListener(@NotNull TableView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull TableView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public TableViewImpl() {
        boolean bl = false;
        this.listeners = new ArrayList();
        this.pageSizeDefaultValues = CollectionsKt.listOf((Object[])new Integer[]{5, 10, 20, 25, 50});
        this.panel = new TablePanel();
        JPanel jPanel = this.panel.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"panel.root");
        this.component = jPanel;
        this.firstRowsPageButton = new CommonButton("First", AllIcons.Actions.Play_first);
        this.lastRowsPageButton = new CommonButton("Last", AllIcons.Actions.Play_last);
        this.previousRowsPageButton = new CommonButton("Previous", AllIcons.Actions.Play_back);
        this.nextRowsPageButton = new CommonButton("Next", AllIcons.Actions.Play_forward);
        this.pageSizeComboBox = new ComboBox();
        this.refreshButton = new CommonButton("Refresh table", AllIcons.Actions.Refresh);
        this.table = new JBTable();
        this.firstRowsPageButton.setToolTipText("First");
        this.panel.getControlsPanel().add((Component)this.firstRowsPageButton);
        this.firstRowsPageButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.loadFirstRowsInvoked();
                }
            }
        });
        this.previousRowsPageButton.setToolTipText("Previous");
        this.panel.getControlsPanel().add((Component)this.previousRowsPageButton);
        this.previousRowsPageButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.loadPreviousRowsInvoked();
                }
            }
        });
        this.pageSizeComboBox.setEditable(true);
        Iterable $this$forEach$iv = this.pageSizeDefaultValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl2 = false;
            this.pageSizeComboBox.addItem((Object)it);
        }
        this.panel.getControlsPanel().add((Component)this.pageSizeComboBox);
        this.pageSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    Object object = pageSizeComboBox.getSelectedItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    it2.rowCountChanged((Integer)object);
                }
            }
        });
        this.nextRowsPageButton.setToolTipText("Next");
        this.panel.getControlsPanel().add((Component)this.nextRowsPageButton);
        this.nextRowsPageButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.loadNextRowsInvoked();
                }
            }
        });
        this.lastRowsPageButton.setToolTipText("Last");
        this.panel.getControlsPanel().add((Component)this.lastRowsPageButton);
        this.lastRowsPageButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.loadLastRowsInvoked();
                }
            }
        });
        this.refreshButton.setToolTipText("Sync table");
        this.panel.getControlsPanel().add((Component)this.refreshButton);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it2 = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it2.refreshDataInvoked();
                }
            }
        });
        JTableHeader jTableHeader = this.table.getTableHeader();
        Intrinsics.checkNotNullExpressionValue((Object)jTableHeader, (String)"table.tableHeader");
        jTableHeader.setDefaultRenderer(new MyTableHeaderRenderer());
        StatusText statusText = this.table.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"table.emptyText");
        statusText.setText("Table is empty");
        this.panel.getRoot().add((Component)new JBScrollPane((Component)this.table));
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (isLoading) {
                    return;
                }
                Point point = e.getPoint();
                int columnIndex = table.columnAtPoint(point);
                Iterable $this$forEach$iv = listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableView.Listener it = (TableView.Listener)element$iv;
                    boolean bl = false;
                    it.toggleOrderByColumnInvoked((SqliteColumn)TableViewImpl.access$getColumns$p(this).get(columnIndex));
                }
            }
        });
    }

    public static final /* synthetic */ void access$setLoading$p(TableViewImpl $this, boolean bl) {
        $this.isLoading = bl;
    }

    public static final /* synthetic */ List access$getColumns$p(TableViewImpl $this) {
        List<SqliteColumn> list = $this.columns;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"columns");
        }
        return list;
    }

    public static final /* synthetic */ void access$setColumns$p(TableViewImpl $this, List list) {
        $this.columns = list;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableHeaderRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "columnNameLabel", "Ljavax/swing/table/DefaultTableCellRenderer;", "panel", "Ljavax/swing/JPanel;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "focused", "viewRowIndex", "", "viewColumnIndex", "intellij.android.debuggers"})
    private static final class MyTableHeaderRenderer
    implements TableCellRenderer {
        private final DefaultTableCellRenderer columnNameLabel = new DefaultTableCellRenderer();
        private final JPanel panel = new JPanel(new BorderLayout());

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            this.columnNameLabel.setText((String)value2);
            return this.panel;
        }

        public MyTableHeaderRenderer() {
            DefaultTableCellRenderer sortIcon = new DefaultTableCellRenderer();
            sortIcon.setIcon(AllIcons.General.ArrowSplitCenterV);
            this.columnNameLabel.setIcon(AllIcons.Nodes.DataColumn);
            this.columnNameLabel.setIconTextGap(8);
            this.panel.setBackground(new Color(0, 0, 0, 0));
            this.panel.add((Component)this.columnNameLabel, "Center");
            this.panel.add((Component)sortIcon, "East");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u001e\u001a\u00020\u0011J \u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl$MyTableModel;", "Ljavax/swing/table/AbstractTableModel;", "columns", "", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "(Lcom/android/tools/idea/sqlite/ui/tableView/TableViewImpl;Ljava/util/List;)V", "getColumns", "()Ljava/util/List;", "isEditable", "", "()Z", "setEditable", "(Z)V", "rows", "", "Lcom/android/tools/idea/sqlite/model/SqliteRow;", "addRows", "", "newRows", "getColumnClass", "Ljava/lang/Class;", "", "modelColumnIndex", "", "getColumnCount", "getColumnName", "getRowCount", "getValueAt", "modelRowIndex", "isCellEditable", "removeAllRows", "setValueAt", "newValue", "", "intellij.android.debuggers"})
    private final class MyTableModel
    extends AbstractTableModel {
        private final List<SqliteRow> rows;
        private boolean isEditable;
        @NotNull
        private final List<SqliteColumn> columns;

        public final boolean isEditable() {
            return this.isEditable;
        }

        public final void setEditable(boolean bl) {
            this.isEditable = bl;
        }

        public final void addRows(@NotNull List<SqliteRow> newRows) {
            Intrinsics.checkNotNullParameter(newRows, (String)"newRows");
            int startIndex = this.rows.size();
            int endIndex = startIndex + newRows.size();
            this.rows.addAll((Collection<SqliteRow>)newRows);
            this.fireTableRowsInserted(startIndex, endIndex);
        }

        public final void removeAllRows() {
            int endIndex = this.rows.size();
            this.rows.clear();
            this.fireTableRowsDeleted(0, endIndex);
        }

        @Override
        @NotNull
        public String getColumnName(int modelColumnIndex) {
            return this.columns.get(modelColumnIndex).getName();
        }

        @NotNull
        public Class<String> getColumnClass(int modelColumnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.columns.size();
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        @NotNull
        public String getValueAt(int modelRowIndex, int modelColumnIndex) {
            return String.valueOf(this.rows.get(modelRowIndex).getValues().get(modelColumnIndex).getValue());
        }

        @Override
        public void setValueAt(@NotNull Object newValue, int modelRowIndex, int modelColumnIndex) {
            Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
            SqliteRow row = this.rows.get(modelRowIndex);
            SqliteColumn column = this.columns.get(modelColumnIndex);
            Iterable $this$forEach$iv = TableViewImpl.this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TableView.Listener it = (TableView.Listener)element$iv;
                boolean bl = false;
                it.updateCellInvoked(row, column, newValue);
            }
        }

        @Override
        public boolean isCellEditable(int modelRowIndex, int modelColumnIndex) {
            return this.isEditable;
        }

        @NotNull
        public final List<SqliteColumn> getColumns() {
            return this.columns;
        }

        public MyTableModel(List<SqliteColumn> columns2) {
            Intrinsics.checkNotNullParameter(columns2, (String)"columns");
            this.columns = columns2;
            boolean bl = false;
            this.rows = new ArrayList();
        }
    }
}

