/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.tracer.Trace;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ArtifactDetail;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.google.wireless.android.sdk.stats.RunEvent;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.Nullable;

public class RunStats {
    public static final Key<RunStats> KEY = Key.create((String)"android.stats.run");
    private AndroidStudioEvent.Builder myEvent;
    private boolean myLogged;
    private Project myProject;

    public RunStats(Project project) {
        this.myProject = project;
        this.myEvent = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.RUN_EVENT);
    }

    public void abort() {
        this.commit(RunEvent.Status.ABORT);
    }

    public void success() {
        this.commit(RunEvent.Status.SUCCESS);
    }

    public void fail() {
        this.commit(RunEvent.Status.FAIL);
    }

    private void commit(RunEvent.Status status) {
        Trace.end();
        Trace.flush();
        if (!this.myLogged) {
            this.myEvent.getRunEventBuilder().setStatus(status).setEndTimestampMs(System.currentTimeMillis());
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(this.myEvent, this.myProject));
            this.myLogged = true;
        }
    }

    public void start() {
        Trace.start();
        Trace.begin((String)"start");
        this.myEvent.getRunEventBuilder().setBeginTimestampMs(System.currentTimeMillis());
    }

    public void markStateCreated() {
    }

    public LaunchTaskDetail.Builder beginLaunchTask(LaunchTask task2) {
        Trace.begin((String)("begingLaunchtask" + task2.getId()));
        LaunchTaskDetail.Builder details = LaunchTaskDetail.newBuilder().setId(task2.getId()).setStartTimestampMs(System.currentTimeMillis());
        for (ApkInfo apk : task2.getApkInfos()) {
            for (ApkFileUnit unit : apk.getFiles()) {
                details.addArtifact(ArtifactDetail.newBuilder().setSize(unit.getApkFile().length()));
            }
        }
        return details;
    }

    public void endLaunchTask(LaunchTask task2, LaunchTaskDetail.Builder detail, boolean success2) {
        Trace.end();
        detail.setEndTimestampMs(System.currentTimeMillis());
        this.myEvent.getRunEventBuilder().addLaunchTaskDetail(detail);
        this.myEvent.getRunEventBuilder().addAllLaunchTaskDetail(task2.getSubTaskDetails());
    }

    public void beginBeforeRunTasks() {
        Trace.begin((String)"beforeRunktask.");
        this.myEvent.getRunEventBuilder().setBeginBeforeRunTasksTimestampMs(System.currentTimeMillis());
    }

    public void endBeforeRunTasks() {
        Trace.end();
        this.myEvent.getRunEventBuilder().setEndBeforeRunTasksTimestampMs(System.currentTimeMillis());
    }

    public void beginWaitForDevice() {
        Trace.begin((String)"WaitForDevice.");
        this.myEvent.getRunEventBuilder().setBeginWaitForDeviceTimestampMs(System.currentTimeMillis());
    }

    public void endWaitForDevice(@Nullable IDevice device) {
        Trace.end();
        this.myEvent.getRunEventBuilder().setEndWaitForDeviceTimestampMs(System.currentTimeMillis());
        if (device == null) {
            return;
        }
        this.myEvent.setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(device));
        this.myEvent.getRunEventBuilder().setDeviceCount(this.myEvent.getRunEventBuilder().getDeviceCount() + 1);
    }

    public void setDebuggable(boolean debuggable2) {
        this.myEvent.getRunEventBuilder().setDebuggable(debuggable2);
    }

    public void setPackage(String packageName) {
        this.myEvent.setProjectId(AnonymizerUtil.anonymizeUtf8((String)packageName)).setRawProjectId(packageName);
    }

    public void setExecutor(String executorId) {
        this.myEvent.getRunEventBuilder().setExecutor(executorId);
    }

    public void setApplyChanges(boolean hotSwap) {
        this.myEvent.getRunEventBuilder().setApplyChanges(hotSwap);
    }

    public void setUserSelectedTarget(boolean selection) {
        this.myEvent.getRunEventBuilder().setUserSelectedTarget(selection);
    }

    public void beginLaunchTasks() {
        Trace.begin((String)"beginLaunchTasks");
        this.myEvent.getRunEventBuilder().setBeginLaunchTasksTimestampMs(System.currentTimeMillis());
    }

    public void endLaunchTasks() {
        Trace.end();
        this.myEvent.getRunEventBuilder().setEndLaunchTasksTimestampMs(System.currentTimeMillis());
    }

    public void setLaunchedDevices(boolean b) {
        this.myEvent.getRunEventBuilder().setLaunchedDevices(b);
    }

    public void setDeployedAsInstant(boolean instant) {
        this.myEvent.getRunEventBuilder().setDeployedAsInstant(instant);
    }

    public void setDeployedFromBundle(boolean fromBundle) {
        this.myEvent.getRunEventBuilder().setDeployedFromBundle(fromBundle);
    }

    public void setErrorId(String id) {
        this.myEvent.getRunEventBuilder().setDeployFailureId(id);
    }

    public void setApplyChangesFallbackToRun(boolean fallback) {
        this.myEvent.getRunEventBuilder().setApplyChangesFallbackToRun(fallback);
    }

    public void setApplyCodeChangesFallbackToRun(boolean fallback) {
        this.myEvent.getRunEventBuilder().setApplyCodeChangesFallbackToRun(fallback);
    }

    public static RunStats from(ExecutionEnvironment env) {
        RunStats data = (RunStats)env.getUserData(KEY);
        if (data == null) {
            data = new RunStats(env.getProject());
            data.setPartial(true);
        }
        return data;
    }

    private void setPartial(boolean partial) {
        this.myEvent.getRunEventBuilder().setPartial(partial);
    }
}

