/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.ConsolePrinter;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AndroidTestListener
implements ITestRunListener {
    private static final String DISPLAY_PREFIX = "android.studio.display.";
    @NotNull
    private final ConsolePrinter myPrinter;
    private long myTestStartingTime;
    private long myTestSuiteStartingTime;
    private String myTestClassName;

    public AndroidTestListener(@NotNull ConsolePrinter printer) {
        if (printer == null) {
            AndroidTestListener.$$$reportNull$$$0(0);
        }
        this.myTestClassName = null;
        this.myPrinter = printer;
    }

    public void testRunStopped(long elapsedTime) {
        this.myPrinter.stderr("Test run stopped.\n");
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        if (this.myTestClassName != null) {
            this.testSuiteFinished();
        }
        this.myPrinter.stdout("Tests ran to completion.\n");
    }

    public void testRunFailed(String errorMessage) {
        this.myPrinter.stderr("Test running failed: " + errorMessage);
    }

    public void testRunStarted(String runName, int testCount) {
        this.myPrinter.stdout("\nStarted running tests\n");
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("enteredTheMatrix");
        this.myPrinter.stdout(builder2.toString());
    }

    public void testStarted(TestIdentifier test) {
        if (!Objects.equals(test.getClassName(), this.myTestClassName)) {
            if (this.myTestClassName != null) {
                this.testSuiteFinished();
            }
            this.myTestClassName = test.getClassName();
            this.testSuiteStarted();
        }
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testStarted");
        builder2.addAttribute("name", test.getTestName());
        builder2.addAttribute("locationHint", "android://" + test.getClassName() + "." + test.getTestName() + "()");
        this.myPrinter.stdout(builder2.toString());
        this.myTestStartingTime = System.currentTimeMillis();
    }

    private void testSuiteStarted() {
        this.myTestSuiteStartingTime = System.currentTimeMillis();
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testSuiteStarted");
        builder2.addAttribute("name", this.myTestClassName);
        builder2.addAttribute("locationHint", "android://" + this.myTestClassName);
        this.myPrinter.stdout(builder2.toString());
    }

    private void testSuiteFinished() {
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testSuiteFinished");
        builder2.addAttribute("name", this.myTestClassName);
        builder2.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestSuiteStartingTime));
        this.myPrinter.stdout(builder2.toString());
        this.myTestClassName = null;
    }

    public void testFailed(TestIdentifier test, String stackTrace) {
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testFailed");
        builder2.addAttribute("name", test.getTestName());
        builder2.addAttribute("message", "");
        builder2.addAttribute("details", stackTrace);
        builder2.addAttribute("error", "true");
        this.myPrinter.stdout(builder2.toString());
    }

    public void testAssumptionFailure(TestIdentifier test, String trace) {
        ServiceMessageBuilder builder2 = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        builder2.addAttribute("message", "Test ignored. Assumption Failed:");
        builder2.addAttribute("details", trace);
        this.myPrinter.stdout(builder2.toString());
    }

    public void testIgnored(TestIdentifier test) {
        ServiceMessageBuilder builder2 = ServiceMessageBuilder.testIgnored((String)test.getTestName());
        this.myPrinter.stdout(builder2.toString());
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        if (((Boolean)StudioFlags.PRINT_INSTRUMENTATION_STATUS.get()).booleanValue()) {
            for (Map.Entry<String, String> entry : testMetrics.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(DISPLAY_PREFIX)) continue;
                this.myPrinter.stdout(key.substring(DISPLAY_PREFIX.length()) + ": " + entry.getValue());
            }
        }
        ServiceMessageBuilder builder2 = new ServiceMessageBuilder("testFinished");
        builder2.addAttribute("name", test.getTestName());
        builder2.addAttribute("duration", Long.toString(System.currentTimeMillis() - this.myTestStartingTime));
        this.myPrinter.stdout(builder2.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/idea/testartifacts/instrumented/AndroidTestListener", "<init>"));
    }
}

