/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profiler.proto.TransportServiceGrpc;
import com.intellij.openapi.Disposable;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventStreamServer
implements Disposable {
    @NotNull
    private final String myServerName;
    @NotNull
    private final BlockingDeque<Common.Event> myEventQueue;
    @NotNull
    private final Map<String, ByteString> myByteCache;
    @NotNull
    private final Object myServerLock;
    private Server myServer;
    private StreamTransportService myTransportService;

    public EventStreamServer(@NotNull String serverName) {
        if (serverName == null) {
            EventStreamServer.$$$reportNull$$$0(0);
        }
        this.myEventQueue = new LinkedBlockingDeque<Common.Event>();
        this.myByteCache = new HashMap<String, ByteString>();
        this.myServerLock = new Object();
        this.myServerName = serverName;
    }

    @NotNull
    public String getServerName() {
        String string = this.myServerName;
        if (string == null) {
            EventStreamServer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public BlockingDeque<Common.Event> getEventDeque() {
        BlockingDeque<Common.Event> blockingDeque = this.myEventQueue;
        if (blockingDeque == null) {
            EventStreamServer.$$$reportNull$$$0(2);
        }
        return blockingDeque;
    }

    @NotNull
    public Map<String, ByteString> getByteCacheMap() {
        Map<String, ByteString> map2 = this.myByteCache;
        if (map2 == null) {
            EventStreamServer.$$$reportNull$$$0(3);
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Object object = this.myServerLock;
        synchronized (object) {
            if (this.myServer != null) {
                throw new IllegalStateException(String.format("Server %s has already started", this.myServerName));
            }
            AbstractServerImplBuilder builder2 = InProcessServerBuilder.forName((String)this.myServerName).directExecutor();
            this.myTransportService = new StreamTransportService();
            builder2.addService((BindableService)this.myTransportService);
            this.myServer = builder2.build();
            this.myServer.start();
        }
    }

    public void stop() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myServerLock;
        synchronized (object) {
            if (this.myServer == null || this.myServer.isShutdown()) {
                return;
            }
            this.myTransportService.shutDownAndWait();
            this.myServer.shutdownNow();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/transport/EventStreamServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/transport/EventStreamServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventDeque";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteCacheMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StreamTransportService
    extends TransportServiceGrpc.TransportServiceImplBase {
        private Thread myEventStreamingThread;
        @Nullable
        private CountDownLatch myEventStreamingLatch;

        private StreamTransportService() {
        }

        private void shutDownAndWait() {
            if (this.myEventStreamingThread != null && this.myEventStreamingLatch != null) {
                try {
                    this.myEventStreamingThread.interrupt();
                    this.myEventStreamingLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void getEvents(Transport.GetEventsRequest request, StreamObserver<Common.Event> responseObserver) {
            this.myEventStreamingLatch = new CountDownLatch(1);
            this.myEventStreamingThread = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted() || !EventStreamServer.this.myEventQueue.isEmpty()) {
                    try {
                        Common.Event event = EventStreamServer.this.myEventQueue.take();
                        responseObserver.onNext((Object)event);
                    }
                    catch (InterruptedException exception) {
                        Thread.currentThread().interrupt();
                    }
                }
                responseObserver.onCompleted();
                this.myEventStreamingLatch.countDown();
            });
            this.myEventStreamingThread.start();
        }

        public void getBytes(Transport.BytesRequest request, StreamObserver<Transport.BytesResponse> responseObserver) {
            if (EventStreamServer.this.myByteCache.containsKey(request.getId())) {
                responseObserver.onNext((Object)Transport.BytesResponse.newBuilder().setContents(EventStreamServer.this.myByteCache.get(request.getId())).build());
                EventStreamServer.this.myByteCache.remove(request.getId());
            } else {
                responseObserver.onNext((Object)Transport.BytesResponse.getDefaultInstance());
            }
            responseObserver.onCompleted();
        }
    }
}

