/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.transport.ServiceProxy;
import com.android.tools.idea.transport.TransportBytesPreprocessor;
import com.android.tools.idea.transport.TransportEventPreprocessor;
import com.android.tools.idea.transport.TransportServiceProxy;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import io.grpc.ManagedChannel;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.NotNull;

public class TransportProxy {
    private Server myProxyServer;
    @NotNull
    private final List<ServiceProxy> myProxyServices;
    @NotNull
    private IDevice myDevice;
    @NotNull
    private ManagedChannel myTransportChannel;
    @NotNull
    private final TransportServiceProxy myProxyService;
    @NotNull
    private final LinkedBlockingDeque<Common.Event> myProxyEventQueue;
    @NotNull
    private final Map<String, ByteString> myProxyBytesCache;

    public TransportProxy(@NotNull IDevice ddmlibDevice, @NotNull Common.Device transportDevice, @NotNull ManagedChannel transportChannel) {
        if (ddmlibDevice == null) {
            TransportProxy.$$$reportNull$$$0(0);
        }
        if (transportDevice == null) {
            TransportProxy.$$$reportNull$$$0(1);
        }
        if (transportChannel == null) {
            TransportProxy.$$$reportNull$$$0(2);
        }
        this.myProxyEventQueue = new LinkedBlockingDeque();
        this.myProxyBytesCache = Collections.synchronizedMap(new HashMap());
        this.myDevice = ddmlibDevice;
        this.myTransportChannel = transportChannel;
        this.myProxyServices = new LinkedList<ServiceProxy>();
        this.myProxyService = new TransportServiceProxy(ddmlibDevice, transportDevice, transportChannel, this.myProxyEventQueue, this.myProxyBytesCache);
    }

    @NotNull
    public BlockingDeque<Common.Event> getEventQueue() {
        LinkedBlockingDeque<Common.Event> linkedBlockingDeque = this.myProxyEventQueue;
        if (linkedBlockingDeque == null) {
            TransportProxy.$$$reportNull$$$0(3);
        }
        return linkedBlockingDeque;
    }

    @NotNull
    public Map<String, ByteString> getBytesCache() {
        Map<String, ByteString> map2 = this.myProxyBytesCache;
        if (map2 == null) {
            TransportProxy.$$$reportNull$$$0(4);
        }
        return map2;
    }

    public void registerProxyService(ServiceProxy proxyService) {
        this.myProxyServices.add(proxyService);
    }

    public void registerProxyCommandHandler(Commands.Command.CommandType commandType, ProxyCommandHandler handler) {
        this.myProxyService.registerCommandHandler(commandType, handler);
    }

    public void registerEventPreprocessor(TransportEventPreprocessor eventPreprocessor) {
        this.myProxyService.registerEventPreprocessor(eventPreprocessor);
    }

    public void registerDataPreprocessor(TransportBytesPreprocessor dataPreprocessor) {
        this.myProxyService.registerDataPreprocessor(dataPreprocessor);
    }

    public void initializeProxyServer(String channelName) {
        InProcessServerBuilder builder2 = InProcessServerBuilder.forName((String)channelName);
        this.myProxyServices.add(this.myProxyService);
        this.myProxyServices.forEach(arg_0 -> TransportProxy.lambda$initializeProxyServer$0((ServerBuilder)builder2, arg_0));
        this.myProxyServer = builder2.build();
    }

    public void connect() throws IOException {
        if (this.myProxyServer == null) {
            throw new IllegalStateException("Proxy server has not been built");
        }
        this.myProxyServer.start();
    }

    public void disconnect() {
        if (this.myProxyServer == null) {
            throw new IllegalStateException("Proxy server has not been built");
        }
        this.myProxyServices.forEach(ServiceProxy::disconnect);
        this.myProxyServer.shutdown();
    }

    @NotNull
    public IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            TransportProxy.$$$reportNull$$$0(5);
        }
        return iDevice;
    }

    @NotNull
    public ManagedChannel getTransportChannel() {
        ManagedChannel managedChannel = this.myTransportChannel;
        if (managedChannel == null) {
            TransportProxy.$$$reportNull$$$0(6);
        }
        return managedChannel;
    }

    private static /* synthetic */ void lambda$initializeProxyServer$0(ServerBuilder builder2, ServiceProxy service) {
        builder2.addService(service.getServiceDefinition());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ddmlibDevice";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transportDevice";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transportChannel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/transport/TransportProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/transport/TransportProxy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventQueue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytesCache";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevice";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransportChannel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ProxyCommandHandler {
        public Transport.ExecuteResponse execute(Commands.Command var1);

        default public boolean shouldHandle(Commands.Command command) {
            return true;
        }
    }
}

