/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager;

import com.android.tools.idea.ui.resourcemanager.ResourceExplorer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/MyFileEditorListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "resourceExplorer", "Lcom/android/tools/idea/ui/resourcemanager/ResourceExplorer;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;Lcom/android/tools/idea/ui/resourcemanager/ResourceExplorer;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResourceExplorer", "()Lcom/android/tools/idea/ui/resourcemanager/ResourceExplorer;", "getToolWindow", "()Lcom/intellij/openapi/wm/ToolWindow;", "editorFocused", "", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "fileOpened", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.android.core"})
final class MyFileEditorListener
implements FileEditorManagerListener {
    @NotNull
    private final Project project;
    @NotNull
    private final ToolWindow toolWindow;
    @Nullable
    private final ResourceExplorer resourceExplorer;

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FileEditor fileEditor = event.getNewEditor();
        if (fileEditor == null) {
            return;
        }
        FileEditor editor2 = fileEditor;
        this.editorFocused(editor2, this.project, this.resourceExplorer);
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileEditor fileEditor = source.getSelectedEditor(file);
        if (fileEditor == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"source.getSelectedEditor(file) ?: return");
        this.editorFocused(fileEditor, this.project, this.resourceExplorer);
    }

    private final void editorFocused(FileEditor editor2, Project project, ResourceExplorer resourceExplorer) {
        block9: {
            VirtualFile virtualFile;
            block8: {
                block7: {
                    virtualFile = editor2.getFile();
                    if (virtualFile == null) break block7;
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile it = virtualFile2;
                    boolean bl3 = false;
                    virtualFile = ModuleUtilCore.findModuleForFile((VirtualFile)it, (Project)project);
                    if (virtualFile != null) break block8;
                }
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"editor.file?.let {\n     \u2026 project)\n    } ?: return");
            VirtualFile module = virtualFile;
            Content content2 = this.toolWindow.getContentManager().getContent(0);
            if (content2 != null) {
                content2.setDisplayName(module.getName());
            }
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module);
            if (facet2 == null) break block9;
            ResourceExplorer resourceExplorer2 = resourceExplorer;
            if (Intrinsics.areEqual((Object)facet2, (Object)(resourceExplorer2 != null ? resourceExplorer2.getFacet() : null)) ^ true) {
                ResourceExplorer resourceExplorer3 = resourceExplorer;
                if (resourceExplorer3 != null) {
                    resourceExplorer3.setFacet(facet2);
                }
            }
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ToolWindow getToolWindow() {
        return this.toolWindow;
    }

    @Nullable
    public final ResourceExplorer getResourceExplorer() {
        return this.resourceExplorer;
    }

    public MyFileEditorListener(@NotNull Project project, @NotNull ToolWindow toolWindow, @Nullable ResourceExplorer resourceExplorer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.project = project;
        this.toolWindow = toolWindow;
        this.resourceExplorer = resourceExplorer;
    }
}

