/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.fonts.ProjectFonts;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.FontFamilyIcon;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/FontIconProvider;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetIconProvider;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "fontIcon", "Lcom/android/tools/idea/ui/resourcemanager/rendering/FontFamilyIcon;", "projectFonts", "Lcom/android/tools/idea/fonts/ProjectFonts;", "supportsTransparency", "", "getSupportsTransparency", "()Z", "getIcon", "Ljavax/swing/Icon;", "assetToRender", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "width", "", "height", "refreshCallback", "Lkotlin/Function0;", "", "shouldBeRendered", "intellij.android.core"})
public final class FontIconProvider
implements AssetIconProvider {
    private final FontFamilyIcon fontIcon;
    private final ProjectFonts projectFonts;
    private final boolean supportsTransparency;

    @Override
    public boolean getSupportsTransparency() {
        return this.supportsTransparency;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull DesignAsset assetToRender, int width, int height, @NotNull Function0<Unit> refreshCallback, @NotNull Function0<Boolean> shouldBeRendered) {
        Intrinsics.checkNotNullParameter((Object)assetToRender, (String)"assetToRender");
        Intrinsics.checkNotNullParameter(refreshCallback, (String)"refreshCallback");
        Intrinsics.checkNotNullParameter(shouldBeRendered, (String)"shouldBeRendered");
        ResourceItem resource = assetToRender.getResourceItem();
        ResourceReference resourceReference = resource.getReferenceToSelf();
        Intrinsics.checkNotNullExpressionValue((Object)resourceReference, (String)"resource.referenceToSelf");
        FontFamily fontFamily = this.projectFonts.getFont(resourceReference.getResourceUrl().toString());
        Intrinsics.checkNotNullExpressionValue((Object)fontFamily, (String)"projectFonts.getFont(res\u2026f.resourceUrl.toString())");
        FontFamily fontFamily2 = fontFamily;
        this.fontIcon.setWidth(width);
        this.fontIcon.setHeight(height);
        this.fontIcon.setFontFamily(fontFamily2);
        return this.fontIcon;
    }

    public FontIconProvider(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.fontIcon = new FontFamilyIcon();
        this.projectFonts = new ProjectFonts(facet2);
    }
}

