/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.converter.models.GradientStopModel;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchGradient;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.pages.SketchPoint2D;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradientModel {
    public static final Logger LOG = Logger.getInstance(SketchGradient.class);
    public static final String GRADIENT_LINEAR = "linear";
    public static final String GRADIENT_RADIAL = "radial";
    public static final String GRADIENT_SWEEP = "sweep";
    private static final String[] TYPES = new String[]{"linear", "radial", "sweep"};
    private int myGradientType;
    @NotNull
    private SketchPoint2D myFrom;
    @NotNull
    private SketchPoint2D myTo;
    @NotNull
    private GradientStopModel[] myGradientStopModels;

    public GradientModel(int gradientType, @NotNull SketchPoint2D from, @NotNull SketchPoint2D to, @NotNull GradientStopModel[] gradientStopModels) {
        if (from == null) {
            GradientModel.$$$reportNull$$$0(0);
        }
        if (to == null) {
            GradientModel.$$$reportNull$$$0(1);
        }
        if (gradientStopModels == null) {
            GradientModel.$$$reportNull$$$0(2);
        }
        this.myGradientType = gradientType;
        this.myFrom = from;
        this.myTo = to;
        this.myGradientStopModels = gradientStopModels;
    }

    public int getGradientType() {
        return this.myGradientType;
    }

    @NotNull
    public SketchPoint2D getFrom() {
        SketchPoint2D sketchPoint2D = this.myFrom;
        if (sketchPoint2D == null) {
            GradientModel.$$$reportNull$$$0(3);
        }
        return sketchPoint2D;
    }

    @NotNull
    public SketchPoint2D getTo() {
        SketchPoint2D sketchPoint2D = this.myTo;
        if (sketchPoint2D == null) {
            GradientModel.$$$reportNull$$$0(4);
        }
        return sketchPoint2D;
    }

    @NotNull
    public GradientStopModel[] getGradientStopModels() {
        if (this.myGradientStopModels == null) {
            GradientModel.$$$reportNull$$$0(5);
        }
        return this.myGradientStopModels;
    }

    @Nullable
    public String getDrawableGradientType() {
        if (this.myGradientType >= 0 && this.myGradientType < TYPES.length) {
            return TYPES[this.getGradientType()];
        }
        LOG.error("Unknown gradient type. Array index is " + this.myGradientType);
        return null;
    }

    @NotNull
    public String getGradientEndX() {
        String string = Double.toString(this.myTo.getX());
        if (string == null) {
            GradientModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getGradientEndY() {
        String string = Double.toString(this.myTo.getY());
        if (string == null) {
            GradientModel.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getGradientStartX() {
        String string = Double.toString(this.myFrom.getX());
        if (string == null) {
            GradientModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getGradientStartY() {
        String string = Double.toString(this.myFrom.getY());
        if (string == null) {
            GradientModel.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getGradientRadius() {
        double radiusX = Math.pow(this.myTo.x - this.myFrom.x, 2.0);
        double radiusY = Math.pow(this.myTo.y - this.myFrom.y, 2.0);
        String string = Double.toString(Math.sqrt(radiusX + radiusY));
        if (string == null) {
            GradientModel.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getSweepCenterY() {
        String string = String.valueOf((this.myTo.y + this.myFrom.y) / 2.0);
        if (string == null) {
            GradientModel.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void toRelativeGradient(@NotNull Rectangle2D ownFrame) {
        if (ownFrame == null) {
            GradientModel.$$$reportNull$$$0(12);
        }
        this.myFrom = this.myFrom.makeAbsolutePosition(ownFrame);
        this.myTo = this.myTo.makeAbsolutePosition(ownFrame);
    }

    public void applyTransformation(@NotNull AffineTransform transformation) {
        if (transformation == null) {
            GradientModel.$$$reportNull$$$0(13);
        }
        Point2D[] origin = new Point2D[]{this.myFrom, this.myTo};
        Point2D[] newPoints = new Point2D[2];
        transformation.transform(origin, 0, newPoints, 0, 2);
        this.myFrom.setLocation(newPoints[0]);
        this.myTo.setLocation(newPoints[1]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradientStopModels";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/GradientModel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownFrame";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/converter/models/GradientModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrom";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientStopModels";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientEndX";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientEndY";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientStartX";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientStartY";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradientRadius";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSweepCenterY";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toRelativeGradient";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyTransformation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

