/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.deserializers;

import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchAssetCollection;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchDocument;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignSymbol;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchForeignTextStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedStyle;
import com.android.tools.idea.ui.resourcemanager.sketchImporter.parser.document.SketchSharedSymbol;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SketchDocumentDeserializer
implements JsonDeserializer<SketchDocument> {
    private static final String ASSETS = "assets";
    private static final String COLOR_SPACE = "colorSpace";
    private static final String CURRENT_PAGE_INDEX = "currentPageIndex";
    private static final String EXT_LAYER_STYLES = "foreignLayerStyles";
    private static final String EXT_SYMBOLS = "foreignSymbols";
    private static final String EXT_TEXT_STYLES = "foreignTextStyles";
    private static final String LAYER_STYLES = "layerStyles";
    private static final String LAYER_SYMBOLS = "layerSymbols";
    private static final String LAYER_TEXT_STYLES = "layerTextStyles";
    private static final String OBJECTS = "objects";
    private static final short DEFAULT_COLOR_SPACE = 0;
    private static final int DEFAULT_CURRENT_PAGE_INDEX = 0;

    @Nullable
    public SketchDocument deserialize(@NotNull JsonElement json, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context) {
        if (json == null) {
            SketchDocumentDeserializer.$$$reportNull$$$0(0);
        }
        if (typeOfT == null) {
            SketchDocumentDeserializer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            SketchDocumentDeserializer.$$$reportNull$$$0(2);
        }
        JsonObject jsonObject = json.getAsJsonObject();
        SketchAssetCollection assets = (SketchAssetCollection)context.deserialize(jsonObject.get(ASSETS), SketchAssetCollection.class);
        JsonElement colorSpaceElement = jsonObject.get(COLOR_SPACE);
        short colorSpace = colorSpaceElement != null ? colorSpaceElement.getAsShort() : (short)0;
        JsonElement currentPageIndexElement = jsonObject.get(CURRENT_PAGE_INDEX);
        int currentPageIndex = currentPageIndexElement != null ? currentPageIndexElement.getAsInt() : 0;
        SketchForeignStyle[] foreignLayerStyles = (SketchForeignStyle[])context.deserialize(jsonObject.get(EXT_LAYER_STYLES), SketchForeignStyle[].class);
        SketchForeignSymbol[] foreignSymbols = (SketchForeignSymbol[])context.deserialize(jsonObject.get(EXT_SYMBOLS), SketchForeignSymbol[].class);
        SketchForeignTextStyle[] foreignTextStyles = (SketchForeignTextStyle[])context.deserialize(jsonObject.get(EXT_TEXT_STYLES), SketchForeignTextStyle[].class);
        SketchSharedStyle[] layerStyles = (SketchSharedStyle[])SketchDocumentDeserializer.getObjectsFrom(jsonObject, SketchSharedStyle[].class, context, LAYER_STYLES);
        SketchSharedSymbol[] layerSymbols = (SketchSharedSymbol[])SketchDocumentDeserializer.getObjectsFrom(jsonObject, SketchSharedSymbol[].class, context, LAYER_SYMBOLS);
        SketchSharedStyle[] layerTextStyles = (SketchSharedStyle[])SketchDocumentDeserializer.getObjectsFrom(jsonObject, SketchSharedStyle[].class, context, LAYER_TEXT_STYLES);
        return new SketchDocument(assets, colorSpace, currentPageIndex, foreignLayerStyles, foreignSymbols, foreignTextStyles, layerStyles, layerSymbols, layerTextStyles);
    }

    @NotNull
    private static <T> T getObjectsFrom(@NotNull JsonObject jsonObject, @NotNull Type typeOfT, @NotNull JsonDeserializationContext context, @NotNull String memberName) {
        if (jsonObject == null) {
            SketchDocumentDeserializer.$$$reportNull$$$0(3);
        }
        if (typeOfT == null) {
            SketchDocumentDeserializer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SketchDocumentDeserializer.$$$reportNull$$$0(5);
        }
        if (memberName == null) {
            SketchDocumentDeserializer.$$$reportNull$$$0(6);
        }
        Object object = context.deserialize(jsonObject.get(memberName).getAsJsonObject().get(OBJECTS), typeOfT);
        if (object == null) {
            SketchDocumentDeserializer.$$$reportNull$$$0(7);
        }
        return (T)object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOfT";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonObject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/parser/deserializers/SketchDocumentDeserializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/resourcemanager/sketchImporter/parser/deserializers/SketchDocumentDeserializer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsFrom";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

