/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.wizard;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WizardUtils {
    public static final String COMPOSE_MIN_AGP_VERSION = "4.0.0-alpha02";
    private static final int PACKAGE_LENGTH_LIMIT = 100;

    @NotNull
    public static File getProjectLocationParent() {
        String parent = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (parent != null) {
            return new File(PathUtil.toSystemDependentName((String)parent));
        }
        String defaultProjectLocation = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (defaultProjectLocation != null && !defaultProjectLocation.isEmpty()) {
            return new File(defaultProjectLocation);
        }
        String child = ApplicationNamesInfo.getInstance().getFullProductName().replace(" ", "") + "Projects";
        return new File(SystemProperties.getUserHome(), child);
    }

    @Nullable
    public static String validatePackageName(@Nullable String packageName) {
        String string = packageName = packageName == null ? "" : packageName;
        if (packageName.length() >= 100) {
            return AndroidBundle.message("android.wizard.module.package.too.long", new Object[0]);
        }
        return AndroidUtils.validateAndroidPackageName(packageName);
    }

    @NotNull
    public static String toHtmlString(@NotNull String text) {
        if (text == null) {
            WizardUtils.$$$reportNull$$$0(0);
        }
        if (!StringUtil.isEmpty((String)text) && !text.startsWith("<html>")) {
            text = text.trim().replaceAll("\n", "<br>");
            String string = String.format("<html>%1$s</html>", text);
            if (string == null) {
                WizardUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            WizardUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static URL toUrl(@NotNull String urlAsString) {
        URL url;
        if (urlAsString == null) {
            WizardUtils.$$$reportNull$$$0(3);
        }
        try {
            url = new URL(urlAsString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        URL uRL = url;
        if (uRL == null) {
            WizardUtils.$$$reportNull$$$0(4);
        }
        return uRL;
    }

    public static String getUniqueName(String initialValue, Validator<String> validator) {
        Object uniqueName = initialValue;
        for (int i2 = 2; i2 <= 100 && validator.validate(uniqueName).getSeverity() == Validator.Severity.ERROR; ++i2) {
            uniqueName = initialValue + Integer.toString(i2);
        }
        return uniqueName;
    }

    public static boolean hasComposeMinAgpVersion(@Nullable Project project, @Nullable String templateCategory) {
        if (project == null || !"Compose".equals(templateCategory)) {
            return true;
        }
        AndroidPluginInfo androidPluginInfo = AndroidPluginInfo.findFromModel(project);
        if (androidPluginInfo == null) {
            return true;
        }
        GradleVersion agpVersion = androidPluginInfo.getPluginVersion();
        if (agpVersion == null) {
            return true;
        }
        return agpVersion.compareTo(COMPOSE_MIN_AGP_VERSION) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ui/wizard/WizardUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlAsString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ui/wizard/WizardUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtmlString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toHtmlString";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

